/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBeforeUnloadEvent.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsBeforeUnloadEventReturnValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSBeforeUnloadEventReturnValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsBeforeUnloadEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSBeforeUnloadEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSBeforeUnloadEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSBeforeUnloadEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBeforeUnloadEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSBeforeUnloadEventPrototype>(vm.heap)) JSBeforeUnloadEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBeforeUnloadEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSBeforeUnloadEvent> JSBeforeUnloadEventConstructor;

template<> JSValue JSBeforeUnloadEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSBeforeUnloadEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSBeforeUnloadEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("BeforeUnloadEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSBeforeUnloadEventConstructor::s_info = { "BeforeUnloadEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBeforeUnloadEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSBeforeUnloadEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeUnloadEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBeforeUnloadEventConstructor) } },
    { "returnValue", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeUnloadEventReturnValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBeforeUnloadEventReturnValue) } },
};

const ClassInfo JSBeforeUnloadEventPrototype::s_info = { "BeforeUnloadEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBeforeUnloadEventPrototype) };

void JSBeforeUnloadEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBeforeUnloadEventPrototypeTableValues, *this);
}

const ClassInfo JSBeforeUnloadEvent::s_info = { "BeforeUnloadEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBeforeUnloadEvent) };

JSBeforeUnloadEvent::JSBeforeUnloadEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BeforeUnloadEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSBeforeUnloadEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSBeforeUnloadEventPrototype::create(vm, globalObject, JSBeforeUnloadEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSBeforeUnloadEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBeforeUnloadEvent>(vm, globalObject);
}

EncodedJSValue jsBeforeUnloadEventReturnValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBeforeUnloadEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BeforeUnloadEvent", "returnValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.returnValue());
    return JSValue::encode(result);
}


EncodedJSValue jsBeforeUnloadEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSBeforeUnloadEventPrototype* domObject = jsDynamicCast<JSBeforeUnloadEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSBeforeUnloadEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSBeforeUnloadEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSBeforeUnloadEventPrototype* domObject = jsDynamicCast<JSBeforeUnloadEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSBeforeUnloadEventReturnValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSBeforeUnloadEvent* castedThis = jsDynamicCast<JSBeforeUnloadEvent*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "BeforeUnloadEvent", "returnValue");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setReturnValue(nativeValue);
}


JSValue JSBeforeUnloadEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBeforeUnloadEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
