/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBarProp.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsBarPropVisible(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBarPropConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSBarPropConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSBarPropPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSBarPropPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBarPropPrototype* ptr = new (NotNull, JSC::allocateCell<JSBarPropPrototype>(vm.heap)) JSBarPropPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBarPropPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSBarProp> JSBarPropConstructor;

template<> JSValue JSBarPropConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSBarPropConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSBarProp::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("BarProp"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSBarPropConstructor::s_info = { "BarProp", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBarPropConstructor) };

/* Hash table for prototype */

static const HashTableValue JSBarPropPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBarPropConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBarPropConstructor) } },
    { "visible", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBarPropVisible), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSBarPropPrototype::s_info = { "BarPropPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBarPropPrototype) };

void JSBarPropPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBarPropPrototypeTableValues, *this);
}

const ClassInfo JSBarProp::s_info = { "BarProp", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBarProp) };

JSBarProp::JSBarProp(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BarProp>&& impl)
    : JSDOMWrapper<BarProp>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSBarProp::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSBarPropPrototype::create(vm, globalObject, JSBarPropPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSBarProp::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBarProp>(vm, globalObject);
}

void JSBarProp::destroy(JSC::JSCell* cell)
{
    JSBarProp* thisObject = static_cast<JSBarProp*>(cell);
    thisObject->JSBarProp::~JSBarProp();
}

EncodedJSValue jsBarPropVisible(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBarProp*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "BarProp", "visible");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.visible());
    return JSValue::encode(result);
}


EncodedJSValue jsBarPropConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSBarPropPrototype* domObject = jsDynamicCast<JSBarPropPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSBarProp::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSBarPropConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSBarPropPrototype* domObject = jsDynamicCast<JSBarPropPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSBarProp::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBarPropConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSBarPropOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsBarProp = jsCast<JSBarProp*>(handle.slot()->asCell());
    Frame* root = WTF::getPtr(jsBarProp->wrapped().frame());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSBarPropOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBarProp = jsCast<JSBarProp*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsBarProp->wrapped(), jsBarProp);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BarProp@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7BarPropE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, BarProp* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSBarProp>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, BarProp* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSBarProp>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7BarProp@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7BarPropE[2];
#if COMPILER(CLANG)
    // If this fails BarProp does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(BarProp), BarProp_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // BarProp has subclasses. If BarProp has subclasses that get passed
    // to toJS() we currently require BarProp you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSBarProp>(globalObject, impl);
}

BarProp* JSBarProp::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBarProp*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
