/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBuffer.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferPrototypeFunctionGetChannelData(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsAudioBufferLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferDuration(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSampleRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferGain(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferGain(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferNumberOfChannels(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioBufferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioBufferPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioBufferPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioBufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioBufferPrototype>(vm.heap)) JSAudioBufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioBufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAudioBuffer> JSAudioBufferConstructor;

template<> JSValue JSAudioBufferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioBufferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioBuffer::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AudioBuffer"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAudioBufferConstructor::s_info = { "AudioBuffer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioBufferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioBufferPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "duration", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferDuration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sampleRate", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSampleRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gain", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferGain) } },
    { "numberOfChannels", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferNumberOfChannels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getChannelData", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioBufferPrototypeFunctionGetChannelData), (intptr_t) (1) } },
};

const ClassInfo JSAudioBufferPrototype::s_info = { "AudioBufferPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioBufferPrototype) };

void JSAudioBufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioBufferPrototypeTableValues, *this);
}

const ClassInfo JSAudioBuffer::s_info = { "AudioBuffer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioBuffer) };

JSAudioBuffer::JSAudioBuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioBuffer>&& impl)
    : JSDOMWrapper<AudioBuffer>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioBuffer::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioBufferPrototype::create(vm, globalObject, JSAudioBufferPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSAudioBuffer::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioBuffer>(vm, globalObject);
}

void JSAudioBuffer::destroy(JSC::JSCell* cell)
{
    JSAudioBuffer* thisObject = static_cast<JSAudioBuffer*>(cell);
    thisObject->JSAudioBuffer::~JSAudioBuffer();
}

EncodedJSValue jsAudioBufferLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBuffer", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferDuration(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBuffer", "duration");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.duration());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferSampleRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBuffer", "sampleRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.sampleRate());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferGain(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBuffer", "gain");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.gain());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferNumberOfChannels(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioBuffer*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioBuffer", "numberOfChannels");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.numberOfChannels());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioBufferConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioBufferPrototype* domObject = jsDynamicCast<JSAudioBufferPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioBuffer::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioBufferConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioBufferPrototype* domObject = jsDynamicCast<JSAudioBufferPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAudioBufferGain(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioBuffer* castedThis = jsDynamicCast<JSAudioBuffer*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioBuffer", "gain");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setGain(nativeValue);
}


JSValue JSAudioBuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioBufferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioBufferPrototypeFunctionGetChannelData(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioBuffer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioBuffer", "getChannelData");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioBuffer::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned channelIndex = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getChannelData(channelIndex, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSAudioBuffer::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioBuffer*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
}

bool JSAudioBufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSAudioBufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioBuffer = jsCast<JSAudioBuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioBuffer->wrapped(), jsAudioBuffer);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioBuffer* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioBuffer>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioBuffer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioBuffer>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to AudioBuffer.
    COMPILE_ASSERT(!__is_polymorphic(AudioBuffer), AudioBuffer_is_polymorphic_but_idl_claims_not_to_be);
#endif
    globalObject->vm().heap.reportExtraMemoryAllocated(impl->memoryCost());
    return createNewWrapper<JSAudioBuffer>(globalObject, impl);
}

AudioBuffer* JSAudioBuffer::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioBuffer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
