/*
 * Copyright (c) 2014, 2015 Apple Inc. All rights reserved.
 * Copyright (c) 2015 Andy VanWagoner <thetalecrafter@gmail.com>.
 * Copyright (c) 2015 Jordan Harband. All rights reserved.
 * Copyright (c) 2015, 2016 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016 Yusuke Suzuki <utatane.tea@gmail.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "JSCBuiltins.h"

#include "BuiltinExecutables.h"
#include "Executable.h"
#include "JSCellInlines.h"
#include "VM.h"

namespace JSC {

const JSC::ConstructAbility s_promiseConstructorAllCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseConstructorAllCodeLength = 1412;
const char* s_promiseConstructorAllCode =
    "(function (iterable)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isObject(this))\n" \
    "        throw new @TypeError(\"|this| is not a object\");\n" \
    "    var constructor = this;\n" \
    "    var promiseCapability = @newPromiseCapability(constructor);\n" \
    "    var values = [];\n" \
    "    var index = 0;\n" \
    "    var remainingElementsCount = 1;\n" \
    "    function newResolveElement(index)\n" \
    "    {\n" \
    "        var alreadyCalled = false;\n" \
    "        return function (argument)\n" \
    "        {\n" \
    "            if (alreadyCalled)\n" \
    "                return @undefined;\n" \
    "            alreadyCalled = true;\n" \
    "            @putByValDirect(values, index, argument);\n" \
    "            --remainingElementsCount;\n" \
    "            if (remainingElementsCount === 0)\n" \
    "                return promiseCapability.@resolve.@call(@undefined, values);\n" \
    "            return @undefined;\n" \
    "        }\n" \
    "    }\n" \
    "    try {\n" \
    "        for (var value of iterable) {\n" \
    "            @putByValDirect(values, index, @undefined);\n" \
    "            var nextPromise = constructor.resolve(value);\n" \
    "            var resolveElement = newResolveElement(index);\n" \
    "            ++remainingElementsCount;\n" \
    "            nextPromise.then(resolveElement, promiseCapability.@reject);\n" \
    "            ++index;\n" \
    "        }\n" \
    "        --remainingElementsCount;\n" \
    "        if (remainingElementsCount === 0)\n" \
    "            promiseCapability.@resolve.@call(@undefined, values);\n" \
    "    } catch (error) {\n" \
    "        promiseCapability.@reject.@call(@undefined, error);\n" \
    "    }\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateFloat32ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateFloat32ArrayCodeLength = 62;
const char* s_typedArrayConstructorAllocateFloat32ArrayCode =
    "(function (length) {\n" \
    "    return new @Float32Array(length);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateFloat64ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateFloat64ArrayCodeLength = 62;
const char* s_typedArrayConstructorAllocateFloat64ArrayCode =
    "(function (length) {\n" \
    "    return new @Float64Array(length);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateInt16ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateInt16ArrayCodeLength = 65;
const char* s_typedArrayConstructorAllocateInt16ArrayCode =
    "(function (length) {\n" \
    "    return new @Int16Array(length);\n" \
    "    \n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateInt32ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateInt32ArrayCodeLength = 65;
const char* s_typedArrayConstructorAllocateInt32ArrayCode =
    "(function (length) {\n" \
    "    return new @Int32Array(length);\n" \
    "    \n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateInt8ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateInt8ArrayCodeLength = 59;
const char* s_typedArrayConstructorAllocateInt8ArrayCode =
    "(function (length) {\n" \
    "    return new @Int8Array(length);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateUint16ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateUint16ArrayCodeLength = 66;
const char* s_typedArrayConstructorAllocateUint16ArrayCode =
    "(function (length) {\n" \
    "    return new @Uint16Array(length);\n" \
    "    \n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateUint32ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateUint32ArrayCodeLength = 61;
const char* s_typedArrayConstructorAllocateUint32ArrayCode =
    "(function (length) {\n" \
    "    return new @Uint32Array(length);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateUint8ArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateUint8ArrayCodeLength = 65;
const char* s_typedArrayConstructorAllocateUint8ArrayCode =
    "(function (length) {\n" \
    "    return new @Uint8Array(length);\n" \
    "    \n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorAllocateUint8ClampedArrayCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorAllocateUint8ClampedArrayCodeLength = 67;
const char* s_typedArrayConstructorAllocateUint8ClampedArrayCode =
    "(function (length) {\n" \
    "    return new @Uint8ClampedArray(length);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_functionPrototypeApplyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_functionPrototypeApplyCodeLength = 112;
const char* s_functionPrototypeApplyCode =
    "(function (thisValue, argumentValues)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this.@apply(thisValue, argumentValues);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_reflectObjectApplyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_reflectObjectApplyCodeLength = 376;
const char* s_reflectObjectApplyCode =
    "(function (target, thisArgument, argumentsList)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (typeof target !== \"function\")\n" \
    "        throw new @TypeError(\"Reflect.apply requires the first argument be a function\");\n" \
    "    if (!@isObject(argumentsList))\n" \
    "        throw new @TypeError(\"Reflect.apply requires the third argument be an object\");\n" \
    "    return target.@apply(thisArgument, argumentsList);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_objectConstructorAssignCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_objectConstructorAssignCodeLength = 662;
const char* s_objectConstructorAssignCode =
    "(function (target, sources)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (target == null)\n" \
    "        throw new @TypeError(\"can't convert \" + target + \" to object\");\n" \
    "    var objTarget = @Object(target);\n" \
    "    for (var s = 1, argumentsLength = arguments.length; s < argumentsLength; ++s) {\n" \
    "        var nextSource = arguments[s];\n" \
    "        if (nextSource != null) {\n" \
    "            var from = @Object(nextSource);\n" \
    "            var keys = @ownEnumerablePropertyKeys(from);\n" \
    "            for (var i = 0, keysLength = keys.length; i < keysLength; ++i) {\n" \
    "                var nextKey = keys[i];\n" \
    "                objTarget[nextKey] = from[nextKey];\n" \
    "            }\n" \
    "        }\n" \
    "    }\n" \
    "    return objTarget;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_functionPrototypeCallCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_functionPrototypeCallCodeLength = 85;
const char* s_functionPrototypeCallCode =
    "(function (thisArgument)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this.@call(...arguments);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promisePrototypeCatchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promisePrototypeCatchCodeLength = 92;
const char* s_promisePrototypeCatchCode =
    "(function (onRejected)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this.then(@undefined, onRejected);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectCommitInstantiatedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectCommitInstantiatedCodeLength = 804;
const char* s_moduleLoaderObjectCommitInstantiatedCode =
    "(function (entry, optionalInstance, source)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var moduleRecord = this.instantiation(optionalInstance, source, entry);\n" \
    "    var dependencies = [];\n" \
    "    var dependenciesMap = moduleRecord.dependenciesMap;\n" \
    "    moduleRecord.registryEntry = entry;\n" \
    "    var requestedModules = this.requestedModules(moduleRecord);\n" \
    "    for (var i = 0, length = requestedModules.length; i < length; ++i) {\n" \
    "        var depKey = requestedModules[i];\n" \
    "        var pair = {\n" \
    "            key: depKey,\n" \
    "            value: @undefined\n" \
    "        };\n" \
    "        @putByValDirect(dependencies, i, pair);\n" \
    "        dependenciesMap.@set(depKey, pair);\n" \
    "    }\n" \
    "    entry.dependencies = dependencies;\n" \
    "    entry.dependenciesMap = dependenciesMap;\n" \
    "    entry.module = moduleRecord;\n" \
    "    this.setStateToMax(entry, this.ResolveDependencies);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeCopyWithinCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeCopyWithinCodeLength = 1762;
const char* s_arrayPrototypeCopyWithinCode =
    "(function (target, start )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    function maxWithPositives(a, b)\n" \
    "    {\n" \
    "        return (a < b) ? b : a;\n" \
    "    }\n" \
    "    function minWithMaybeNegativeZeroAndPositive(maybeNegativeZero, positive)\n" \
    "    {\n" \
    "        return (maybeNegativeZero < positive) ? maybeNegativeZero : positive;\n" \
    "    }\n" \
    "    if (this === null || this === @undefined)\n" \
    "        throw new @TypeError(\"Array.copyWithin requires that |this| not be null or undefined\");\n" \
    "    var thisObject = @Object(this);\n" \
    "    var length = @toLength(thisObject.length);\n" \
    "    var relativeTarget = @toInteger(target);\n" \
    "    var to = (relativeTarget < 0) ? maxWithPositives(length + relativeTarget, 0) : minWithMaybeNegativeZeroAndPositive(relativeTarget, length);\n" \
    "    var relativeStart = @toInteger(start);\n" \
    "    var from = (relativeStart < 0) ? maxWithPositives(length + relativeStart, 0) : minWithMaybeNegativeZeroAndPositive(relativeStart, length);\n" \
    "    var relativeEnd;\n" \
    "    if (arguments.length >= 3) {\n" \
    "        var end = arguments[2];\n" \
    "        if (end === @undefined)\n" \
    "            relativeEnd = length;\n" \
    "        else\n" \
    "            relativeEnd = @toInteger(end);\n" \
    "    } else\n" \
    "        relativeEnd = length;\n" \
    "    var finalValue = (relativeEnd < 0) ? maxWithPositives(length + relativeEnd, 0) : minWithMaybeNegativeZeroAndPositive(relativeEnd, length);\n" \
    "    var count = minWithMaybeNegativeZeroAndPositive(finalValue - from, length - to);\n" \
    "    var direction = 1;\n" \
    "    if (from < to && to < from + count) {\n" \
    "        direction = -1;\n" \
    "        from = from + count - 1;\n" \
    "        to = to + count - 1;\n" \
    "    }\n" \
    "    for (var i = 0; i < count; ++i, from += direction, to += direction) {\n" \
    "        if (from in thisObject)\n" \
    "            thisObject[to] = thisObject[from];\n" \
    "        else\n" \
    "            delete thisObject[to];\n" \
    "    }\n" \
    "    return thisObject;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsCreateResolvingFunctionsCodeLength = 1051;
const char* s_promiseOperationsCreateResolvingFunctionsCode =
    "(function (promise)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var alreadyResolved = false;\n" \
    "    var resolve = function (resolution) {\n" \
    "        if (alreadyResolved)\n" \
    "            return @undefined;\n" \
    "        alreadyResolved = true;\n" \
    "        if (resolution === promise)\n" \
    "            return @rejectPromise(promise, new @TypeError(\"Resolve a promise with itself\"));\n" \
    "        if (!@isObject(resolution))\n" \
    "            return @fulfillPromise(promise, resolution);\n" \
    "        var then;\n" \
    "        try {\n" \
    "            then = resolution.then;\n" \
    "        } catch (error) {\n" \
    "            return @rejectPromise(promise, error);\n" \
    "        }\n" \
    "        if (typeof then !== 'function')\n" \
    "            return @fulfillPromise(promise, resolution);\n" \
    "        @enqueueJob(@promiseResolveThenableJob, [promise, resolution, then]);\n" \
    "        return @undefined;\n" \
    "    };\n" \
    "    var reject = function (reason) {\n" \
    "        if (alreadyResolved)\n" \
    "            return @undefined;\n" \
    "        alreadyResolved = true;\n" \
    "        return @rejectPromise(promise, reason);\n" \
    "    };\n" \
    "    return {\n" \
    "        @resolve: resolve,\n" \
    "        @reject: reject\n" \
    "    };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_reflectObjectDeletePropertyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_reflectObjectDeletePropertyCodeLength = 201;
const char* s_reflectObjectDeletePropertyCode =
    "(function (target, propertyKey)\n" \
    "{\n" \
    "    if (!@isObject(target))\n" \
    "        throw new @TypeError(\"Reflect.deleteProperty requires the first argument be an object\");\n" \
    "    return delete target[propertyKey];\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectEnsureRegisteredCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectEnsureRegisteredCodeLength = 211;
const char* s_moduleLoaderObjectEnsureRegisteredCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.registry.@get(key);\n" \
    "    if (entry)\n" \
    "        return entry;\n" \
    "    entry = this.newRegistryEntry(key);\n" \
    "    this.registry.@set(key, entry);\n" \
    "    return entry;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeEveryCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeEveryCodeLength = 762;
const char* s_arrayPrototypeEveryCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.every requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.every requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.every callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    \n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (!(i in array))\n" \
    "            continue;\n" \
    "        if (!callback.@call(thisArg, array[i], i, array))\n" \
    "            return false;\n" \
    "    }\n" \
    "    \n" \
    "    return true;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeEveryCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeEveryCodeLength = 427;
const char* s_typedArrayPrototypeEveryCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.every callback must be a function\");\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (!callback.@call(thisArg, this[i], i, this))\n" \
    "            return false;\n" \
    "    }\n" \
    "    return true;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeFillCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeFillCodeLength = 1089;
const char* s_arrayPrototypeFillCode =
    "(function (value )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.fill requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.fill requires that |this| not be undefined\");\n" \
    "    var O = @Object(this);\n" \
    "    var len = @toLength(O.length);\n" \
    "    var relativeStart = 0;\n" \
    "    if (arguments.length > 1 && arguments[1] !== @undefined)\n" \
    "        relativeStart = arguments[1] | 0;\n" \
    "    var k = 0;\n" \
    "    if (relativeStart < 0) {\n" \
    "        k = len + relativeStart;\n" \
    "        if (k < 0)\n" \
    "            k = 0;\n" \
    "    } else {\n" \
    "        k = relativeStart;\n" \
    "        if (k > len)\n" \
    "            k = len;\n" \
    "    }\n" \
    "    var relativeEnd = len;\n" \
    "    if (arguments.length > 2 && arguments[2] !== @undefined)\n" \
    "        relativeEnd = arguments[2] | 0;\n" \
    "    var final = 0;\n" \
    "    if (relativeEnd < 0) {\n" \
    "        final = len + relativeEnd;\n" \
    "        if (final < 0)\n" \
    "            final = 0;\n" \
    "    } else {\n" \
    "        final = relativeEnd;\n" \
    "        if (final > len)\n" \
    "            final = len;\n" \
    "    }\n" \
    "    for (; k < final; k++)\n" \
    "        O[k] = value;\n" \
    "    return O;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeFilterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeFilterCodeLength = 898;
const char* s_arrayPrototypeFilterCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.filter requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.filter requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.filter callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var result = [];\n" \
    "    var nextIndex = 0;\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (!(i in array))\n" \
    "            continue;\n" \
    "        var current = array[i]\n" \
    "        if (callback.@call(thisArg, current, i, array)) {\n" \
    "            @putByValDirect(result, nextIndex, current);\n" \
    "            ++nextIndex;\n" \
    "        }\n" \
    "    }\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeFilterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeFilterCodeLength = 603;
const char* s_typedArrayPrototypeFilterCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.filter callback must be a function\");\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var kept = [];\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        var value = this[i];\n" \
    "        if (callback.@call(thisArg, value, i, this))\n" \
    "            kept.@push(value);\n" \
    "    }\n" \
    "    var result = new this.constructor(kept.length);\n" \
    "    for (var i = 0; i < kept.length; i++)\n" \
    "        result[i] = kept[i];\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeFindCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeFindCodeLength = 735;
const char* s_arrayPrototypeFindCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.find requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.find requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.find callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        var kValue = array[i];\n" \
    "        if (callback.@call(thisArg, kValue, i, array))\n" \
    "            return kValue;\n" \
    "    }\n" \
    "    return @undefined;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeFindCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeFindCodeLength = 455;
const char* s_typedArrayPrototypeFindCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.find callback must be a function\");\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        let elem = this[i];\n" \
    "        if (callback.@call(thisArg, elem, i, this))\n" \
    "            return elem;\n" \
    "    }\n" \
    "    return @undefined;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeFindIndexCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeFindIndexCodeLength = 708;
const char* s_arrayPrototypeFindIndexCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.findIndex requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.findIndex requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.findIndex callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (callback.@call(thisArg, array[i], i, array))\n" \
    "            return i;\n" \
    "    }\n" \
    "    return -1;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeFindIndexCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeFindIndexCodeLength = 424;
const char* s_typedArrayPrototypeFindIndexCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.findIndex callback must be a function\");\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (callback.@call(thisArg, this[i], i, this))\n" \
    "            return i;\n" \
    "    }\n" \
    "    return -1;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeForEachCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeForEachCodeLength = 694;
const char* s_arrayPrototypeForEachCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.forEach requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.forEach requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.forEach callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    \n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (i in array)\n" \
    "            callback.@call(thisArg, array[i], i, array);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_mapPrototypeForEachCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_mapPrototypeForEachCodeLength = 566;
const char* s_mapPrototypeForEachCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isMap(this))\n" \
    "        throw new @TypeError(\"Map operation called on non-Map object\");\n" \
    "    if (typeof callback !== 'function')\n" \
    "        throw new @TypeError(\"Map.prototype.forEach callback must be a function\");\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var iterator = @MapIterator(this);\n" \
    "    var value = [ @undefined, @undefined ];\n" \
    "    for (;;) {\n" \
    "        if (@mapIteratorNext.@call(iterator, value))\n" \
    "            break;\n" \
    "        callback.@call(thisArg, value[1], value[0], this);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_setPrototypeForEachCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_setPrototypeForEachCodeLength = 554;
const char* s_setPrototypeForEachCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isSet(this))\n" \
    "        throw new @TypeError(\"Set operation called on non-Set object\");\n" \
    "    if (typeof callback !== 'function')\n" \
    "        throw new @TypeError(\"Set.prototype.forEach callback must be a function\");\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var iterator = @SetIterator(this);\n" \
    "    var value = [ @undefined ];\n" \
    "    for (;;) {\n" \
    "        if (@setIteratorNext.@call(iterator, value))\n" \
    "            break;\n" \
    "        callback.@call(thisArg, value[0], value[0], this);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeForEachCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeForEachCodeLength = 373;
const char* s_typedArrayPrototypeForEachCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.forEach callback must be a function\");\n" \
    "    for (var i = 0; i < length; i++)\n" \
    "        callback.@call(thisArg, this[i], i, this);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectForceFulfillPromiseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectForceFulfillPromiseCodeLength = 147;
const char* s_moduleLoaderObjectForceFulfillPromiseCode =
    "(function (promise, value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (promise.@promiseState === @promiseStatePending)\n" \
    "        @fulfillPromise(promise, value);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayConstructorFromCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayConstructorFromCodeLength = 1983;
const char* s_arrayConstructorFromCode =
    "(function (items )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var thisObj = this;\n" \
    "    var mapFn = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var thisArg;\n" \
    "    if (mapFn !== @undefined) {\n" \
    "        if (typeof mapFn !== \"function\")\n" \
    "            throw new @TypeError(\"Array.from requires that the second argument, when provided, be a function\");\n" \
    "        if (arguments.length > 2)\n" \
    "            thisArg = arguments[2];\n" \
    "    }\n" \
    "    if (items == null)\n" \
    "        throw new @TypeError(\"Array.from requires an array-like object - not null or undefined\");\n" \
    "    var iteratorMethod = items[@symbolIterator];\n" \
    "    if (iteratorMethod != null) {\n" \
    "        if (typeof iteratorMethod !== \"function\")\n" \
    "            throw new @TypeError(\"Array.from requires that the property of the first argument, items[Symbol.iterator], when exists, be a function\");\n" \
    "        var result = (typeof thisObj === \"function\") ? @Object(new thisObj()) : [];\n" \
    "        var k = 0;\n" \
    "        var iterator = iteratorMethod.@call(items);\n" \
    "        var wrapper = {\n" \
    "            [@symbolIterator]() {\n" \
    "                return iterator;\n" \
    "            }\n" \
    "        };\n" \
    "        for (var value of wrapper) {\n" \
    "            if (mapFn)\n" \
    "                @putByValDirect(result, k, thisArg === @undefined ? mapFn(value, k) : mapFn.@call(thisArg, value, k));\n" \
    "            else\n" \
    "                @putByValDirect(result, k, value);\n" \
    "            k += 1;\n" \
    "        }\n" \
    "        result.length = k;\n" \
    "        return result;\n" \
    "    }\n" \
    "    var arrayLike = @Object(items);\n" \
    "    var arrayLikeLength = @toLength(arrayLike.length);\n" \
    "    var result = (typeof thisObj === \"function\") ? @Object(new thisObj(arrayLikeLength)) : new @Array(arrayLikeLength);\n" \
    "    var k = 0;\n" \
    "    while (k < arrayLikeLength) {\n" \
    "        var value = arrayLike[k];\n" \
    "        if (mapFn)\n" \
    "            @putByValDirect(result, k, thisArg === @undefined ? mapFn(value, k) : mapFn.@call(thisArg, value, k));\n" \
    "        else\n" \
    "            @putByValDirect(result, k, value);\n" \
    "        k += 1;\n" \
    "    }\n" \
    "    result.length = arrayLikeLength;\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorFromCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorFromCodeLength = 2240;
const char* s_typedArrayConstructorFromCode =
    "(function (items )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    let mapFn = arguments[1];\n" \
    "    let thisArg;\n" \
    "    if (mapFn !== @undefined) {\n" \
    "        if (typeof mapFn !== \"function\")\n" \
    "            throw new @TypeError(\"TypedArray.from requires that the second argument, when provided, be a function\");\n" \
    "        if (arguments.length > 2)\n" \
    "            thisArg = arguments[2];\n" \
    "    }\n" \
    "    if (items == null)\n" \
    "        throw new @TypeError(\"TypedArray.from requires an array-like object - not null or undefined\");\n" \
    "    let iteratorMethod = items[@symbolIterator];\n" \
    "    if (iteratorMethod != null) {\n" \
    "        if (typeof iteratorMethod !== \"function\")\n" \
    "            throw new @TypeError(\"TypedArray.from requires that the property of the first argument, items[Symbol.iterator], when exists, be a function\");\n" \
    "        let accumulator = [];\n" \
    "        let k = 0;\n" \
    "        let iterator = iteratorMethod.@call(items);\n" \
    "        let wrapper = {\n" \
    "            [@symbolIterator]() {\n" \
    "                return iterator;\n" \
    "            }\n" \
    "        };\n" \
    "        for (let value of wrapper) {\n" \
    "            if (mapFn)\n" \
    "                @putByValDirect(accumulator, k, thisArg === @undefined ? mapFn(value, k) : mapFn.@call(thisArg, value, k));\n" \
    "            else\n" \
    "                @putByValDirect(accumulator, k, value);\n" \
    "            k++;\n" \
    "        }\n" \
    "        let constructFunction = this.@allocateTypedArray;\n" \
    "        if (constructFunction === @undefined)\n" \
    "            throw new @TypeError(\"TypedArray.from requires its this argument subclass a TypedArray constructor\");\n" \
    "        let result = constructFunction(k);\n" \
    "        for (let i = 0; i < k; i++) \n" \
    "            result[i] = accumulator[i];\n" \
    "        return result;\n" \
    "    }\n" \
    "    let arrayLike = @Object(items);\n" \
    "    let arrayLikeLength = @toLength(arrayLike.length);\n" \
    "    let constructFunction = this.@allocateTypedArray;\n" \
    "    if (constructFunction === @undefined)\n" \
    "        throw new @TypeError(\"this does not subclass a TypedArray constructor\");\n" \
    "    let result = constructFunction(arrayLikeLength);\n" \
    "    let k = 0;\n" \
    "    while (k < arrayLikeLength) {\n" \
    "        let value = arrayLike[k];\n" \
    "        if (mapFn)\n" \
    "            result[k] = thisArg === @undefined ? mapFn(value, k) : mapFn.@call(thisArg, value, k);\n" \
    "        else\n" \
    "            result[k] = value;\n" \
    "        k++;\n" \
    "    }\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectFulfillFetchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectFulfillFetchCodeLength = 243;
const char* s_moduleLoaderObjectFulfillFetchCode =
    "(function (entry, payload)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!entry.fetch)\n" \
    "        entry.fetch = @newPromiseCapability(@InternalPromise).@promise;\n" \
    "    this.forceFulfillPromise(entry.fetch, payload);\n" \
    "    this.setStateToMax(entry, this.Translate);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectFulfillInstantiateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectFulfillInstantiateCodeLength = 291;
const char* s_moduleLoaderObjectFulfillInstantiateCode =
    "(function (entry, optionalInstance, source)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!entry.instantiate)\n" \
    "        entry.instantiate = @newPromiseCapability(@InternalPromise).@promise;\n" \
    "    this.commitInstantiated(entry, optionalInstance, source);\n" \
    "    this.forceFulfillPromise(entry.instantiate, entry);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsFulfillPromiseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsFulfillPromiseCodeLength = 416;
const char* s_promiseOperationsFulfillPromiseCode =
    "(function (promise, value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var reactions = promise.@promiseFulfillReactions;\n" \
    "    promise.@promiseResult = value;\n" \
    "    promise.@promiseFulfillReactions = @undefined;\n" \
    "    promise.@promiseRejectReactions = @undefined;\n" \
    "    promise.@promiseState = @promiseStateFulfilled;\n" \
    "    @InspectorInstrumentation.promiseFulfilled(promise, value, reactions);\n" \
    "    @triggerPromiseReactions(reactions, value);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectFulfillTranslateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectFulfillTranslateCodeLength = 255;
const char* s_moduleLoaderObjectFulfillTranslateCode =
    "(function (entry, source)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!entry.translate)\n" \
    "        entry.translate = @newPromiseCapability(@InternalPromise).@promise;\n" \
    "    this.forceFulfillPromise(entry.translate, source);\n" \
    "    this.setStateToMax(entry, this.Instantiate);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_generatorPrototypeGeneratorResumeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_generatorPrototypeGeneratorResumeCodeLength = 1161;
const char* s_generatorPrototypeGeneratorResumeCode =
    "(function (generator, sentValue, resumeMode)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const Completed = -1;\n" \
    "    const Executing = -2;\n" \
    "    const NormalMode = 0;\n" \
    "    const ReturnMode = 1;\n" \
    "    const ThrowMode = 2;\n" \
    "    let state = generator.@generatorState;\n" \
    "    let done = false;\n" \
    "    let value = @undefined;\n" \
    "    if (typeof state !== 'number')\n" \
    "        throw new @TypeError(\"|this| should be a generator\");\n" \
    "    if (state === Executing)\n" \
    "        throw new @TypeError(\"Generator is executing\");\n" \
    "    if (state === Completed) {\n" \
    "        if (resumeMode === ThrowMode)\n" \
    "            throw sentValue;\n" \
    "        done = true;\n" \
    "        if (resumeMode === ReturnMode)\n" \
    "            value = sentValue;\n" \
    "    } else {\n" \
    "        try {\n" \
    "            generator.@generatorState = Executing;\n" \
    "            value = generator.@generatorNext.@call(generator.@generatorThis, generator, state, sentValue, resumeMode);\n" \
    "            if (generator.@generatorState === Executing) {\n" \
    "                generator.@generatorState = Completed;\n" \
    "                done = true;\n" \
    "            }\n" \
    "        } catch (error) {\n" \
    "            generator.@generatorState = Completed;\n" \
    "            throw error;\n" \
    "        }\n" \
    "    }\n" \
    "    return { done, value };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_reflectObjectHasCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_reflectObjectHasCodeLength = 203;
const char* s_reflectObjectHasCode =
    "(function (target, propertyKey)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isObject(target))\n" \
    "        throw new @TypeError(\"Reflect.has requires the first argument be an object\");\n" \
    "    return propertyKey in target;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeIncludesCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeIncludesCodeLength = 947;
const char* s_arrayPrototypeIncludesCode =
    "(function (searchElement )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.includes requires that |this| not be null\");\n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.includes requires that |this| not be undefined\");\n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (length === 0)\n" \
    "        return false;\n" \
    "    var fromIndex = 0;\n" \
    "    if (arguments.length > 1 && arguments[1] !== @undefined)\n" \
    "        fromIndex = arguments[1] | 0;\n" \
    "    var index;\n" \
    "    if (fromIndex >= 0)\n" \
    "        index = fromIndex;\n" \
    "    else\n" \
    "        index = length + fromIndex;\n" \
    "    if (index < 0)\n" \
    "        index = 0;\n" \
    "    var currentElement;\n" \
    "    for (; index < length; ++index) {\n" \
    "        currentElement = array[index];\n" \
    "        if (searchElement === currentElement || (searchElement !== searchElement && currentElement !== currentElement))\n" \
    "            return true;\n" \
    "    }\n" \
    "    return false;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsInitializePromiseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsInitializePromiseCodeLength = 549;
const char* s_promiseOperationsInitializePromiseCode =
    "(function (executor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (typeof executor !== 'function')\n" \
    "        throw new @TypeError(\"Promise constructor takes a function argument\");\n" \
    "    this.@promiseState = @promiseStatePending;\n" \
    "    this.@promiseFulfillReactions = [];\n" \
    "    this.@promiseRejectReactions = [];\n" \
    "    var resolvingFunctions = @createResolvingFunctions(this);\n" \
    "    try {\n" \
    "        executor(resolvingFunctions.@resolve, resolvingFunctions.@reject);\n" \
    "    } catch (error) {\n" \
    "        return resolvingFunctions.@reject.@call(@undefined, error);\n" \
    "    }\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectInstantiationCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectInstantiationCodeLength = 105;
const char* s_moduleLoaderObjectInstantiationCode =
    "(function (result, source, entry)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this.parseModule(entry.key, source);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_internalPromiseConstructorInternalAllCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_internalPromiseConstructorInternalAllCodeLength = 1536;
const char* s_internalPromiseConstructorInternalAllCode =
    "(function (array)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var promiseCapability = @newPromiseCapability(@InternalPromise);\n" \
    "    var values = [];\n" \
    "    var index = 0;\n" \
    "    var remainingElementsCount = 0;\n" \
    "    function newResolveElement(index)\n" \
    "    {\n" \
    "        var alreadyCalled = false;\n" \
    "        return function (argument)\n" \
    "        {\n" \
    "            if (alreadyCalled)\n" \
    "                return @undefined;\n" \
    "            alreadyCalled = true;\n" \
    "            @putByValDirect(values, index, argument);\n" \
    "            --remainingElementsCount;\n" \
    "            if (remainingElementsCount === 0)\n" \
    "                return promiseCapability.@resolve.@call(@undefined, values);\n" \
    "            return @undefined;\n" \
    "        }\n" \
    "    }\n" \
    "    try {\n" \
    "        if (array.length === 0)\n" \
    "            promiseCapability.@resolve.@call(@undefined, values);\n" \
    "        else {\n" \
    "            for (var index = 0, length = array.length; index < length; ++index) {\n" \
    "                var value = array[index];\n" \
    "                @putByValDirect(values, index, @undefined);\n" \
    "                var nextPromiseCapability = @newPromiseCapability(@InternalPromise);\n" \
    "                nextPromiseCapability.@resolve.@call(@undefined, value);\n" \
    "                var nextPromise = nextPromiseCapability.@promise;\n" \
    "                var resolveElement = newResolveElement(index);\n" \
    "                ++remainingElementsCount;\n" \
    "                nextPromise.then(resolveElement, promiseCapability.@reject);\n" \
    "            }\n" \
    "        }\n" \
    "    } catch (error) {\n" \
    "        promiseCapability.@reject.@call(@undefined, error);\n" \
    "    }\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_globalObjectIsDictionaryCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_globalObjectIsDictionaryCodeLength = 124;
const char* s_globalObjectIsDictionaryCode =
    "(function (object)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return object === @undefined || object == null || typeof object === \"object\";\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsIsPromiseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsIsPromiseCodeLength = 101;
const char* s_promiseOperationsIsPromiseCode =
    "(function (promise)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @isObject(promise) && !!promise.@promiseState;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectLinkCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectLinkCodeLength = 390;
const char* s_moduleLoaderObjectLinkCode =
    "(function (entry)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (entry.state === this.Ready)\n" \
    "        return;\n" \
    "    this.setStateToMax(entry, this.Ready);\n" \
    "    var dependencies = entry.dependencies;\n" \
    "    for (var i = 0, length = dependencies.length; i < length; ++i) {\n" \
    "        var pair = dependencies[i];\n" \
    "        this.link(pair.value.registryEntry);\n" \
    "    }\n" \
    "    this.moduleDeclarationInstantiation(entry.module);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectLinkAndEvaluateModuleCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectLinkAndEvaluateModuleCodeLength = 74;
const char* s_moduleLoaderObjectLinkAndEvaluateModuleCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this.requestReady(key);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectLoadAndEvaluateModuleCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectLoadAndEvaluateModuleCodeLength = 196;
const char* s_moduleLoaderObjectLoadAndEvaluateModuleCode =
    "(function (moduleName, referrer)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var loader = this;\n" \
    "    return this.resolve(moduleName, referrer).then(function (key) {\n" \
    "        return loader.requestReady(key);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectLoadModuleCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectLoadModuleCodeLength = 262;
const char* s_moduleLoaderObjectLoadModuleCode =
    "(function (moduleName, referrer)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var loader = this;\n" \
    "    return this.resolve(moduleName, referrer).then(function (key) {\n" \
    "        return loader.requestInstantiateAll(key);\n" \
    "    }).then(function (entry) {\n" \
    "        return entry.key;\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_stringPrototypeLocaleCompareCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_stringPrototypeLocaleCompareCodeLength = 623;
const char* s_stringPrototypeLocaleCompareCode =
    "(function (that)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"String.prototype.localeCompare requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"String.prototype.localeCompare requires that |this| not be undefined\");\n" \
    "    var thisString = @toString(this);\n" \
    "    var thatString = @toString(that);\n" \
    "    if (arguments[1] === @undefined && arguments[2] === @undefined)\n" \
    "        return @Collator.prototype.compare(thisString, thatString);\n" \
    "    var collator = new @Collator(arguments[1], arguments[2]);\n" \
    "    return collator.compare(thisString, thatString);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeMapCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeMapCodeLength = 856;
const char* s_arrayPrototypeMapCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.map requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.map requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.map callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var result = [];\n" \
    "    result.length = length;\n" \
    "    var nextIndex = 0;\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (!(i in array))\n" \
    "            continue;\n" \
    "        var mappedValue = callback.@call(thisArg, array[i], i, array);\n" \
    "        @putByValDirect(result, i, mappedValue);\n" \
    "    }\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeMapCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeMapCodeLength = 494;
const char* s_typedArrayPrototypeMapCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.map callback must be a function\");\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    var result = new this.constructor(length);\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        var mappedValue = callback.@call(thisArg, this[i], i, this);\n" \
    "        result[i] = mappedValue;\n" \
    "    }\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectModuleEvaluationCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectModuleEvaluationCodeLength = 473;
const char* s_moduleLoaderObjectModuleEvaluationCode =
    "(function (moduleRecord)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (moduleRecord.evaluated)\n" \
    "        return;\n" \
    "    moduleRecord.evaluated = true;\n" \
    "    var entry = moduleRecord.registryEntry;\n" \
    "    var dependencies = entry.dependencies;\n" \
    "    for (var i = 0, length = dependencies.length; i < length; ++i) {\n" \
    "        var pair = dependencies[i];\n" \
    "        var requiredModuleRecord = pair.value;\n" \
    "        this.moduleEvaluation(requiredModuleRecord);\n" \
    "    }\n" \
    "    this.evaluate(entry.key, moduleRecord);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilityCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsNewPromiseCapabilityCodeLength = 1065;
const char* s_promiseOperationsNewPromiseCapabilityCode =
    "(function (constructor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (typeof constructor !== \"function\")\n" \
    "        throw new @TypeError(\"promise capability requires a constructor function\");\n" \
    "    var promiseCapability = {\n" \
    "        @promise: @undefined,\n" \
    "        @resolve: @undefined,\n" \
    "        @reject: @undefined\n" \
    "    };\n" \
    "    function executor(resolve, reject)\n" \
    "    {\n" \
    "        if (promiseCapability.@resolve !== @undefined)\n" \
    "            throw new @TypeError(\"resolve function is already set\");\n" \
    "        if (promiseCapability.@reject !== @undefined)\n" \
    "            throw new @TypeError(\"reject function is already set\");\n" \
    "        promiseCapability.@resolve = resolve;\n" \
    "        promiseCapability.@reject = reject;\n" \
    "    }\n" \
    "    var promise = new constructor(executor);\n" \
    "    if (typeof promiseCapability.@resolve !== \"function\")\n" \
    "        throw new @TypeError(\"executor did not take a resolve function\");\n" \
    "    if (typeof promiseCapability.@reject !== \"function\")\n" \
    "        throw new @TypeError(\"executor did not take a reject function\");\n" \
    "    promiseCapability.@promise = promise;\n" \
    "    return promiseCapability;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsNewPromiseReactionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsNewPromiseReactionCodeLength = 136;
const char* s_promiseOperationsNewPromiseReactionCode =
    "(function (capability, handler)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return {\n" \
    "        @capabilities: capability,\n" \
    "        @handler: handler\n" \
    "    };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectNewRegistryEntryCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectNewRegistryEntryCodeLength = 384;
const char* s_moduleLoaderObjectNewRegistryEntryCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return {\n" \
    "        key: key,\n" \
    "        state: this.Fetch,\n" \
    "        metadata: @undefined,\n" \
    "        fetch: @undefined,\n" \
    "        translate: @undefined,\n" \
    "        instantiate: @undefined,\n" \
    "        resolveDependencies: @undefined,\n" \
    "        dependencies: [],\n" \
    "        dependenciesMap: @undefined,\n" \
    "        module: @undefined,\n" \
    "        error: @undefined,\n" \
    "    };\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayIteratorPrototypeNextCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayIteratorPrototypeNextCodeLength = 1058;
const char* s_arrayIteratorPrototypeNextCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this == null)\n" \
    "        throw new @TypeError(\"%ArrayIteratorPrototype%.next requires that |this| not be null or undefined\");\n" \
    "    var itemKind = this.@arrayIterationKind;\n" \
    "    if (itemKind === @undefined)\n" \
    "        throw new @TypeError(\"%ArrayIteratorPrototype%.next requires that |this| be an Array Iterator instance\");\n" \
    "    var done = true;\n" \
    "    var value = @undefined;\n" \
    "    var array = this.@iteratedObject;\n" \
    "    if (array !== @undefined) {\n" \
    "        var index = this.@arrayIteratorNextIndex;\n" \
    "        var length = array.length >>> 0;\n" \
    "        if (index >= length) {\n" \
    "            this.@iteratedObject = @undefined;\n" \
    "        } else {\n" \
    "            this.@arrayIteratorNextIndex = index + 1;\n" \
    "            done = false;\n" \
    "            if (itemKind === @arrayIterationKindKey) {\n" \
    "                value = index;\n" \
    "            } else if (itemKind === @arrayIterationKindValue) {\n" \
    "                value = array[index];\n" \
    "            } else {\n" \
    "                value = [ index, array[index] ];\n" \
    "            }\n" \
    "        }\n" \
    "    }\n" \
    "    return {done, value};\n" \
    "})\n" \
;

const JSC::ConstructAbility s_generatorPrototypeNextCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_generatorPrototypeNextCodeLength = 87;
const char* s_generatorPrototypeNextCode =
    "(function (value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @generatorResume(this, value,  0);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_stringIteratorPrototypeNextCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_stringIteratorPrototypeNextCodeLength = 1225;
const char* s_stringIteratorPrototypeNextCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this == null)\n" \
    "        throw new @TypeError(\"%StringIteratorPrototype%.next requires that |this| not be null or undefined\");\n" \
    "    var position = this.@stringIteratorNextIndex;\n" \
    "    if (position === @undefined)\n" \
    "        throw new @TypeError(\"%StringIteratorPrototype%.next requires that |this| be a String Iterator instance\");\n" \
    "    var done = true;\n" \
    "    var value = @undefined;\n" \
    "    var string = this.@iteratedString;\n" \
    "    if (string !== @undefined) {\n" \
    "        var length = string.length >>> 0;\n" \
    "        if (position >= length) {\n" \
    "            this.@iteratedString = @undefined;\n" \
    "        } else {\n" \
    "            done = false;\n" \
    "            var first = string.@charCodeAt(position);\n" \
    "            if (first < 0xD800 || first > 0xDBFF || position + 1 === length)\n" \
    "                value = string[position];\n" \
    "            else {\n" \
    "                var second = string.@charCodeAt(position + 1);\n" \
    "                if (second < 0xDC00 || second > 0xDFFF)\n" \
    "                    value = string[position];\n" \
    "                else\n" \
    "                    value = string[position] + string[position + 1];\n" \
    "            }\n" \
    "            this.@stringIteratorNextIndex = position + value.length;\n" \
    "        }\n" \
    "    }\n" \
    "    return {done, value};\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayConstructorOfCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayConstructorOfCodeLength = 286;
const char* s_arrayConstructorOfCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = arguments.length;\n" \
    "    var array = typeof this === 'function' ? new this(length) : new @Array(length);\n" \
    "    for (var k = 0; k < length; ++k)\n" \
    "        @putByValDirect(array, k, arguments[k]);\n" \
    "    array.length = length;\n" \
    "    return array;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayConstructorOfCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayConstructorOfCodeLength = 405;
const char* s_typedArrayConstructorOfCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    let len = arguments.length;\n" \
    "    let constructFunction = this.@allocateTypedArray;\n" \
    "    if (constructFunction === @undefined)\n" \
    "        throw new @TypeError(\"TypedArray.from requires its this argument to subclass a TypedArray constructor\");\n" \
    "    let result = constructFunction(len);\n" \
    "    for (let i = 0; i < len; i++)\n" \
    "        result[i] = arguments[i];\n" \
    "    return result;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_inspectorInstrumentationObjectPromiseFulfilledCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_inspectorInstrumentationObjectPromiseFulfilledCodeLength = 102;
const char* s_inspectorInstrumentationObjectPromiseFulfilledCode =
    "(function (promise, value, reactions)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!this.isEnabled)\n" \
    "        return;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsPromiseReactionJobCodeLength = 356;
const char* s_promiseOperationsPromiseReactionJobCode =
    "(function (reaction, argument)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var promiseCapability = reaction.@capabilities;\n" \
    "    var result;\n" \
    "    try {\n" \
    "        result = reaction.@handler.@call(@undefined, argument);\n" \
    "    } catch (error) {\n" \
    "        return promiseCapability.@reject.@call(@undefined, error);\n" \
    "    }\n" \
    "    return promiseCapability.@resolve.@call(@undefined, result);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_inspectorInstrumentationObjectPromiseRejectedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_inspectorInstrumentationObjectPromiseRejectedCodeLength = 103;
const char* s_inspectorInstrumentationObjectPromiseRejectedCode =
    "(function (promise, reason, reactions)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!this.isEnabled)\n" \
    "        return;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsPromiseResolveThenableJobCodeLength = 342;
const char* s_promiseOperationsPromiseResolveThenableJobCode =
    "(function (promiseToResolve, thenable, then)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var resolvingFunctions = @createResolvingFunctions(promiseToResolve);\n" \
    "    try {\n" \
    "        return then.@call(thenable, resolvingFunctions.@resolve, resolvingFunctions.@reject);\n" \
    "    } catch (error) {\n" \
    "        return resolvingFunctions.@reject.@call(@undefined, error);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectProvideCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectProvideCodeLength = 1077;
const char* s_moduleLoaderObjectProvideCode =
    "(function (key, stage, value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.ensureRegistered(key);\n" \
    "    if (stage === this.Fetch) {\n" \
    "        if (entry.status > this.Fetch)\n" \
    "            throw new @TypeError(\"Requested module is already fetched.\");\n" \
    "        this.fulfillFetch(entry, value);\n" \
    "        return;\n" \
    "    }\n" \
    "    if (stage === this.Translate) {\n" \
    "        if (entry.status > this.Translate)\n" \
    "            throw new @TypeError(\"Requested module is already translated.\");\n" \
    "        this.fulfillFetch(entry, @undefined);\n" \
    "        this.fulfillTranslate(entry, value);\n" \
    "        return;\n" \
    "    }\n" \
    "    if (stage === this.Instantiate) {\n" \
    "        if (entry.status > this.Instantiate)\n" \
    "            throw new @TypeError(\"Requested module is already instantiated.\");\n" \
    "        this.fulfillFetch(entry, @undefined);\n" \
    "        this.fulfillTranslate(entry, value);\n" \
    "        var loader = this;\n" \
    "        entry.translate.then(function (source) {\n" \
    "            loader.fulfillInstantiate(entry, value, source);\n" \
    "        });\n" \
    "        return;\n" \
    "    }\n" \
    "    throw new @TypeError(\"Requested module is already ready to be executed.\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseConstructorRaceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseConstructorRaceCodeLength = 546;
const char* s_promiseConstructorRaceCode =
    "(function (iterable)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isObject(this))\n" \
    "        throw new @TypeError(\"|this| is not a object\");\n" \
    "    var constructor = this;\n" \
    "    var promiseCapability = @newPromiseCapability(constructor);\n" \
    "    try {\n" \
    "        for (var value of iterable) {\n" \
    "            var nextPromise = constructor.resolve(value);\n" \
    "            nextPromise.then(promiseCapability.@resolve, promiseCapability.@reject);\n" \
    "        }\n" \
    "    } catch (error) {\n" \
    "        promiseCapability.@reject.@call(@undefined, error);\n" \
    "    }\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_stringConstructorRawCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_stringConstructorRawCodeLength = 1045;
const char* s_stringConstructorRawCode =
    "(function (template)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (template === null || template === @undefined)\n" \
    "        throw new @TypeError(\"String.raw requires template not be null or undefined\");\n" \
    "    var cookedSegments = @Object(template);\n" \
    "    var rawValue = cookedSegments.raw;\n" \
    "    if (rawValue === null || rawValue === @undefined)\n" \
    "        throw new @TypeError(\"String.raw requires template.raw not be null or undefined\");\n" \
    "    var rawSegments = @Object(rawValue);\n" \
    "    var numberOfSubstitutions = arguments.length - 1;\n" \
    "    var segmentCount = @toLength(rawSegments.length);\n" \
    "    if (segmentCount <= 0)\n" \
    "        return '';\n" \
    "    var stringElements = '';\n" \
    "    for (var i = 0; ; ++i) {\n" \
    "        var segment = @toString(rawSegments[i]);\n" \
    "        stringElements += segment;\n" \
    "        if ((i + 1) === segmentCount)\n" \
    "            return stringElements;\n" \
    "        if (i < numberOfSubstitutions) {\n" \
    "            var substitutionIndexInArguments = i + 1;\n" \
    "            var next = @toString(arguments[substitutionIndexInArguments]);\n" \
    "            stringElements += next;\n" \
    "        }\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeReduceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeReduceCodeLength = 1097;
const char* s_arrayPrototypeReduceCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.reduce requires that |this| not be null\");\n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.reduce requires that |this| not be undefined\");\n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.reduce callback must be a function\");\n" \
    "    if (length === 0 && arguments.length < 2)\n" \
    "        throw new @TypeError(\"reduce of empty array with no initial value\");\n" \
    "    var accumulator, k = 0;\n" \
    "    if (arguments.length > 1)\n" \
    "        accumulator = arguments[1];\n" \
    "    else {\n" \
    "        while (k < length && !(k in array))\n" \
    "            k += 1;\n" \
    "        if (k >= length)\n" \
    "            throw new @TypeError(\"reduce of empty array with no initial value\");\n" \
    "        accumulator = array[k++];\n" \
    "    }\n" \
    "    while (k < length) {\n" \
    "        if (k in array)\n" \
    "            accumulator = callback.@call(@undefined, accumulator, array[k], k, array);\n" \
    "        k += 1;\n" \
    "    }\n" \
    "    return accumulator;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeReduceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeReduceCodeLength = 629;
const char* s_typedArrayPrototypeReduceCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.reduce callback must be a function\");\n" \
    "    if (length === 0 && arguments.length < 2)\n" \
    "        throw new @TypeError(\"TypedArray.prototype.reduce of empty array with no initial value\");\n" \
    "    var accumulator, k = 0;\n" \
    "    if (arguments.length > 1)\n" \
    "        accumulator = arguments[1];\n" \
    "    else\n" \
    "        accumulator = this[k++];\n" \
    "    for (; k < length; k++)\n" \
    "        accumulator = callback.@call(@undefined, accumulator, this[k], k, this);\n" \
    "    return accumulator;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeReduceRightCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeReduceRightCodeLength = 1117;
const char* s_arrayPrototypeReduceRightCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.reduceRight requires that |this| not be null\");\n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.reduceRight requires that |this| not be undefined\");\n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.reduceRight callback must be a function\");\n" \
    "    if (length === 0 && arguments.length < 2)\n" \
    "        throw new @TypeError(\"reduceRight of empty array with no initial value\");\n" \
    "    var accumulator, k = length - 1;\n" \
    "    if (arguments.length > 1)\n" \
    "        accumulator = arguments[1];\n" \
    "    else {\n" \
    "        while (k >= 0 && !(k in array))\n" \
    "            k -= 1;\n" \
    "        if (k < 0)\n" \
    "            throw new @TypeError(\"reduceRight of empty array with no initial value\");\n" \
    "        accumulator = array[k--];\n" \
    "    }\n" \
    "    while (k >= 0) {\n" \
    "        if (k in array)\n" \
    "            accumulator = callback.@call(@undefined, accumulator, array[k], k, array);\n" \
    "        k -= 1;\n" \
    "    }\n" \
    "    return accumulator;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeReduceRightCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeReduceRightCodeLength = 644;
const char* s_typedArrayPrototypeReduceRightCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.reduceRight callback must be a function\");\n" \
    "    if (length === 0 && arguments.length < 2)\n" \
    "        throw new @TypeError(\"TypedArray.prototype.reduceRight of empty array with no initial value\");\n" \
    "    var accumulator, k = length - 1;\n" \
    "    if (arguments.length > 1)\n" \
    "        accumulator = arguments[1];\n" \
    "    else\n" \
    "        accumulator = this[k--];\n" \
    "    for (; k >= 0; k--)\n" \
    "        accumulator = callback.@call(@undefined, accumulator, this[k], k, this);\n" \
    "    return accumulator;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseConstructorRejectCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseConstructorRejectCodeLength = 277;
const char* s_promiseConstructorRejectCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isObject(this))\n" \
    "        throw new @TypeError(\"|this| is not a object\");\n" \
    "    var promiseCapability = @newPromiseCapability(this);\n" \
    "    promiseCapability.@reject.@call(@undefined, reason);\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsRejectPromiseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsRejectPromiseCodeLength = 417;
const char* s_promiseOperationsRejectPromiseCode =
    "(function (promise, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var reactions = promise.@promiseRejectReactions;\n" \
    "    promise.@promiseResult = reason;\n" \
    "    promise.@promiseFulfillReactions = @undefined;\n" \
    "    promise.@promiseRejectReactions = @undefined;\n" \
    "    promise.@promiseState = @promiseStateRejected;\n" \
    "    @InspectorInstrumentation.promiseRejected(promise, reason, reactions);\n" \
    "    @triggerPromiseReactions(reactions, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestFetchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestFetchCodeLength = 616;
const char* s_moduleLoaderObjectRequestFetchCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.ensureRegistered(key);\n" \
    "    if (entry.state > this.Link) {\n" \
    "        var deferred = @newPromiseCapability(@InternalPromise);\n" \
    "        deferred.@reject.@call(@undefined, new @TypeError(\"Requested module is already ready to be executed.\"));\n" \
    "        return deferred.@promise;\n" \
    "    }\n" \
    "    if (entry.fetch)\n" \
    "        return entry.fetch;\n" \
    "    var loader = this;\n" \
    "    var fetchPromise = this.fetch(key).then(function (payload) {\n" \
    "        loader.setStateToMax(entry, loader.Translate);\n" \
    "        return payload;\n" \
    "    });\n" \
    "    entry.fetch = fetchPromise;\n" \
    "    return fetchPromise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestInstantiateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestInstantiateCodeLength = 775;
const char* s_moduleLoaderObjectRequestInstantiateCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.ensureRegistered(key);\n" \
    "    if (entry.state > this.Link) {\n" \
    "        var deferred = @newPromiseCapability(@InternalPromise);\n" \
    "        deferred.@reject.@call(@undefined, new @TypeError(\"Requested module is already ready to be executed.\"));\n" \
    "        return deferred.@promise;\n" \
    "    }\n" \
    "    if (entry.instantiate)\n" \
    "        return entry.instantiate;\n" \
    "    var loader = this;\n" \
    "    var instantiatePromise = this.requestTranslate(key).then(function (source) {\n" \
    "        return loader.instantiate(key, source).then(function (optionalInstance) {\n" \
    "            loader.commitInstantiated(entry, optionalInstance, source);\n" \
    "            return entry;\n" \
    "        });\n" \
    "    });\n" \
    "    entry.instantiate = instantiatePromise;\n" \
    "    return instantiatePromise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestInstantiateAllCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestInstantiateAllCodeLength = 88;
const char* s_moduleLoaderObjectRequestInstantiateAllCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this.requestResolveDependencies(key);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestLinkCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestLinkCodeLength = 429;
const char* s_moduleLoaderObjectRequestLinkCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.ensureRegistered(key);\n" \
    "    if (entry.state > this.Link) {\n" \
    "        var deferred = @newPromiseCapability(@InternalPromise);\n" \
    "        deferred.@resolve.@call(@undefined, entry.module);\n" \
    "        return deferred.@promise;\n" \
    "    }\n" \
    "    var loader = this;\n" \
    "    return this.requestInstantiateAll(key).then(function (entry) {\n" \
    "        loader.link(entry);\n" \
    "        return entry;\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestReadyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestReadyCodeLength = 174;
const char* s_moduleLoaderObjectRequestReadyCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var loader = this;\n" \
    "    return this.requestLink(key).then(function (entry) {\n" \
    "        loader.moduleEvaluation(entry.module);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestResolveDependenciesCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestResolveDependenciesCodeLength = 1623;
const char* s_moduleLoaderObjectRequestResolveDependenciesCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.ensureRegistered(key);\n" \
    "    if (entry.state > this.Link) {\n" \
    "        var deferred = @newPromiseCapability(@InternalPromise);\n" \
    "        deferred.@reject.@call(@undefined, new @TypeError(\"Requested module is already ready to be executed.\"));\n" \
    "        return deferred.@promise;\n" \
    "    }\n" \
    "    if (entry.resolveDependencies)\n" \
    "        return entry.resolveDependencies;\n" \
    "    var loader = this;\n" \
    "    var resolveDependenciesPromise = this.requestInstantiate(key).then(function (entry) {\n" \
    "        var depLoads = [];\n" \
    "        for (var i = 0, length = entry.dependencies.length; i < length; ++i) {\n" \
    "            let pair = entry.dependencies[i];\n" \
    "            var promise = loader.resolve(pair.key, key).then(function (depKey) {\n" \
    "                var depEntry = loader.ensureRegistered(depKey);\n" \
    "                if (depEntry.resolveDependencies) {\n" \
    "                    return depEntry.instantiate.then(function (entry) {\n" \
    "                        pair.value = entry.module;\n" \
    "                        return entry;\n" \
    "                    });\n" \
    "                }\n" \
    "                return loader.requestResolveDependencies(depKey).then(function (entry) {\n" \
    "                    pair.value = entry.module;\n" \
    "                    return entry;\n" \
    "                });\n" \
    "            });\n" \
    "            @putByValDirect(depLoads, i, promise);\n" \
    "        }\n" \
    "        return @InternalPromise.internalAll(depLoads).then(function (modules) {\n" \
    "            loader.setStateToMax(entry, loader.Link);\n" \
    "            return entry;\n" \
    "        });\n" \
    "    });\n" \
    "    entry.resolveDependencies = resolveDependenciesPromise;\n" \
    "    return resolveDependenciesPromise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectRequestTranslateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectRequestTranslateCodeLength = 739;
const char* s_moduleLoaderObjectRequestTranslateCode =
    "(function (key)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var entry = this.ensureRegistered(key);\n" \
    "    if (entry.state > this.Link) {\n" \
    "        var deferred = @newPromiseCapability(@InternalPromise);\n" \
    "        deferred.@reject.@call(@undefined, new @TypeError(\"Requested module is already ready to be executed.\"));\n" \
    "        return deferred.@promise;\n" \
    "    }\n" \
    "    if (entry.translate)\n" \
    "        return entry.translate;\n" \
    "    var loader = this;\n" \
    "    var translatePromise = this.requestFetch(key).then(function (payload) {\n" \
    "        return loader.translate(key, payload).then(function (source) {\n" \
    "            loader.setStateToMax(entry, loader.Instantiate);\n" \
    "            return source;\n" \
    "        });\n" \
    "    });\n" \
    "    entry.translate = translatePromise;\n" \
    "    return translatePromise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseConstructorResolveCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseConstructorResolveCodeLength = 426;
const char* s_promiseConstructorResolveCode =
    "(function (value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isObject(this))\n" \
    "        throw new @TypeError(\"|this| is not a object\");\n" \
    "    if (@isPromise(value)) {\n" \
    "        var valueConstructor = value.constructor;\n" \
    "        if (valueConstructor === this)\n" \
    "            return value;\n" \
    "    }\n" \
    "    var promiseCapability = @newPromiseCapability(this);\n" \
    "    promiseCapability.@resolve.@call(@undefined, value);\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_generatorPrototypeReturnCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_generatorPrototypeReturnCodeLength = 87;
const char* s_generatorPrototypeReturnCode =
    "(function (value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @generatorResume(this, value,  1);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_stringPrototypeSearchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_stringPrototypeSearchCodeLength = 602;
const char* s_stringPrototypeSearchCode =
    "(function (regexp)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this == null) {\n" \
    "        if (this === null)\n" \
    "            throw new @TypeError(\"String.prototype.search requires that |this| not be null\");\n" \
    "        throw new @TypeError(\"String.prototype.search requires that |this| not be undefined\");\n" \
    "    }\n" \
    "    if (regexp != null) {\n" \
    "         var searcher = regexp[@symbolSearch];\n" \
    "         if (searcher !== @undefined)\n" \
    "            return searcher.@call(regexp, this);\n" \
    "    }\n" \
    "    var thisString = @toString(this);\n" \
    "    var createdRegExp = new @RegExp(regexp, @undefined);\n" \
    "    return createdRegExp[@symbolSearch](thisString);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_moduleLoaderObjectSetStateToMaxCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_moduleLoaderObjectSetStateToMaxCodeLength = 115;
const char* s_moduleLoaderObjectSetStateToMaxCode =
    "(function (entry, newState)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (entry.state < newState)\n" \
    "        entry.state = newState;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeSomeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeSomeCodeLength = 748;
const char* s_arrayPrototypeSomeCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.some requires that |this| not be null\");\n" \
    "    \n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.some requires that |this| not be undefined\");\n" \
    "    \n" \
    "    var array = @Object(this);\n" \
    "    var length = @toLength(array.length);\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"Array.prototype.some callback must be a function\");\n" \
    "    \n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (!(i in array))\n" \
    "            continue;\n" \
    "        if (callback.@call(thisArg, array[i], i, array))\n" \
    "            return true;\n" \
    "    }\n" \
    "    return false;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeSomeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeSomeCodeLength = 425;
const char* s_typedArrayPrototypeSomeCode =
    "(function (callback )\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    var thisArg = arguments.length > 1 ? arguments[1] : @undefined;\n" \
    "    if (typeof callback !== \"function\")\n" \
    "        throw new @TypeError(\"TypedArray.prototype.some callback must be a function\");\n" \
    "    for (var i = 0; i < length; i++) {\n" \
    "        if (callback.@call(thisArg, this[i], i, this))\n" \
    "            return true;\n" \
    "    }\n" \
    "    return false;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_arrayPrototypeSortCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_arrayPrototypeSortCodeLength = 6060;
const char* s_arrayPrototypeSortCode =
    "(function (comparator)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    function min(a, b)\n" \
    "    {\n" \
    "        return a < b ? a : b;\n" \
    "    }\n" \
    "    function stringComparator(a, b)\n" \
    "    {\n" \
    "        var aString = a.string;\n" \
    "        var bString = b.string;\n" \
    "        var aLength = aString.length;\n" \
    "        var bLength = bString.length;\n" \
    "        var length = min(aLength, bLength);\n" \
    "        for (var i = 0; i < length; ++i) {\n" \
    "            var aCharCode = aString.@charCodeAt(i);\n" \
    "            var bCharCode = bString.@charCodeAt(i);\n" \
    "            if (aCharCode == bCharCode)\n" \
    "                continue;\n" \
    "            return aCharCode - bCharCode;\n" \
    "        }\n" \
    "        return aLength - bLength;\n" \
    "    }\n" \
    "    function compactSparse(array, dst, src, length)\n" \
    "    {\n" \
    "        var values = [ ];\n" \
    "        var seen = { };\n" \
    "        var valueCount = 0;\n" \
    "        var undefinedCount = 0;\n" \
    "        for (var i = dst; i < src; ++i)\n" \
    "            delete array[i];\n" \
    "        for (var object = array; object; object = @Object.@getPrototypeOf(object)) {\n" \
    "            var propertyNames = @Object.@getOwnPropertyNames(object);\n" \
    "            for (var i = 0; i < propertyNames.length; ++i) {\n" \
    "                var index = propertyNames[i];\n" \
    "                if (index < length) {\n" \
    "                    if (seen[index])\n" \
    "                        continue;\n" \
    "                    seen[index] = 1;\n" \
    "                    var value = array[index];\n" \
    "                    delete array[index];\n" \
    "                    if (value === @undefined) {\n" \
    "                        ++undefinedCount;\n" \
    "                        continue;\n" \
    "                    }\n" \
    "                    array[valueCount++] = value;\n" \
    "                }\n" \
    "            }\n" \
    "        }\n" \
    "        for (var i = valueCount; i < valueCount + undefinedCount; ++i)\n" \
    "            array[i] = @undefined;\n" \
    "        return valueCount;\n" \
    "    }\n" \
    "    function compactSlow(array, length)\n" \
    "    {\n" \
    "        var holeCount = 0;\n" \
    "        for (var dst = 0, src = 0; src < length; ++src) {\n" \
    "            if (!(src in array)) {\n" \
    "                ++holeCount;\n" \
    "                if (holeCount < 256)\n" \
    "                    continue;\n" \
    "                return compactSparse(array, dst, src, length);\n" \
    "            }\n" \
    "            var value = array[src];\n" \
    "            if (value === @undefined)\n" \
    "                continue;\n" \
    "            array[dst++] = value;\n" \
    "        }\n" \
    "        var valueCount = dst;\n" \
    "        var undefinedCount = length - valueCount - holeCount;\n" \
    "        for (var i = valueCount; i < valueCount + undefinedCount; ++i)\n" \
    "            array[i] = @undefined;\n" \
    "        for (var i = valueCount + undefinedCount; i < length; ++i)\n" \
    "            delete array[i];\n" \
    "        return valueCount;\n" \
    "    }\n" \
    "    function compact(array, length)\n" \
    "    {\n" \
    "        for (var i = 0; i < array.length; ++i) {\n" \
    "            if (array[i] === @undefined)\n" \
    "                return compactSlow(array, length);\n" \
    "        }\n" \
    "        return length;\n" \
    "    }\n" \
    "    function merge(dst, src, srcIndex, srcEnd, width, comparator)\n" \
    "    {\n" \
    "        var left = srcIndex;\n" \
    "        var leftEnd = min(left + width, srcEnd);\n" \
    "        var right = leftEnd;\n" \
    "        var rightEnd = min(right + width, srcEnd);\n" \
    "        for (var dstIndex = left; dstIndex < rightEnd; ++dstIndex) {\n" \
    "            if (right < rightEnd) {\n" \
    "                if (left >= leftEnd || comparator(src[right], src[left]) < 0) {\n" \
    "                    dst[dstIndex] = src[right++];\n" \
    "                    continue;\n" \
    "                }\n" \
    "            }\n" \
    "            dst[dstIndex] = src[left++];\n" \
    "        }\n" \
    "    }\n" \
    "    function mergeSort(array, valueCount, comparator)\n" \
    "    {\n" \
    "        var buffer = [ ];\n" \
    "        buffer.length = valueCount;\n" \
    "        var dst = buffer;\n" \
    "        var src = array;\n" \
    "        for (var width = 1; width < valueCount; width *= 2) {\n" \
    "            for (var srcIndex = 0; srcIndex < valueCount; srcIndex += 2 * width)\n" \
    "                merge(dst, src, srcIndex, valueCount, width, comparator);\n" \
    "            var tmp = src;\n" \
    "            src = dst;\n" \
    "            dst = tmp;\n" \
    "        }\n" \
    "        if (src != array) {\n" \
    "            for(var i = 0; i < valueCount; i++)\n" \
    "                array[i] = src[i];\n" \
    "        }\n" \
    "    }\n" \
    "    function bucketSort(array, dst, bucket, depth)\n" \
    "    {\n" \
    "        if (bucket.length < 32 || depth > 32) {\n" \
    "            mergeSort(bucket, bucket.length, stringComparator);\n" \
    "            for (var i = 0; i < bucket.length; ++i)\n" \
    "                array[dst++] = bucket[i].value;\n" \
    "            return dst;\n" \
    "        }\n" \
    "        var buckets = [ ];\n" \
    "        for (var i = 0; i < bucket.length; ++i) {\n" \
    "            var entry = bucket[i];\n" \
    "            var string = entry.string;\n" \
    "            if (string.length == depth) {\n" \
    "                array[dst++] = entry.value;\n" \
    "                continue;\n" \
    "            }\n" \
    "            var c = string.@charCodeAt(depth);\n" \
    "            if (!buckets[c])\n" \
    "                buckets[c] = [ ];\n" \
    "            buckets[c][buckets[c].length] = entry;\n" \
    "        }\n" \
    "        for (var i = 0; i < buckets.length; ++i) {\n" \
    "            if (!buckets[i])\n" \
    "                continue;\n" \
    "            dst = bucketSort(array, dst, buckets[i], depth + 1);\n" \
    "        }\n" \
    "        return dst;\n" \
    "    }\n" \
    "    function comparatorSort(array, comparator)\n" \
    "    {\n" \
    "        var length = array.length >>> 0;\n" \
    "        if (length < 2)\n" \
    "            return;\n" \
    "        var valueCount = compact(array, length);\n" \
    "        mergeSort(array, valueCount, comparator);\n" \
    "    }\n" \
    "    function stringSort(array)\n" \
    "    {\n" \
    "        var length = array.length >>> 0;\n" \
    "        if (length < 2)\n" \
    "            return;\n" \
    "        var valueCount = compact(array, length);\n" \
    "        var strings = new @Array(valueCount);\n" \
    "        for (var i = 0; i < valueCount; ++i)\n" \
    "            strings[i] = { string: @toString(array[i]), value: array[i] };\n" \
    "        bucketSort(array, 0, strings, 0);\n" \
    "    }\n" \
    "    if (this === null)\n" \
    "        throw new @TypeError(\"Array.prototype.sort requires that |this| not be null\");\n" \
    "    if (this === @undefined)\n" \
    "        throw new @TypeError(\"Array.prototype.sort requires that |this| not be undefined\");\n" \
    "    if (typeof this == \"string\")\n" \
    "        throw new @TypeError(\"Attempted to assign to readonly property.\");\n" \
    "    var array = @Object(this);\n" \
    "    if (typeof comparator == \"function\")\n" \
    "        comparatorSort(array, comparator);\n" \
    "    else\n" \
    "        stringSort(array);\n" \
    "    return array;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeSortCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeSortCodeLength = 1521;
const char* s_typedArrayPrototypeSortCode =
    "(function (comparator)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    function min(a, b)\n" \
    "    {\n" \
    "        return a < b ? a : b;\n" \
    "    }\n" \
    "    function merge(dst, src, srcIndex, srcEnd, width, comparator)\n" \
    "    {\n" \
    "        var left = srcIndex;\n" \
    "        var leftEnd = min(left + width, srcEnd);\n" \
    "        var right = leftEnd;\n" \
    "        var rightEnd = min(right + width, srcEnd);\n" \
    "        for (var dstIndex = left; dstIndex < rightEnd; ++dstIndex) {\n" \
    "            if (right < rightEnd) {\n" \
    "                if (left >= leftEnd || comparator(src[right], src[left]) < 0) {\n" \
    "                    dst[dstIndex] = src[right++];\n" \
    "                    continue;\n" \
    "                }\n" \
    "            }\n" \
    "            dst[dstIndex] = src[left++];\n" \
    "        }\n" \
    "    }\n" \
    "    function mergeSort(array, valueCount, comparator)\n" \
    "    {\n" \
    "        var buffer = [ ];\n" \
    "        buffer.length = valueCount;\n" \
    "        var dst = buffer;\n" \
    "        var src = array;\n" \
    "        for (var width = 1; width < valueCount; width *= 2) {\n" \
    "            for (var srcIndex = 0; srcIndex < valueCount; srcIndex += 2 * width)\n" \
    "                merge(dst, src, srcIndex, valueCount, width, comparator);\n" \
    "            var tmp = src;\n" \
    "            src = dst;\n" \
    "            dst = tmp;\n" \
    "        }\n" \
    "        if (src != array) {\n" \
    "            for(var i = 0; i < valueCount; i++)\n" \
    "                array[i] = src[i];\n" \
    "        }\n" \
    "    }\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    if (length < 2)\n" \
    "        return;\n" \
    "    if (typeof comparator == \"function\")\n" \
    "        mergeSort(this, length, comparator);\n" \
    "    else\n" \
    "        @typedArraySort(this);\n" \
    "    \n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_globalObjectSpeciesGetterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_globalObjectSpeciesGetterCodeLength = 35;
const char* s_globalObjectSpeciesGetterCode =
    "(function ()\n" \
    "{\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_functionPrototypeSymbolHasInstanceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_functionPrototypeSymbolHasInstanceCodeLength = 258;
const char* s_functionPrototypeSymbolHasInstanceCode =
    "(function (value)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (typeof this !== \"function\")\n" \
    "        return false;\n" \
    "    if (@isBoundFunction(this))\n" \
    "        return @hasInstanceBoundFunction(this, value);\n" \
    "    let target = this.prototype;\n" \
    "    return @instanceOf(value, target);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_iteratorPrototypeSymbolIteratorGetterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_iteratorPrototypeSymbolIteratorGetterCodeLength = 53;
const char* s_iteratorPrototypeSymbolIteratorGetterCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promisePrototypeThenCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promisePrototypeThenCodeLength = 1201;
const char* s_promisePrototypeThenCode =
    "(function (onFulfilled, onRejected)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isPromise(this))\n" \
    "        throw new @TypeError(\"|this| is not a object\");\n" \
    "    var constructor = this.constructor;\n" \
    "    var resultCapability = @newPromiseCapability(constructor);\n" \
    "    if (typeof onFulfilled !== \"function\")\n" \
    "        onFulfilled = function (argument) { return argument; };\n" \
    "    if (typeof onRejected !== \"function\")\n" \
    "        onRejected = function (argument) { throw argument; };\n" \
    "    var fulfillReaction = @newPromiseReaction(resultCapability, onFulfilled);\n" \
    "    var rejectReaction = @newPromiseReaction(resultCapability, onRejected);\n" \
    "    var state = this.@promiseState;\n" \
    "    if (state === @promiseStatePending) {\n" \
    "        @putByValDirect(this.@promiseFulfillReactions, this.@promiseFulfillReactions.length, fulfillReaction)\n" \
    "        @putByValDirect(this.@promiseRejectReactions, this.@promiseRejectReactions.length, rejectReaction)\n" \
    "    } else if (state === @promiseStateFulfilled)\n" \
    "        @enqueueJob(@promiseReactionJob, [fulfillReaction, this.@promiseResult]);\n" \
    "    else if (state === @promiseStateRejected)\n" \
    "        @enqueueJob(@promiseReactionJob, [rejectReaction, this.@promiseResult]);\n" \
    "    return resultCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_generatorPrototypeThrowCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_generatorPrototypeThrowCodeLength = 95;
const char* s_generatorPrototypeThrowCode =
    "(function (exception)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    return @generatorResume(this, exception,  2);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_globalObjectToIntegerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_globalObjectToIntegerCodeLength = 285;
const char* s_globalObjectToIntegerCode =
    "(function (target)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var numberValue = @Number(target);\n" \
    "    if (numberValue !== numberValue)\n" \
    "        return 0;\n" \
    "    if (numberValue === 0 || !@isFinite(numberValue))\n" \
    "        return numberValue;\n" \
    "    return (numberValue > 0 ? 1 : -1) * @floor(@abs(numberValue));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_globalObjectToLengthCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_globalObjectToLengthCodeLength = 203;
const char* s_globalObjectToLengthCode =
    "(function (target)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var maxSafeInteger = 0x1FFFFFFFFFFFFF;\n" \
    "    var length = @toInteger(target);\n" \
    "    return length > 0 ? (length < maxSafeInteger ? length : maxSafeInteger) : 0;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_datePrototypeToLocaleDateStringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_datePrototypeToLocaleDateStringCodeLength = 1050;
const char* s_datePrototypeToLocaleDateStringCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    function toDateTimeOptionsDateDate(opts)\n" \
    "    {\n" \
    "        var options;\n" \
    "        if (opts === @undefined)\n" \
    "            options = null;\n" \
    "        else if (opts === null)\n" \
    "            throw new @TypeError(\"null is not an object\");\n" \
    "        else\n" \
    "            options = @Object(opts);\n" \
    "        var needsDefaults = !options || (\n" \
    "            options.weekday === @undefined &&\n" \
    "            options.year === @undefined &&\n" \
    "            options.month === @undefined &&\n" \
    "            options.day === @undefined\n" \
    "        );\n" \
    "        if (needsDefaults) {\n" \
    "            options = @Object.create(options)\n" \
    "            options.year = \"numeric\";\n" \
    "            options.month = \"numeric\";\n" \
    "            options.day = \"numeric\";\n" \
    "        }\n" \
    "        return options;\n" \
    "    }\n" \
    "    var value = @thisTimeValue.@call(this);\n" \
    "    if (@isNaN(value))\n" \
    "        return \"Invalid Date\";\n" \
    "    var options = toDateTimeOptionsDateDate(arguments[1]);\n" \
    "    var locales = arguments[0];\n" \
    "    var dateFormat = new @DateTimeFormat(locales, options);\n" \
    "    return dateFormat.format(value);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_datePrototypeToLocaleStringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_datePrototypeToLocaleStringCodeLength = 1297;
const char* s_datePrototypeToLocaleStringCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    function toDateTimeOptionsAnyAll(opts)\n" \
    "    {\n" \
    "        var options;\n" \
    "        if (opts === @undefined)\n" \
    "            options = null;\n" \
    "        else if (opts === null)\n" \
    "            throw new @TypeError(\"null is not an object\");\n" \
    "        else\n" \
    "            options = @Object(opts);\n" \
    "        var needsDefaults = !options || (\n" \
    "            options.weekday === @undefined &&\n" \
    "            options.year === @undefined &&\n" \
    "            options.month === @undefined &&\n" \
    "            options.day === @undefined &&\n" \
    "            options.hour === @undefined &&\n" \
    "            options.minute === @undefined &&\n" \
    "            options.second === @undefined\n" \
    "        );\n" \
    "        if (needsDefaults) {\n" \
    "            options = @Object.create(options)\n" \
    "            options.year = \"numeric\";\n" \
    "            options.month = \"numeric\";\n" \
    "            options.day = \"numeric\";\n" \
    "            options.hour = \"numeric\";\n" \
    "            options.minute = \"numeric\";\n" \
    "            options.second = \"numeric\";\n" \
    "        }\n" \
    "        return options;\n" \
    "    }\n" \
    "    var value = @thisTimeValue.@call(this);\n" \
    "    if (@isNaN(value))\n" \
    "        return \"Invalid Date\";\n" \
    "    var options = toDateTimeOptionsAnyAll(arguments[1]);\n" \
    "    var locales = arguments[0];\n" \
    "    var dateFormat = new @DateTimeFormat(locales, options);\n" \
    "    return dateFormat.format(value);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_numberPrototypeToLocaleStringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_numberPrototypeToLocaleStringCodeLength = 342;
const char* s_numberPrototypeToLocaleStringCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var number = this;\n" \
    "    if (!(typeof number === \"number\" || number instanceof @Number))\n" \
    "        throw new @TypeError(\"Number.prototype.toLocaleString called on incompatible \" + typeof number);\n" \
    "    var numberFormat = new @NumberFormat(arguments[0], arguments[1]);\n" \
    "    return numberFormat.format(number);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_typedArrayPrototypeToLocaleStringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_typedArrayPrototypeToLocaleStringCodeLength = 267;
const char* s_typedArrayPrototypeToLocaleStringCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    var length = @typedArrayLength(this);\n" \
    "    if (length == 0)\n" \
    "        return \"\";\n" \
    "    var string = this[0].toLocaleString();\n" \
    "    for (var i = 1; i < length; i++)\n" \
    "        string += \",\" + this[i].toLocaleString();\n" \
    "    return string;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_datePrototypeToLocaleTimeStringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_datePrototypeToLocaleTimeStringCodeLength = 1012;
const char* s_datePrototypeToLocaleTimeStringCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    function toDateTimeOptionsTimeTime(opts)\n" \
    "    {\n" \
    "        var options;\n" \
    "        if (opts === @undefined)\n" \
    "            options = null;\n" \
    "        else if (opts === null)\n" \
    "            throw new @TypeError(\"null is not an object\");\n" \
    "        else\n" \
    "            options = @Object(opts);\n" \
    "        var needsDefaults = !options || (\n" \
    "            options.hour === @undefined &&\n" \
    "            options.minute === @undefined &&\n" \
    "            options.second === @undefined\n" \
    "        );\n" \
    "        if (needsDefaults) {\n" \
    "            options = @Object.create(options)\n" \
    "            options.hour = \"numeric\";\n" \
    "            options.minute = \"numeric\";\n" \
    "            options.second = \"numeric\";\n" \
    "        }\n" \
    "        return options;\n" \
    "    }\n" \
    "    var value = @thisTimeValue.@call(this);\n" \
    "    if (@isNaN(value))\n" \
    "        return \"Invalid Date\";\n" \
    "    var options = toDateTimeOptionsTimeTime(arguments[1]);\n" \
    "    var locales = arguments[0];\n" \
    "    var dateFormat = new @DateTimeFormat(locales, options);\n" \
    "    return dateFormat.format(value);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_promiseOperationsTriggerPromiseReactionsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_promiseOperationsTriggerPromiseReactionsCodeLength = 203;
const char* s_promiseOperationsTriggerPromiseReactionsCode =
    "(function (reactions, argument)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    for (var index = 0, length = reactions.length; index < length; ++index)\n" \
    "        @enqueueJob(@promiseReactionJob, [reactions[index], argument]);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    return vm.builtinExecutables()->codeName##Executable()->link(vm, vm.builtinExecutables()->codeName##Source()); }
JSC_FOREACH_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace JSC
