//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef WebRenderMessages_h
#define WebRenderMessages_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "Units.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SideVariant.h"
#include "mozilla/layers/LayersTypes.h"
#include "mozilla/webrender/WebRenderTypes.h"
#include "mozilla/webrender/webrender_ffi.h"
#include "mozilla/layers/LayersSurfaces.h"
#include "mozilla/layers/LayersMessages.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct RefCountedShmem|
//
namespace mozilla {
namespace layers {
class RefCountedShmem final
{
private:
    typedef ::mozilla::ipc::Shmem Shmem;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    RefCountedShmem() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT RefCountedShmem(Shmem& _buffer) :
        buffer_(_buffer)
    {
    }

    MOZ_IMPLICIT RefCountedShmem(Shmem&& _buffer) :
        buffer_(std::move(_buffer))
    {
    }

    Shmem&
    buffer()
    {
        return buffer_;
    }
    Shmem&
    buffer() const
    {
        return const_cast<Shmem&>(buffer_);
    }

private:
    ::mozilla::ipc::IPDLStructMember<Shmem> buffer_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::RefCountedShmem>
{
    typedef ::mozilla::layers::RefCountedShmem paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddSharedExternalImage|
//
namespace mozilla {
namespace layers {
class OpAddSharedExternalImage final
{
private:
    typedef ::mozilla::wr::ExternalImageId ExternalImageId;
    typedef ::mozilla::wr::ImageKey ImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddSharedExternalImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddSharedExternalImage(
            const ExternalImageId& _externalImageId,
            const ImageKey& _key) :
        externalImageId_(_externalImageId),
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpAddSharedExternalImage(
            ExternalImageId&& _externalImageId,
            ImageKey&& _key) :
        externalImageId_(std::move(_externalImageId)),
        key_(std::move(_key))
    {
    }

    ExternalImageId&
    externalImageId()
    {
        return externalImageId_;
    }
    const ExternalImageId&
    externalImageId() const
    {
        return externalImageId_;
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ExternalImageId> externalImageId_;
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddSharedExternalImage>
{
    typedef ::mozilla::layers::OpAddSharedExternalImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace layers {
class PTextureParent;
} // namespace layers
} // namespace mozilla

namespace mozilla {
namespace layers {
class PTextureChild;
} // namespace layers
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpPushExternalImageForTexture|
//
namespace mozilla {
namespace layers {
class OpPushExternalImageForTexture final
{
private:
    typedef ::mozilla::wr::ExternalImageId ExternalImageId;
    typedef ::mozilla::wr::ImageKey ImageKey;
    typedef ::mozilla::layers::PTextureParent PTextureParent;
    typedef ::mozilla::layers::PTextureChild PTextureChild;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpPushExternalImageForTexture() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpPushExternalImageForTexture(
            const ExternalImageId& _externalImageId,
            const ImageKey& _key,
            const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>& _texture,
            const bool& _isUpdate) :
        externalImageId_(_externalImageId),
        key_(_key),
        texture_(_texture),
        isUpdate_(_isUpdate)
    {
    }

    MOZ_IMPLICIT OpPushExternalImageForTexture(
            ExternalImageId&& _externalImageId,
            ImageKey&& _key,
            mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&& _texture,
            bool&& _isUpdate) :
        externalImageId_(std::move(_externalImageId)),
        key_(std::move(_key)),
        texture_(std::move(_texture)),
        isUpdate_(std::move(_isUpdate))
    {
    }

    ExternalImageId&
    externalImageId()
    {
        return externalImageId_;
    }
    const ExternalImageId&
    externalImageId() const
    {
        return externalImageId_;
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

    mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    texture()
    {
        return texture_;
    }
    const mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>&
    texture() const
    {
        return texture_;
    }

    bool&
    isUpdate()
    {
        return isUpdate_;
    }
    const bool&
    isUpdate() const
    {
        return isUpdate_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ExternalImageId> externalImageId_;
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
    ::mozilla::ipc::IPDLStructMember<mozilla::NotNull<::mozilla::ipc::SideVariant<PTextureParent*, PTextureChild*>>> texture_;
    ::mozilla::ipc::IPDLStructMember<bool> isUpdate_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpPushExternalImageForTexture>
{
    typedef ::mozilla::layers::OpPushExternalImageForTexture paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddCompositorAnimations|
//
namespace mozilla {
namespace layers {
class OpAddCompositorAnimations final
{
private:
    typedef ::mozilla::layers::CompositorAnimations CompositorAnimations;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddCompositorAnimations() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddCompositorAnimations(const CompositorAnimations& _data) :
        data_(_data)
    {
    }

    MOZ_IMPLICIT OpAddCompositorAnimations(CompositorAnimations&& _data) :
        data_(std::move(_data))
    {
    }

    CompositorAnimations&
    data()
    {
        return data_;
    }
    const CompositorAnimations&
    data() const
    {
        return data_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CompositorAnimations> data_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddCompositorAnimations>
{
    typedef ::mozilla::layers::OpAddCompositorAnimations paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddPipelineIdForCompositable|
//
namespace mozilla {
namespace layers {
class OpAddPipelineIdForCompositable final
{
private:
    typedef ::mozilla::wr::PipelineId PipelineId;
    typedef ::mozilla::layers::CompositableHandle CompositableHandle;
    typedef ::mozilla::layers::CompositableHandleOwner CompositableHandleOwner;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddPipelineIdForCompositable() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddPipelineIdForCompositable(
            const PipelineId& _pipelineId,
            const CompositableHandle& _handle,
            const CompositableHandleOwner& _owner) :
        pipelineId_(_pipelineId),
        handle_(_handle),
        owner_(_owner)
    {
    }

    MOZ_IMPLICIT OpAddPipelineIdForCompositable(
            PipelineId&& _pipelineId,
            CompositableHandle&& _handle,
            CompositableHandleOwner&& _owner) :
        pipelineId_(std::move(_pipelineId)),
        handle_(std::move(_handle)),
        owner_(std::move(_owner))
    {
    }

    PipelineId&
    pipelineId()
    {
        return pipelineId_;
    }
    const PipelineId&
    pipelineId() const
    {
        return pipelineId_;
    }

    CompositableHandle&
    handle()
    {
        return handle_;
    }
    const CompositableHandle&
    handle() const
    {
        return handle_;
    }

    CompositableHandleOwner&
    owner()
    {
        return owner_;
    }
    const CompositableHandleOwner&
    owner() const
    {
        return owner_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PipelineId> pipelineId_;
    ::mozilla::ipc::IPDLStructMember<CompositableHandle> handle_;
    ::mozilla::ipc::IPDLStructMember<CompositableHandleOwner> owner_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddPipelineIdForCompositable>
{
    typedef ::mozilla::layers::OpAddPipelineIdForCompositable paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpRemovePipelineIdForCompositable|
//
namespace mozilla {
namespace layers {
class OpRemovePipelineIdForCompositable final
{
private:
    typedef ::mozilla::wr::PipelineId PipelineId;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpRemovePipelineIdForCompositable() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpRemovePipelineIdForCompositable(const PipelineId& _pipelineId) :
        pipelineId_(_pipelineId)
    {
    }

    MOZ_IMPLICIT OpRemovePipelineIdForCompositable(PipelineId&& _pipelineId) :
        pipelineId_(std::move(_pipelineId))
    {
    }

    PipelineId&
    pipelineId()
    {
        return pipelineId_;
    }
    const PipelineId&
    pipelineId() const
    {
        return pipelineId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PipelineId> pipelineId_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpRemovePipelineIdForCompositable>
{
    typedef ::mozilla::layers::OpRemovePipelineIdForCompositable paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpReleaseTextureOfImage|
//
namespace mozilla {
namespace layers {
class OpReleaseTextureOfImage final
{
private:
    typedef ::mozilla::wr::ImageKey ImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpReleaseTextureOfImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpReleaseTextureOfImage(const ImageKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpReleaseTextureOfImage(ImageKey&& _key) :
        key_(std::move(_key))
    {
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpReleaseTextureOfImage>
{
    typedef ::mozilla::layers::OpReleaseTextureOfImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUpdateAsyncImagePipeline|
//
namespace mozilla {
namespace layers {
class OpUpdateAsyncImagePipeline final
{
private:
    typedef ::mozilla::wr::PipelineId PipelineId;
    typedef ::mozilla::LayoutDeviceRect LayoutDeviceRect;
    typedef ::mozilla::wr::WrRotation WrRotation;
    typedef ::mozilla::wr::ImageRendering ImageRendering;
    typedef ::mozilla::wr::MixBlendMode MixBlendMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUpdateAsyncImagePipeline() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUpdateAsyncImagePipeline(
            const PipelineId& _pipelineId,
            const LayoutDeviceRect& _scBounds,
            const WrRotation& _rotation,
            const ImageRendering& _filter,
            const MixBlendMode& _mixBlendMode) :
        pipelineId_(_pipelineId),
        scBounds_(_scBounds),
        rotation_(_rotation),
        filter_(_filter),
        mixBlendMode_(_mixBlendMode)
    {
    }

    MOZ_IMPLICIT OpUpdateAsyncImagePipeline(
            PipelineId&& _pipelineId,
            LayoutDeviceRect&& _scBounds,
            WrRotation&& _rotation,
            ImageRendering&& _filter,
            MixBlendMode&& _mixBlendMode) :
        pipelineId_(std::move(_pipelineId)),
        scBounds_(std::move(_scBounds)),
        rotation_(std::move(_rotation)),
        filter_(std::move(_filter)),
        mixBlendMode_(std::move(_mixBlendMode))
    {
    }

    PipelineId&
    pipelineId()
    {
        return pipelineId_;
    }
    const PipelineId&
    pipelineId() const
    {
        return pipelineId_;
    }

    LayoutDeviceRect&
    scBounds()
    {
        return scBounds_;
    }
    const LayoutDeviceRect&
    scBounds() const
    {
        return scBounds_;
    }

    WrRotation&
    rotation()
    {
        return rotation_;
    }
    const WrRotation&
    rotation() const
    {
        return rotation_;
    }

    ImageRendering&
    filter()
    {
        return filter_;
    }
    const ImageRendering&
    filter() const
    {
        return filter_;
    }

    MixBlendMode&
    mixBlendMode()
    {
        return mixBlendMode_;
    }
    const MixBlendMode&
    mixBlendMode() const
    {
        return mixBlendMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PipelineId> pipelineId_;
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceRect> scBounds_;
    ::mozilla::ipc::IPDLStructMember<WrRotation> rotation_;
    ::mozilla::ipc::IPDLStructMember<ImageRendering> filter_;
    ::mozilla::ipc::IPDLStructMember<MixBlendMode> mixBlendMode_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUpdateAsyncImagePipeline>
{
    typedef ::mozilla::layers::OpUpdateAsyncImagePipeline paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUpdatedAsyncImagePipeline|
//
namespace mozilla {
namespace layers {
class OpUpdatedAsyncImagePipeline final
{
private:
    typedef ::mozilla::wr::PipelineId PipelineId;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUpdatedAsyncImagePipeline() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUpdatedAsyncImagePipeline(const PipelineId& _pipelineId) :
        pipelineId_(_pipelineId)
    {
    }

    MOZ_IMPLICIT OpUpdatedAsyncImagePipeline(PipelineId&& _pipelineId) :
        pipelineId_(std::move(_pipelineId))
    {
    }

    PipelineId&
    pipelineId()
    {
        return pipelineId_;
    }
    const PipelineId&
    pipelineId() const
    {
        return pipelineId_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<PipelineId> pipelineId_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUpdatedAsyncImagePipeline>
{
    typedef ::mozilla::layers::OpUpdatedAsyncImagePipeline paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union WebRenderParentCommand|
//
namespace mozilla {
namespace layers {
class WebRenderParentCommand final
{
public:
    enum Type {
        T__None,
        TOpAddPipelineIdForCompositable = 1,
        TOpRemovePipelineIdForCompositable,
        TOpReleaseTextureOfImage,
        TOpUpdateAsyncImagePipeline,
        TOpUpdatedAsyncImagePipeline,
        TCompositableOperation,
        TOpAddCompositorAnimations,
        T__Last = TOpAddCompositorAnimations
    };

private:
    typedef ::mozilla::layers::OpAddPipelineIdForCompositable OpAddPipelineIdForCompositable;
    typedef ::mozilla::layers::OpRemovePipelineIdForCompositable OpRemovePipelineIdForCompositable;
    typedef ::mozilla::layers::OpReleaseTextureOfImage OpReleaseTextureOfImage;
    typedef ::mozilla::layers::OpUpdateAsyncImagePipeline OpUpdateAsyncImagePipeline;
    typedef ::mozilla::layers::OpUpdatedAsyncImagePipeline OpUpdatedAsyncImagePipeline;
    typedef ::mozilla::layers::CompositableOperation CompositableOperation;
    typedef ::mozilla::layers::OpAddCompositorAnimations OpAddCompositorAnimations;
    typedef OpAddPipelineIdForCompositable OpAddPipelineIdForCompositable__tdef;
    typedef OpRemovePipelineIdForCompositable OpRemovePipelineIdForCompositable__tdef;
    typedef OpReleaseTextureOfImage OpReleaseTextureOfImage__tdef;
    typedef OpUpdateAsyncImagePipeline OpUpdateAsyncImagePipeline__tdef;
    typedef OpUpdatedAsyncImagePipeline OpUpdatedAsyncImagePipeline__tdef;
    typedef CompositableOperation CompositableOperation__tdef;
    typedef OpAddCompositorAnimations OpAddCompositorAnimations__tdef;

    OpAddPipelineIdForCompositable*
    ptr_OpAddPipelineIdForCompositable()
    {
        return (&(mVOpAddPipelineIdForCompositable));
    }
    const OpAddPipelineIdForCompositable*
    constptr_OpAddPipelineIdForCompositable() const
    {
        return (&(mVOpAddPipelineIdForCompositable));
    }
    OpRemovePipelineIdForCompositable*
    ptr_OpRemovePipelineIdForCompositable()
    {
        return (&(mVOpRemovePipelineIdForCompositable));
    }
    const OpRemovePipelineIdForCompositable*
    constptr_OpRemovePipelineIdForCompositable() const
    {
        return (&(mVOpRemovePipelineIdForCompositable));
    }
    OpReleaseTextureOfImage*
    ptr_OpReleaseTextureOfImage()
    {
        return (&(mVOpReleaseTextureOfImage));
    }
    const OpReleaseTextureOfImage*
    constptr_OpReleaseTextureOfImage() const
    {
        return (&(mVOpReleaseTextureOfImage));
    }
    OpUpdateAsyncImagePipeline*
    ptr_OpUpdateAsyncImagePipeline()
    {
        return (&(mVOpUpdateAsyncImagePipeline));
    }
    const OpUpdateAsyncImagePipeline*
    constptr_OpUpdateAsyncImagePipeline() const
    {
        return (&(mVOpUpdateAsyncImagePipeline));
    }
    OpUpdatedAsyncImagePipeline*
    ptr_OpUpdatedAsyncImagePipeline()
    {
        return (&(mVOpUpdatedAsyncImagePipeline));
    }
    const OpUpdatedAsyncImagePipeline*
    constptr_OpUpdatedAsyncImagePipeline() const
    {
        return (&(mVOpUpdatedAsyncImagePipeline));
    }
    CompositableOperation*
    ptr_CompositableOperation()
    {
        return (&(mVCompositableOperation));
    }
    const CompositableOperation*
    constptr_CompositableOperation() const
    {
        return (&(mVCompositableOperation));
    }
    OpAddCompositorAnimations*
    ptr_OpAddCompositorAnimations()
    {
        return (&(mVOpAddCompositorAnimations));
    }
    const OpAddCompositorAnimations*
    constptr_OpAddCompositorAnimations() const
    {
        return (&(mVOpAddCompositorAnimations));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT WebRenderParentCommand() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT WebRenderParentCommand(const OpAddPipelineIdForCompositable& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(OpAddPipelineIdForCompositable&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const OpRemovePipelineIdForCompositable& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(OpRemovePipelineIdForCompositable&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const OpReleaseTextureOfImage& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(OpReleaseTextureOfImage&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const OpUpdateAsyncImagePipeline& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(OpUpdateAsyncImagePipeline&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const OpUpdatedAsyncImagePipeline& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(OpUpdatedAsyncImagePipeline&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const CompositableOperation& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(CompositableOperation&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const OpAddCompositorAnimations& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(OpAddCompositorAnimations&& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(const WebRenderParentCommand& aOther);

    MOZ_IMPLICIT WebRenderParentCommand(WebRenderParentCommand&& aOther);

    ~WebRenderParentCommand();

    Type
    type() const
    {
        return mType;
    }

    WebRenderParentCommand&
    operator=(const OpAddPipelineIdForCompositable& aRhs);

    WebRenderParentCommand&
    operator=(OpAddPipelineIdForCompositable&& aRhs);

    WebRenderParentCommand&
    operator=(const OpRemovePipelineIdForCompositable& aRhs);

    WebRenderParentCommand&
    operator=(OpRemovePipelineIdForCompositable&& aRhs);

    WebRenderParentCommand&
    operator=(const OpReleaseTextureOfImage& aRhs);

    WebRenderParentCommand&
    operator=(OpReleaseTextureOfImage&& aRhs);

    WebRenderParentCommand&
    operator=(const OpUpdateAsyncImagePipeline& aRhs);

    WebRenderParentCommand&
    operator=(OpUpdateAsyncImagePipeline&& aRhs);

    WebRenderParentCommand&
    operator=(const OpUpdatedAsyncImagePipeline& aRhs);

    WebRenderParentCommand&
    operator=(OpUpdatedAsyncImagePipeline&& aRhs);

    WebRenderParentCommand&
    operator=(const CompositableOperation& aRhs);

    WebRenderParentCommand&
    operator=(CompositableOperation&& aRhs);

    WebRenderParentCommand&
    operator=(const OpAddCompositorAnimations& aRhs);

    WebRenderParentCommand&
    operator=(OpAddCompositorAnimations&& aRhs);

    WebRenderParentCommand&
    operator=(const WebRenderParentCommand& aRhs);

    WebRenderParentCommand&
    operator=(WebRenderParentCommand&& aRhs);

    OpAddPipelineIdForCompositable&
    get_OpAddPipelineIdForCompositable()
    {
        AssertSanity(TOpAddPipelineIdForCompositable);
        return (*(ptr_OpAddPipelineIdForCompositable()));
    }
    const OpAddPipelineIdForCompositable&
    get_OpAddPipelineIdForCompositable() const
    {
        AssertSanity(TOpAddPipelineIdForCompositable);
        return (*(constptr_OpAddPipelineIdForCompositable()));
    }
    operator OpAddPipelineIdForCompositable&()
    {
        return get_OpAddPipelineIdForCompositable();
    }
    operator const OpAddPipelineIdForCompositable&() const
    {
        return get_OpAddPipelineIdForCompositable();
    }

    OpRemovePipelineIdForCompositable&
    get_OpRemovePipelineIdForCompositable()
    {
        AssertSanity(TOpRemovePipelineIdForCompositable);
        return (*(ptr_OpRemovePipelineIdForCompositable()));
    }
    const OpRemovePipelineIdForCompositable&
    get_OpRemovePipelineIdForCompositable() const
    {
        AssertSanity(TOpRemovePipelineIdForCompositable);
        return (*(constptr_OpRemovePipelineIdForCompositable()));
    }
    operator OpRemovePipelineIdForCompositable&()
    {
        return get_OpRemovePipelineIdForCompositable();
    }
    operator const OpRemovePipelineIdForCompositable&() const
    {
        return get_OpRemovePipelineIdForCompositable();
    }

    OpReleaseTextureOfImage&
    get_OpReleaseTextureOfImage()
    {
        AssertSanity(TOpReleaseTextureOfImage);
        return (*(ptr_OpReleaseTextureOfImage()));
    }
    const OpReleaseTextureOfImage&
    get_OpReleaseTextureOfImage() const
    {
        AssertSanity(TOpReleaseTextureOfImage);
        return (*(constptr_OpReleaseTextureOfImage()));
    }
    operator OpReleaseTextureOfImage&()
    {
        return get_OpReleaseTextureOfImage();
    }
    operator const OpReleaseTextureOfImage&() const
    {
        return get_OpReleaseTextureOfImage();
    }

    OpUpdateAsyncImagePipeline&
    get_OpUpdateAsyncImagePipeline()
    {
        AssertSanity(TOpUpdateAsyncImagePipeline);
        return (*(ptr_OpUpdateAsyncImagePipeline()));
    }
    const OpUpdateAsyncImagePipeline&
    get_OpUpdateAsyncImagePipeline() const
    {
        AssertSanity(TOpUpdateAsyncImagePipeline);
        return (*(constptr_OpUpdateAsyncImagePipeline()));
    }
    operator OpUpdateAsyncImagePipeline&()
    {
        return get_OpUpdateAsyncImagePipeline();
    }
    operator const OpUpdateAsyncImagePipeline&() const
    {
        return get_OpUpdateAsyncImagePipeline();
    }

    OpUpdatedAsyncImagePipeline&
    get_OpUpdatedAsyncImagePipeline()
    {
        AssertSanity(TOpUpdatedAsyncImagePipeline);
        return (*(ptr_OpUpdatedAsyncImagePipeline()));
    }
    const OpUpdatedAsyncImagePipeline&
    get_OpUpdatedAsyncImagePipeline() const
    {
        AssertSanity(TOpUpdatedAsyncImagePipeline);
        return (*(constptr_OpUpdatedAsyncImagePipeline()));
    }
    operator OpUpdatedAsyncImagePipeline&()
    {
        return get_OpUpdatedAsyncImagePipeline();
    }
    operator const OpUpdatedAsyncImagePipeline&() const
    {
        return get_OpUpdatedAsyncImagePipeline();
    }

    CompositableOperation&
    get_CompositableOperation()
    {
        AssertSanity(TCompositableOperation);
        return (*(ptr_CompositableOperation()));
    }
    const CompositableOperation&
    get_CompositableOperation() const
    {
        AssertSanity(TCompositableOperation);
        return (*(constptr_CompositableOperation()));
    }
    operator CompositableOperation&()
    {
        return get_CompositableOperation();
    }
    operator const CompositableOperation&() const
    {
        return get_CompositableOperation();
    }

    OpAddCompositorAnimations&
    get_OpAddCompositorAnimations()
    {
        AssertSanity(TOpAddCompositorAnimations);
        return (*(ptr_OpAddCompositorAnimations()));
    }
    const OpAddCompositorAnimations&
    get_OpAddCompositorAnimations() const
    {
        AssertSanity(TOpAddCompositorAnimations);
        return (*(constptr_OpAddCompositorAnimations()));
    }
    operator OpAddCompositorAnimations&()
    {
        return get_OpAddCompositorAnimations();
    }
    operator const OpAddCompositorAnimations&() const
    {
        return get_OpAddCompositorAnimations();
    }

private:
    union {
        OpAddPipelineIdForCompositable mVOpAddPipelineIdForCompositable;
        OpRemovePipelineIdForCompositable mVOpRemovePipelineIdForCompositable;
        OpReleaseTextureOfImage mVOpReleaseTextureOfImage;
        OpUpdateAsyncImagePipeline mVOpUpdateAsyncImagePipeline;
        OpUpdatedAsyncImagePipeline mVOpUpdatedAsyncImagePipeline;
        CompositableOperation mVCompositableOperation;
        OpAddCompositorAnimations mVOpAddCompositorAnimations;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::WebRenderParentCommand>
{
    typedef ::mozilla::layers::WebRenderParentCommand paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OffsetRange|
//
namespace mozilla {
namespace layers {
class OffsetRange final
{
private:
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OffsetRange() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OffsetRange(
            const uint32_t& _source,
            const uint32_t& _start,
            const uint32_t& _length) :
        source_(_source),
        start_(_start),
        length_(_length)
    {
    }

    MOZ_IMPLICIT OffsetRange(
            uint32_t&& _source,
            uint32_t&& _start,
            uint32_t&& _length) :
        source_(std::move(_source)),
        start_(std::move(_start)),
        length_(std::move(_length))
    {
    }

    uint32_t&
    source()
    {
        return source_;
    }
    const uint32_t&
    source() const
    {
        return source_;
    }

    uint32_t&
    start()
    {
        return start_;
    }
    const uint32_t&
    start() const
    {
        return start_;
    }

    uint32_t&
    length()
    {
        return length_;
    }
    const uint32_t&
    length() const
    {
        return length_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<uint32_t> source_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> start_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> length_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OffsetRange>
{
    typedef ::mozilla::layers::OffsetRange paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddImage|
//
namespace mozilla {
namespace layers {
class OpAddImage final
{
private:
    typedef ::mozilla::wr::ImageDescriptor ImageDescriptor;
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::uint16_t uint16_t;
    typedef ::mozilla::wr::ImageKey ImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddImage(
            const ImageDescriptor& _descriptor,
            const OffsetRange& _bytes,
            const uint16_t& _tiling,
            const ImageKey& _key) :
        descriptor_(_descriptor),
        bytes_(_bytes),
        key_(_key),
        tiling_(_tiling)
    {
    }

    MOZ_IMPLICIT OpAddImage(
            ImageDescriptor&& _descriptor,
            OffsetRange&& _bytes,
            uint16_t&& _tiling,
            ImageKey&& _key) :
        descriptor_(std::move(_descriptor)),
        bytes_(std::move(_bytes)),
        key_(std::move(_key)),
        tiling_(std::move(_tiling))
    {
    }

    ImageDescriptor&
    descriptor()
    {
        return descriptor_;
    }
    const ImageDescriptor&
    descriptor() const
    {
        return descriptor_;
    }

    OffsetRange&
    bytes()
    {
        return bytes_;
    }
    const OffsetRange&
    bytes() const
    {
        return bytes_;
    }

    uint16_t&
    tiling()
    {
        return tiling_;
    }
    const uint16_t&
    tiling() const
    {
        return tiling_;
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageDescriptor> descriptor_;
    ::mozilla::ipc::IPDLStructMember<OffsetRange> bytes_;
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
    ::mozilla::ipc::IPDLStructMember<uint16_t> tiling_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddImage>
{
    typedef ::mozilla::layers::OpAddImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddBlobImage|
//
namespace mozilla {
namespace layers {
class OpAddBlobImage final
{
private:
    typedef ::mozilla::wr::ImageDescriptor ImageDescriptor;
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::mozilla::ImageIntRect ImageIntRect;
    typedef ::uint16_t uint16_t;
    typedef ::mozilla::wr::BlobImageKey BlobImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddBlobImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddBlobImage(
            const ImageDescriptor& _descriptor,
            const OffsetRange& _bytes,
            const ImageIntRect& _visibleRect,
            const uint16_t& _tiling,
            const BlobImageKey& _key) :
        descriptor_(_descriptor),
        bytes_(_bytes),
        visibleRect_(_visibleRect),
        key_(_key),
        tiling_(_tiling)
    {
    }

    MOZ_IMPLICIT OpAddBlobImage(
            ImageDescriptor&& _descriptor,
            OffsetRange&& _bytes,
            ImageIntRect&& _visibleRect,
            uint16_t&& _tiling,
            BlobImageKey&& _key) :
        descriptor_(std::move(_descriptor)),
        bytes_(std::move(_bytes)),
        visibleRect_(std::move(_visibleRect)),
        key_(std::move(_key)),
        tiling_(std::move(_tiling))
    {
    }

    ImageDescriptor&
    descriptor()
    {
        return descriptor_;
    }
    const ImageDescriptor&
    descriptor() const
    {
        return descriptor_;
    }

    OffsetRange&
    bytes()
    {
        return bytes_;
    }
    const OffsetRange&
    bytes() const
    {
        return bytes_;
    }

    ImageIntRect&
    visibleRect()
    {
        return visibleRect_;
    }
    const ImageIntRect&
    visibleRect() const
    {
        return visibleRect_;
    }

    uint16_t&
    tiling()
    {
        return tiling_;
    }
    const uint16_t&
    tiling() const
    {
        return tiling_;
    }

    BlobImageKey&
    key()
    {
        return key_;
    }
    const BlobImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageDescriptor> descriptor_;
    ::mozilla::ipc::IPDLStructMember<OffsetRange> bytes_;
    ::mozilla::ipc::IPDLStructMember<ImageIntRect> visibleRect_;
    ::mozilla::ipc::IPDLStructMember<BlobImageKey> key_;
    ::mozilla::ipc::IPDLStructMember<uint16_t> tiling_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddBlobImage>
{
    typedef ::mozilla::layers::OpAddBlobImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddSnapshotImage|
//
namespace mozilla {
namespace layers {
class OpAddSnapshotImage final
{
private:
    typedef ::mozilla::wr::SnapshotImageKey SnapshotImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddSnapshotImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddSnapshotImage(const SnapshotImageKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpAddSnapshotImage(SnapshotImageKey&& _key) :
        key_(std::move(_key))
    {
    }

    SnapshotImageKey&
    key()
    {
        return key_;
    }
    const SnapshotImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SnapshotImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddSnapshotImage>
{
    typedef ::mozilla::layers::OpAddSnapshotImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUpdateImage|
//
namespace mozilla {
namespace layers {
class OpUpdateImage final
{
private:
    typedef ::mozilla::wr::ImageDescriptor ImageDescriptor;
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::mozilla::wr::ImageKey ImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUpdateImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUpdateImage(
            const ImageDescriptor& _descriptor,
            const OffsetRange& _bytes,
            const ImageKey& _key) :
        descriptor_(_descriptor),
        bytes_(_bytes),
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpUpdateImage(
            ImageDescriptor&& _descriptor,
            OffsetRange&& _bytes,
            ImageKey&& _key) :
        descriptor_(std::move(_descriptor)),
        bytes_(std::move(_bytes)),
        key_(std::move(_key))
    {
    }

    ImageDescriptor&
    descriptor()
    {
        return descriptor_;
    }
    const ImageDescriptor&
    descriptor() const
    {
        return descriptor_;
    }

    OffsetRange&
    bytes()
    {
        return bytes_;
    }
    const OffsetRange&
    bytes() const
    {
        return bytes_;
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageDescriptor> descriptor_;
    ::mozilla::ipc::IPDLStructMember<OffsetRange> bytes_;
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUpdateImage>
{
    typedef ::mozilla::layers::OpUpdateImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUpdateBlobImage|
//
namespace mozilla {
namespace layers {
class OpUpdateBlobImage final
{
private:
    typedef ::mozilla::wr::ImageDescriptor ImageDescriptor;
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::mozilla::wr::BlobImageKey BlobImageKey;
    typedef ::mozilla::ImageIntRect ImageIntRect;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUpdateBlobImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUpdateBlobImage(
            const ImageDescriptor& _descriptor,
            const OffsetRange& _bytes,
            const BlobImageKey& _key,
            const ImageIntRect& _visibleRect,
            const ImageIntRect& _dirtyRect) :
        descriptor_(_descriptor),
        bytes_(_bytes),
        key_(_key),
        visibleRect_(_visibleRect),
        dirtyRect_(_dirtyRect)
    {
    }

    MOZ_IMPLICIT OpUpdateBlobImage(
            ImageDescriptor&& _descriptor,
            OffsetRange&& _bytes,
            BlobImageKey&& _key,
            ImageIntRect&& _visibleRect,
            ImageIntRect&& _dirtyRect) :
        descriptor_(std::move(_descriptor)),
        bytes_(std::move(_bytes)),
        key_(std::move(_key)),
        visibleRect_(std::move(_visibleRect)),
        dirtyRect_(std::move(_dirtyRect))
    {
    }

    ImageDescriptor&
    descriptor()
    {
        return descriptor_;
    }
    const ImageDescriptor&
    descriptor() const
    {
        return descriptor_;
    }

    OffsetRange&
    bytes()
    {
        return bytes_;
    }
    const OffsetRange&
    bytes() const
    {
        return bytes_;
    }

    BlobImageKey&
    key()
    {
        return key_;
    }
    const BlobImageKey&
    key() const
    {
        return key_;
    }

    ImageIntRect&
    visibleRect()
    {
        return visibleRect_;
    }
    const ImageIntRect&
    visibleRect() const
    {
        return visibleRect_;
    }

    ImageIntRect&
    dirtyRect()
    {
        return dirtyRect_;
    }
    const ImageIntRect&
    dirtyRect() const
    {
        return dirtyRect_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageDescriptor> descriptor_;
    ::mozilla::ipc::IPDLStructMember<OffsetRange> bytes_;
    ::mozilla::ipc::IPDLStructMember<BlobImageKey> key_;
    ::mozilla::ipc::IPDLStructMember<ImageIntRect> visibleRect_;
    ::mozilla::ipc::IPDLStructMember<ImageIntRect> dirtyRect_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUpdateBlobImage>
{
    typedef ::mozilla::layers::OpUpdateBlobImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpSetBlobImageVisibleArea|
//
namespace mozilla {
namespace layers {
class OpSetBlobImageVisibleArea final
{
private:
    typedef ::mozilla::ImageIntRect ImageIntRect;
    typedef ::mozilla::wr::BlobImageKey BlobImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpSetBlobImageVisibleArea() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpSetBlobImageVisibleArea(
            const ImageIntRect& _area,
            const BlobImageKey& _key) :
        area_(_area),
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpSetBlobImageVisibleArea(
            ImageIntRect&& _area,
            BlobImageKey&& _key) :
        area_(std::move(_area)),
        key_(std::move(_key))
    {
    }

    ImageIntRect&
    area()
    {
        return area_;
    }
    const ImageIntRect&
    area() const
    {
        return area_;
    }

    BlobImageKey&
    key()
    {
        return key_;
    }
    const BlobImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageIntRect> area_;
    ::mozilla::ipc::IPDLStructMember<BlobImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpSetBlobImageVisibleArea>
{
    typedef ::mozilla::layers::OpSetBlobImageVisibleArea paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpUpdateSharedExternalImage|
//
namespace mozilla {
namespace layers {
class OpUpdateSharedExternalImage final
{
private:
    typedef ::mozilla::wr::ExternalImageId ExternalImageId;
    typedef ::mozilla::wr::ImageKey ImageKey;
    typedef ::mozilla::ImageIntRect ImageIntRect;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpUpdateSharedExternalImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpUpdateSharedExternalImage(
            const ExternalImageId& _externalImageId,
            const ImageKey& _key,
            const ImageIntRect& _dirtyRect) :
        externalImageId_(_externalImageId),
        key_(_key),
        dirtyRect_(_dirtyRect)
    {
    }

    MOZ_IMPLICIT OpUpdateSharedExternalImage(
            ExternalImageId&& _externalImageId,
            ImageKey&& _key,
            ImageIntRect&& _dirtyRect) :
        externalImageId_(std::move(_externalImageId)),
        key_(std::move(_key)),
        dirtyRect_(std::move(_dirtyRect))
    {
    }

    ExternalImageId&
    externalImageId()
    {
        return externalImageId_;
    }
    const ExternalImageId&
    externalImageId() const
    {
        return externalImageId_;
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

    ImageIntRect&
    dirtyRect()
    {
        return dirtyRect_;
    }
    const ImageIntRect&
    dirtyRect() const
    {
        return dirtyRect_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ExternalImageId> externalImageId_;
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
    ::mozilla::ipc::IPDLStructMember<ImageIntRect> dirtyRect_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUpdateSharedExternalImage>
{
    typedef ::mozilla::layers::OpUpdateSharedExternalImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpDeleteImage|
//
namespace mozilla {
namespace layers {
class OpDeleteImage final
{
private:
    typedef ::mozilla::wr::ImageKey ImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpDeleteImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpDeleteImage(const ImageKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpDeleteImage(ImageKey&& _key) :
        key_(std::move(_key))
    {
    }

    ImageKey&
    key()
    {
        return key_;
    }
    const ImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpDeleteImage>
{
    typedef ::mozilla::layers::OpDeleteImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpDeleteSnapshotImage|
//
namespace mozilla {
namespace layers {
class OpDeleteSnapshotImage final
{
private:
    typedef ::mozilla::wr::SnapshotImageKey SnapshotImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpDeleteSnapshotImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpDeleteSnapshotImage(const SnapshotImageKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpDeleteSnapshotImage(SnapshotImageKey&& _key) :
        key_(std::move(_key))
    {
    }

    SnapshotImageKey&
    key()
    {
        return key_;
    }
    const SnapshotImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SnapshotImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpDeleteSnapshotImage>
{
    typedef ::mozilla::layers::OpDeleteSnapshotImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpDeleteBlobImage|
//
namespace mozilla {
namespace layers {
class OpDeleteBlobImage final
{
private:
    typedef ::mozilla::wr::BlobImageKey BlobImageKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpDeleteBlobImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpDeleteBlobImage(const BlobImageKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpDeleteBlobImage(BlobImageKey&& _key) :
        key_(std::move(_key))
    {
    }

    BlobImageKey&
    key()
    {
        return key_;
    }
    const BlobImageKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<BlobImageKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpDeleteBlobImage>
{
    typedef ::mozilla::layers::OpDeleteBlobImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddRawFont|
//
namespace mozilla {
namespace layers {
class OpAddRawFont final
{
private:
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::wr::FontKey FontKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddRawFont() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddRawFont(
            const OffsetRange& _bytes,
            const uint32_t& _fontIndex,
            const FontKey& _key) :
        bytes_(_bytes),
        key_(_key),
        fontIndex_(_fontIndex)
    {
    }

    MOZ_IMPLICIT OpAddRawFont(
            OffsetRange&& _bytes,
            uint32_t&& _fontIndex,
            FontKey&& _key) :
        bytes_(std::move(_bytes)),
        key_(std::move(_key)),
        fontIndex_(std::move(_fontIndex))
    {
    }

    OffsetRange&
    bytes()
    {
        return bytes_;
    }
    const OffsetRange&
    bytes() const
    {
        return bytes_;
    }

    uint32_t&
    fontIndex()
    {
        return fontIndex_;
    }
    const uint32_t&
    fontIndex() const
    {
        return fontIndex_;
    }

    FontKey&
    key()
    {
        return key_;
    }
    const FontKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<OffsetRange> bytes_;
    ::mozilla::ipc::IPDLStructMember<FontKey> key_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> fontIndex_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddRawFont>
{
    typedef ::mozilla::layers::OpAddRawFont paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddFontDescriptor|
//
namespace mozilla {
namespace layers {
class OpAddFontDescriptor final
{
private:
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::wr::FontKey FontKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddFontDescriptor() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddFontDescriptor(
            const OffsetRange& _bytes,
            const uint32_t& _fontIndex,
            const FontKey& _key) :
        bytes_(_bytes),
        key_(_key),
        fontIndex_(_fontIndex)
    {
    }

    MOZ_IMPLICIT OpAddFontDescriptor(
            OffsetRange&& _bytes,
            uint32_t&& _fontIndex,
            FontKey&& _key) :
        bytes_(std::move(_bytes)),
        key_(std::move(_key)),
        fontIndex_(std::move(_fontIndex))
    {
    }

    OffsetRange&
    bytes()
    {
        return bytes_;
    }
    const OffsetRange&
    bytes() const
    {
        return bytes_;
    }

    uint32_t&
    fontIndex()
    {
        return fontIndex_;
    }
    const uint32_t&
    fontIndex() const
    {
        return fontIndex_;
    }

    FontKey&
    key()
    {
        return key_;
    }
    const FontKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<OffsetRange> bytes_;
    ::mozilla::ipc::IPDLStructMember<FontKey> key_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> fontIndex_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddFontDescriptor>
{
    typedef ::mozilla::layers::OpAddFontDescriptor paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpDeleteFont|
//
namespace mozilla {
namespace layers {
class OpDeleteFont final
{
private:
    typedef ::mozilla::wr::FontKey FontKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpDeleteFont() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpDeleteFont(const FontKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpDeleteFont(FontKey&& _key) :
        key_(std::move(_key))
    {
    }

    FontKey&
    key()
    {
        return key_;
    }
    const FontKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FontKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpDeleteFont>
{
    typedef ::mozilla::layers::OpDeleteFont paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpAddFontInstance|
//
namespace mozilla {
namespace layers {
class OpAddFontInstance final
{
private:
    typedef ::mozilla::wr::MaybeFontInstanceOptions MaybeFontInstanceOptions;
    typedef ::mozilla::wr::MaybeFontInstancePlatformOptions MaybeFontInstancePlatformOptions;
    typedef ::mozilla::layers::OffsetRange OffsetRange;
    typedef ::mozilla::wr::FontInstanceKey FontInstanceKey;
    typedef ::mozilla::wr::FontKey FontKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpAddFontInstance() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpAddFontInstance(
            const MaybeFontInstanceOptions& _options,
            const MaybeFontInstancePlatformOptions& _platformOptions,
            const OffsetRange& _variations,
            const FontInstanceKey& _instanceKey,
            const FontKey& _fontKey,
            const float& _glyphSize) :
        options_(_options),
        platformOptions_(_platformOptions),
        variations_(_variations),
        instanceKey_(_instanceKey),
        fontKey_(_fontKey),
        glyphSize_(_glyphSize)
    {
    }

    MOZ_IMPLICIT OpAddFontInstance(
            MaybeFontInstanceOptions&& _options,
            MaybeFontInstancePlatformOptions&& _platformOptions,
            OffsetRange&& _variations,
            FontInstanceKey&& _instanceKey,
            FontKey&& _fontKey,
            float&& _glyphSize) :
        options_(std::move(_options)),
        platformOptions_(std::move(_platformOptions)),
        variations_(std::move(_variations)),
        instanceKey_(std::move(_instanceKey)),
        fontKey_(std::move(_fontKey)),
        glyphSize_(std::move(_glyphSize))
    {
    }

    MaybeFontInstanceOptions&
    options()
    {
        return options_;
    }
    const MaybeFontInstanceOptions&
    options() const
    {
        return options_;
    }

    MaybeFontInstancePlatformOptions&
    platformOptions()
    {
        return platformOptions_;
    }
    const MaybeFontInstancePlatformOptions&
    platformOptions() const
    {
        return platformOptions_;
    }

    OffsetRange&
    variations()
    {
        return variations_;
    }
    const OffsetRange&
    variations() const
    {
        return variations_;
    }

    FontInstanceKey&
    instanceKey()
    {
        return instanceKey_;
    }
    const FontInstanceKey&
    instanceKey() const
    {
        return instanceKey_;
    }

    FontKey&
    fontKey()
    {
        return fontKey_;
    }
    const FontKey&
    fontKey() const
    {
        return fontKey_;
    }

    float&
    glyphSize()
    {
        return glyphSize_;
    }
    const float&
    glyphSize() const
    {
        return glyphSize_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<MaybeFontInstanceOptions> options_;
    ::mozilla::ipc::IPDLStructMember<MaybeFontInstancePlatformOptions> platformOptions_;
    ::mozilla::ipc::IPDLStructMember<OffsetRange> variations_;
    ::mozilla::ipc::IPDLStructMember<FontInstanceKey> instanceKey_;
    ::mozilla::ipc::IPDLStructMember<FontKey> fontKey_;
    ::mozilla::ipc::IPDLStructMember<float> glyphSize_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpAddFontInstance>
{
    typedef ::mozilla::layers::OpAddFontInstance paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OpDeleteFontInstance|
//
namespace mozilla {
namespace layers {
class OpDeleteFontInstance final
{
private:
    typedef ::mozilla::wr::FontInstanceKey FontInstanceKey;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OpDeleteFontInstance() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OpDeleteFontInstance(const FontInstanceKey& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT OpDeleteFontInstance(FontInstanceKey&& _key) :
        key_(std::move(_key))
    {
    }

    FontInstanceKey&
    key()
    {
        return key_;
    }
    const FontInstanceKey&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<FontInstanceKey> key_;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpDeleteFontInstance>
{
    typedef ::mozilla::layers::OpDeleteFontInstance paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union OpUpdateResource|
//
namespace mozilla {
namespace layers {
class OpUpdateResource final
{
public:
    enum Type {
        T__None,
        TOpAddImage = 1,
        TOpAddBlobImage,
        TOpAddSnapshotImage,
        TOpUpdateImage,
        TOpUpdateBlobImage,
        TOpSetBlobImageVisibleArea,
        TOpDeleteImage,
        TOpDeleteBlobImage,
        TOpDeleteSnapshotImage,
        TOpAddRawFont,
        TOpAddFontDescriptor,
        TOpDeleteFont,
        TOpAddFontInstance,
        TOpDeleteFontInstance,
        TOpAddSharedExternalImage,
        TOpPushExternalImageForTexture,
        TOpUpdateSharedExternalImage,
        T__Last = TOpUpdateSharedExternalImage
    };

private:
    typedef ::mozilla::layers::OpAddImage OpAddImage;
    typedef ::mozilla::layers::OpAddBlobImage OpAddBlobImage;
    typedef ::mozilla::layers::OpAddSnapshotImage OpAddSnapshotImage;
    typedef ::mozilla::layers::OpUpdateImage OpUpdateImage;
    typedef ::mozilla::layers::OpUpdateBlobImage OpUpdateBlobImage;
    typedef ::mozilla::layers::OpSetBlobImageVisibleArea OpSetBlobImageVisibleArea;
    typedef ::mozilla::layers::OpDeleteImage OpDeleteImage;
    typedef ::mozilla::layers::OpDeleteBlobImage OpDeleteBlobImage;
    typedef ::mozilla::layers::OpDeleteSnapshotImage OpDeleteSnapshotImage;
    typedef ::mozilla::layers::OpAddRawFont OpAddRawFont;
    typedef ::mozilla::layers::OpAddFontDescriptor OpAddFontDescriptor;
    typedef ::mozilla::layers::OpDeleteFont OpDeleteFont;
    typedef ::mozilla::layers::OpAddFontInstance OpAddFontInstance;
    typedef ::mozilla::layers::OpDeleteFontInstance OpDeleteFontInstance;
    typedef ::mozilla::layers::OpAddSharedExternalImage OpAddSharedExternalImage;
    typedef ::mozilla::layers::OpPushExternalImageForTexture OpPushExternalImageForTexture;
    typedef ::mozilla::layers::OpUpdateSharedExternalImage OpUpdateSharedExternalImage;
    typedef OpAddImage OpAddImage__tdef;
    typedef OpAddBlobImage OpAddBlobImage__tdef;
    typedef OpAddSnapshotImage OpAddSnapshotImage__tdef;
    typedef OpUpdateImage OpUpdateImage__tdef;
    typedef OpUpdateBlobImage OpUpdateBlobImage__tdef;
    typedef OpSetBlobImageVisibleArea OpSetBlobImageVisibleArea__tdef;
    typedef OpDeleteImage OpDeleteImage__tdef;
    typedef OpDeleteBlobImage OpDeleteBlobImage__tdef;
    typedef OpDeleteSnapshotImage OpDeleteSnapshotImage__tdef;
    typedef OpAddRawFont OpAddRawFont__tdef;
    typedef OpAddFontDescriptor OpAddFontDescriptor__tdef;
    typedef OpDeleteFont OpDeleteFont__tdef;
    typedef OpAddFontInstance OpAddFontInstance__tdef;
    typedef OpDeleteFontInstance OpDeleteFontInstance__tdef;
    typedef OpAddSharedExternalImage OpAddSharedExternalImage__tdef;
    typedef OpPushExternalImageForTexture OpPushExternalImageForTexture__tdef;
    typedef OpUpdateSharedExternalImage OpUpdateSharedExternalImage__tdef;

    OpAddImage*
    ptr_OpAddImage()
    {
        return (&(mVOpAddImage));
    }
    const OpAddImage*
    constptr_OpAddImage() const
    {
        return (&(mVOpAddImage));
    }
    OpAddBlobImage*
    ptr_OpAddBlobImage()
    {
        return (&(mVOpAddBlobImage));
    }
    const OpAddBlobImage*
    constptr_OpAddBlobImage() const
    {
        return (&(mVOpAddBlobImage));
    }
    OpAddSnapshotImage*
    ptr_OpAddSnapshotImage()
    {
        return (&(mVOpAddSnapshotImage));
    }
    const OpAddSnapshotImage*
    constptr_OpAddSnapshotImage() const
    {
        return (&(mVOpAddSnapshotImage));
    }
    OpUpdateImage*
    ptr_OpUpdateImage()
    {
        return (&(mVOpUpdateImage));
    }
    const OpUpdateImage*
    constptr_OpUpdateImage() const
    {
        return (&(mVOpUpdateImage));
    }
    OpUpdateBlobImage*
    ptr_OpUpdateBlobImage()
    {
        return (&(mVOpUpdateBlobImage));
    }
    const OpUpdateBlobImage*
    constptr_OpUpdateBlobImage() const
    {
        return (&(mVOpUpdateBlobImage));
    }
    OpSetBlobImageVisibleArea*
    ptr_OpSetBlobImageVisibleArea()
    {
        return (&(mVOpSetBlobImageVisibleArea));
    }
    const OpSetBlobImageVisibleArea*
    constptr_OpSetBlobImageVisibleArea() const
    {
        return (&(mVOpSetBlobImageVisibleArea));
    }
    OpDeleteImage*
    ptr_OpDeleteImage()
    {
        return (&(mVOpDeleteImage));
    }
    const OpDeleteImage*
    constptr_OpDeleteImage() const
    {
        return (&(mVOpDeleteImage));
    }
    OpDeleteBlobImage*
    ptr_OpDeleteBlobImage()
    {
        return (&(mVOpDeleteBlobImage));
    }
    const OpDeleteBlobImage*
    constptr_OpDeleteBlobImage() const
    {
        return (&(mVOpDeleteBlobImage));
    }
    OpDeleteSnapshotImage*
    ptr_OpDeleteSnapshotImage()
    {
        return (&(mVOpDeleteSnapshotImage));
    }
    const OpDeleteSnapshotImage*
    constptr_OpDeleteSnapshotImage() const
    {
        return (&(mVOpDeleteSnapshotImage));
    }
    OpAddRawFont*
    ptr_OpAddRawFont()
    {
        return (&(mVOpAddRawFont));
    }
    const OpAddRawFont*
    constptr_OpAddRawFont() const
    {
        return (&(mVOpAddRawFont));
    }
    OpAddFontDescriptor*
    ptr_OpAddFontDescriptor()
    {
        return (&(mVOpAddFontDescriptor));
    }
    const OpAddFontDescriptor*
    constptr_OpAddFontDescriptor() const
    {
        return (&(mVOpAddFontDescriptor));
    }
    OpDeleteFont*
    ptr_OpDeleteFont()
    {
        return (&(mVOpDeleteFont));
    }
    const OpDeleteFont*
    constptr_OpDeleteFont() const
    {
        return (&(mVOpDeleteFont));
    }
    OpAddFontInstance*
    ptr_OpAddFontInstance()
    {
        return (&(mVOpAddFontInstance));
    }
    const OpAddFontInstance*
    constptr_OpAddFontInstance() const
    {
        return (&(mVOpAddFontInstance));
    }
    OpDeleteFontInstance*
    ptr_OpDeleteFontInstance()
    {
        return (&(mVOpDeleteFontInstance));
    }
    const OpDeleteFontInstance*
    constptr_OpDeleteFontInstance() const
    {
        return (&(mVOpDeleteFontInstance));
    }
    OpAddSharedExternalImage*
    ptr_OpAddSharedExternalImage()
    {
        return (&(mVOpAddSharedExternalImage));
    }
    const OpAddSharedExternalImage*
    constptr_OpAddSharedExternalImage() const
    {
        return (&(mVOpAddSharedExternalImage));
    }
    OpPushExternalImageForTexture*
    ptr_OpPushExternalImageForTexture()
    {
        return (&(mVOpPushExternalImageForTexture));
    }
    const OpPushExternalImageForTexture*
    constptr_OpPushExternalImageForTexture() const
    {
        return (&(mVOpPushExternalImageForTexture));
    }
    OpUpdateSharedExternalImage*
    ptr_OpUpdateSharedExternalImage()
    {
        return (&(mVOpUpdateSharedExternalImage));
    }
    const OpUpdateSharedExternalImage*
    constptr_OpUpdateSharedExternalImage() const
    {
        return (&(mVOpUpdateSharedExternalImage));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT OpUpdateResource() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT OpUpdateResource(const OpAddImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpAddBlobImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddBlobImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpAddSnapshotImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddSnapshotImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpUpdateImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpUpdateImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpUpdateBlobImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpUpdateBlobImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpSetBlobImageVisibleArea& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpSetBlobImageVisibleArea&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpDeleteImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpDeleteImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpDeleteBlobImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpDeleteBlobImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpDeleteSnapshotImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpDeleteSnapshotImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpAddRawFont& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddRawFont&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpAddFontDescriptor& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddFontDescriptor&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpDeleteFont& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpDeleteFont&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpAddFontInstance& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddFontInstance&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpDeleteFontInstance& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpDeleteFontInstance&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpAddSharedExternalImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpAddSharedExternalImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpPushExternalImageForTexture& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpPushExternalImageForTexture&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpUpdateSharedExternalImage& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpUpdateSharedExternalImage&& aOther);

    MOZ_IMPLICIT OpUpdateResource(const OpUpdateResource& aOther);

    MOZ_IMPLICIT OpUpdateResource(OpUpdateResource&& aOther);

    ~OpUpdateResource();

    Type
    type() const
    {
        return mType;
    }

    OpUpdateResource&
    operator=(const OpAddImage& aRhs);

    OpUpdateResource&
    operator=(OpAddImage&& aRhs);

    OpUpdateResource&
    operator=(const OpAddBlobImage& aRhs);

    OpUpdateResource&
    operator=(OpAddBlobImage&& aRhs);

    OpUpdateResource&
    operator=(const OpAddSnapshotImage& aRhs);

    OpUpdateResource&
    operator=(OpAddSnapshotImage&& aRhs);

    OpUpdateResource&
    operator=(const OpUpdateImage& aRhs);

    OpUpdateResource&
    operator=(OpUpdateImage&& aRhs);

    OpUpdateResource&
    operator=(const OpUpdateBlobImage& aRhs);

    OpUpdateResource&
    operator=(OpUpdateBlobImage&& aRhs);

    OpUpdateResource&
    operator=(const OpSetBlobImageVisibleArea& aRhs);

    OpUpdateResource&
    operator=(OpSetBlobImageVisibleArea&& aRhs);

    OpUpdateResource&
    operator=(const OpDeleteImage& aRhs);

    OpUpdateResource&
    operator=(OpDeleteImage&& aRhs);

    OpUpdateResource&
    operator=(const OpDeleteBlobImage& aRhs);

    OpUpdateResource&
    operator=(OpDeleteBlobImage&& aRhs);

    OpUpdateResource&
    operator=(const OpDeleteSnapshotImage& aRhs);

    OpUpdateResource&
    operator=(OpDeleteSnapshotImage&& aRhs);

    OpUpdateResource&
    operator=(const OpAddRawFont& aRhs);

    OpUpdateResource&
    operator=(OpAddRawFont&& aRhs);

    OpUpdateResource&
    operator=(const OpAddFontDescriptor& aRhs);

    OpUpdateResource&
    operator=(OpAddFontDescriptor&& aRhs);

    OpUpdateResource&
    operator=(const OpDeleteFont& aRhs);

    OpUpdateResource&
    operator=(OpDeleteFont&& aRhs);

    OpUpdateResource&
    operator=(const OpAddFontInstance& aRhs);

    OpUpdateResource&
    operator=(OpAddFontInstance&& aRhs);

    OpUpdateResource&
    operator=(const OpDeleteFontInstance& aRhs);

    OpUpdateResource&
    operator=(OpDeleteFontInstance&& aRhs);

    OpUpdateResource&
    operator=(const OpAddSharedExternalImage& aRhs);

    OpUpdateResource&
    operator=(OpAddSharedExternalImage&& aRhs);

    OpUpdateResource&
    operator=(const OpPushExternalImageForTexture& aRhs);

    OpUpdateResource&
    operator=(OpPushExternalImageForTexture&& aRhs);

    OpUpdateResource&
    operator=(const OpUpdateSharedExternalImage& aRhs);

    OpUpdateResource&
    operator=(OpUpdateSharedExternalImage&& aRhs);

    OpUpdateResource&
    operator=(const OpUpdateResource& aRhs);

    OpUpdateResource&
    operator=(OpUpdateResource&& aRhs);

    OpAddImage&
    get_OpAddImage()
    {
        AssertSanity(TOpAddImage);
        return (*(ptr_OpAddImage()));
    }
    const OpAddImage&
    get_OpAddImage() const
    {
        AssertSanity(TOpAddImage);
        return (*(constptr_OpAddImage()));
    }
    operator OpAddImage&()
    {
        return get_OpAddImage();
    }
    operator const OpAddImage&() const
    {
        return get_OpAddImage();
    }

    OpAddBlobImage&
    get_OpAddBlobImage()
    {
        AssertSanity(TOpAddBlobImage);
        return (*(ptr_OpAddBlobImage()));
    }
    const OpAddBlobImage&
    get_OpAddBlobImage() const
    {
        AssertSanity(TOpAddBlobImage);
        return (*(constptr_OpAddBlobImage()));
    }
    operator OpAddBlobImage&()
    {
        return get_OpAddBlobImage();
    }
    operator const OpAddBlobImage&() const
    {
        return get_OpAddBlobImage();
    }

    OpAddSnapshotImage&
    get_OpAddSnapshotImage()
    {
        AssertSanity(TOpAddSnapshotImage);
        return (*(ptr_OpAddSnapshotImage()));
    }
    const OpAddSnapshotImage&
    get_OpAddSnapshotImage() const
    {
        AssertSanity(TOpAddSnapshotImage);
        return (*(constptr_OpAddSnapshotImage()));
    }
    operator OpAddSnapshotImage&()
    {
        return get_OpAddSnapshotImage();
    }
    operator const OpAddSnapshotImage&() const
    {
        return get_OpAddSnapshotImage();
    }

    OpUpdateImage&
    get_OpUpdateImage()
    {
        AssertSanity(TOpUpdateImage);
        return (*(ptr_OpUpdateImage()));
    }
    const OpUpdateImage&
    get_OpUpdateImage() const
    {
        AssertSanity(TOpUpdateImage);
        return (*(constptr_OpUpdateImage()));
    }
    operator OpUpdateImage&()
    {
        return get_OpUpdateImage();
    }
    operator const OpUpdateImage&() const
    {
        return get_OpUpdateImage();
    }

    OpUpdateBlobImage&
    get_OpUpdateBlobImage()
    {
        AssertSanity(TOpUpdateBlobImage);
        return (*(ptr_OpUpdateBlobImage()));
    }
    const OpUpdateBlobImage&
    get_OpUpdateBlobImage() const
    {
        AssertSanity(TOpUpdateBlobImage);
        return (*(constptr_OpUpdateBlobImage()));
    }
    operator OpUpdateBlobImage&()
    {
        return get_OpUpdateBlobImage();
    }
    operator const OpUpdateBlobImage&() const
    {
        return get_OpUpdateBlobImage();
    }

    OpSetBlobImageVisibleArea&
    get_OpSetBlobImageVisibleArea()
    {
        AssertSanity(TOpSetBlobImageVisibleArea);
        return (*(ptr_OpSetBlobImageVisibleArea()));
    }
    const OpSetBlobImageVisibleArea&
    get_OpSetBlobImageVisibleArea() const
    {
        AssertSanity(TOpSetBlobImageVisibleArea);
        return (*(constptr_OpSetBlobImageVisibleArea()));
    }
    operator OpSetBlobImageVisibleArea&()
    {
        return get_OpSetBlobImageVisibleArea();
    }
    operator const OpSetBlobImageVisibleArea&() const
    {
        return get_OpSetBlobImageVisibleArea();
    }

    OpDeleteImage&
    get_OpDeleteImage()
    {
        AssertSanity(TOpDeleteImage);
        return (*(ptr_OpDeleteImage()));
    }
    const OpDeleteImage&
    get_OpDeleteImage() const
    {
        AssertSanity(TOpDeleteImage);
        return (*(constptr_OpDeleteImage()));
    }
    operator OpDeleteImage&()
    {
        return get_OpDeleteImage();
    }
    operator const OpDeleteImage&() const
    {
        return get_OpDeleteImage();
    }

    OpDeleteBlobImage&
    get_OpDeleteBlobImage()
    {
        AssertSanity(TOpDeleteBlobImage);
        return (*(ptr_OpDeleteBlobImage()));
    }
    const OpDeleteBlobImage&
    get_OpDeleteBlobImage() const
    {
        AssertSanity(TOpDeleteBlobImage);
        return (*(constptr_OpDeleteBlobImage()));
    }
    operator OpDeleteBlobImage&()
    {
        return get_OpDeleteBlobImage();
    }
    operator const OpDeleteBlobImage&() const
    {
        return get_OpDeleteBlobImage();
    }

    OpDeleteSnapshotImage&
    get_OpDeleteSnapshotImage()
    {
        AssertSanity(TOpDeleteSnapshotImage);
        return (*(ptr_OpDeleteSnapshotImage()));
    }
    const OpDeleteSnapshotImage&
    get_OpDeleteSnapshotImage() const
    {
        AssertSanity(TOpDeleteSnapshotImage);
        return (*(constptr_OpDeleteSnapshotImage()));
    }
    operator OpDeleteSnapshotImage&()
    {
        return get_OpDeleteSnapshotImage();
    }
    operator const OpDeleteSnapshotImage&() const
    {
        return get_OpDeleteSnapshotImage();
    }

    OpAddRawFont&
    get_OpAddRawFont()
    {
        AssertSanity(TOpAddRawFont);
        return (*(ptr_OpAddRawFont()));
    }
    const OpAddRawFont&
    get_OpAddRawFont() const
    {
        AssertSanity(TOpAddRawFont);
        return (*(constptr_OpAddRawFont()));
    }
    operator OpAddRawFont&()
    {
        return get_OpAddRawFont();
    }
    operator const OpAddRawFont&() const
    {
        return get_OpAddRawFont();
    }

    OpAddFontDescriptor&
    get_OpAddFontDescriptor()
    {
        AssertSanity(TOpAddFontDescriptor);
        return (*(ptr_OpAddFontDescriptor()));
    }
    const OpAddFontDescriptor&
    get_OpAddFontDescriptor() const
    {
        AssertSanity(TOpAddFontDescriptor);
        return (*(constptr_OpAddFontDescriptor()));
    }
    operator OpAddFontDescriptor&()
    {
        return get_OpAddFontDescriptor();
    }
    operator const OpAddFontDescriptor&() const
    {
        return get_OpAddFontDescriptor();
    }

    OpDeleteFont&
    get_OpDeleteFont()
    {
        AssertSanity(TOpDeleteFont);
        return (*(ptr_OpDeleteFont()));
    }
    const OpDeleteFont&
    get_OpDeleteFont() const
    {
        AssertSanity(TOpDeleteFont);
        return (*(constptr_OpDeleteFont()));
    }
    operator OpDeleteFont&()
    {
        return get_OpDeleteFont();
    }
    operator const OpDeleteFont&() const
    {
        return get_OpDeleteFont();
    }

    OpAddFontInstance&
    get_OpAddFontInstance()
    {
        AssertSanity(TOpAddFontInstance);
        return (*(ptr_OpAddFontInstance()));
    }
    const OpAddFontInstance&
    get_OpAddFontInstance() const
    {
        AssertSanity(TOpAddFontInstance);
        return (*(constptr_OpAddFontInstance()));
    }
    operator OpAddFontInstance&()
    {
        return get_OpAddFontInstance();
    }
    operator const OpAddFontInstance&() const
    {
        return get_OpAddFontInstance();
    }

    OpDeleteFontInstance&
    get_OpDeleteFontInstance()
    {
        AssertSanity(TOpDeleteFontInstance);
        return (*(ptr_OpDeleteFontInstance()));
    }
    const OpDeleteFontInstance&
    get_OpDeleteFontInstance() const
    {
        AssertSanity(TOpDeleteFontInstance);
        return (*(constptr_OpDeleteFontInstance()));
    }
    operator OpDeleteFontInstance&()
    {
        return get_OpDeleteFontInstance();
    }
    operator const OpDeleteFontInstance&() const
    {
        return get_OpDeleteFontInstance();
    }

    OpAddSharedExternalImage&
    get_OpAddSharedExternalImage()
    {
        AssertSanity(TOpAddSharedExternalImage);
        return (*(ptr_OpAddSharedExternalImage()));
    }
    const OpAddSharedExternalImage&
    get_OpAddSharedExternalImage() const
    {
        AssertSanity(TOpAddSharedExternalImage);
        return (*(constptr_OpAddSharedExternalImage()));
    }
    operator OpAddSharedExternalImage&()
    {
        return get_OpAddSharedExternalImage();
    }
    operator const OpAddSharedExternalImage&() const
    {
        return get_OpAddSharedExternalImage();
    }

    OpPushExternalImageForTexture&
    get_OpPushExternalImageForTexture()
    {
        AssertSanity(TOpPushExternalImageForTexture);
        return (*(ptr_OpPushExternalImageForTexture()));
    }
    const OpPushExternalImageForTexture&
    get_OpPushExternalImageForTexture() const
    {
        AssertSanity(TOpPushExternalImageForTexture);
        return (*(constptr_OpPushExternalImageForTexture()));
    }
    operator OpPushExternalImageForTexture&()
    {
        return get_OpPushExternalImageForTexture();
    }
    operator const OpPushExternalImageForTexture&() const
    {
        return get_OpPushExternalImageForTexture();
    }

    OpUpdateSharedExternalImage&
    get_OpUpdateSharedExternalImage()
    {
        AssertSanity(TOpUpdateSharedExternalImage);
        return (*(ptr_OpUpdateSharedExternalImage()));
    }
    const OpUpdateSharedExternalImage&
    get_OpUpdateSharedExternalImage() const
    {
        AssertSanity(TOpUpdateSharedExternalImage);
        return (*(constptr_OpUpdateSharedExternalImage()));
    }
    operator OpUpdateSharedExternalImage&()
    {
        return get_OpUpdateSharedExternalImage();
    }
    operator const OpUpdateSharedExternalImage&() const
    {
        return get_OpUpdateSharedExternalImage();
    }

private:
    union {
        OpAddImage mVOpAddImage;
        OpAddBlobImage mVOpAddBlobImage;
        OpAddSnapshotImage mVOpAddSnapshotImage;
        OpUpdateImage mVOpUpdateImage;
        OpUpdateBlobImage mVOpUpdateBlobImage;
        OpSetBlobImageVisibleArea mVOpSetBlobImageVisibleArea;
        OpDeleteImage mVOpDeleteImage;
        OpDeleteBlobImage mVOpDeleteBlobImage;
        OpDeleteSnapshotImage mVOpDeleteSnapshotImage;
        OpAddRawFont mVOpAddRawFont;
        OpAddFontDescriptor mVOpAddFontDescriptor;
        OpDeleteFont mVOpDeleteFont;
        OpAddFontInstance mVOpAddFontInstance;
        OpDeleteFontInstance mVOpDeleteFontInstance;
        OpAddSharedExternalImage mVOpAddSharedExternalImage;
        OpPushExternalImageForTexture mVOpPushExternalImageForTexture;
        OpUpdateSharedExternalImage mVOpUpdateSharedExternalImage;
    };
    Type mType;
};
} // namespace layers
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::layers::OpUpdateResource>
{
    typedef ::mozilla::layers::OpUpdateResource paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef WebRenderMessages_h
