/* THIS FILE IS AUTOGENERATED FROM EventListener.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "EventListenerBinding.h"
#include "MainThreadUtils.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Event.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
EventListener::HandleEvent(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, Event& event, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, event, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  bool isCallable = JS::IsCallable(mCallback);
  JS::Rooted<JS::Value> callable(cx);
  if (isCallable) {
    callable = JS::ObjectValue(*mCallback);
  } else {
    EventListenerAtoms* atomsCache = GetAtomCache<EventListenerAtoms>(cx);
    if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
         !InitIds(cx, atomsCache)) ||
        !GetCallableProperty(cx, atomsCache->handleEvent_id, &callable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
  }
  JS::Rooted<JS::Value> thisValue(cx, isCallable ? aThisVal.get()
                                                 : JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

bool
EventListener::InitIds(JSContext* cx, EventListenerAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->handleEvent_id.init(cx, "handleEvent")) {
    return false;
  }
  return true;
}



} // namespace mozilla::dom
