/* THIS FILE IS AUTOGENERATED FROM HTMLSlotElement.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_HTMLSLOTELEMENTBINDING_H_
#define DOM_HTMLSLOTELEMENTBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct AssignedNodesOptionsAtoms;
class Element;
class HTMLSlotElement;
struct NativePropertyHooks;
class OwningElementOrText;
class ProtoAndIfaceCache;
class Text;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningElementOrText& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningElementOrText& aUnion);


struct AssignedNodesOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mFlatten;

  AssignedNodesOptions();

  explicit inline AssignedNodesOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AssignedNodesOptions(AssignedNodesOptions&& aOther) = default;

  explicit inline AssignedNodesOptions(const AssignedNodesOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  AssignedNodesOptions&
  operator=(const AssignedNodesOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, AssignedNodesOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastAssignedNodesOptions : public AssignedNodesOptions
{
  inline FastAssignedNodesOptions()
    : AssignedNodesOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ElementOrText : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eElement,
    eText
  };
public:
  enum class Type
  {
    eElement = TypeOrUninit::eElement,
    eText = TypeOrUninit::eText
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Element> > mElement;
    UnionMember<NonNull<mozilla::dom::Text> > mText;

  };

  TypeOrUninit mType;
  Value mValue;

  ElementOrText(const ElementOrText&) = delete;
  ElementOrText& operator=(const ElementOrText&) = delete;
public:
  explicit inline ElementOrText()
    : mType(eUninitialized)
  {
  }

  inline ~ElementOrText()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Text>&
  RawSetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eText;
    return mValue.mText.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Text>&
  SetAsText()
  {
    if (mType == eText) {
      return mValue.mText.Value();
    }
    Uninit();
    mType = eText;
    return mValue.mText.SetValue();
  }

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline NonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline mozilla::dom::Text&
  GetAsText() const
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
      case eText: {
        DestroyText();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToText(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToText(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyText()
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    mValue.mText.Destroy();
    mType = eUninitialized;
  }
};


class OwningElementOrText : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningElementOrText& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eElement,
    eText
  };
public:
  enum class Type
  {
    eElement = TypeOrUninit::eElement,
    eText = TypeOrUninit::eText
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;
    UnionMember<OwningNonNull<mozilla::dom::Text> > mText;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningElementOrText()
    : mType(eUninitialized)
  {
  }

  OwningElementOrText(OwningElementOrText&& aOther);

  explicit inline OwningElementOrText(const OwningElementOrText& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningElementOrText()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Text>&
  RawSetAsText();

  [[nodiscard]] OwningNonNull<mozilla::dom::Text>&
  SetAsText();

  inline bool
  IsText() const
  {
    return mType == eText;
  }

  inline OwningNonNull<mozilla::dom::Text>&
  GetAsText()
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  inline OwningNonNull<mozilla::dom::Text> const &
  GetAsText() const
  {
    MOZ_RELEASE_ASSERT(IsText(), "Wrong type!");
    return mValue.mText.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningElementOrText&
  operator=(OwningElementOrText&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningElementOrText&
  operator=(const OwningElementOrText& aOther);

private:
  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElement();

  bool
  TrySetToText(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToText(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyText();
};


namespace HTMLSlotElement_Binding {

  typedef mozilla::dom::HTMLSlotElement NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLSlotElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLSlotElement,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace HTMLSlotElement_Binding



} // namespace mozilla::dom

#endif // DOM_HTMLSLOTELEMENTBINDING_H_
