// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mozilla/glean/bindings/GleanJSPingsLookup.h"

#include "mozilla/PerfectHash.h"
#include "nsString.h"

#include "mozilla/PerfectHash.h"

#define GLEAN_PING_INDEX_BITS (16)
#define GLEAN_PING_ID(entry) ((entry) >> GLEAN_PING_INDEX_BITS)
#define GLEAN_PING_INDEX(entry) ((entry) & ((1UL << GLEAN_PING_INDEX_BITS) - 1))

namespace mozilla::glean {

// Contains the ping id and the index into the ping string table.
using ping_entry_t = uint32_t;

Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry);

#if defined(_MSC_VER) && !defined(__clang__)
const char gPingStringTable[] = {
#else
constexpr char gPingStringTable[] = {
#endif
  /*     0 - "messagingSystem" */ 'm', 'e', 's', 's', 'a', 'g', 'i', 'n', 'g', 'S', 'y', 's', 't', 'e', 'm', '\0',
  /*    16 - "newtab" */ 'n', 'e', 'w', 't', 'a', 'b', '\0',
  /*    23 - "newtabContent" */ 'n', 'e', 'w', 't', 'a', 'b', 'C', 'o', 'n', 't', 'e', 'n', 't', '\0',
  /*    37 - "spoc" */ 's', 'p', 'o', 'c', '\0',
  /*    42 - "topSites" */ 't', 'o', 'p', 'S', 'i', 't', 'e', 's', '\0',
  /*    51 - "profiles" */ 'p', 'r', 'o', 'f', 'i', 'l', 'e', 's', '\0',
  /*    60 - "searchWith" */ 's', 'e', 'a', 'r', 'c', 'h', 'W', 'i', 't', 'h', '\0',
  /*    71 - "serpCategorization" */ 's', 'e', 'r', 'p', 'C', 'a', 't', 'e', 'g', 'o', 'r', 'i', 'z', 'a', 't', 'i', 'o', 'n', '\0',
  /*    90 - "quickSuggest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', '\0',
  /*   103 - "quickSuggestDeletionRequest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   131 - "urlbarKeywordExposure" */ 'u', 'r', 'l', 'b', 'a', 'r', 'K', 'e', 'y', 'w', 'o', 'r', 'd', 'E', 'x', 'p', 'o', 's', 'u', 'r', 'e', '\0',
  /*   153 - "dataLeakBlocker" */ 'd', 'a', 't', 'a', 'L', 'e', 'a', 'k', 'B', 'l', 'o', 'c', 'k', 'e', 'r', '\0',
  /*   169 - "contextIdDeletionRequest" */ 'c', 'o', 'n', 't', 'e', 'x', 't', 'I', 'd', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   194 - "prototypeNoCodeEvents" */ 'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e', 'N', 'o', 'C', 'o', 'd', 'e', 'E', 'v', 'e', 'n', 't', 's', '\0',
  /*   216 - "pageload" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', '\0',
  /*   225 - "pageloadBaseDomain" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', 'B', 'a', 's', 'e', 'D', 'o', 'm', 'a', 'i', 'n', '\0',
  /*   244 - "useCounters" */ 'u', 's', 'e', 'C', 'o', 'u', 'n', 't', 'e', 'r', 's', '\0',
  /*   256 - "unexpectedScriptLoad" */ 'u', 'n', 'e', 'x', 'p', 'e', 'c', 't', 'e', 'd', 'S', 'c', 'r', 'i', 'p', 't', 'L', 'o', 'a', 'd', '\0',
  /*   277 - "fxAccounts" */ 'f', 'x', 'A', 'c', 'c', 'o', 'u', 'n', 't', 's', '\0',
  /*   288 - "sync" */ 's', 'y', 'n', 'c', '\0',
  /*   293 - "bounceTrackingProtection" */ 'b', 'o', 'u', 'n', 'c', 'e', 'T', 'r', 'a', 'c', 'k', 'i', 'n', 'g', 'P', 'r', 'o', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   318 - "hangReport" */ 'h', 'a', 'n', 'g', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   329 - "backgroundTasks" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'T', 'a', 's', 'k', 's', '\0',
  /*   345 - "captchaDetection" */ 'c', 'a', 'p', 't', 'c', 'h', 'a', 'D', 'e', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   362 - "crash" */ 'c', 'r', 'a', 's', 'h', '\0',
  /*   368 - "geckoTrace" */ 'g', 'e', 'c', 'k', 'o', 'T', 'r', 'a', 'c', 'e', '\0',
  /*   379 - "dauReporting" */ 'd', 'a', 'u', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   392 - "tempFogInitialState" */ 't', 'e', 'm', 'p', 'F', 'o', 'g', 'I', 'n', 'i', 't', 'i', 'a', 'l', 'S', 't', 'a', 't', 'e', '\0',
  /*   412 - "collectionDisabledPing" */ 'c', 'o', 'l', 'l', 'e', 'c', 't', 'i', 'o', 'n', 'D', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   435 - "disabledPing" */ 'd', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   448 - "onePingOnly" */ 'o', 'n', 'e', 'P', 'i', 'n', 'g', 'O', 'n', 'l', 'y', '\0',
  /*   460 - "rideAlongPing" */ 'r', 'i', 'd', 'e', 'A', 'l', 'o', 'n', 'g', 'P', 'i', 'n', 'g', '\0',
  /*   474 - "testOhttpPing" */ 't', 'e', 's', 't', 'O', 'h', 't', 't', 'p', 'P', 'i', 'n', 'g', '\0',
  /*   488 - "testPing" */ 't', 'e', 's', 't', 'P', 'i', 'n', 'g', '\0',
  /*   497 - "heartbeat" */ 'h', 'e', 'a', 'r', 't', 'b', 'e', 'a', 't', '\0',
  /*   507 - "nimbusTargetingContext" */ 'n', 'i', 'm', 'b', 'u', 's', 'T', 'a', 'r', 'g', 'e', 't', 'i', 'n', 'g', 'C', 'o', 'n', 't', 'e', 'x', 't', '\0',
  /*   530 - "brokenSiteReport" */ 'b', 'r', 'o', 'k', 'e', 'n', 'S', 'i', 't', 'e', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   547 - "userCharacteristics" */ 'u', 's', 'e', 'r', 'C', 'h', 'a', 'r', 'a', 'c', 't', 'e', 'r', 'i', 's', 't', 'i', 'c', 's', '\0',
  /*   567 - "onboardingOptOut" */ 'o', 'n', 'b', 'o', 'a', 'r', 'd', 'i', 'n', 'g', 'O', 'p', 't', 'O', 'u', 't', '\0',
  /*   584 - "thirdPartyModules" */ 't', 'h', 'i', 'r', 'd', 'P', 'a', 'r', 't', 'y', 'M', 'o', 'd', 'u', 'l', 'e', 's', '\0',
  /*   602 - "usageDeletionRequest" */ 'u', 's', 'a', 'g', 'e', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   623 - "usageReporting" */ 'u', 's', 'a', 'g', 'e', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   638 - "firstStartup" */ 'f', 'i', 'r', 's', 't', 'S', 't', 'a', 'r', 't', 'u', 'p', '\0',
  /*   651 - "defaultAgent" */ 'd', 'e', 'f', 'a', 'u', 'l', 't', 'A', 'g', 'e', 'n', 't', '\0',
  /*   664 - "backgroundUpdate" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'U', 'p', 'd', 'a', 't', 'e', '\0',
  /*   681 - "update" */ 'u', 'p', 'd', 'a', 't', 'e', '\0',
};



const ping_entry_t sPingByNameLookupEntries[] = {
  983256,
  3015337,
  852137,
  1900956,
  2490915,
  786585,
  262181,
  655463,
  1311008,
  2294257,
  1179904,
  458812,
  2097612,
  1114356,
  1638762,
  2884235,
  393267,
  2425362,
  1442110,
  2687578,
  131088,
  2228712,
  1704304,
  1245461,
  2163162,
  2556471,
  1507657,
  2753135,
  1835400,
  2622024,
  524359,
  1769851,
  2032064,
  2359803,
  1966515,
  327722,
  917698,
  589914,
  65536,
  196631,
  2949784,
  1048801,
  1376549,
  721027,
  2818686,
  1573209
};



Maybe<uint32_t>
PingByNameLookup(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   4,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,
       0,   1,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   8,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  11,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
      11,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  19,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   1,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  21,   0,   0,   0,
       0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             sPingByNameLookupEntries);
  return ping_result_check(aKey, entry);
}


/**
 * Get a ping's name given its entry from the PHF.
 */
const char* GetPingName(ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  MOZ_ASSERT(idx < sizeof(gPingStringTable), "Ping index larger than string table");
  return &gPingStringTable[idx];
}

/**
 * Check if the found entry is pointing at the correct ping.
 * PHF can false-positive a result when the key isn't present, so we check
 * for a string match. If it fails, return Nothing(). If we found it,
 * return the ping's id.
 */
Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  uint32_t id = GLEAN_PING_ID(aEntry);

  if (MOZ_UNLIKELY(idx > sizeof(gPingStringTable))) {
    return Nothing();
  }

  if (aKey.EqualsASCII(&gPingStringTable[idx])) {
    return Some(id);
  }

  return Nothing();
}

#undef GLEAN_PING_INDEX_BITS
#undef GLEAN_PING_ID
#undef GLEAN_PING_INDEX

}  // namespace mozilla::glean
