/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.glsl.fixedfunc;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.ValueConv;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.fixedfunc.GLLightingFunc;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.fixedfunc.GLPointerFunc;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import jogamp.opengl.util.glsl.fixedfunc.FixedFuncPipeline;

public class FixedFuncHook
implements GLLightingFunc,
GLMatrixFunc,
GLPointerFunc {
    public static final int MAX_TEXTURE_UNITS = 8;
    protected final GLProfile gl2es1GLProfile;
    protected FixedFuncPipeline fixedFunction;
    protected PMVMatrix pmvMatrix;
    protected boolean ownsPMVMatrix;
    protected GL2ES2 gl;

    public FixedFuncHook(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix) {
        this.gl2es1GLProfile = GLProfile.createCustomGLProfile("GL2ES1", gL2ES2.getGLProfile().getImpl());
        this.gl = gL2ES2;
        if (null != pMVMatrix) {
            this.ownsPMVMatrix = false;
            this.pmvMatrix = pMVMatrix;
        } else {
            this.ownsPMVMatrix = true;
            this.pmvMatrix = new PMVMatrix(6);
        }
        this.fixedFunction = new FixedFuncPipeline(this.gl, shaderSelectionMode, this.pmvMatrix);
    }

    public FixedFuncHook(GL2ES2 gL2ES2, ShaderSelectionMode shaderSelectionMode, PMVMatrix pMVMatrix, Class<?> clazz, String string, String string2, String string3, String string4, String string5, String string6) {
        this.gl2es1GLProfile = GLProfile.createCustomGLProfile("GL2ES1", gL2ES2.getGLProfile().getImpl());
        this.gl = gL2ES2;
        if (null != pMVMatrix) {
            this.ownsPMVMatrix = false;
            this.pmvMatrix = pMVMatrix;
        } else {
            this.ownsPMVMatrix = true;
            this.pmvMatrix = new PMVMatrix(6);
        }
        this.fixedFunction = new FixedFuncPipeline(this.gl, shaderSelectionMode, this.pmvMatrix, clazz, string, string2, string3, string4, string5, string6);
    }

    public boolean verbose() {
        return this.fixedFunction.verbose();
    }

    public void setVerbose(boolean bl) {
        this.fixedFunction.setVerbose(bl);
    }

    public void destroy() {
        this.fixedFunction.destroy(this.gl);
        this.fixedFunction = null;
        this.pmvMatrix = null;
        this.gl = null;
    }

    public PMVMatrix getMatrix() {
        return this.pmvMatrix;
    }

    public final boolean isGL4core() {
        return false;
    }

    public final boolean isGL3core() {
        return false;
    }

    public final boolean isGLcore() {
        return false;
    }

    public final boolean isGLES2Compatible() {
        return false;
    }

    public final boolean isGLES3Compatible() {
        return false;
    }

    public final GLProfile getGLProfile() {
        return this.gl2es1GLProfile;
    }

    public void glDrawArrays(int n, int n2, int n3) {
        this.fixedFunction.glDrawArrays(this.gl, n, n2, n3);
    }

    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        this.fixedFunction.glDrawElements(this.gl, n, n2, n3, buffer);
    }

    public void glDrawElements(int n, int n2, int n3, long l) {
        this.fixedFunction.glDrawElements(this.gl, n, n2, n3, l);
    }

    public void glActiveTexture(int n) {
        this.fixedFunction.glActiveTexture(n);
        this.gl.glActiveTexture(n);
    }

    public void glEnable(int n) {
        if (this.fixedFunction.glEnable(n, true)) {
            this.gl.glEnable(n);
        }
    }

    public void glDisable(int n) {
        if (this.fixedFunction.glEnable(n, false)) {
            this.gl.glDisable(n);
        }
    }

    @Override
    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        if (PMVMatrix.isMatrixGetName(n)) {
            this.pmvMatrix.glGetFloatv(n, floatBuffer);
            return;
        }
        this.gl.glGetFloatv(n, floatBuffer);
    }

    @Override
    public void glGetFloatv(int n, float[] fArray, int n2) {
        if (PMVMatrix.isMatrixGetName(n)) {
            this.pmvMatrix.glGetFloatv(n, fArray, n2);
            return;
        }
        this.gl.glGetFloatv(n, fArray, n2);
    }

    @Override
    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        if (PMVMatrix.isMatrixGetName(n)) {
            this.pmvMatrix.glGetIntegerv(n, intBuffer);
            return;
        }
        this.gl.glGetIntegerv(n, intBuffer);
    }

    @Override
    public void glGetIntegerv(int n, int[] nArray, int n2) {
        if (PMVMatrix.isMatrixGetName(n)) {
            this.pmvMatrix.glGetIntegerv(n, nArray, n2);
            return;
        }
        this.gl.glGetIntegerv(n, nArray, n2);
    }

    public void glTexEnvi(int n, int n2, int n3) {
        this.fixedFunction.glTexEnvi(n, n2, n3);
    }

    public void glGetTexEnviv(int n, int n2, IntBuffer intBuffer) {
        this.fixedFunction.glGetTexEnviv(n, n2, intBuffer);
    }

    public void glGetTexEnviv(int n, int n2, int[] nArray, int n3) {
        this.fixedFunction.glGetTexEnviv(n, n2, nArray, n3);
    }

    public void glBindTexture(int n, int n2) {
        this.fixedFunction.glBindTexture(n, n2);
        this.gl.glBindTexture(n, n2);
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        switch (n3) {
            case 3: {
                n3 = 6408 == n7 ? 6408 : 6407;
                break;
            }
            case 4: {
                n3 = 6407 == n7 ? 6407 : 6408;
            }
        }
        this.fixedFunction.glTexImage2D(n, n3, n7);
        this.gl.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
    }

    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        switch (n3) {
            case 3: {
                n3 = 6408 == n7 ? 6408 : 6407;
                break;
            }
            case 4: {
                n3 = 6407 == n7 ? 6407 : 6408;
            }
        }
        this.fixedFunction.glTexImage2D(n, n3, n7);
        this.gl.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, l);
    }

    public void glPointSize(float f) {
        this.fixedFunction.glPointSize(f);
    }

    public void glPointParameterf(int n, float f) {
        this.fixedFunction.glPointParameterf(n, f);
    }

    public void glPointParameterfv(int n, float[] fArray, int n2) {
        this.fixedFunction.glPointParameterfv(n, fArray, n2);
    }

    public void glPointParameterfv(int n, FloatBuffer floatBuffer) {
        this.fixedFunction.glPointParameterfv(n, floatBuffer);
    }

    public int glGetMatrixMode() {
        return this.pmvMatrix.glGetMatrixMode();
    }

    @Override
    public void glMatrixMode(int n) {
        this.pmvMatrix.glMatrixMode(n);
    }

    @Override
    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        this.pmvMatrix.glLoadMatrixf(floatBuffer);
    }

    @Override
    public void glLoadMatrixf(float[] fArray, int n) {
        this.glLoadMatrixf(Buffers.newDirectFloatBuffer((float[])fArray, (int)n));
    }

    @Override
    public void glPopMatrix() {
        this.pmvMatrix.glPopMatrix();
    }

    @Override
    public void glPushMatrix() {
        this.pmvMatrix.glPushMatrix();
    }

    @Override
    public void glLoadIdentity() {
        this.pmvMatrix.glLoadIdentity();
    }

    @Override
    public void glMultMatrixf(FloatBuffer floatBuffer) {
        this.pmvMatrix.glMultMatrixf(floatBuffer);
    }

    @Override
    public void glMultMatrixf(float[] fArray, int n) {
        this.glMultMatrixf(Buffers.newDirectFloatBuffer((float[])fArray, (int)n));
    }

    @Override
    public void glTranslatef(float f, float f2, float f3) {
        this.pmvMatrix.glTranslatef(f, f2, f3);
    }

    @Override
    public void glRotatef(float f, float f2, float f3, float f4) {
        this.pmvMatrix.glRotatef(f, f2, f3, f4);
    }

    @Override
    public void glScalef(float f, float f2, float f3) {
        this.pmvMatrix.glScalef(f, f2, f3);
    }

    public void glOrtho(double d, double d2, double d3, double d4, double d5, double d6) {
        this.glOrthof((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    @Override
    public void glOrthof(float f, float f2, float f3, float f4, float f5, float f6) {
        this.pmvMatrix.glOrthof(f, f2, f3, f4, f5, f6);
    }

    public void glFrustum(double d, double d2, double d3, double d4, double d5, double d6) {
        this.glFrustumf((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    @Override
    public void glFrustumf(float f, float f2, float f3, float f4, float f5, float f6) {
        this.pmvMatrix.glFrustumf(f, f2, f3, f4, f5, f6);
    }

    @Override
    public void glColor4f(float f, float f2, float f3, float f4) {
        this.fixedFunction.glColor4f(this.gl, f, f2, f3, f4);
    }

    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        this.glColor4f(ValueConv.byte_to_float((byte)by, (boolean)false), ValueConv.byte_to_float((byte)by2, (boolean)false), ValueConv.byte_to_float((byte)by3, (boolean)false), ValueConv.byte_to_float((byte)by4, (boolean)false));
    }

    @Override
    public void glLightfv(int n, int n2, FloatBuffer floatBuffer) {
        this.fixedFunction.glLightfv(this.gl, n, n2, floatBuffer);
    }

    @Override
    public void glLightfv(int n, int n2, float[] fArray, int n3) {
        this.glLightfv(n, n2, Buffers.newDirectFloatBuffer((float[])fArray, (int)n3));
    }

    @Override
    public void glMaterialfv(int n, int n2, FloatBuffer floatBuffer) {
        this.fixedFunction.glMaterialfv(this.gl, n, n2, floatBuffer);
    }

    @Override
    public void glMaterialfv(int n, int n2, float[] fArray, int n3) {
        this.glMaterialfv(n, n2, Buffers.newDirectFloatBuffer((float[])fArray, (int)n3));
    }

    @Override
    public void glMaterialf(int n, int n2, float f) {
        this.glMaterialfv(n, n2, Buffers.newDirectFloatBuffer((float[])new float[]{f}));
    }

    @Override
    public void glShadeModel(int n) {
        this.fixedFunction.glShadeModel(this.gl, n);
    }

    public void glAlphaFunc(int n, float f) {
        this.fixedFunction.glAlphaFunc(n, f);
    }

    public void glClientActiveTexture(int n) {
        this.fixedFunction.glClientActiveTexture(n);
    }

    @Override
    public void glEnableClientState(int n) {
        this.fixedFunction.glEnableClientState(this.gl, n);
    }

    @Override
    public void glDisableClientState(int n) {
        this.fixedFunction.glDisableClientState(this.gl, n);
    }

    @Override
    public void glVertexPointer(GLArrayData gLArrayData) {
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck((Buffer)gLArrayData.getBuffer(), (int)1);
            if (!Buffers.isDirect((Object)gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glVertexPointer(this.gl, gLArrayData);
    }

    @Override
    public void glVertexPointer(int n, int n2, int n3, Buffer buffer) {
        this.glVertexPointer(GLArrayDataWrapper.createFixed(32884, n, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glVertexPointer(int n, int n2, int n3, long l) {
        int n4 = this.gl.getBoundBuffer(34962);
        if (n4 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glVertexPointer(GLArrayDataWrapper.createFixed(32884, n, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, null, n4, l, 35044, 34962));
    }

    @Override
    public void glColorPointer(GLArrayData gLArrayData) {
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck((Buffer)gLArrayData.getBuffer(), (int)1);
            if (!Buffers.isDirect((Object)gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glColorPointer(this.gl, gLArrayData);
    }

    @Override
    public void glColorPointer(int n, int n2, int n3, Buffer buffer) {
        this.glColorPointer(GLArrayDataWrapper.createFixed(32886, n, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glColorPointer(int n, int n2, int n3, long l) {
        int n4 = this.gl.getBoundBuffer(34962);
        if (n4 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glColorPointer(GLArrayDataWrapper.createFixed(32886, n, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, null, n4, l, 35044, 34962));
    }

    @Override
    public void glNormalPointer(GLArrayData gLArrayData) {
        if (gLArrayData.getCompsPerElem() != 3) {
            throw new GLException("Only 3 components per normal allowed");
        }
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck((Buffer)gLArrayData.getBuffer(), (int)1);
            if (!Buffers.isDirect((Object)gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glNormalPointer(this.gl, gLArrayData);
    }

    @Override
    public void glNormalPointer(int n, int n2, Buffer buffer) {
        this.glNormalPointer(GLArrayDataWrapper.createFixed(32885, 3, n, GLBuffers.isGLTypeFixedPoint(n), n2, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glNormalPointer(int n, int n2, long l) {
        int n3 = this.gl.getBoundBuffer(34962);
        if (n3 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glNormalPointer(GLArrayDataWrapper.createFixed(32885, 3, n, GLBuffers.isGLTypeFixedPoint(n), n2, null, n3, l, 35044, 34962));
    }

    @Override
    public void glTexCoordPointer(GLArrayData gLArrayData) {
        if (gLArrayData.isVBO()) {
            if (!this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not enabled: " + gLArrayData);
            }
        } else {
            if (this.gl.isVBOArrayBound()) {
                throw new GLException("VBO array is not disabled: " + gLArrayData);
            }
            Buffers.rangeCheck((Buffer)gLArrayData.getBuffer(), (int)1);
            if (!Buffers.isDirect((Object)gLArrayData.getBuffer())) {
                throw new GLException("Argument \"pointer\" was not a direct buffer");
            }
        }
        this.fixedFunction.glTexCoordPointer(this.gl, gLArrayData);
    }

    @Override
    public void glTexCoordPointer(int n, int n2, int n3, Buffer buffer) {
        this.glTexCoordPointer(GLArrayDataWrapper.createFixed(32888, n, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, buffer, 0, 0L, 0, 34962));
    }

    @Override
    public void glTexCoordPointer(int n, int n2, int n3, long l) {
        int n4 = this.gl.getBoundBuffer(34962);
        if (n4 == 0) {
            throw new GLException("no GL_ARRAY_BUFFER VBO bound");
        }
        this.glTexCoordPointer(GLArrayDataWrapper.createFixed(32888, n, n2, GLBuffers.isGLTypeFixedPoint(n2), n3, null, n4, l, 35044, 34962));
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName() + " (");
        if (null != this.pmvMatrix) {
            stringBuilder.append(", matrixDirty: " + (0 != this.pmvMatrix.getModifiedBits(false)));
        }
        stringBuilder.append("\n\t, FixedFunction: " + this.fixedFunction);
        stringBuilder.append(this.gl);
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }
}

