/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.Parser;

public class DateFormatParser
extends Parser {
    private final SimpleDateFormat parser;
    private final String missingFields;
    private boolean forbidLeadingSpaces;

    public DateFormatParser(String format, String type) {
        super("date", type, format);
        this.forbidLeadingSpaces = format.charAt(0) != ' ';
        this.parser = new SimpleDateFormat(format.replaceFirst("^\\s", ""));
        this.parser.setLenient(false);
        this.missingFields = (format.contains("y") ? "" : "y") + (format.contains("M") ? "" : "M") + (format.contains("d") ? "" : "d");
    }

    public DateFormatParser(String format) {
        this(format, DateFormatParser.getTypeDependingOnFormat(format));
    }

    private static String getTypeDependingOnFormat(String format) {
        return format.contains("m") ? "datetime" : "date";
    }

    @Override
    Object parse(String string) {
        if (string == null || this.forbidLeadingSpaces && string.charAt(0) == ' ') {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parser.parse(string, parsePosition);
        if (parsePosition.getIndex() != string.length()) {
            return null;
        }
        if (this.missingFields.length() != 0) {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            calendar.setTime(date);
            if (this.missingFields.contains("y")) {
                calendar.set(1, year);
            }
            if (this.missingFields.contains("M")) {
                calendar.set(2, month);
            }
            if (this.missingFields.contains("d")) {
                calendar.set(5, day);
            }
            date = calendar.getTime();
        }
        return FormattedDate.createDefaultFormattedDate(date.getTime(), this.getType());
    }
}

