/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.openide.util.WeakSet;
import org.openide.util.io.SafeException;

public class NbObjectOutputStream
extends ObjectOutputStream {
    private static final String SVUID = "serialVersionUID";
    private static final Set<String> alreadyReported = new WeakSet<String>();
    private static Map<String, Boolean> examinedClasses;
    private final List<Class> serializing = new ArrayList<Class>(50);

    public NbObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException securityException) {
            throw (IOException)new IOException(securityException.toString()).initCause(securityException);
        }
    }

    @Override
    public Object replaceObject(Object object) throws IOException {
        if (object instanceof Image) {
            return null;
        }
        return super.replaceObject(object);
    }

    public static void writeSafely(ObjectOutput objectOutput, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(byteArrayOutputStream);
            nbObjectOutputStream.writeObject(object);
            nbObjectOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            objectOutput.writeInt(0);
            throw new SafeException(exception);
        }
        objectOutput.writeInt(byteArrayOutputStream.size());
        objectOutput.write(byteArrayOutputStream.toByteArray());
    }

    protected void annotateClass(Class clazz) throws IOException {
        super.annotateClass(clazz);
        if (clazz.isArray()) {
            return;
        }
        if (clazz.isInterface()) {
            return;
        }
        this.serializing.add(clazz);
        if (NbObjectOutputStream.isSerialVersionUIDDeclared(clazz)) {
            return;
        }
        if (IOException.class.isAssignableFrom(clazz)) {
            return;
        }
        String string = clazz.getName();
        if (alreadyReported.add(string)) {
            Object object;
            HashSet<Object> hashSet = new HashSet<Object>();
            StringBuffer stringBuffer = new StringBuffer("Serializable class ");
            stringBuffer.append(string);
            stringBuffer.append(" does not declare serialVersionUID field. Encountered while storing: [");
            Iterator<Class> iterator = this.serializing.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == clazz || !hashSet.add(object)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Class)object).getName());
            }
            stringBuffer.append("] See also http://www.netbeans.org/issues/show_bug.cgi?id=19915");
            object = System.getProperty("InstanceDataObject.current.file");
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(" [may have been writing ");
                stringBuffer.append((String)object);
                stringBuffer.append("]");
            }
            Logger.getLogger(NbObjectOutputStream.class.getName()).warning(stringBuffer.toString());
        }
    }

    static boolean isSerialVersionUIDDeclared(Class clazz) {
        String string = clazz.getName();
        Boolean bl = examinedClasses.get(string);
        if (bl == null) {
            if (string.equals("java.util.HashSet") || string.equals("java.util.ArrayList") || clazz.isEnum() || string.equals("java.lang.Enum")) {
                bl = Boolean.TRUE;
            } else {
                bl = Boolean.FALSE;
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (!fieldArray[i].getName().equals(SVUID)) continue;
                    bl = Boolean.TRUE;
                    break;
                }
            }
            examinedClasses.put(clazz.getName(), bl);
        }
        return bl;
    }

    static {
        alreadyReported.add("java.lang.Exception");
        alreadyReported.add("java.io.IOException");
        alreadyReported.add("java.util.TreeSet");
        alreadyReported.add("java.awt.geom.AffineTransform");
        examinedClasses = new WeakHashMap<String, Boolean>(250);
    }
}

