/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.res.StringManager;

public class SecurityListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(SecurityListener.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.security");
    private static final String UMASK_PROPERTY_NAME = "org.apache.catalina.security.SecurityListener.UMASK";
    private static final String UMASK_FORMAT = "%04o";
    private static final int DEFAULT_BUILD_DATE_WARNING_AGE_DAYS = -1;
    private final Set<String> checkedOsUsers = new HashSet<String>();
    private int buildDateWarningAgeDays = -1;
    private Integer minimumUmask = 7;

    public SecurityListener() {
        this.checkedOsUsers.add("root");
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (lifecycleEvent.getType().equals("before_init")) {
            if (!(lifecycleEvent.getLifecycle() instanceof Server)) {
                log.warn((Object)sm.getString("listener.notServer", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
            }
            this.doChecks();
        }
    }

    public void setCheckedOsUsers(String string) {
        if (string == null || string.length() == 0) {
            this.checkedOsUsers.clear();
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                if (string2.length() <= 0) continue;
                this.checkedOsUsers.add(string2.toLowerCase(Locale.getDefault()));
            }
        }
    }

    public String getCheckedOsUsers() {
        return StringUtils.join(this.checkedOsUsers);
    }

    public void setMinimumUmask(String string) {
        this.minimumUmask = string == null || string.length() == 0 ? Integer.valueOf(0) : Integer.valueOf(string, 8);
    }

    public String getMinimumUmask() {
        return String.format(UMASK_FORMAT, this.minimumUmask);
    }

    public void setBuildDateWarningAgeDays(String string) {
        try {
            this.buildDateWarningAgeDays = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)sm.getString("SecurityListener.buildDateAgeUnreadable", new Object[]{string, String.valueOf(-1)}));
        }
    }

    public int getBuildDateWarningAgeDays() {
        return this.buildDateWarningAgeDays;
    }

    protected void doChecks() {
        this.checkOsUser();
        this.checkUmask();
        this.checkServerBuildAge();
    }

    protected void checkOsUser() {
        String string;
        String string2 = System.getProperty("user.name");
        if (string2 != null && this.checkedOsUsers.contains(string = string2.toLowerCase(Locale.getDefault()))) {
            throw new Error(sm.getString("SecurityListener.checkUserWarning", new Object[]{string2}));
        }
    }

    protected void checkUmask() {
        String string = System.getProperty(UMASK_PROPERTY_NAME);
        Integer n = null;
        if (string != null) {
            try {
                n = Integer.valueOf(string, 8);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn((Object)sm.getString("SecurityListener.checkUmaskParseFail", new Object[]{string}));
            }
        }
        if (n == null) {
            if ("\r\n".equals(System.lineSeparator())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("SecurityListener.checkUmaskSkip"));
                }
                return;
            }
            if (this.minimumUmask > 0) {
                log.warn((Object)sm.getString("SecurityListener.checkUmaskNone", new Object[]{UMASK_PROPERTY_NAME, this.getMinimumUmask()}));
            }
            return;
        }
        if ((n & this.minimumUmask) != this.minimumUmask) {
            throw new Error(sm.getString("SecurityListener.checkUmaskFail", new Object[]{String.format(UMASK_FORMAT, n), this.getMinimumUmask()}));
        }
    }

    protected void checkServerBuildAge() {
        int n = this.getBuildDateWarningAgeDays();
        if (n >= 0) {
            String string = ServerInfo.getServerBuiltISO();
            if (null == string || string.length() < 1 || !Character.isDigit(string.charAt(0))) {
                log.warn((Object)sm.getString("SecurityListener.buildDateUnreadable", new Object[]{string}));
            } else {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd").parse(string);
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, -n);
                    if (date.before(calendar.getTime())) {
                        log.warn((Object)sm.getString("SecurityListener.buildDateIsOld", new Object[]{String.valueOf(n)}));
                    }
                }
                catch (ParseException parseException) {
                    log.warn((Object)sm.getString("SecurityListener.buildDateUnreadable", new Object[]{string}));
                }
            }
        }
    }
}

