/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.RangesExpression;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.internal.Coerce;
import org.semver4j.internal.Comparator;
import org.semver4j.internal.Differ;
import org.semver4j.internal.Modifier;
import org.semver4j.internal.StrictParser;

public class Semver
implements Comparable<Semver> {
    @NotNull
    public static final Semver ZERO = new Semver("0.0.0");
    @NotNull
    private final String originalVersion;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final @NotNull List<@NotNull String> preRelease;
    @NotNull
    private final @NotNull List<@NotNull String> build;
    @NotNull
    private final String version;

    public Semver(@NotNull String version) {
        this.originalVersion = version.trim();
        StrictParser.Version parsedVersion = new StrictParser().parse(this.originalVersion);
        this.major = parsedVersion.getMajor();
        this.minor = parsedVersion.getMinor();
        this.patch = parsedVersion.getPatch();
        this.preRelease = parsedVersion.getPreRelease();
        this.build = parsedVersion.getBuild();
        String resultVersion = String.format(Locale.ROOT, "%d.%d.%d", this.major, this.minor, this.patch);
        if (!this.preRelease.isEmpty()) {
            resultVersion = resultVersion + "-" + String.join((CharSequence)".", this.preRelease);
        }
        if (!this.build.isEmpty()) {
            resultVersion = resultVersion + "+" + String.join((CharSequence)".", this.build);
        }
        this.version = resultVersion;
    }

    @Nullable
    public static Semver parse(@Nullable String version) {
        if (version == null) {
            return null;
        }
        try {
            return new Semver(version);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Semver coerce(@Nullable String version) {
        Semver semver = Semver.parse(version);
        if (semver != null) {
            return semver;
        }
        String coerce = Coerce.coerce(version);
        return Semver.parse(coerce);
    }

    public static boolean isValid(@Nullable String version) {
        return Semver.parse(version) != null;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @NotNull
    public @NotNull List<@NotNull String> getPreRelease() {
        return this.preRelease;
    }

    @NotNull
    public @NotNull List<@NotNull String> getBuild() {
        return this.build;
    }

    public boolean isStable() {
        return this.major > 0 && this.preRelease.isEmpty();
    }

    @NotNull
    public Semver nextMajor() {
        return new Modifier(this).nextMajor();
    }

    @NotNull
    public Semver withIncMajor() {
        return this.withIncMajor(1);
    }

    @NotNull
    public Semver withIncMajor(int number) {
        return new Modifier(this).withIncMajor(number);
    }

    @NotNull
    public Semver nextMinor() {
        return new Modifier(this).nextMinor();
    }

    @NotNull
    public Semver withIncMinor() {
        return this.withIncMinor(1);
    }

    @NotNull
    public Semver withIncMinor(int number) {
        return new Modifier(this).withIncMinor(number);
    }

    @NotNull
    public Semver nextPatch() {
        return new Modifier(this).nextPatch();
    }

    @NotNull
    public Semver withIncPatch() {
        return this.withIncPatch(1);
    }

    @NotNull
    public Semver withIncPatch(int number) {
        return new Modifier(this).withIncPatch(number);
    }

    @NotNull
    public Semver withPreRelease(@NotNull String preRelease) {
        return new Modifier(this).withPreRelease(preRelease);
    }

    @NotNull
    public Semver withBuild(@NotNull String build) {
        return new Modifier(this).withBuild(build);
    }

    @NotNull
    public Semver withClearedPreRelease() {
        return new Modifier(this).withClearedPreRelease();
    }

    @NotNull
    public Semver withClearedBuild() {
        return new Modifier(this).withClearedBuild();
    }

    @NotNull
    public Semver withClearedPreReleaseAndBuild() {
        return new Modifier(this).withClearedPreReleaseAndBuild();
    }

    @Override
    public int compareTo(@NotNull Semver other) {
        return new Comparator(this).compareTo(other);
    }

    public boolean isApiCompatible(@NotNull String version) {
        return this.diff(version).ordinal() < VersionDiff.MAJOR.ordinal();
    }

    public boolean isApiCompatible(@NotNull Semver version) {
        return this.diff(version).ordinal() < VersionDiff.MAJOR.ordinal();
    }

    public boolean isGreaterThan(@NotNull String version) {
        return this.isGreaterThan(new Semver(version));
    }

    public boolean isGreaterThan(@NotNull Semver version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqualTo(@NotNull String version) {
        return this.isGreaterThanOrEqualTo(new Semver(version));
    }

    public boolean isGreaterThanOrEqualTo(@NotNull Semver version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLowerThan(@NotNull String version) {
        return this.isLowerThan(new Semver(version));
    }

    public boolean isLowerThan(@NotNull Semver version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerThanOrEqualTo(@NotNull String version) {
        return this.isLowerThanOrEqualTo(new Semver(version));
    }

    public boolean isLowerThanOrEqualTo(@NotNull Semver version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isEqualTo(@NotNull String version) {
        return this.isEqualTo(new Semver(version));
    }

    public boolean isEqualTo(@NotNull Semver version) {
        return this.equals(version);
    }

    public boolean isEquivalentTo(@NotNull String version) {
        return this.isEquivalentTo(new Semver(version));
    }

    public boolean isEquivalentTo(@NotNull Semver version) {
        return this.compareTo(version) == 0;
    }

    @NotNull
    public VersionDiff diff(@NotNull String version) {
        return this.diff(new Semver(version));
    }

    @NotNull
    public VersionDiff diff(@NotNull Semver version) {
        return new Differ(this).diff(version);
    }

    public boolean satisfies(@NotNull String range) {
        RangesList rangesList = RangesListFactory.create(range);
        return this.satisfies(rangesList);
    }

    public boolean satisfies(@NotNull RangesExpression rangesExpression) {
        RangesList rangesList = RangesListFactory.create(rangesExpression);
        return this.satisfies(rangesList);
    }

    public boolean satisfies(@NotNull RangesList rangesList) {
        return rangesList.isSatisfiedBy(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Semver semver = (Semver)o;
        return Objects.equals(this.originalVersion, semver.originalVersion);
    }

    public int hashCode() {
        return Objects.hash(this.originalVersion);
    }

    @NotNull
    public String toString() {
        return this.getVersion();
    }

    public static enum VersionDiff {
        NONE,
        BUILD,
        PRE_RELEASE,
        PATCH,
        MINOR,
        MAJOR;

    }
}

