/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class WeightedSumMetric
extends Metric {
    public static final String FUNC = "wsum";
    private String valueCol;
    private String countCol;
    private List<Part> parts;

    public WeightedSumMetric(String valueCol, String countCol) {
        this.init(valueCol, countCol, false);
    }

    public WeightedSumMetric(String valueCol, String countCol, boolean outputLong) {
        this.init(valueCol, countCol, outputLong);
    }

    public WeightedSumMetric(StreamExpression expression, StreamFactory factory) throws IOException {
        String functionName = expression.getFunctionName();
        if (!FUNC.equals(functionName)) {
            throw new IOException("Expected 'wsum' function but found " + functionName);
        }
        String valueCol = factory.getValueOperand(expression, 0);
        String countCol = factory.getValueOperand(expression, 1);
        String outputLong = factory.getValueOperand(expression, 2);
        if (null == valueCol) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expected %s(valueCol,countCol)", expression, FUNC));
        }
        boolean ol = false;
        if (outputLong != null) {
            ol = Boolean.parseBoolean(outputLong);
        }
        this.init(valueCol, countCol, ol);
    }

    private void init(String valueCol, String countCol, boolean outputLong) {
        this.valueCol = valueCol;
        this.countCol = countCol != null ? countCol : "count(*)";
        this.outputLong = outputLong;
        this.setFunctionName(FUNC);
        this.setIdentifier(FUNC, "(", valueCol, ", " + countCol + ", " + outputLong + ")");
    }

    @Override
    public void update(Tuple tuple) {
        Object c = tuple.get(this.countCol);
        Object o = tuple.get(this.valueCol);
        if (c instanceof Number && o instanceof Number) {
            if (this.parts == null) {
                this.parts = new ArrayList<Part>();
            }
            Number count = (Number)c;
            Number value = (Number)o;
            this.parts.add(new Part(count.longValue(), value.doubleValue()));
        }
    }

    @Override
    public Metric newInstance() {
        return new WeightedSumMetric(this.valueCol, this.countCol, this.outputLong);
    }

    @Override
    public String[] getColumns() {
        return new String[]{this.valueCol, this.countCol};
    }

    @Override
    public Number getValue() {
        long total = this.sumCounts();
        double wavg = 0.0;
        if (total > 0L) {
            for (Part next : this.parts) {
                wavg += next.weighted(total);
            }
        }
        return this.outputLong ? (double)Math.round(wavg) : wavg;
    }

    private long sumCounts() {
        long total = 0L;
        if (this.parts != null) {
            for (Part next : this.parts) {
                total += next.count;
            }
        }
        return total;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpression(this.getFunctionName()).withParameter(this.valueCol).withParameter(this.countCol).withParameter(Boolean.toString(this.outputLong));
    }

    private static final class Part {
        private final double value;
        private final long count;

        Part(long count, double value) {
            this.count = count;
            this.value = value;
        }

        private double weighted(long total) {
            return (double)this.count / (double)total * this.value;
        }
    }
}

