/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.apache.solr.common.cloud.SecurityAwareZkACLProvider;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.solr.security.hadoop.RequestContinuesRecorderAuthenticationHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class HadoopAuthFilter
extends DelegationTokenAuthenticationFilter {
    static final String DELEGATION_TOKEN_ZK_CLIENT = "solr.kerberos.delegation.token.zk.client";
    private CuratorFramework curatorFramework;

    public void init(FilterConfig conf) throws ServletException {
        if (conf != null && "zookeeper".equals(conf.getInitParameter("signer.secret.provider"))) {
            SolrZkClient zkClient = (SolrZkClient)conf.getServletContext().getAttribute(DELEGATION_TOKEN_ZK_CLIENT);
            try {
                conf.getServletContext().setAttribute("signer.secret.provider.zookeeper.curator.client", (Object)this.getCuratorClient(zkClient));
            }
            catch (InterruptedException | KeeperException e) {
                throw new ServletException(e);
            }
        }
        super.init(conf);
    }

    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain filterChain) throws IOException, ServletException {
        FilterChain filterChainWrapper = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                UserGroupInformation realUserUgi;
                HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
                UserGroupInformation ugi = HttpUserGroupInformation.get();
                if (ugi != null && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY && (realUserUgi = ugi.getRealUser()) != null) {
                    httpRequest.setAttribute("solr.impersonator.user.name", (Object)realUserUgi.getShortUserName());
                }
                filterChain.doFilter(servletRequest, servletResponse);
            }
        };
        super.doFilter(request, response, filterChainWrapper);
    }

    public void destroy() {
        super.destroy();
        if (this.curatorFramework != null) {
            this.curatorFramework.close();
        }
        this.curatorFramework = null;
    }

    protected void initializeAuthHandler(String authHandlerClassName, FilterConfig filterConfig) throws ServletException {
        super.initializeAuthHandler(authHandlerClassName, filterConfig);
        AuthenticationHandler authHandler = this.getAuthenticationHandler();
        super.initializeAuthHandler(RequestContinuesRecorderAuthenticationHandler.class.getName(), filterConfig);
        RequestContinuesRecorderAuthenticationHandler newAuthHandler = (RequestContinuesRecorderAuthenticationHandler)this.getAuthenticationHandler();
        newAuthHandler.setAuthHandler(authHandler);
    }

    protected CuratorFramework getCuratorClient(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        SolrZkToCuratorCredentialsACLs curatorToSolrZk;
        String zkConnectionString;
        String zkNamespace;
        ExponentialBackoffRetry retryPolicy;
        block3: {
            retryPolicy = new ExponentialBackoffRetry(1000, 3);
            if (zkClient == null) {
                throw new IllegalArgumentException("zkClient required");
            }
            String zkHost = zkClient.getZkServerAddress();
            String zkChroot = zkHost.contains("/") ? zkHost.substring(zkHost.indexOf(47)) : "";
            zkNamespace = zkChroot + "/security";
            zkNamespace = zkNamespace.startsWith("/") ? zkNamespace.substring(1) : zkNamespace;
            zkConnectionString = zkHost.contains("/") ? zkHost.substring(0, zkHost.indexOf(47)) : zkHost;
            curatorToSolrZk = new SolrZkToCuratorCredentialsACLs(zkClient);
            int connectionTimeoutMs = 30000;
            try {
                zkClient.makePath("/security", CreateMode.PERSISTENT, true);
            }
            catch (KeeperException ex) {
                if (ex.code() == KeeperException.Code.NODEEXISTS) break block3;
                throw ex;
            }
        }
        this.curatorFramework = CuratorFrameworkFactory.builder().namespace(zkNamespace).connectString(zkConnectionString).retryPolicy((RetryPolicy)retryPolicy).aclProvider(curatorToSolrZk.getACLProvider()).authorization(curatorToSolrZk.getAuthInfos()).sessionTimeoutMs(zkClient.getZkClientTimeout()).connectionTimeoutMs(30000).build();
        this.curatorFramework.start();
        return this.curatorFramework;
    }

    protected static class SolrZkToCuratorCredentialsACLs {
        private final String zkChroot;
        private final ACLProvider aclProvider;
        private final List<AuthInfo> authInfos;

        public SolrZkToCuratorCredentialsACLs(SolrZkClient zkClient) {
            this.aclProvider = this.createACLProvider(zkClient);
            this.authInfos = this.createAuthInfo(zkClient);
            String zkHost = zkClient.getZkServerAddress();
            this.zkChroot = zkHost.contains("/") ? zkHost.substring(zkHost.indexOf(47)) : null;
        }

        public ACLProvider getACLProvider() {
            return this.aclProvider;
        }

        public List<AuthInfo> getAuthInfos() {
            return this.authInfos;
        }

        private ACLProvider createACLProvider(SolrZkClient zkClient) {
            final ZkACLProvider zkACLProvider = zkClient.getZkACLProvider();
            return new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return zkACLProvider.getACLsToAdd(null);
                }

                public List<ACL> getAclForPath(String path) {
                    List acls = null;
                    acls = zkACLProvider instanceof SecurityAwareZkACLProvider && zkChroot != null ? zkACLProvider.getACLsToAdd(path.replace(zkChroot, "")) : zkACLProvider.getACLsToAdd(path);
                    return acls;
                }
            };
        }

        private List<AuthInfo> createAuthInfo(SolrZkClient zkClient) {
            ArrayList<AuthInfo> ret = new ArrayList<AuthInfo>();
            ZkCredentialsProvider credentialsProvider = zkClient.getZkClientConnectionStrategy().getZkCredentialsToAddAutomatically();
            for (ZkCredentialsProvider.ZkCredentials zkCredentials : credentialsProvider.getCredentials()) {
                ret.add(new AuthInfo(zkCredentials.getScheme(), zkCredentials.getAuth()));
            }
            return ret;
        }
    }
}

