/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.HttpClient;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.logging.MDCSnapshot;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.security.AuditEvent;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.servlet.BaseSolrFilter;
import org.apache.solr.servlet.CoordinatorHttpSolrCall;
import org.apache.solr.servlet.CoreContainerProvider;
import org.apache.solr.servlet.ExceptionWhileTracing;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.PathExcluder;
import org.apache.solr.servlet.RateLimitManager;
import org.apache.solr.servlet.ServletUtils;
import org.apache.solr.servlet.SolrAuthenticationException;
import org.apache.solr.servlet.SolrRequestParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDispatchFilter
extends BaseSolrFilter
implements PathExcluder {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ATTR_TRACING_SPAN = Span.class.getName();
    public static final String ATTR_TRACING_TRACER = Tracer.class.getName();
    private CoreContainerProvider.ServiceHolder coreService;
    protected final CountDownLatch init = new CountDownLatch(1);
    protected String abortErrorMessage = null;
    private HttpSolrCallFactory solrCallFactory;
    private List<Pattern> excludePatterns;
    public final boolean isV2Enabled = V2ApiUtils.isEnabled();
    public static final String PROPERTIES_ATTRIBUTE = "solr.properties";
    public static final String SOLRHOME_ATTRIBUTE = "solr.solr.home";
    public static final String SOLR_INSTALL_DIR_ATTRIBUTE = "solr.install.dir";
    public static final String SOLR_DEFAULT_CONFDIR_ATTRIBUTE = "solr.default.confdir";
    public static final String SOLR_LOG_MUTECONSOLE = "solr.log.muteconsole";
    public static final String SOLR_LOG_LEVEL = "solr.log.level";

    @Override
    public void setExcludePatterns(List<Pattern> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public HttpClient getHttpClient() {
        try {
            return this.coreService.getService().getHttpClient();
        }
        catch (UnavailableException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Internal Http Client Unavailable, startup may have failed");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            this.coreService = CoreContainerProvider.serviceForContext(config.getServletContext());
            boolean isCoordinator = "on".equals(this.coreService.getService().getCoreContainer().nodeRoles.getRoleMode(NodeRoles.Role.COORDINATOR));
            HttpSolrCallFactory httpSolrCallFactory = this.solrCallFactory = isCoordinator ? new CoordinatorHttpSolrCall.Factory() : new HttpSolrCallFactory(){};
            if (log.isTraceEnabled()) {
                log.trace("SolrDispatchFilter.init(): {}", (Object)this.getClass().getClassLoader());
            }
            ServletUtils.configExcludes(this, config.getInitParameter("excludePatterns"));
        }
        catch (InterruptedException e) {
            throw new ServletException("Interrupted while fetching core service");
        }
        catch (Throwable t) {
            log.error("Could not start Dispatch Filter.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        finally {
            log.trace("SolrDispatchFilter.init() done");
            this.init.countDown();
        }
    }

    public CoreContainer getCores() throws UnavailableException {
        return this.coreService.getService().getCoreContainer();
    }

    public void destroy() {
    }

    @SuppressForbidden(reason="Set the thread contextClassLoader for all 3rd party dependencies that we cannot control")
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try (MDCSnapshot mdcSnapshot = MDCSnapshot.create();){
            assert (null != mdcSnapshot);
            MDCLoggingContext.reset();
            MDCLoggingContext.setNode(this.getCores());
            Thread.currentThread().setContextClassLoader(this.getCores().getResourceLoader().getClassLoader());
            this.doFilter(request, response, chain, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain, boolean retry) throws IOException, ServletException {
        HttpServletResponse response;
        if (!(_request instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = ServletUtils.closeShield((HttpServletRequest)_request, retry);
        if (ServletUtils.excludedPath(this.excludePatterns, request, response = ServletUtils.closeShield((HttpServletResponse)_response, retry), chain)) {
            return;
        }
        Tracer t = this.getCores() == null ? GlobalTracer.get() : this.getCores().getTracer();
        request.setAttribute(ATTR_TRACING_TRACER, (Object)t);
        RateLimitManager rateLimitManager = this.coreService.getService().getRateLimitManager();
        try {
            ServletUtils.rateLimitRequest(rateLimitManager, request, response, () -> {
                try {
                    this.dispatch(chain, request, response, retry);
                }
                catch (IOException | ServletException | SolrAuthenticationException e) {
                    throw new ExceptionWhileTracing((Exception)e);
                }
            });
        }
        finally {
            ServletUtils.consumeInputFully(request, response);
            SolrRequestInfo.reset();
            SolrRequestParsers.cleanupMultipartFiles(request);
        }
    }

    private static Span getSpan(HttpServletRequest req) {
        return (Span)req.getAttribute(ATTR_TRACING_SPAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatch(FilterChain chain, HttpServletRequest request, HttpServletResponse response, boolean retry) throws IOException, ServletException, SolrAuthenticationException {
        AtomicReference<HttpServletRequest> wrappedRequest = new AtomicReference<HttpServletRequest>();
        this.authenticateRequest(request, response, wrappedRequest);
        if (wrappedRequest.get() != null) {
            request = wrappedRequest.get();
        }
        if (this.getCores().getAuthenticationPlugin() != null) {
            if (log.isDebugEnabled()) {
                log.debug("User principal: {}", (Object)request.getUserPrincipal());
            }
            String principalName = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
            SolrDispatchFilter.getSpan(request).setTag((Tag)Tags.DB_USER, (Object)String.valueOf(principalName));
        }
        HttpSolrCall call = this.getHttpSolrCall(request, response, retry);
        ExecutorUtil.setServerThreadFlag((Boolean)Boolean.TRUE);
        try {
            Action result = call.call();
            switch (result) {
                case PASSTHROUGH: {
                    SolrDispatchFilter.getSpan(request).log("SolrDispatchFilter PASSTHROUGH");
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                case RETRY: {
                    SolrDispatchFilter.getSpan(request).log("SolrDispatchFilter RETRY");
                    this.doFilter((ServletRequest)request, (ServletResponse)response, chain, true);
                    return;
                }
                case FORWARD: {
                    SolrDispatchFilter.getSpan(request).log("SolrDispatchFilter FORWARD");
                    request.getRequestDispatcher(call.getPath()).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            return;
        }
        finally {
            call.destroy();
            ExecutorUtil.setServerThreadFlag(null);
        }
    }

    protected HttpSolrCall getHttpSolrCall(HttpServletRequest request, HttpServletResponse response, boolean retry) {
        CoreContainer cores;
        String path = ServletUtils.getPathAfterContext(request);
        try {
            cores = this.getCores();
        }
        catch (UnavailableException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core Container Unavailable");
        }
        return this.solrCallFactory.createInstance(this, path, cores, request, response, retry);
    }

    private void authenticateRequest(HttpServletRequest request, HttpServletResponse response, AtomicReference<HttpServletRequest> wrappedRequest) throws IOException, SolrAuthenticationException {
        boolean requestContinues;
        CoreContainer cores;
        AtomicBoolean isAuthenticated = new AtomicBoolean(false);
        try {
            cores = this.getCores();
        }
        catch (UnavailableException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core Container Unavailable");
        }
        AuthenticationPlugin authenticationPlugin = cores.getAuthenticationPlugin();
        if (authenticationPlugin == null) {
            if (this.shouldAudit(AuditEvent.EventType.ANONYMOUS)) {
                cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.ANONYMOUS, request));
            }
            return;
        }
        String requestPath = ServletUtils.getPathAfterContext(request);
        if ("/admin/info/key".equals(requestPath)) {
            log.debug("Pass through PKI authentication endpoint");
            return;
        }
        if ("/solr/".equals(requestPath) || "/".equals(requestPath)) {
            log.debug("Pass through Admin UI entry point");
            return;
        }
        String header = request.getHeader("SolrAuth");
        String headerV2 = request.getHeader("SolrAuthV2");
        if ((header != null || headerV2 != null) && cores.getPkiAuthenticationSecurityBuilder() != null) {
            authenticationPlugin = cores.getPkiAuthenticationSecurityBuilder();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Request to authenticate: {}, domain: {}, port: {}", new Object[]{request, request.getLocalName(), request.getLocalPort()});
            }
            requestContinues = authenticationPlugin.authenticate(request, response, (req, rsp) -> {
                isAuthenticated.set(true);
                wrappedRequest.set((HttpServletRequest)req);
            });
        }
        catch (Exception e) {
            log.info("Error authenticating", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during request authentication, ", (Throwable)e);
        }
        if (!requestContinues || !isAuthenticated.get()) {
            response.flushBuffer();
            if (this.shouldAudit(AuditEvent.EventType.REJECTED)) {
                cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.REJECTED, request));
            }
            throw new SolrAuthenticationException();
        }
        if (this.shouldAudit(AuditEvent.EventType.AUTHENTICATED)) {
            cores.getAuditLoggerPlugin().doAudit(new AuditEvent(AuditEvent.EventType.AUTHENTICATED, request));
        }
    }

    private boolean shouldAudit(AuditEvent.EventType eventType) {
        CoreContainer cores;
        try {
            cores = this.getCores();
        }
        catch (UnavailableException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core Container Unavailable");
        }
        return cores.getAuditLoggerPlugin() != null && cores.getAuditLoggerPlugin().shouldLog(eventType);
    }

    @VisibleForTesting
    void replaceRateLimitManager(RateLimitManager rateLimitManager) {
        this.coreService.getService().setRateLimitManager(rateLimitManager);
    }

    public static interface HttpSolrCallFactory {
        default public HttpSolrCall createInstance(SolrDispatchFilter filter, String path, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
            if (filter.isV2Enabled && (path.startsWith("/____v2/") || path.equals("/____v2"))) {
                return new V2HttpCall(filter, cores, request, response, retry);
            }
            return new HttpSolrCall(filter, cores, request, response, retry);
        }
    }

    public static enum Action {
        PASSTHROUGH,
        FORWARD,
        RETURN,
        RETRY,
        ADMIN,
        REMOTEQUERY,
        PROCESS,
        ADMIN_OR_REMOTEQUERY;

    }
}

