/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.payloads.PayloadDecoder;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Cache;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SchemaXmlWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FieldTypePluginLoader;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.similarities.SchemaSimilarityFactory;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.util.ConcurrentLRUCache;
import org.apache.solr.util.PayloadUtils;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSchema {
    public static final String COPY_FIELD = "copyField";
    public static final String COPY_FIELDS = "copyFields";
    public static final String DEFAULT_SCHEMA_FILE = "schema.xml";
    public static final String DESTINATION = "dest";
    public static final String DYNAMIC_FIELD = "dynamicField";
    public static final String DYNAMIC_FIELDS = "dynamicFields";
    public static final String FIELD = "field";
    public static final String FIELDS = "fields";
    public static final String FIELD_TYPE = "fieldType";
    public static final String FIELD_TYPES = "fieldTypes";
    public static final String INTERNAL_POLY_FIELD_PREFIX = "*___";
    public static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    public static final String MAX_CHARS = "maxChars";
    public static final String NAME = "name";
    public static final String NEST_PARENT_FIELD_NAME = "_nest_parent_";
    public static final String NEST_PATH_FIELD_NAME = "_nest_path_";
    public static final String REQUIRED = "required";
    public static final String SCHEMA = "schema";
    public static final String SIMILARITY = "similarity";
    public static final String SOURCE = "source";
    public static final String TYPE = "type";
    public static final String TYPES = "types";
    public static final String ROOT_FIELD_NAME = "_root_";
    public static final String UNIQUE_KEY = "uniqueKey";
    public static final String VERSION = "version";
    private static final String DESTINATION_DYNAMIC_BASE = "destDynamicBase";
    private static final String SOURCE_DYNAMIC_BASE = "sourceDynamicBase";
    private static final String SOURCE_EXPLICIT_FIELDS = "sourceExplicitFields";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String resourceName;
    protected String name;
    protected final Version luceneVersion;
    protected float version;
    protected final SolrResourceLoader loader;
    protected final SolrClassLoader solrClassLoader;
    protected final Properties substitutableProperties;
    protected Map<String, SchemaField> fields = new HashMap<String, SchemaField>();
    protected Map<String, FieldType> fieldTypes = new HashMap<String, FieldType>();
    protected List<SchemaField> fieldsWithDefaultValue = new ArrayList<SchemaField>();
    protected Collection<SchemaField> requiredFields = new HashSet<SchemaField>();
    protected DynamicField[] dynamicFields = new DynamicField[0];
    private static final Set<String> FIELDTYPE_KEYS = Set.of("fieldtype", "fieldType");
    private static final Set<String> FIELD_KEYS = Set.of("dynamicField", "field");
    protected Cache<String, SchemaField> dynamicFieldCache = new ConcurrentLRUCache<String, SchemaField>(10000, 8000, 9000, 100, false, false, null);
    private Analyzer indexAnalyzer;
    private Analyzer queryAnalyzer;
    protected List<SchemaAware> schemaAware = new ArrayList<SchemaAware>();
    protected Map<String, List<CopyField>> copyFieldsMap = new HashMap<String, List<CopyField>>();
    protected DynamicCopy[] dynamicCopyFields = new DynamicCopy[0];
    private Map<FieldType, PayloadDecoder> decoders = new HashMap<FieldType, PayloadDecoder>();
    protected Map<SchemaField, Integer> copyFieldTargetCounts = new HashMap<SchemaField, Integer>();
    private ConfigNode rootNode;
    protected Similarity similarity;
    protected SimilarityFactory similarityFactory;
    protected boolean isExplicitSimilarity = false;
    protected SchemaField uniqueKeyField;
    protected String uniqueKeyFieldName;
    protected FieldType uniqueKeyFieldType;
    public static Map<String, String> nameMapping = Stream.of(SchemaProps.Handler.values()).collect(Collectors.toUnmodifiableMap(SchemaProps.Handler::getNameLower, SchemaProps.Handler::getRealName));

    public DynamicField[] getDynamicFields() {
        return this.dynamicFields;
    }

    public Map<String, List<CopyField>> getCopyFieldsMap() {
        return Collections.unmodifiableMap(this.copyFieldsMap);
    }

    public DynamicCopy[] getDynamicCopyFields() {
        return this.dynamicCopyFields;
    }

    public IndexSchema(String name, ConfigSetService.ConfigResource schemaResource, Version luceneVersion, SolrResourceLoader resourceLoader, Properties substitutableProperties) {
        this(luceneVersion, resourceLoader, substitutableProperties);
        this.resourceName = Objects.requireNonNull(name);
        if (substitutableProperties != null) {
            ConfigNode.SUBSTITUTES.set(substitutableProperties::getProperty);
        }
        try {
            this.readSchema(schemaResource);
            this.loader.inform(this.loader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ConfigNode.SUBSTITUTES.remove();
        }
    }

    protected IndexSchema(Version luceneVersion, SolrResourceLoader loader, Properties substitutableProperties) {
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
        this.loader = loader;
        this.solrClassLoader = loader.getSchemaLoader() == null ? loader : loader.getSchemaLoader();
        this.substitutableProperties = substitutableProperties;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public SolrClassLoader getSolrClassLoader() {
        return this.solrClassLoader;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getSchemaName() {
        return this.name;
    }

    public Version getDefaultLuceneMatchVersion() {
        return this.luceneVersion;
    }

    public float getVersion() {
        return this.version;
    }

    public Map<String, SchemaField> getFields() {
        return this.fields;
    }

    public Map<String, FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SchemaField> getFieldsWithDefaultValue() {
        return this.fieldsWithDefaultValue;
    }

    public Collection<SchemaField> getRequiredFields() {
        return this.requiredFields;
    }

    public Similarity getSimilarity() {
        if (null == this.similarity) {
            this.similarity = this.similarityFactory.getSimilarity();
        }
        return this.similarity;
    }

    public SimilarityFactory getSimilarityFactory() {
        return this.similarityFactory;
    }

    public Analyzer getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public SchemaField getUniqueKeyField() {
        return this.uniqueKeyField;
    }

    public IndexableField getUniqueKeyField(Document doc) {
        return doc.getField(this.uniqueKeyFieldName);
    }

    public String printableUniqueKey(Document doc) {
        IndexableField f = doc.getField(this.uniqueKeyFieldName);
        return f == null ? null : this.uniqueKeyFieldType.toExternal(f);
    }

    public String printableUniqueKey(SolrDocument solrDoc) {
        Object val = solrDoc.getFieldValue(this.uniqueKeyFieldName);
        if (val == null) {
            return null;
        }
        if (val instanceof IndexableField) {
            return this.uniqueKeyFieldType.toExternal((IndexableField)val);
        }
        return val.toString();
    }

    public String printableUniqueKey(SolrInputDocument solrDoc) {
        Object val = solrDoc.getFieldValue(this.uniqueKeyFieldName);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public String printableUniqueKey(BytesRef idBytes) {
        return this.uniqueKeyFieldType.indexedToReadable(idBytes.utf8ToString());
    }

    public BytesRef indexableUniqueKey(String idStr) {
        return new BytesRef((CharSequence)this.uniqueKeyFieldType.toInternal(idStr));
    }

    private SchemaField getIndexedField(String fname) {
        SchemaField f = this.getFields().get(fname);
        if (f == null) {
            throw new RuntimeException("unknown field '" + fname + "'");
        }
        if (!f.indexed()) {
            throw new RuntimeException("'" + fname + "' is not an indexed field:" + f);
        }
        return f;
    }

    public void refreshAnalyzers() {
        this.indexAnalyzer = new SolrIndexAnalyzer();
        this.queryAnalyzer = new SolrQueryAnalyzer();
    }

    public Function<String, UninvertingReader.Type> getUninversionMapper() {
        return name -> {
            SchemaField sf = this.getFieldOrNull((String)name);
            if (sf == null) {
                return null;
            }
            if (sf.isUninvertible()) {
                return sf.getType().getUninversionType(sf);
            }
            return null;
        };
    }

    void persist(Writer writer) throws IOException {
        SolrQueryResponse response = new SolrQueryResponse();
        response.add(SCHEMA, this.getNamedPropertyValues());
        ModifiableSolrParams args = new ModifiableSolrParams().set("indent", new String[]{"on"});
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(null, (SolrParams)args);
        SchemaXmlWriter schemaXmlWriter = new SchemaXmlWriter(writer, req, response);
        schemaXmlWriter.setEmitManagedSchemaDoNotEditWarning(true);
        schemaXmlWriter.writeResponse();
        schemaXmlWriter.close();
    }

    public boolean isMutable() {
        return false;
    }

    protected void readSchema(ConfigSetService.ConfigResource is) {
        assert (null != is) : "schema InputSource should never be null";
        try {
            ConfigNode node;
            this.rootNode = is.get();
            this.name = (String)this.rootNode.attributes().get(NAME);
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                sb.append("schema has no name!");
                log.warn("{}", (Object)sb);
            } else {
                sb.append("Schema ");
                sb.append(NAME);
                sb.append("=");
                sb.append(this.name);
                log.info("{}", (Object)sb);
            }
            this.version = Float.parseFloat((String)this.rootNode.attributes().get(VERSION, (Object)"1.0f"));
            FieldTypePluginLoader typeLoader = new FieldTypePluginLoader(this, this.fieldTypes, this.schemaAware);
            List fTypes = this.rootNode.getAll(null, FIELDTYPE_KEYS);
            ConfigNode types = this.rootNode.child(TYPES);
            if (types != null) {
                fTypes.addAll(types.getAll(null, FIELDTYPE_KEYS));
            }
            typeLoader.load(this.solrClassLoader, fTypes);
            Map<String, Boolean> explicitRequiredProp = this.loadFields(this.rootNode);
            this.similarityFactory = IndexSchema.readSimilarity(this.solrClassLoader, this.rootNode.child(SIMILARITY));
            if (this.similarityFactory == null) {
                Class<SchemaSimilarityFactory> simClass = SchemaSimilarityFactory.class;
                this.similarityFactory = (SimilarityFactory)this.solrClassLoader.newInstance(simClass.getName(), SimilarityFactory.class, new String[0]);
                this.similarityFactory.init((SolrParams)new ModifiableSolrParams());
            } else {
                this.isExplicitSimilarity = true;
            }
            if (!(this.similarityFactory instanceof SolrCoreAware)) {
                for (FieldType ft : this.fieldTypes.values()) {
                    if (null == ft.getSimilarity()) continue;
                    String msg = "FieldType '" + ft.getTypeName() + "' is configured with a similarity, but the global similarity does not support it: " + this.similarityFactory.getClass();
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
            }
            if ((node = this.rootNode.child("defaultSearchField")) != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Setting defaultSearchField in schema not supported since Solr 7");
            }
            node = this.rootNode.child(it -> it.attributes().get("defaultOperator") != null, "solrQueryParser");
            if (node != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Setting default operator in schema (solrQueryParser/@defaultOperator) not supported");
            }
            node = this.rootNode.child(UNIQUE_KEY);
            if (node == null) {
                log.warn("no {} specified in schema.", (Object)UNIQUE_KEY);
            } else {
                String msg;
                this.uniqueKeyField = this.getIndexedField(node.txt().trim());
                this.uniqueKeyFieldName = this.uniqueKeyField.getName();
                this.uniqueKeyFieldType = this.uniqueKeyField.getType();
                if (this.fields.containsKey(ROOT_FIELD_NAME) && !this.isUsableForChildDocs()) {
                    msg = "_root_ field must be defined using the exact same fieldType as the uniqueKey field (" + this.uniqueKeyFieldName + ") uses: " + this.uniqueKeyFieldType.getTypeName();
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (null != this.uniqueKeyField.getDefaultValue()) {
                    msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be configured with a default value (" + this.uniqueKeyField.getDefaultValue() + ")";
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (!this.uniqueKeyField.stored()) {
                    log.warn("{} is not stored - distributed search and MoreLikeThis will not work", (Object)UNIQUE_KEY);
                }
                if (this.uniqueKeyField.multiValued()) {
                    msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be configured to be multivalued";
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (this.uniqueKeyField.getType().isPointField()) {
                    msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be configured to use a Points based FieldType: " + this.uniqueKeyField.getType().getTypeName();
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                if (!Boolean.FALSE.equals(explicitRequiredProp.get(this.uniqueKeyFieldName))) {
                    this.uniqueKeyField.required = true;
                    this.requiredFields.add(this.uniqueKeyField);
                }
            }
            this.dynamicCopyFields = new DynamicCopy[0];
            this.loadCopyFields(this.rootNode);
            this.postReadInform();
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)e.code()), "Can't load schema " + this.loader.resourceLocation(this.resourceName) + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't load schema " + this.loader.resourceLocation(this.resourceName) + ": " + e.getMessage(), (Throwable)e);
        }
        this.refreshAnalyzers();
        log.info("Loaded schema {}/{} with uniqueid field {}", new Object[]{this.name, Float.valueOf(this.version), this.uniqueKeyFieldName});
    }

    protected void postReadInform() {
        for (SchemaAware aware : this.schemaAware) {
            aware.inform(this);
        }
    }

    protected synchronized Map<String, Boolean> loadFields(ConfigNode n) {
        HashMap<String, Boolean> explicitRequiredProp = new HashMap<String, Boolean>();
        ArrayList<DynamicField> dFields = new ArrayList<DynamicField>();
        ArrayList nodes = n.getAll(null, FIELD_KEYS);
        ConfigNode child = n.child(FIELDS);
        if (child != null) {
            nodes = new ArrayList(nodes);
            nodes.addAll(child.getAll(null, FIELD_KEYS));
        }
        for (ConfigNode node : nodes) {
            String name = DOMUtil.getAttr((ConfigNode)node, (String)NAME, (String)"field definition");
            log.trace("reading field def {}", (Object)name);
            String type = DOMUtil.getAttr((ConfigNode)node, (String)TYPE, (String)("field " + name));
            FieldType ft = this.fieldTypes.get(type);
            if (ft == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fieldType '" + type + "' specified on field " + name);
            }
            Map args = DOMUtil.toMapExcept((ConfigNode)node, (String[])new String[]{NAME, TYPE});
            if (null != args.get(REQUIRED)) {
                explicitRequiredProp.put(name, Boolean.valueOf((String)args.get(REQUIRED)));
            }
            SchemaField f = SchemaField.create(name, ft, args);
            if (node.name().equals(FIELD)) {
                SchemaField old = this.fields.put(f.getName(), f);
                if (old != null) {
                    String msg = "[schema.xml] Duplicate field definition for '" + f.getName() + "' [[[" + old.toString() + "]]] and [[[" + f.toString() + "]]]";
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                log.debug("field defined: {}", (Object)f);
                if (f.getDefaultValue() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} contains default value {}", (Object)name, (Object)f.getDefaultValue());
                    }
                    this.fieldsWithDefaultValue.add(f);
                }
                if (!f.isRequired()) continue;
                log.debug("{} is required in this schema", (Object)name);
                this.requiredFields.add(f);
                continue;
            }
            if (node.name().equals(DYNAMIC_FIELD)) {
                if (!this.isValidDynamicField(dFields, f)) continue;
                this.addDynamicFieldNoDupCheck(dFields, f);
                continue;
            }
            throw new RuntimeException("Unknown field type");
        }
        this.requiredFields.addAll(this.fieldsWithDefaultValue);
        this.dynamicFields = IndexSchema.dynamicFieldListToSortedArray(dFields);
        return explicitRequiredProp;
    }

    protected static DynamicField[] dynamicFieldListToSortedArray(List<DynamicField> dynamicFieldList) {
        Object[] dFields = dynamicFieldList.toArray(new DynamicField[dynamicFieldList.size()]);
        Arrays.sort(dFields);
        if (log.isTraceEnabled()) {
            log.trace("Dynamic Field Ordering: {}", (Object)Arrays.toString(dFields));
        }
        return dFields;
    }

    protected synchronized void loadCopyFields(ConfigNode n) {
        ArrayList nodes = n.getAll(COPY_FIELD);
        ConfigNode f = n.child(FIELDS);
        if (f != null) {
            nodes = new ArrayList(nodes);
            nodes.addAll(f.getAll(COPY_FIELD));
        }
        for (ConfigNode configNode : nodes) {
            String source = DOMUtil.getAttr((ConfigNode)configNode, (String)SOURCE, (String)"copyField definition");
            String dest = DOMUtil.getAttr((ConfigNode)configNode, (String)DESTINATION, (String)"copyField definition");
            String maxChars = DOMUtil.getAttr((ConfigNode)configNode, (String)MAX_CHARS, null);
            int maxCharsInt = 0;
            if (maxChars != null) {
                try {
                    maxCharsInt = Integer.parseInt(maxChars);
                }
                catch (NumberFormatException e) {
                    log.warn("Couldn't parse {} attribute for '{}' from '{}' to '{}' as integer. The whole field will be copied.", new Object[]{MAX_CHARS, COPY_FIELD, source, dest});
                }
            }
            if (dest.equals(this.uniqueKeyFieldName)) {
                String msg = "uniqueKey field (" + this.uniqueKeyFieldName + ") can not be the dest of a copyField(source=" + source + ")";
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            this.registerCopyField(source, dest, maxCharsInt);
        }
        for (Map.Entry entry : this.copyFieldTargetCounts.entrySet()) {
            if ((Integer)entry.getValue() <= 1 || ((SchemaField)entry.getKey()).multiValued()) continue;
            log.warn("Field {} is not multivalued and destination for multiple {} ({})", new Object[]{((SchemaField)entry.getKey()).name, COPY_FIELDS, entry.getValue()});
        }
    }

    protected static boolean isValidFieldGlob(String name) {
        if (name.startsWith("*") || name.endsWith("*")) {
            int count = 0;
            for (int pos = 0; pos < name.length() && -1 != (pos = name.indexOf(42, pos)); ++pos) {
                ++count;
            }
            if (1 == count) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidDynamicField(List<DynamicField> dFields, SchemaField f) {
        String glob = f.getName();
        if (f.getDefaultValue() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "dynamicField can not have a default value: " + glob);
        }
        if (f.isRequired()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "dynamicField can not be required: " + glob);
        }
        if (!IndexSchema.isValidFieldGlob(glob)) {
            String msg = "Dynamic field name '" + glob + "' should have either a leading or a trailing asterisk, and no others.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (this.isDuplicateDynField(dFields, f)) {
            String msg = "[schema.xml] Duplicate DynamicField definition for '" + glob + "'";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return true;
    }

    public void registerDynamicFields(SchemaField ... fields) {
        ArrayList<DynamicField> dynFields = new ArrayList<DynamicField>(Arrays.asList(this.dynamicFields));
        for (SchemaField field : fields) {
            if (this.isDuplicateDynField(dynFields, field)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("dynamic field already exists: dynamic field: [{}]", (Object)field.getName());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("dynamic field creation for schema field: {}", (Object)field.getName());
            }
            this.addDynamicFieldNoDupCheck(dynFields, field);
        }
        this.dynamicFields = IndexSchema.dynamicFieldListToSortedArray(dynFields);
    }

    private void addDynamicFieldNoDupCheck(List<DynamicField> dFields, SchemaField f) {
        dFields.add(new DynamicField(f));
        log.debug("dynamic field defined: {}", (Object)f);
    }

    protected boolean isDuplicateDynField(List<DynamicField> dFields, SchemaField f) {
        for (DynamicField df : dFields) {
            if (!df.getRegex().equals(f.name)) continue;
            return true;
        }
        return false;
    }

    public void registerCopyField(String source, String dest) {
        this.registerCopyField(source, dest, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void registerCopyField(String source, String dest, int maxChars) {
        Object msg;
        log.debug("{} {}='{}' {}='{}' {}='{}'", new Object[]{COPY_FIELD, SOURCE, source, DESTINATION, dest, MAX_CHARS, maxChars});
        DynamicField destDynamicField = null;
        SchemaField destSchemaField = this.fields.get(dest);
        SchemaField sourceSchemaField = this.fields.get(source);
        DynamicField sourceDynamicBase = null;
        DynamicField destDynamicBase = null;
        boolean sourceIsDynamicFieldReference = false;
        boolean sourceIsExplicitFieldGlob = false;
        String invalidGlobMessage = "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
        boolean sourceIsGlob = IndexSchema.isValidFieldGlob(source);
        if (source.contains("*") && !sourceIsGlob) {
            String msg2 = "copyField source :'" + source + "' is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg2);
        }
        if (dest.contains("*") && !IndexSchema.isValidFieldGlob(dest)) {
            String msg3 = "copyField dest :'" + dest + "' is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg3);
        }
        if (null == sourceSchemaField && sourceIsGlob) {
            Pattern pattern = Pattern.compile(source.replace("*", ".*"));
            for (String field : this.fields.keySet()) {
                if (!pattern.matcher(field).matches()) continue;
                sourceIsExplicitFieldGlob = true;
                break;
            }
        }
        if (null == destSchemaField || null == sourceSchemaField && !sourceIsExplicitFieldGlob) {
            for (DynamicField dynamicField : this.dynamicFields) {
                if (null == sourceSchemaField && !sourceIsDynamicFieldReference && !sourceIsExplicitFieldGlob && dynamicField.matches(source)) {
                    sourceIsDynamicFieldReference = true;
                    if (!source.equals(dynamicField.getRegex())) {
                        sourceDynamicBase = dynamicField;
                    }
                }
                if (null == destSchemaField) {
                    if (dest.equals(dynamicField.getRegex())) {
                        destDynamicField = dynamicField;
                        destSchemaField = dynamicField.prototype;
                    } else if (dynamicField.matches(dest)) {
                        destSchemaField = dynamicField.makeSchemaField(dest);
                        destDynamicField = new DynamicField(destSchemaField);
                        destDynamicBase = dynamicField;
                    }
                }
                if (null != destSchemaField && (null != sourceSchemaField || sourceIsDynamicFieldReference || sourceIsExplicitFieldGlob)) break;
            }
        }
        if (null == sourceSchemaField && !sourceIsGlob && !sourceIsDynamicFieldReference) {
            msg = "copyField source :'" + source + "' is not a glob and doesn't match any explicit field or dynamicField.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)msg);
        }
        if (null == destSchemaField) {
            msg = "copyField dest :'" + dest + "' is not an explicit field and doesn't match a dynamicField.";
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)msg);
        }
        if (sourceIsGlob) {
            if (null != destDynamicField) {
                this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, destDynamicBase));
                this.incrementCopyFieldTargetCount(destSchemaField);
                return;
            }
            destDynamicField = new DynamicField(destSchemaField);
            this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, null));
            this.incrementCopyFieldTargetCount(destSchemaField);
            return;
        }
        if (sourceIsDynamicFieldReference) {
            if (null != destDynamicField) {
                this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, destDynamicBase));
                this.incrementCopyFieldTargetCount(destSchemaField);
                return;
            }
            sourceSchemaField = this.getField(source);
            this.registerExplicitSrcAndDestFields(source, maxChars, destSchemaField, sourceSchemaField);
            return;
        }
        if (null == destDynamicField) {
            this.registerExplicitSrcAndDestFields(source, maxChars, destSchemaField, sourceSchemaField);
            return;
        }
        if (destDynamicField.pattern instanceof DynamicReplacement.DynamicPattern.NameEquals) {
            this.registerDynamicCopyField(new DynamicCopy(source, destDynamicField, maxChars, sourceDynamicBase, destDynamicBase));
            this.incrementCopyFieldTargetCount(destSchemaField);
            return;
        }
        msg = "copyField only supports a dynamic destination with an asterisk if the source also has an asterisk";
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)msg);
    }

    protected void registerExplicitSrcAndDestFields(String source, int maxChars, SchemaField destSchemaField, SchemaField sourceSchemaField) {
        List<CopyField> copyFieldList = this.copyFieldsMap.get(source);
        if (copyFieldList == null) {
            copyFieldList = new ArrayList<CopyField>();
            this.copyFieldsMap.put(source, copyFieldList);
        }
        copyFieldList.add(new CopyField(sourceSchemaField, destSchemaField, maxChars));
        this.incrementCopyFieldTargetCount(destSchemaField);
    }

    private void incrementCopyFieldTargetCount(SchemaField dest) {
        this.copyFieldTargetCounts.put(dest, this.copyFieldTargetCounts.containsKey(dest) ? this.copyFieldTargetCounts.get(dest) + 1 : 1);
    }

    private void registerDynamicCopyField(DynamicCopy dcopy) {
        DynamicCopy[] temp = new DynamicCopy[this.dynamicCopyFields.length + 1];
        System.arraycopy(this.dynamicCopyFields, 0, temp, 0, this.dynamicCopyFields.length);
        temp[temp.length - 1] = dcopy;
        this.dynamicCopyFields = temp;
    }

    static SimilarityFactory readSimilarity(SolrClassLoader loader, ConfigNode node) {
        SimilarityFactory similarityFactory;
        if (node == null) {
            return null;
        }
        String classArg = (String)node.attributes().get("class");
        final Object obj = loader.newInstance(classArg, Object.class, new String[]{"search.similarities."});
        if (obj instanceof SimilarityFactory) {
            NamedList namedList = DOMUtil.childNodesToNamedList((ConfigNode)node);
            namedList.add("class", (Object)classArg);
            SolrParams params = namedList.toSolrParams();
            similarityFactory = (SimilarityFactory)obj;
            similarityFactory.init(params);
        } else {
            similarityFactory = new SimilarityFactory(){

                @Override
                public Similarity getSimilarity() {
                    return (Similarity)obj;
                }
            };
        }
        return similarityFactory;
    }

    public SchemaField[] getDynamicFieldPrototypes() {
        SchemaField[] df = new SchemaField[this.dynamicFields.length];
        for (int i = 0; i < this.dynamicFields.length; ++i) {
            df[i] = this.dynamicFields[i].prototype;
        }
        return df;
    }

    public String getDynamicPattern(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.getRegex();
        }
        return null;
    }

    public boolean hasExplicitField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return true;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!fieldName.equals(df.getRegex())) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return false;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return true;
        }
        return false;
    }

    public SchemaField getFieldOrNull(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f;
        }
        f = (SchemaField)this.dynamicFieldCache.get((Object)fieldName);
        if (f != null) {
            return f;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            f = df.makeSchemaField(fieldName);
            this.dynamicFieldCache.put((Object)fieldName, (Object)f);
            break;
        }
        return f;
    }

    public SchemaField getField(String fieldName) {
        SchemaField f = this.getFieldOrNull(fieldName);
        if (f != null) {
            return f;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: \"" + fieldName + "\"");
    }

    public FieldType getFieldType(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.getDynamicFieldType(fieldName);
    }

    public FieldType getFieldTypeByName(String fieldTypeName) {
        return this.fieldTypes.get(fieldTypeName);
    }

    public FieldType getFieldTypeNoEx(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.dynFieldType(fieldName);
    }

    public FieldType getDynamicFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field " + fieldName);
    }

    private FieldType dynFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        return null;
    }

    public List<String> getCopySources(String destField) {
        SchemaField f = this.getField(destField);
        if (!this.isCopyFieldTarget(f)) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Map.Entry<String, List<CopyField>> cfs : this.copyFieldsMap.entrySet()) {
            for (CopyField copyField : cfs.getValue()) {
                if (!copyField.getDestination().getName().equals(destField)) continue;
                fieldNames.add(copyField.getSource().getName());
            }
        }
        for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
            if (!dynamicCopy.getDestFieldName().equals(destField)) continue;
            fieldNames.add(dynamicCopy.getRegex());
        }
        return fieldNames;
    }

    public List<CopyField> getCopyFieldsList(String sourceField) {
        ArrayList<CopyField> result = new ArrayList<CopyField>();
        for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
            if (!dynamicCopy.matches(sourceField)) continue;
            result.add(new CopyField(this.getField(sourceField), dynamicCopy.getTargetField(sourceField), dynamicCopy.maxChars));
        }
        List<CopyField> fixedCopyFields = this.copyFieldsMap.get(sourceField);
        if (null != fixedCopyFields) {
            result.addAll(fixedCopyFields);
        }
        return result;
    }

    public boolean isCopyFieldTarget(SchemaField f) {
        return this.copyFieldTargetCounts.containsKey(f);
    }

    public Map<String, Object> getNamedPropertyValues() {
        return this.getNamedPropertyValues(null, (SolrParams)new MapSolrParams(Collections.emptyMap()));
    }

    public Map<String, Object> getNamedPropertyValues(String name, SolrParams params) {
        return new SchemaProps(name, params, this).toMap(new LinkedHashMap<String, Object>());
    }

    public List<SimpleOrderedMap<Object>> getCopyFieldProperties(boolean showDetails, Set<String> requestedSourceFields, Set<String> requestedDestinationFields) {
        String destination;
        String source;
        ArrayList<SimpleOrderedMap<Object>> copyFieldProperties = new ArrayList<SimpleOrderedMap<Object>>();
        TreeMap<String, List<CopyField>> sortedCopyFields = new TreeMap<String, List<CopyField>>(this.copyFieldsMap);
        for (ArrayList copyFields : sortedCopyFields.values()) {
            copyFields = new ArrayList(copyFields);
            copyFields.sort((cf1, cf2) -> cf1.getDestination().getName().compareTo(cf2.getDestination().getName()));
            for (CopyField copyField : copyFields) {
                source = copyField.getSource().getName();
                destination = copyField.getDestination().getName();
                if (null != requestedSourceFields && !requestedSourceFields.contains(source) || null != requestedDestinationFields && !requestedDestinationFields.contains(destination)) continue;
                SimpleOrderedMap props = new SimpleOrderedMap();
                props.add(SOURCE, (Object)source);
                props.add(DESTINATION, (Object)destination);
                if (0 != copyField.getMaxChars()) {
                    props.add(MAX_CHARS, (Object)copyField.getMaxChars());
                }
                copyFieldProperties.add((SimpleOrderedMap<Object>)props);
            }
        }
        for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
            DynamicField destDynamicBase;
            source = dynamicCopy.getRegex();
            destination = dynamicCopy.getDestFieldName();
            if (null != requestedSourceFields && !requestedSourceFields.contains(source) || null != requestedDestinationFields && !requestedDestinationFields.contains(destination)) continue;
            SimpleOrderedMap dynamicCopyProps = new SimpleOrderedMap();
            dynamicCopyProps.add(SOURCE, (Object)dynamicCopy.getRegex());
            if (showDetails) {
                DynamicField sourceDynamicBase = dynamicCopy.getSourceDynamicBase();
                if (null != sourceDynamicBase) {
                    dynamicCopyProps.add(SOURCE_DYNAMIC_BASE, (Object)sourceDynamicBase.getRegex());
                } else if (source.contains("*")) {
                    ArrayList<String> sourceExplicitFields = new ArrayList<String>();
                    Pattern pattern = Pattern.compile(source.replace("*", ".*"));
                    for (String field : this.fields.keySet()) {
                        if (!pattern.matcher(field).matches()) continue;
                        sourceExplicitFields.add(field);
                    }
                    if (sourceExplicitFields.size() > 0) {
                        Collections.sort(sourceExplicitFields);
                        dynamicCopyProps.add(SOURCE_EXPLICIT_FIELDS, sourceExplicitFields);
                    }
                }
            }
            dynamicCopyProps.add(DESTINATION, (Object)dynamicCopy.getDestFieldName());
            if (showDetails && null != (destDynamicBase = dynamicCopy.getDestDynamicBase())) {
                dynamicCopyProps.add(DESTINATION_DYNAMIC_BASE, (Object)destDynamicBase.getRegex());
            }
            if (0 != dynamicCopy.getMaxChars()) {
                dynamicCopyProps.add(MAX_CHARS, (Object)dynamicCopy.getMaxChars());
            }
            copyFieldProperties.add((SimpleOrderedMap<Object>)dynamicCopyProps);
        }
        return copyFieldProperties;
    }

    public IndexSchema addField(SchemaField newField, boolean persist) {
        return this.addFields(Collections.singletonList(newField), Collections.emptyMap(), persist);
    }

    public IndexSchema addField(SchemaField newField) {
        return this.addField(newField, true);
    }

    public IndexSchema addField(SchemaField newField, Collection<String> copyFieldNames) {
        return this.addFields(Collections.singletonList(newField), Collections.singletonMap(newField.getName(), copyFieldNames), true);
    }

    public IndexSchema addFields(Collection<SchemaField> newFields) {
        return this.addFields(newFields, Collections.emptyMap(), true);
    }

    public IndexSchema addFields(Collection<SchemaField> newFields, Map<String, Collection<String>> copyFieldNames, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteFields(Collection<String> names) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema replaceField(String fieldName, FieldType replacementFieldType, Map<String, ?> replacementArgs) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addDynamicFields(Collection<SchemaField> newDynamicFields, Map<String, Collection<String>> copyFieldNames, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteDynamicFields(Collection<String> fieldNamePatterns) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public ManagedIndexSchema replaceDynamicField(String fieldNamePattern, FieldType replacementFieldType, Map<String, ?> replacementArgs) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addCopyFields(Map<String, Collection<String>> copyFields, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addCopyFields(String source, Collection<String> destinations, int maxChars) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteCopyFields(Map<String, Collection<String>> copyFields) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public SchemaField newField(String fieldName, String fieldType, Map<String, ?> options) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public SchemaField newDynamicField(String fieldNamePattern, String fieldType, Map<String, ?> options) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public Object getSchemaUpdateLock() {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema addFieldTypes(List<FieldType> fieldTypeList, boolean persist) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema deleteFieldTypes(Collection<String> names) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public IndexSchema replaceFieldType(String typeName, String replacementClassName, Map<String, Object> replacementArgs) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public FieldType newFieldType(String typeName, String className, Map<String, ?> options) {
        String msg = "This IndexSchema is not mutable.";
        log.error(msg);
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
    }

    public boolean isUsableForChildDocs() {
        FieldType rootType = this.getFieldTypeNoEx(ROOT_FIELD_NAME);
        return null != this.uniqueKeyFieldType && null != rootType && rootType.getTypeName().equals(this.uniqueKeyFieldType.getTypeName());
    }

    public PayloadDecoder getPayloadDecoder(String field) {
        FieldType ft = this.getFieldType(field);
        if (ft == null) {
            return null;
        }
        return this.decoders.computeIfAbsent(ft, f -> PayloadUtils.getPayloadDecoder(ft));
    }

    public static class SchemaProps
    implements MapSerializable {
        private static final String SOURCE_FIELD_LIST = "source.fl";
        private static final String DESTINATION_FIELD_LIST = "dest.fl";
        public final String name;
        private final SolrParams params;
        private final IndexSchema schema;
        boolean showDefaults;
        boolean includeDynamic;
        Set<String> requestedFields;
        private Set<String> requestedSourceFields;
        private Set<String> requestedDestinationFields;

        SchemaProps(String name, SolrParams params, IndexSchema schema) {
            this.name = name;
            this.params = params;
            this.schema = schema;
            this.showDefaults = params.getBool("showDefaults", false);
            this.includeDynamic = params.getBool("includeDynamic", false);
            this.requestedSourceFields = this.readMultiVals(SOURCE_FIELD_LIST);
            this.requestedDestinationFields = this.readMultiVals(DESTINATION_FIELD_LIST);
            this.requestedFields = this.readMultiVals("fl");
        }

        public Collection<SimpleOrderedMap<Object>> applyDynamic() {
            return (List)Handler.DYNAMIC_FIELDS.fun.apply(this);
        }

        private Set<String> readMultiVals(String name) {
            String[] fields;
            String flParam = this.params.get(name);
            if (null != flParam && (fields = flParam.trim().split("[,\\s]+")).length > 0) {
                return new LinkedHashSet<String>(Stream.of(fields).filter(it -> !it.trim().isEmpty()).collect(Collectors.toList()));
            }
            return null;
        }

        SimpleOrderedMap<Object> getProperties(SchemaField sf) {
            SimpleOrderedMap<Object> result = sf.getNamedPropertyValues(this.showDefaults);
            if (this.schema.isDynamicField(sf.name)) {
                String dynamicBase = this.schema.getDynamicPattern(sf.getName());
                if (!sf.getName().equals(dynamicBase)) {
                    result.add("dynamicBase", (Object)dynamicBase);
                }
            }
            return result;
        }

        public Map<String, Object> toMap(Map<String, Object> map) {
            return Stream.of(Handler.values()).filter(it -> this.name == null || it.nameLower.equals(this.name)).map(it -> new Pair((Object)it.realName, it.fun.apply(this))).filter(it -> it.second() != null).collect(Collectors.toMap(Pair::first, Pair::second, (v1, v2) -> v2, LinkedHashMap::new));
        }

        public static enum Handler {
            NAME("name", sp -> sp.schema.getSchemaName()),
            VERSION("version", sp -> Float.valueOf(sp.schema.getVersion())),
            UNIQUE_KEY("uniqueKey", sp -> sp.schema.uniqueKeyFieldName),
            SIMILARITY("similarity", sp -> sp.schema.isExplicitSimilarity ? sp.schema.similarityFactory.getNamedPropertyValues() : null),
            FIELD_TYPES("fieldTypes", sp -> new TreeMap<String, FieldType>(sp.schema.fieldTypes).values().stream().map(it -> it.getNamedPropertyValues(sp.showDefaults)).collect(Collectors.toList())),
            FIELDS("fields", sp -> {
                List result = (sp.requestedFields != null ? sp.requestedFields : new TreeSet<String>(sp.schema.fields.keySet())).stream().map(sp.schema::getFieldOrNull).filter(it -> it != null).filter(it -> sp.includeDynamic || !sp.schema.isDynamicField(it.name)).map(sp::getProperties).collect(Collectors.toList());
                if (sp.includeDynamic && sp.requestedFields == null) {
                    result.addAll(sp.applyDynamic());
                }
                return result;
            }),
            DYNAMIC_FIELDS("dynamicFields", sp -> Stream.of(sp.schema.dynamicFields).filter(it -> !it.getRegex().startsWith(IndexSchema.INTERNAL_POLY_FIELD_PREFIX)).filter(it -> sp.requestedFields == null || sp.requestedFields.contains(it.getPrototype().getName())).map(it -> sp.getProperties(it.getPrototype())).collect(Collectors.toList())),
            COPY_FIELDS("copyFields", sp -> sp.schema.getCopyFieldProperties(false, sp.requestedSourceFields, sp.requestedDestinationFields));

            final Function<SchemaProps, Object> fun;
            public final String realName;
            public final String nameLower;

            private Handler(String name, Function<SchemaProps, Object> fun) {
                this.fun = fun;
                this.realName = name;
                this.nameLower = name.toLowerCase(Locale.ROOT);
            }

            public String getRealName() {
                return this.realName;
            }

            public String getNameLower() {
                return this.nameLower;
            }
        }
    }

    public static class DynamicCopy
    extends DynamicReplacement {
        private final DynamicField destination;
        private final int maxChars;
        final DynamicField sourceDynamicBase;
        final DynamicField destDynamicBase;

        public int getMaxChars() {
            return this.maxChars;
        }

        public DynamicField getSourceDynamicBase() {
            return this.sourceDynamicBase;
        }

        public DynamicField getDestDynamicBase() {
            return this.destDynamicBase;
        }

        DynamicCopy(String sourceRegex, DynamicField destination, int maxChars, DynamicField sourceDynamicBase, DynamicField destDynamicBase) {
            super(sourceRegex);
            this.destination = destination;
            this.maxChars = maxChars;
            this.sourceDynamicBase = sourceDynamicBase;
            this.destDynamicBase = destDynamicBase;
        }

        public DynamicField getDestination() {
            return this.destination;
        }

        public String getDestFieldName() {
            return this.destination.getRegex();
        }

        public SchemaField getTargetField(String sourceField) {
            String remainder = this.pattern.remainder(sourceField);
            String targetFieldName = this.destination.pattern.subst(remainder);
            return this.destination.makeSchemaField(targetFieldName);
        }

        public String toString() {
            return this.destination.prototype.toString();
        }
    }

    public static final class DynamicField
    extends DynamicReplacement {
        private final SchemaField prototype;

        public SchemaField getPrototype() {
            return this.prototype;
        }

        DynamicField(SchemaField prototype) {
            super(prototype.name);
            this.prototype = prototype;
        }

        SchemaField makeSchemaField(String name) {
            return new SchemaField(this.prototype, name);
        }

        public String toString() {
            return this.prototype.toString();
        }
    }

    public static abstract class DynamicReplacement
    implements Comparable<DynamicReplacement> {
        protected DynamicPattern pattern;

        public boolean matches(String name) {
            return this.pattern.matches(name);
        }

        protected DynamicReplacement(String regex) {
            this.pattern = DynamicPattern.createPattern(regex);
        }

        @Override
        public int compareTo(DynamicReplacement other) {
            return other.pattern.length() - this.pattern.length();
        }

        public String getRegex() {
            return this.pattern.regex;
        }

        protected static abstract class DynamicPattern {
            protected final String regex;
            protected final String fixedStr;

            protected DynamicPattern(String regex, String fixedStr) {
                this.regex = regex;
                this.fixedStr = fixedStr;
            }

            static DynamicPattern createPattern(String regex) {
                if (regex.startsWith("*")) {
                    return new NameEndsWith(regex);
                }
                if (regex.endsWith("*")) {
                    return new NameStartsWith(regex);
                }
                return new NameEquals(regex);
            }

            abstract boolean matches(String var1);

            abstract String remainder(String var1);

            abstract String subst(String var1);

            public int length() {
                return this.regex.length();
            }

            private static class NameEquals
            extends DynamicPattern {
                NameEquals(String regex) {
                    super(regex, regex);
                }

                @Override
                boolean matches(String name) {
                    return this.regex.equals(name);
                }

                @Override
                String remainder(String name) {
                    return "";
                }

                @Override
                String subst(String replacement) {
                    return this.fixedStr;
                }
            }

            private static class NameEndsWith
            extends DynamicPattern {
                NameEndsWith(String regex) {
                    super(regex, regex.substring(1));
                }

                @Override
                boolean matches(String name) {
                    return name.endsWith(this.fixedStr);
                }

                @Override
                String remainder(String name) {
                    return name.substring(0, name.length() - this.fixedStr.length());
                }

                @Override
                String subst(String replacement) {
                    return replacement + this.fixedStr;
                }
            }

            private static class NameStartsWith
            extends DynamicPattern {
                NameStartsWith(String regex) {
                    super(regex, regex.substring(0, regex.length() - 1));
                }

                @Override
                boolean matches(String name) {
                    return name.startsWith(this.fixedStr);
                }

                @Override
                String remainder(String name) {
                    return name.substring(this.fixedStr.length());
                }

                @Override
                String subst(String replacement) {
                    return this.fixedStr + replacement;
                }
            }
        }
    }

    private class SolrQueryAnalyzer
    extends SolrIndexAnalyzer {
        SolrQueryAnalyzer() {
        }

        @Override
        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getQueryAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer = (Analyzer)this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getQueryAnalyzer();
        }
    }

    private class SolrIndexAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected final HashMap<String, Analyzer> analyzers;

        SolrIndexAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
            this.analyzers = this.analyzerCache();
        }

        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getIndexAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer = this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getIndexAnalyzer();
        }
    }
}

