/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/cores/{coreName}/reload")
public class ReloadCoreAPI
extends CoreAdminAPIBase {
    @Inject
    public ReloadCoreAPI(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse, CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse reloadCore(@Parameter(description="The name of the core to reload.", required=true) @PathParam(value="coreName") String coreName, @Schema(description="Additional parameters for reloading the core") @RequestBody ReloadCoreRequestBody reloadCoreRequestBody) throws Exception {
        SolrJerseyResponse solrJerseyResponse = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        return this.handlePotentiallyAsynchronousTask(solrJerseyResponse, coreName, reloadCoreRequestBody == null ? null : reloadCoreRequestBody.async, "reload", () -> {
            this.coreContainer.reload(coreName);
            return solrJerseyResponse;
        });
    }

    public static class ReloadCoreRequestBody
    implements JacksonReflectMapWriter {
        @Schema(description="Request ID to track this action which will be processed asynchronously.")
        @JsonProperty(value="async")
        public String async;
    }
}

