/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores/{core}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class MergeIndexesAPI {
    private static final String V2_MERGE_INDEXES_CORE_CMD = "merge-indexes";
    private final CoreAdminHandler coreHandler;

    public MergeIndexesAPI(CoreAdminHandler coreHandler) {
        this.coreHandler = coreHandler;
    }

    @Command(name="merge-indexes")
    public void mergeIndexesIntoCore(PayloadObj<MergeIndexesPayload> obj) throws Exception {
        MergeIndexesPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.MERGEINDEXES.name().toLowerCase(Locale.ROOT));
        v1Params.put("core", obj.getRequest().getPathTemplateValues().get("core"));
        if (v2Body.indexDir != null && !v2Body.indexDir.isEmpty()) {
            v1Params.put("indexDir", v2Body.indexDir.toArray(new String[0]));
        }
        if (v2Body.srcCore != null && !v2Body.srcCore.isEmpty()) {
            v1Params.put("srcCore", v2Body.srcCore.toArray(new String[0]));
        }
        if (v2Body.updateChain != null) {
            v1Params.put("update.chain", v1Params.remove("updateChain"));
        }
        this.coreHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    public static class MergeIndexesPayload
    implements ReflectMapWriter {
        @JsonProperty
        public List<String> indexDir;
        @JsonProperty
        public List<String> srcCore;
        @JsonProperty
        public String updateChain;
        @JsonProperty
        public String async;
    }
}

