/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

@Path(value="/collections")
public class CreateCollectionAPI
extends AdminAPIBase {
    @Inject
    public CreateCollectionAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse createCollection(CreateCollectionRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request body is missing but required");
        }
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        CreateCollectionAPI.recordCollectionForLogAndTracing(requestBody.name, this.solrQueryRequest);
        if (".system".equals(requestBody.name)) {
            requestBody.numShards = 1;
            requestBody.shardNames = null;
            CreateCollectionAPI.createSysConfigSet(coreContainer);
        }
        requestBody.validate();
        CreateCollectionAPI.populateDefaultsIfNecessary(coreContainer, requestBody);
        ZkNodeProps remoteMessage = CreateCollectionAPI.createRemoteMessage(requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.CREATE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (requestBody.async != null) {
            response.requestId = requestBody.async;
            return response;
        }
        response.successfulSubResponsesByNodeName = remoteResponse.getResponse().get("success");
        response.failedSubResponsesByNodeName = remoteResponse.getResponse().get("failure");
        response.warning = (String)remoteResponse.getResponse().get("warning");
        if (requestBody.async == null) {
            CollectionsHandler.waitForActiveCollection(requestBody.name, coreContainer, remoteResponse);
        }
        return response;
    }

    public static void populateDefaultsIfNecessary(CoreContainer coreContainer, CreateCollectionRequestBody requestBody) throws IOException {
        if (CollectionUtil.isEmpty(requestBody.shardNames) && requestBody.numShards == null) {
            requestBody.numShards = CreateCollectionAPI.readIntegerDefaultFromClusterProp(coreContainer, "numShards");
        }
        if (requestBody.nrtReplicas == null) {
            requestBody.nrtReplicas = CreateCollectionAPI.readIntegerDefaultFromClusterProp(coreContainer, "nrtReplicas");
        }
        if (requestBody.tlogReplicas == null) {
            requestBody.tlogReplicas = CreateCollectionAPI.readIntegerDefaultFromClusterProp(coreContainer, "tlogReplicas");
        }
        if (requestBody.pullReplicas == null) {
            requestBody.pullReplicas = CreateCollectionAPI.readIntegerDefaultFromClusterProp(coreContainer, "pullReplicas");
        }
    }

    private static void verifyShardsParam(List<String> shardNames) {
        for (String shard : shardNames) {
            SolrIdentifierValidator.validateShardName((String)shard);
        }
    }

    public static ZkNodeProps createRemoteMessage(CreateCollectionRequestBody reqBody) {
        HashMap<Object, Object> rawProperties = new HashMap<Object, Object>();
        rawProperties.put("fromApi", "true");
        rawProperties.put("operation", CollectionParams.CollectionAction.CREATE.toLower());
        rawProperties.put("name", reqBody.name);
        rawProperties.put("collection.configName", reqBody.config);
        rawProperties.put("numShards", reqBody.numShards);
        if (reqBody.shuffleNodes != null) {
            rawProperties.put("createNodeSet.shuffle", reqBody.shuffleNodes);
        }
        if (CollectionUtil.isNotEmpty(reqBody.shardNames)) {
            rawProperties.put("shards", String.join((CharSequence)",", reqBody.shardNames));
        }
        rawProperties.put("pullReplicas", reqBody.pullReplicas);
        rawProperties.put("tlogReplicas", reqBody.tlogReplicas);
        rawProperties.put("waitForFinalState", reqBody.waitForFinalState);
        rawProperties.put("perReplicaState", reqBody.perReplicaState);
        rawProperties.put("alias", reqBody.alias);
        rawProperties.put("async", reqBody.async);
        if (reqBody.createReplicas == null || reqBody.createReplicas.booleanValue()) {
            if (reqBody.nodeSet != null) {
                rawProperties.put("createNodeSet", String.join((CharSequence)",", reqBody.nodeSet));
            }
        } else {
            rawProperties.put("createNodeSet", "EMPTY");
        }
        if (reqBody.replicationFactor != null) {
            rawProperties.put("replicationFactor", reqBody.replicationFactor);
            if (reqBody.nrtReplicas == null) {
                rawProperties.put("nrtReplicas", reqBody.replicationFactor);
            }
        }
        if (reqBody.nrtReplicas != null) {
            rawProperties.put("nrtReplicas", reqBody.nrtReplicas);
            if (reqBody.replicationFactor == null) {
                rawProperties.put("replicationFactor", reqBody.nrtReplicas);
            }
        }
        if (reqBody.properties != null) {
            for (Map.Entry<String, String> entry : reqBody.properties.entrySet()) {
                rawProperties.put("property." + entry.getKey(), entry.getValue());
            }
        }
        if (reqBody.router != null) {
            RouterProperties routerProps = reqBody.router;
            rawProperties.put("router.name", routerProps.name);
            rawProperties.put("router.field", routerProps.field);
        }
        return new ZkNodeProps(rawProperties);
    }

    public static Map<String, String> copyPrefixedPropertiesWithoutPrefix(SolrParams params, Map<String, String> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            String[] values = params.getParams(param);
            if (values.length != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one value can be present for parameter " + param);
            }
            String modifiedKey = param.replaceFirst(prefix, "");
            props.put(modifiedKey, values[0]);
        }
        return props;
    }

    private static Integer readIntegerDefaultFromClusterProp(CoreContainer coreContainer, String propName) throws IOException {
        Object defaultValue = new ClusterProperties(coreContainer.getZkController().getZkStateReader().getZkClient()).getClusterProperty(List.of("defaults", "collection", propName), null);
        if (defaultValue == null) {
            return null;
        }
        return Integer.valueOf(String.valueOf(defaultValue));
    }

    private static void createSysConfigSet(CoreContainer coreContainer) throws KeeperException, InterruptedException {
        SolrZkClient zk = coreContainer.getZkController().getZkStateReader().getZkClient();
        ZkMaintenanceUtils.ensureExists((String)"/configs", (SolrZkClient)zk);
        ZkMaintenanceUtils.ensureExists((String)"/configs/.system", (SolrZkClient)zk);
        try {
            byte[] data;
            String path = "/configs/.system/schema.xml";
            try (InputStream inputStream = CollectionsHandler.class.getResourceAsStream("/SystemCollectionSchema.xml");){
                assert (inputStream != null);
                data = inputStream.readAllBytes();
            }
            assert (data != null && data.length > 0);
            ZkMaintenanceUtils.ensureExists((String)path, (byte[])data, (CreateMode)CreateMode.PERSISTENT, (SolrZkClient)zk);
            path = "/configs/.system/solrconfig.xml";
            inputStream = CollectionsHandler.class.getResourceAsStream("/SystemCollectionSolrConfig.xml");
            try {
                assert (inputStream != null);
                data = inputStream.readAllBytes();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            assert (data != null && data.length > 0);
            ZkMaintenanceUtils.ensureExists((String)path, (byte[])data, (CreateMode)CreateMode.PERSISTENT, (SolrZkClient)zk);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static class RouterProperties
    implements JacksonReflectMapWriter {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="field")
        public String field;
    }

    public static class CreateCollectionRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="replicationFactor")
        public Integer replicationFactor;
        @JsonProperty(value="config")
        public String config;
        @JsonProperty(value="numShards")
        public Integer numShards;
        @JsonProperty(value="shardNames")
        public List<String> shardNames;
        @JsonProperty(value="pullReplicas")
        public Integer pullReplicas;
        @JsonProperty(value="tlogReplicas")
        public Integer tlogReplicas;
        @JsonProperty(value="nrtReplicas")
        public Integer nrtReplicas;
        @JsonProperty(value="waitForFinalState")
        public Boolean waitForFinalState;
        @JsonProperty(value="perReplicaState")
        public Boolean perReplicaState;
        @JsonProperty(value="alias")
        public String alias;
        @JsonProperty(value="properties")
        public Map<String, String> properties;
        @JsonProperty(value="async")
        public String async;
        @JsonProperty(value="router")
        public RouterProperties router;
        @JsonProperty(value="nodeSet")
        public List<String> nodeSet;
        @JsonProperty(value="createReplicas")
        public Boolean createReplicas;
        @JsonProperty(value="shuffleNodes")
        public Boolean shuffleNodes;

        public static CreateCollectionRequestBody fromV1Params(SolrParams params, boolean nameRequired) {
            CreateCollectionRequestBody requestBody = new CreateCollectionRequestBody();
            requestBody.name = nameRequired ? params.required().get("name") : params.get("name");
            requestBody.replicationFactor = params.getInt("replicationFactor");
            requestBody.config = params.get("collection.configName");
            requestBody.numShards = params.getInt("numShards");
            if (params.get("createNodeSet") != null) {
                String commaDelimNodeSet = params.get("createNodeSet");
                if ("EMPTY".equals(commaDelimNodeSet)) {
                    requestBody.createReplicas = false;
                } else {
                    requestBody.nodeSet = Arrays.asList(params.get("createNodeSet").split(","));
                }
            }
            requestBody.shuffleNodes = params.getBool("createNodeSet.shuffle");
            requestBody.shardNames = params.get("shards") != null ? Arrays.stream(params.get("shards").split(",")).collect(Collectors.toList()) : new ArrayList<String>();
            requestBody.tlogReplicas = params.getInt("tlogReplicas");
            requestBody.pullReplicas = params.getInt("pullReplicas");
            requestBody.nrtReplicas = params.getInt("nrtReplicas");
            requestBody.waitForFinalState = params.getBool("waitForFinalState");
            requestBody.perReplicaState = params.getBool("perReplicaState");
            requestBody.alias = params.get("alias");
            requestBody.async = params.get("async");
            requestBody.properties = CreateCollectionAPI.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
            if (params.get("router.name") != null || params.get("router.field") != null) {
                RouterProperties routerProperties = new RouterProperties();
                routerProperties.name = params.get("router.name");
                routerProperties.field = params.get("router.field");
                requestBody.router = routerProperties;
            }
            return requestBody;
        }

        public void validate() {
            if (this.replicationFactor != null && this.nrtReplicas != null && !this.replicationFactor.equals(this.nrtReplicas)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot specify both replicationFactor and nrtReplicas as they mean the same thing");
            }
            SolrIdentifierValidator.validateCollectionName((String)this.name);
            if (this.shardNames != null && !this.shardNames.isEmpty()) {
                CreateCollectionAPI.verifyShardsParam(this.shardNames);
            }
        }

        public void addToRemoteMessageWithPrefix(Map<String, Object> remoteMessage, String prefix) {
            Map v1Params = this.toMap(new HashMap());
            CreateCollectionRequestBody.convertV2CreateCollectionMapToV1ParamMap(v1Params);
            for (Map.Entry v1Param : v1Params.entrySet()) {
                remoteMessage.put(prefix + (String)v1Param.getKey(), v1Param.getValue());
            }
        }

        public static void convertV2CreateCollectionMapToV1ParamMap(Map<String, Object> v2MapVals) {
            Set v2Keys = v2MapVals.keySet().stream().collect(Collectors.toSet());
            Iterator iterator = v2Keys.iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "properties": {
                        Map propertiesMap = (Map)v2MapVals.remove("properties");
                        V2ApiUtils.flattenMapWithPrefix(propertiesMap, v2MapVals, "property.");
                        break;
                    }
                    case "router": {
                        Map routerProperties = (Map)v2MapVals.remove("router");
                        V2ApiUtils.flattenMapWithPrefix(routerProperties, v2MapVals, "router.");
                        break;
                    }
                    case "config": {
                        v2MapVals.put("collection.configName", v2MapVals.remove("config"));
                        break;
                    }
                    case "shardNames": {
                        String shardsValue = String.join((CharSequence)",", (Collection)v2MapVals.remove("shardNames"));
                        v2MapVals.put("shards", shardsValue);
                        break;
                    }
                    case "shuffleNodes": {
                        v2MapVals.put("createNodeSet.shuffle", v2MapVals.remove("shuffleNodes"));
                        break;
                    }
                    case "nodeSet": {
                        Object nodeSetValUncast = v2MapVals.remove("nodeSet");
                        if (nodeSetValUncast instanceof String) {
                            v2MapVals.put("createNodeSet", nodeSetValUncast);
                            break;
                        }
                        List nodeSetList = (List)nodeSetValUncast;
                        String nodeSetStr = String.join((CharSequence)",", nodeSetList);
                        v2MapVals.put("createNodeSet", nodeSetStr);
                        break;
                    }
                }
            }
        }
    }
}

