/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.eclipse.jetty.io.RuntimeIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatStream
extends TupleStream
implements Expressible {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String commaDelimitedFilepaths;
    private final int maxLines;
    private StreamContext context;
    private Path chroot;
    private Iterator<CrawlFile> allFilesToCrawl;
    private int linesReturned = 0;
    private CrawlFile currentFilePath;
    private LineIterator currentFileLines;

    public CatStream(StreamExpression expression, StreamFactory factory) throws IOException {
        this(factory.getValueOperand(expression, 0), factory.getIntOperand(expression, "maxLines", Integer.valueOf(-1)));
    }

    public CatStream(String commaDelimitedFilepaths, int maxLines) {
        if (commaDelimitedFilepaths == null) {
            throw new IllegalArgumentException("No filepaths provided to stream");
        }
        String filepathsWithoutSurroundingQuotes = this.stripSurroundingQuotesIfTheyExist(commaDelimitedFilepaths);
        if (StrUtils.isNullOrEmpty((String)filepathsWithoutSurroundingQuotes)) {
            throw new IllegalArgumentException("No filepaths provided to stream");
        }
        this.commaDelimitedFilepaths = filepathsWithoutSurroundingQuotes;
        this.maxLines = maxLines;
    }

    private String stripSurroundingQuotesIfTheyExist(String value) {
        if (value.length() < 2) {
            return value;
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public void setStreamContext(StreamContext context) {
        this.context = context;
        Object solrCoreObj = context.get((Object)"solr-core");
        if (solrCoreObj == null || !(solrCoreObj instanceof SolrCore)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "StreamContext must have SolrCore in solr-core key");
        }
        SolrCore core = (SolrCore)context.get((Object)"solr-core");
        this.chroot = core.getCoreContainer().getUserFilesPath();
        if (!Files.exists(this.chroot, new LinkOption[0])) {
            throw new IllegalStateException(this.chroot + " directory used to load files must exist but could not be found!");
        }
    }

    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    public void open() throws IOException {
        List<CrawlFile> initialCrawlSeeds = this.validateAndSetFilepathsInSandbox();
        ArrayList<CrawlFile> filesToCrawl = new ArrayList<CrawlFile>();
        for (CrawlFile crawlSeed : initialCrawlSeeds) {
            this.findReadableFiles(crawlSeed, filesToCrawl);
        }
        log.debug("Found files [{}] to stream from roots: [{}]", filesToCrawl, initialCrawlSeeds);
        this.allFilesToCrawl = filesToCrawl.iterator();
    }

    public void close() throws IOException {
    }

    public Tuple read() throws IOException {
        if (this.maxLines >= 0 && this.linesReturned >= this.maxLines) {
            this.closeCurrentFileIfSet();
            return Tuple.EOF();
        }
        if (this.currentFileHasMoreLinesToRead()) {
            return this.fetchNextLineFromCurrentFile();
        }
        if (this.advanceToNextFileWithData()) {
            return this.fetchNextLineFromCurrentFile();
        }
        this.closeCurrentFileIfSet();
        return Tuple.EOF();
    }

    public StreamComparator getStreamSort() {
        return null;
    }

    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(((Object)((Object)this)).getClass()));
        expression.addParameter("\"" + this.commaDelimitedFilepaths + "\"");
        return expression;
    }

    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName(factory.getFunctionName(((Object)((Object)this)).getClass())).withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-source").withExpression(this.toExpression(factory).toString());
    }

    private List<CrawlFile> validateAndSetFilepathsInSandbox() {
        ArrayList<CrawlFile> crawlSeeds = new ArrayList<CrawlFile>();
        for (String crawlRootStr : this.commaDelimitedFilepaths.split(",")) {
            Path crawlRootPath = this.chroot.resolve(crawlRootStr).normalize();
            if (!crawlRootPath.startsWith(this.chroot)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "file/directory to stream must be under " + this.chroot);
            }
            if (!Files.exists(crawlRootPath, new LinkOption[0])) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "file/directory to stream doesn't exist: " + crawlRootStr);
            }
            crawlSeeds.add(new CrawlFile(crawlRootStr, crawlRootPath));
        }
        return crawlSeeds;
    }

    private boolean advanceToNextFileWithData() throws IOException {
        while (this.allFilesToCrawl.hasNext()) {
            this.closeCurrentFileIfSet();
            this.currentFilePath = this.allFilesToCrawl.next();
            this.currentFileLines = this.currentFilePath.absolutePath.toString().endsWith(".gz") ? new LineIterator((Reader)new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(this.currentFilePath.absolutePath, new OpenOption[0])), StandardCharsets.UTF_8)) : FileUtils.lineIterator((File)this.currentFilePath.absolutePath.toFile(), (String)"UTF-8");
            if (!this.currentFileLines.hasNext()) continue;
            return true;
        }
        return false;
    }

    private Tuple fetchNextLineFromCurrentFile() {
        ++this.linesReturned;
        return new Tuple("file", (Object)this.currentFilePath.displayPath, "line", (Object)this.currentFileLines.next());
    }

    private boolean currentFileHasMoreLinesToRead() {
        return this.currentFileLines != null && this.currentFileLines.hasNext();
    }

    private void closeCurrentFileIfSet() throws IOException {
        if (this.currentFilePath != null) {
            this.currentFileLines.close();
            this.currentFilePath = null;
            this.currentFileLines = null;
        }
    }

    private void findReadableFiles(CrawlFile seed, List<CrawlFile> foundFiles) {
        Path entry = seed.absolutePath;
        if (!Files.exists(entry, new LinkOption[0]) || !Files.isReadable(entry) || Files.isSymbolicLink(entry)) {
            return;
        }
        if (Files.isRegularFile(entry, new LinkOption[0])) {
            foundFiles.add(seed);
        } else if (Files.isDirectory(entry, new LinkOption[0])) {
            try (Stream<Path> directoryContents = Files.list(entry);){
                directoryContents.sorted().forEach(iPath -> {
                    String displayPathSeparator = iPath.getFileSystem().getSeparator();
                    String itemDisplayPath = seed.displayPath + displayPathSeparator + iPath.getFileName();
                    this.findReadableFiles(new CrawlFile(itemDisplayPath, (Path)iPath), foundFiles);
                });
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }

    public static class CrawlFile {
        private final String displayPath;
        private final Path absolutePath;

        public CrawlFile(String displayPath, Path absolutePath) {
            this.displayPath = displayPath;
            this.absolutePath = absolutePath;
        }
    }
}

