/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.Map;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.CreateCollectionAPI;

abstract class AliasCmd
implements CollApiCmds.CollectionApiCommand {
    protected final CollectionCommandContext ccc;

    protected AliasCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    static NamedList<Object> createCollectionAndWait(ClusterState clusterState, String aliasName, Map<String, String> aliasMetadata, String createCollName, CollectionCommandContext ccc) throws Exception {
        NamedList results;
        block5: {
            ModifiableSolrParams createReqParams = new ModifiableSolrParams();
            for (Map.Entry<String, String> e : aliasMetadata.entrySet()) {
                if (!e.getKey().startsWith("create-collection.")) continue;
                createReqParams.set(e.getKey().substring("create-collection.".length()), new String[]{e.getValue()});
            }
            if (createReqParams.get("collection.configName") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We require an explicit collection.configName");
            }
            createReqParams.set("name", new String[]{createCollName});
            CreateCollectionAPI.CreateCollectionRequestBody createReqBody = CreateCollectionAPI.CreateCollectionRequestBody.fromV1Params((SolrParams)createReqParams, true);
            CreateCollectionAPI.populateDefaultsIfNecessary(ccc.getCoreContainer(), createReqBody);
            ZkNodeProps createMessage = CreateCollectionAPI.createRemoteMessage(createReqBody);
            results = new NamedList();
            try {
                new CreateCollectionCmd(ccc).call(clusterState, createMessage, (NamedList<Object>)results);
            }
            catch (SolrException e) {
                if (e.getMessage().contains("collection already exists")) break block5;
                throw e;
            }
        }
        CollectionsHandler.waitForActiveCollection(createCollName, ccc.getCoreContainer(), new OverseerSolrResponse((NamedList<Object>)results));
        CollectionProperties collectionProperties = new CollectionProperties(ccc.getZkStateReader().getZkClient());
        collectionProperties.setCollectionProperty(createCollName, "routedAliasName", aliasName);
        while (!ccc.getZkStateReader().getCollectionProperties(createCollName, 1000L).containsKey("routedAliasName")) {
            Thread.sleep(50L);
        }
        return results;
    }
}

