# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Media module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_media.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Media
else:
    import _Media

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Media.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _Media.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Media.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Media.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _Media.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _Media.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _Media.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _Media.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _Media.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _Media.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Media.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _Media.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _Media.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Media.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Media.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Media.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _Media.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Media:
_Media.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _Media.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TCollection
import OCC.Core.Image
import OCC.Core.Graphic3d
import OCC.Core.BVH
import OCC.Core.Quantity
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.Aspect
import OCC.Core.TopLoc
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.OSD

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Media_BufferPool_Create() -> "opencascade::handle< Media_BufferPool >":
    return _Media.Handle_Media_BufferPool_Create()

def Handle_Media_BufferPool_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_BufferPool >":
    return _Media.Handle_Media_BufferPool_DownCast(t)

def Handle_Media_BufferPool_IsNull(t: "opencascade::handle< Media_BufferPool > const &") -> "bool":
    return _Media.Handle_Media_BufferPool_IsNull(t)

def Handle_Media_CodecContext_Create() -> "opencascade::handle< Media_CodecContext >":
    return _Media.Handle_Media_CodecContext_Create()

def Handle_Media_CodecContext_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_CodecContext >":
    return _Media.Handle_Media_CodecContext_DownCast(t)

def Handle_Media_CodecContext_IsNull(t: "opencascade::handle< Media_CodecContext > const &") -> "bool":
    return _Media.Handle_Media_CodecContext_IsNull(t)

def Handle_Media_FormatContext_Create() -> "opencascade::handle< Media_FormatContext >":
    return _Media.Handle_Media_FormatContext_Create()

def Handle_Media_FormatContext_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_FormatContext >":
    return _Media.Handle_Media_FormatContext_DownCast(t)

def Handle_Media_FormatContext_IsNull(t: "opencascade::handle< Media_FormatContext > const &") -> "bool":
    return _Media.Handle_Media_FormatContext_IsNull(t)

def Handle_Media_Frame_Create() -> "opencascade::handle< Media_Frame >":
    return _Media.Handle_Media_Frame_Create()

def Handle_Media_Frame_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_Frame >":
    return _Media.Handle_Media_Frame_DownCast(t)

def Handle_Media_Frame_IsNull(t: "opencascade::handle< Media_Frame > const &") -> "bool":
    return _Media.Handle_Media_Frame_IsNull(t)

def Handle_Media_Packet_Create() -> "opencascade::handle< Media_Packet >":
    return _Media.Handle_Media_Packet_Create()

def Handle_Media_Packet_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_Packet >":
    return _Media.Handle_Media_Packet_DownCast(t)

def Handle_Media_Packet_IsNull(t: "opencascade::handle< Media_Packet > const &") -> "bool":
    return _Media.Handle_Media_Packet_IsNull(t)

def Handle_Media_PlayerContext_Create() -> "opencascade::handle< Media_PlayerContext >":
    return _Media.Handle_Media_PlayerContext_Create()

def Handle_Media_PlayerContext_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_PlayerContext >":
    return _Media.Handle_Media_PlayerContext_DownCast(t)

def Handle_Media_PlayerContext_IsNull(t: "opencascade::handle< Media_PlayerContext > const &") -> "bool":
    return _Media.Handle_Media_PlayerContext_IsNull(t)

def Handle_Media_Scaler_Create() -> "opencascade::handle< Media_Scaler >":
    return _Media.Handle_Media_Scaler_Create()

def Handle_Media_Scaler_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_Scaler >":
    return _Media.Handle_Media_Scaler_DownCast(t)

def Handle_Media_Scaler_IsNull(t: "opencascade::handle< Media_Scaler > const &") -> "bool":
    return _Media.Handle_Media_Scaler_IsNull(t)

def Handle_Media_Timer_Create() -> "opencascade::handle< Media_Timer >":
    return _Media.Handle_Media_Timer_Create()

def Handle_Media_Timer_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Media_Timer >":
    return _Media.Handle_Media_Timer_DownCast(t)

def Handle_Media_Timer_IsNull(t: "opencascade::handle< Media_Timer > const &") -> "bool":
    return _Media.Handle_Media_Timer_IsNull(t)
class Media_BufferPool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _Media.Media_BufferPool_swiginit(self, _Media.new_Media_BufferPool(*args))

    def BufferSize(self, *args) -> "int":
        r"""
        Return buffer size within the pool.

        Returns
        -------
        int

        """
        return _Media.Media_BufferPool_BufferSize(self, *args)

    def GetBuffer(self, *args) -> "AVBufferRef *":
        r"""
        Get new buffer from the pool.

        Returns
        -------
        AVBufferRef *

        """
        return _Media.Media_BufferPool_GetBuffer(self, *args)

    def Init(self, *args) -> "bool":
        r"""
        (re-)initialize the pool.

        Parameters
        ----------
        theBufferSize: int

        Returns
        -------
        bool

        """
        return _Media.Media_BufferPool_Init(self, *args)

    def Release(self, *args) -> "void":
        r"""
        Release the pool (reference-counted buffer will be released when needed).

        Returns
        -------
        None

        """
        return _Media.Media_BufferPool_Release(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_BufferPool_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_BufferPool

# Register Media_BufferPool in _Media:
_Media.Media_BufferPool_swigregister(Media_BufferPool)

class Media_CodecContext(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _Media.Media_CodecContext_swiginit(self, _Media.new_Media_CodecContext(*args))

    def CanProcessPacket(self, *args) -> "bool":
        r"""
        Return true if packet belongs to this stream.

        Parameters
        ----------
        thePacket: Media_Packet

        Returns
        -------
        bool

        """
        return _Media.Media_CodecContext_CanProcessPacket(self, *args)

    def Close(self, *args) -> "void":
        r"""
        Close input.

        Returns
        -------
        None

        """
        return _Media.Media_CodecContext_Close(self, *args)

    def Context(self, *args) -> "AVCodecContext *":
        r"""
        Return context.

        Returns
        -------
        AVCodecContext *

        """
        return _Media.Media_CodecContext_Context(self, *args)

    def Flush(self, *args) -> "void":
        r"""
        Avcodec_flush_buffers() wrapper.

        Returns
        -------
        None

        """
        return _Media.Media_CodecContext_Flush(self, *args)

    def Init(self, *args) -> "bool":
        r"""
        Open codec specified within the stream. @param thestream stream to open @param theptsstartbase pts start in seconds @param thenbthreads amount of threads to use for avmedia_type_video stream; -1 means osd_parallel::nblogicalprocessors(),  0 means auto by ffmpeg itself >0 means specified number of threads (decoder should support multi-threading to take effect).

        Parameters
        ----------
        theStream: AVStream
        thePtsStartBase: double
        theNbThreads: int,optional
        	default value is -1

        Returns
        -------
        bool
        Open codec. @param thestream stream to open @param theptsstartbase pts start in seconds @param thenbthreads amount of threads to use for avmedia_type_video stream; -1 means osd_parallel::nblogicalprocessors(),  0 means auto by ffmpeg itself >0 means specified number of threads (decoder should support multi-threading to take effect) @param thecodecid codec (avcodecid) to open.

        Parameters
        ----------
        theStream: AVStream
        thePtsStartBase: double
        theNbThreads: int
        theCodecId: int

        Returns
        -------
        bool

        """
        return _Media.Media_CodecContext_Init(self, *args)

    def ReceiveFrame(self, *args) -> "bool":
        r"""
        Avcodec_receive_frame() wrapper.

        Parameters
        ----------
        theFrame: Media_Frame

        Returns
        -------
        bool

        """
        return _Media.Media_CodecContext_ReceiveFrame(self, *args)

    def SendPacket(self, *args) -> "bool":
        r"""
        Avcodec_send_packet() wrapper.

        Parameters
        ----------
        thePacket: Media_Packet

        Returns
        -------
        bool

        """
        return _Media.Media_CodecContext_SendPacket(self, *args)

    def SizeX(self, *args) -> "int":
        r"""
        Returns source frame width.

        Returns
        -------
        int

        """
        return _Media.Media_CodecContext_SizeX(self, *args)

    def SizeY(self, *args) -> "int":
        r"""
        Returns source frame height.

        Returns
        -------
        int

        """
        return _Media.Media_CodecContext_SizeY(self, *args)

    def StreamIndex(self, *args) -> "int":
        r"""
        Return stream index.

        Returns
        -------
        int

        """
        return _Media.Media_CodecContext_StreamIndex(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_CodecContext_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_CodecContext

# Register Media_CodecContext in _Media:
_Media.Media_CodecContext_swigregister(Media_CodecContext)

class Media_FormatContext(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor.

        Returns
        -------
        None

        """
        _Media.Media_FormatContext_swiginit(self, _Media.new_Media_FormatContext(*args))

    def Close(self, *args) -> "void":
        r"""
        Close input.

        Returns
        -------
        None

        """
        return _Media.Media_FormatContext_Close(self, *args)

    def Context(self, *args) -> "AVFormatContext *":
        r"""
        Return context.

        Returns
        -------
        AVFormatContext *

        """
        return _Media.Media_FormatContext_Context(self, *args)

    def Duration(self, *args) -> "double":
        r"""
        Return duration in seconds.

        Returns
        -------
        double

        """
        return _Media.Media_FormatContext_Duration(self, *args)

    @staticmethod
    def FormatAVErrorDescription(*args) -> "TCollection_AsciiString":
        r"""
        Returns string description for averror code.

        Parameters
        ----------
        theErrCodeAV: int

        Returns
        -------
        TCollection_AsciiString

        """
        return _Media.Media_FormatContext_FormatAVErrorDescription(*args)

    @staticmethod
    def FormatTime(*args) -> "TCollection_AsciiString":
        r"""
        Time formatter.

        Parameters
        ----------
        theSeconds: double

        Returns
        -------
        TCollection_AsciiString

        """
        return _Media.Media_FormatContext_FormatTime(*args)

    @staticmethod
    def FormatTimeProgress(*args) -> "TCollection_AsciiString":
        r"""
        Time progress / duration formatter.

        Parameters
        ----------
        theProgress: double
        theDuration: double

        Returns
        -------
        TCollection_AsciiString

        """
        return _Media.Media_FormatContext_FormatTimeProgress(*args)

    @staticmethod
    def FormatUnitsToSeconds(*args) -> "double":
        r"""
        Convert time units into seconds for context. @param thetimeunits value to convert returns converted time units in seconds.

        Parameters
        ----------
        theTimeUnits: int64_t

        Returns
        -------
        double

        """
        return _Media.Media_FormatContext_FormatUnitsToSeconds(*args)

    def NbSteams(self, *args) -> "unsigned int":
        r"""
        Return amount of streams.

        Returns
        -------
        unsigned int

        """
        return _Media.Media_FormatContext_NbSteams(self, *args)

    def OpenInput(self, *args) -> "bool":
        r"""
        Open input.

        Parameters
        ----------
        theInput: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _Media.Media_FormatContext_OpenInput(self, *args)

    def PtsStartBase(self, *args) -> "double":
        r"""
        Return pts start base in seconds.

        Returns
        -------
        double

        """
        return _Media.Media_FormatContext_PtsStartBase(self, *args)

    def ReadPacket(self, *args) -> "bool":
        r"""
        Av_read_frame() wrapper.

        Parameters
        ----------
        thePacket: Media_Packet

        Returns
        -------
        bool

        """
        return _Media.Media_FormatContext_ReadPacket(self, *args)

    @staticmethod
    def SecondsToUnits(*args) -> "int64_t":
        r"""
        Convert seconds into time units for context. @param thetimeseconds value to convert returns time units.

        Parameters
        ----------
        theTimeSeconds: double

        Returns
        -------
        int64_t
        Convert seconds into time units. @param thetimebase the timebase @param thetimeseconds value to convert returns time units.

        Parameters
        ----------
        theTimeBase: AVRational
        theTimeSeconds: double

        Returns
        -------
        int64_t

        """
        return _Media.Media_FormatContext_SecondsToUnits(*args)

    def Seek(self, *args) -> "bool":
        r"""
        Seek context to specified position.

        Parameters
        ----------
        theSeekPts: double
        toSeekBack: bool

        Returns
        -------
        bool

        """
        return _Media.Media_FormatContext_Seek(self, *args)

    def SeekStream(self, *args) -> "bool":
        r"""
        Seek stream to specified position.

        Parameters
        ----------
        theStreamId: unsigned int
        theSeekPts: double
        toSeekBack: bool

        Returns
        -------
        bool

        """
        return _Media.Media_FormatContext_SeekStream(self, *args)

    def Stream(self, *args) -> "AVStream const &":
        r"""
        Return stream.

        Parameters
        ----------
        theIndex: unsigned int

        Returns
        -------
        AVStream

        """
        return _Media.Media_FormatContext_Stream(self, *args)

    def StreamInfo(self, *args) -> "TCollection_AsciiString":
        r"""
        Format stream info.

        Parameters
        ----------
        theIndex: unsigned int
        theCodecCtx: AVCodecContext *,optional
        	default value is NULL

        Returns
        -------
        TCollection_AsciiString

        """
        return _Media.Media_FormatContext_StreamInfo(self, *args)

    @staticmethod
    def StreamSecondsToUnits(*args) -> "int64_t":
        r"""
        Convert seconds into time units for stream. @param thestream the stream @param thetimeseconds value to convert returns time units.

        Parameters
        ----------
        theStream: AVStream
        theTimeSeconds: double

        Returns
        -------
        int64_t

        """
        return _Media.Media_FormatContext_StreamSecondsToUnits(*args)

    @staticmethod
    def StreamUnitsToSeconds(*args) -> "double":
        r"""
        Convert time units into seconds using stream base. @param thestream the stream; @param thetimeunits value to convert; returns converted time units in seconds.

        Parameters
        ----------
        theStream: AVStream
        theTimeUnits: int64_t

        Returns
        -------
        double

        """
        return _Media.Media_FormatContext_StreamUnitsToSeconds(*args)

    @staticmethod
    def UnitsToSeconds(*args) -> "double":
        r"""
        Convert time units into seconds. returns zero for invalid value. @param thetimebase the timebase @param thetimeunits value to convert returns converted time units in seconds.

        Parameters
        ----------
        theTimeBase: AVRational
        theTimeUnits: int64_t

        Returns
        -------
        double

        """
        return _Media.Media_FormatContext_UnitsToSeconds(*args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_FormatContext_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_FormatContext

# Register Media_FormatContext in _Media:
_Media.Media_FormatContext_swigregister(Media_FormatContext)

def Media_FormatContext_FormatAVErrorDescription(*args) -> "TCollection_AsciiString":
    r"""
    Returns string description for averror code.

    Parameters
    ----------
    theErrCodeAV: int

    Returns
    -------
    TCollection_AsciiString

    """
    return _Media.Media_FormatContext_FormatAVErrorDescription(*args)

def Media_FormatContext_FormatTime(*args) -> "TCollection_AsciiString":
    r"""
    Time formatter.

    Parameters
    ----------
    theSeconds: double

    Returns
    -------
    TCollection_AsciiString

    """
    return _Media.Media_FormatContext_FormatTime(*args)

def Media_FormatContext_FormatTimeProgress(*args) -> "TCollection_AsciiString":
    r"""
    Time progress / duration formatter.

    Parameters
    ----------
    theProgress: double
    theDuration: double

    Returns
    -------
    TCollection_AsciiString

    """
    return _Media.Media_FormatContext_FormatTimeProgress(*args)

def Media_FormatContext_FormatUnitsToSeconds(*args) -> "double":
    r"""
    Convert time units into seconds for context. @param thetimeunits value to convert returns converted time units in seconds.

    Parameters
    ----------
    theTimeUnits: int64_t

    Returns
    -------
    double

    """
    return _Media.Media_FormatContext_FormatUnitsToSeconds(*args)

def Media_FormatContext_SecondsToUnits(*args) -> "int64_t":
    r"""
    Convert seconds into time units for context. @param thetimeseconds value to convert returns time units.

    Parameters
    ----------
    theTimeSeconds: double

    Returns
    -------
    int64_t
    Convert seconds into time units. @param thetimebase the timebase @param thetimeseconds value to convert returns time units.

    Parameters
    ----------
    theTimeBase: AVRational
    theTimeSeconds: double

    Returns
    -------
    int64_t

    """
    return _Media.Media_FormatContext_SecondsToUnits(*args)

def Media_FormatContext_StreamSecondsToUnits(*args) -> "int64_t":
    r"""
    Convert seconds into time units for stream. @param thestream the stream @param thetimeseconds value to convert returns time units.

    Parameters
    ----------
    theStream: AVStream
    theTimeSeconds: double

    Returns
    -------
    int64_t

    """
    return _Media.Media_FormatContext_StreamSecondsToUnits(*args)

def Media_FormatContext_StreamUnitsToSeconds(*args) -> "double":
    r"""
    Convert time units into seconds using stream base. @param thestream the stream; @param thetimeunits value to convert; returns converted time units in seconds.

    Parameters
    ----------
    theStream: AVStream
    theTimeUnits: int64_t

    Returns
    -------
    double

    """
    return _Media.Media_FormatContext_StreamUnitsToSeconds(*args)

def Media_FormatContext_UnitsToSeconds(*args) -> "double":
    r"""
    Convert time units into seconds. returns zero for invalid value. @param thetimebase the timebase @param thetimeunits value to convert returns converted time units in seconds.

    Parameters
    ----------
    theTimeBase: AVRational
    theTimeUnits: int64_t

    Returns
    -------
    double

    """
    return _Media.Media_FormatContext_UnitsToSeconds(*args)

class Media_Frame(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _Media.Media_Frame_swiginit(self, _Media.new_Media_Frame(*args))

    def BestEffortTimestamp(self, *args) -> "int64_t":
        r"""
        Returns frame timestamp estimated using various heuristics, in stream time base.

        Returns
        -------
        int64_t

        """
        return _Media.Media_Frame_BestEffortTimestamp(self, *args)

    def ChangeFrame(self, *args) -> "AVFrame *":
        r"""
        Return frame.

        Returns
        -------
        AVFrame *

        """
        return _Media.Media_Frame_ChangeFrame(self, *args)

    def Format(self, *args) -> "int":
        r"""
        Return pixel format (avpixelformat).

        Returns
        -------
        int

        """
        return _Media.Media_Frame_Format(self, *args)

    @staticmethod
    def FormatFFmpeg2Occt(*args) -> "Image_Format":
        r"""
        Convert pixel format from ffmpeg (avpixelformat) to occt.

        Parameters
        ----------
        theFormat: int

        Returns
        -------
        Image_Format

        """
        return _Media.Media_Frame_FormatFFmpeg2Occt(*args)

    @staticmethod
    def FormatOcct2FFmpeg(*args) -> "int":
        r"""
        Convert pixel format from occt to ffmpeg (avpixelformat). returns -1 (av_pix_fmt_none) if undefined.

        Parameters
        ----------
        theFormat: Image_Format

        Returns
        -------
        int

        """
        return _Media.Media_Frame_FormatOcct2FFmpeg(*args)

    def Frame(self, *args) -> "AVFrame const *":
        r"""
        Return frame.

        Returns
        -------
        AVFrame *

        """
        return _Media.Media_Frame_Frame(self, *args)

    def InitWrapper(self, *args) -> "bool":
        r"""
        Wrap allocated image pixmap.

        Parameters
        ----------
        thePixMap: Image_PixMap

        Returns
        -------
        bool

        """
        return _Media.Media_Frame_InitWrapper(self, *args)

    def IsEmpty(self, *args) -> "bool":
        r"""
        Return true if frame does not contain any data.

        Returns
        -------
        bool

        """
        return _Media.Media_Frame_IsEmpty(self, *args)

    def IsFullRangeYUV(self, *args) -> "bool":
        r"""
        Return true if yuv range is full.

        Returns
        -------
        bool

        """
        return _Media.Media_Frame_IsFullRangeYUV(self, *args)

    def IsLocked(self, *args) -> "bool":
        r"""
        Return locked state.

        Returns
        -------
        bool

        """
        return _Media.Media_Frame_IsLocked(self, *args)

    def LineSize(self, *args) -> "int":
        r"""
        Returns linesize in bytes for specified data plane.

        Parameters
        ----------
        thePlaneId: int

        Returns
        -------
        int

        """
        return _Media.Media_Frame_LineSize(self, *args)

    def PixelAspectRatio(self, *args) -> "float":
        r"""
        Return par.

        Returns
        -------
        float

        """
        return _Media.Media_Frame_PixelAspectRatio(self, *args)

    def Plane(self, *args) -> "uint8_t *":
        r"""
        Access data plane for specified id.

        Parameters
        ----------
        thePlaneId: int

        Returns
        -------
        uint8_t *

        """
        return _Media.Media_Frame_Plane(self, *args)

    def Pts(self, *args) -> "double":
        r"""
        Return presentation timestamp (pts).

        Returns
        -------
        double

        """
        return _Media.Media_Frame_Pts(self, *args)

    def SetLocked(self, *args) -> "void":
        r"""
        Lock/free frame for edition.

        Parameters
        ----------
        theToLock: bool

        Returns
        -------
        None

        """
        return _Media.Media_Frame_SetLocked(self, *args)

    def SetPixelAspectRatio(self, *args) -> "void":
        r"""
        Set par.

        Parameters
        ----------
        theRatio: float

        Returns
        -------
        None

        """
        return _Media.Media_Frame_SetPixelAspectRatio(self, *args)

    def SetPts(self, *args) -> "void":
        r"""
        Set presentation timestamp (pts).

        Parameters
        ----------
        thePts: double

        Returns
        -------
        None

        """
        return _Media.Media_Frame_SetPts(self, *args)

    def Size(self, *args) -> "Graphic3d_Vec2i":
        r"""
        Return image dimensions.

        Returns
        -------
        Graphic3d_Vec2i

        """
        return _Media.Media_Frame_Size(self, *args)

    def SizeX(self, *args) -> "int":
        r"""
        Return image width.

        Returns
        -------
        int

        """
        return _Media.Media_Frame_SizeX(self, *args)

    def SizeY(self, *args) -> "int":
        r"""
        Return image height.

        Returns
        -------
        int

        """
        return _Media.Media_Frame_SizeY(self, *args)

    @staticmethod
    def Swap(*args) -> "void":
        r"""
        Swap avframe* within two frames.

        Parameters
        ----------
        theFrame1: Media_Frame
        theFrame2: Media_Frame

        Returns
        -------
        None

        """
        return _Media.Media_Frame_Swap(*args)

    def Unref(self, *args) -> "void":
        r"""
        Av_frame_unref() wrapper.

        Returns
        -------
        None

        """
        return _Media.Media_Frame_Unref(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Frame_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Frame

# Register Media_Frame in _Media:
_Media.Media_Frame_swigregister(Media_Frame)

def Media_Frame_FormatFFmpeg2Occt(*args) -> "Image_Format":
    r"""
    Convert pixel format from ffmpeg (avpixelformat) to occt.

    Parameters
    ----------
    theFormat: int

    Returns
    -------
    Image_Format

    """
    return _Media.Media_Frame_FormatFFmpeg2Occt(*args)

def Media_Frame_FormatOcct2FFmpeg(*args) -> "int":
    r"""
    Convert pixel format from occt to ffmpeg (avpixelformat). returns -1 (av_pix_fmt_none) if undefined.

    Parameters
    ----------
    theFormat: Image_Format

    Returns
    -------
    int

    """
    return _Media.Media_Frame_FormatOcct2FFmpeg(*args)

def Media_Frame_Swap(*args) -> "void":
    r"""
    Swap avframe* within two frames.

    Parameters
    ----------
    theFrame1: Media_Frame
    theFrame2: Media_Frame

    Returns
    -------
    None

    """
    return _Media.Media_Frame_Swap(*args)

class Media_IFrameQueue(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def LockFrame(self, *args) -> "opencascade::handle< Media_Frame >":
        r"""
        Lock the frame, e.g. take ownership on a single (not currently displayed) frame from the queue to perform decoding into.

        Returns
        -------
        opencascade::handle<Media_Frame>

        """
        return _Media.Media_IFrameQueue_LockFrame(self, *args)

    def ReleaseFrame(self, *args) -> "void":
        r"""
        Release previously locked frame, e.g. it can be displayed on the screen.

        Parameters
        ----------
        theFrame: Media_Frame

        Returns
        -------
        None

        """
        return _Media.Media_IFrameQueue_ReleaseFrame(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_IFrameQueue

# Register Media_IFrameQueue in _Media:
_Media.Media_IFrameQueue_swigregister(Media_IFrameQueue)

class Media_Packet(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _Media.Media_Packet_swiginit(self, _Media.new_Media_Packet(*args))

    def ChangeData(self, *args) -> "uint8_t *":
        r"""
        Return data.

        Returns
        -------
        uint8_t *

        """
        return _Media.Media_Packet_ChangeData(self, *args)

    def ChangePacket(self, *args) -> "AVPacket *":
        r"""
        Return packet.

        Returns
        -------
        AVPacket *

        """
        return _Media.Media_Packet_ChangePacket(self, *args)

    def Data(self, *args) -> "uint8_t const *":
        r"""
        Return data.

        Returns
        -------
        uint8_t *

        """
        return _Media.Media_Packet_Data(self, *args)

    def Dts(self, *args) -> "int64_t":
        r"""
        Return decoding timestamp (dts).

        Returns
        -------
        int64_t

        """
        return _Media.Media_Packet_Dts(self, *args)

    def Duration(self, *args) -> "int64_t":
        r"""
        Return duration.

        Returns
        -------
        int64_t

        """
        return _Media.Media_Packet_Duration(self, *args)

    def DurationSeconds(self, *args) -> "double":
        r"""
        Return duration in seconds.

        Returns
        -------
        double

        """
        return _Media.Media_Packet_DurationSeconds(self, *args)

    def IsKeyFrame(self, *args) -> "bool":
        r"""
        Return true for a key frame.

        Returns
        -------
        bool

        """
        return _Media.Media_Packet_IsKeyFrame(self, *args)

    def Packet(self, *args) -> "AVPacket const *":
        r"""
        Return packet.

        Returns
        -------
        AVPacket *

        """
        return _Media.Media_Packet_Packet(self, *args)

    def Pts(self, *args) -> "int64_t":
        r"""
        Return presentation timestamp (pts).

        Returns
        -------
        int64_t

        """
        return _Media.Media_Packet_Pts(self, *args)

    def SetDurationSeconds(self, *args) -> "void":
        r"""
        Set duration in seconds.

        Parameters
        ----------
        theDurationSec: double

        Returns
        -------
        None

        """
        return _Media.Media_Packet_SetDurationSeconds(self, *args)

    def SetKeyFrame(self, *args) -> "void":
        r"""
        Mark as key frame.

        Returns
        -------
        None

        """
        return _Media.Media_Packet_SetKeyFrame(self, *args)

    def Size(self, *args) -> "int":
        r"""
        Return data size.

        Returns
        -------
        int

        """
        return _Media.Media_Packet_Size(self, *args)

    def StreamIndex(self, *args) -> "int":
        r"""
        Return stream index.

        Returns
        -------
        int

        """
        return _Media.Media_Packet_StreamIndex(self, *args)

    def Unref(self, *args) -> "void":
        r"""
        Av_packet_unref() wrapper.

        Returns
        -------
        None

        """
        return _Media.Media_Packet_Unref(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Packet_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Packet

# Register Media_Packet in _Media:
_Media.Media_Packet_swigregister(Media_Packet)

class Media_PlayerContext(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Main constructor. note that frame queue is stored as pointer, and it is expected that this context is stored as a class field of frame queue.

        Parameters
        ----------
        theFrameQueue: Media_IFrameQueue *

        Returns
        -------
        None

        """
        _Media.Media_PlayerContext_swiginit(self, _Media.new_Media_PlayerContext(*args))

    @staticmethod
    def DumpFirstFrame(*args) -> "bool":
        r"""
        Dump first video frame. @param thesrcvideo [in] path to the video @param themediainfo [out] video description.

        Parameters
        ----------
        theSrcVideo: TCollection_AsciiString
        theMediaInfo: TCollection_AsciiString

        Returns
        -------
        opencascade::handle<Media_Frame>
        Dump first video frame. @param thesrcvideo [in] path to the video @param theoutimage [in] path to make a screenshot @param themediainfo [out] video description @param themaxsize [in] when positive - downscales image to specified size.

        Parameters
        ----------
        theSrcVideo: TCollection_AsciiString
        theOutImage: TCollection_AsciiString
        theMediaInfo: TCollection_AsciiString
        theMaxSize: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _Media.Media_PlayerContext_DumpFirstFrame(*args)

    def Pause(self, *args) -> "void":
        r"""
        Pause playback.

        Returns
        -------
        None

        """
        return _Media.Media_PlayerContext_Pause(self, *args)

    def PlayPause(self, *args) -> "void":
        r"""
        Pause/pause playback depending on the current state.

        Parameters
        ----------

        Returns
        -------
        theIsPaused: bool
        theProgress: float
        theDuration: float

        """
        return _Media.Media_PlayerContext_PlayPause(self, *args)

    def PlaybackState(self, *args) -> "void":
        r"""
        Return playback state.

        Parameters
        ----------

        Returns
        -------
        theIsPaused: bool
        theProgress: float
        theDuration: float

        """
        return _Media.Media_PlayerContext_PlaybackState(self, *args)

    def Resume(self, *args) -> "void":
        r"""
        Resume playback.

        Returns
        -------
        None

        """
        return _Media.Media_PlayerContext_Resume(self, *args)

    def Seek(self, *args) -> "void":
        r"""
        Seek to specified position.

        Parameters
        ----------
        thePosSec: float

        Returns
        -------
        None

        """
        return _Media.Media_PlayerContext_Seek(self, *args)

    def SetForceRgb(self, *args) -> "void":
        r"""
        Set if queue requires rgb pixel format or can handle also yuv pixel format.

        Parameters
        ----------
        theToForce: bool

        Returns
        -------
        None

        """
        return _Media.Media_PlayerContext_SetForceRgb(self, *args)

    def SetInput(self, *args) -> "void":
        r"""
        Set new input for playback.

        Parameters
        ----------
        theInputPath: TCollection_AsciiString
        theToWait: bool

        Returns
        -------
        None

        """
        return _Media.Media_PlayerContext_SetInput(self, *args)

    def ToForceRgb(self, *args) -> "bool":
        r"""
        Return true if queue requires rgb pixel format or can handle also yuv pixel format; true by default.

        Returns
        -------
        bool

        """
        return _Media.Media_PlayerContext_ToForceRgb(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_PlayerContext_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_PlayerContext

# Register Media_PlayerContext in _Media:
_Media.Media_PlayerContext_swigregister(Media_PlayerContext)

def Media_PlayerContext_DumpFirstFrame(*args) -> "bool":
    r"""
    Dump first video frame. @param thesrcvideo [in] path to the video @param themediainfo [out] video description.

    Parameters
    ----------
    theSrcVideo: TCollection_AsciiString
    theMediaInfo: TCollection_AsciiString

    Returns
    -------
    opencascade::handle<Media_Frame>
    Dump first video frame. @param thesrcvideo [in] path to the video @param theoutimage [in] path to make a screenshot @param themediainfo [out] video description @param themaxsize [in] when positive - downscales image to specified size.

    Parameters
    ----------
    theSrcVideo: TCollection_AsciiString
    theOutImage: TCollection_AsciiString
    theMediaInfo: TCollection_AsciiString
    theMaxSize: int,optional
    	default value is 0

    Returns
    -------
    bool

    """
    return _Media.Media_PlayerContext_DumpFirstFrame(*args)

class Media_Scaler(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _Media.Media_Scaler_swiginit(self, _Media.new_Media_Scaler(*args))

    def Convert(self, *args) -> "bool":
        r"""
        Convert one frame to another.

        Parameters
        ----------
        theSrc: Media_Frame
        theRes: Media_Frame

        Returns
        -------
        bool

        """
        return _Media.Media_Scaler_Convert(self, *args)

    def Init(self, *args) -> "bool":
        r"""
        Sws_getcontext() wrapper - creates conversion context. @param thesrcdims dimensions of input frame @param thesrcformat pixel format (avpixelformat) of input frame @param theresdims dimensions of destination frame @param theresformat pixel format (avpixelformat) of destination frame.

        Parameters
        ----------
        theSrcDims: Graphic3d_Vec2i
        theSrcFormat: int
        theResDims: Graphic3d_Vec2i
        theResFormat: int

        Returns
        -------
        bool

        """
        return _Media.Media_Scaler_Init(self, *args)

    def IsValid(self, *args) -> "bool":
        r"""
        Return true if context was initialized.

        Returns
        -------
        bool

        """
        return _Media.Media_Scaler_IsValid(self, *args)

    def Release(self, *args) -> "void":
        r"""
        Sws_freecontext() wrapper.

        Returns
        -------
        None

        """
        return _Media.Media_Scaler_Release(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Scaler_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Scaler

# Register Media_Scaler in _Media:
_Media.Media_Scaler_swigregister(Media_Scaler)

class Media_Timer(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor.

        Returns
        -------
        None

        """
        _Media.Media_Timer_swiginit(self, _Media.new_Media_Timer(*args))

    def ElapsedTime(self, *args) -> "Standard_Real":
        r"""
        Return elapsed time in seconds.

        Returns
        -------
        float

        """
        return _Media.Media_Timer_ElapsedTime(self, *args)

    def IsStarted(self, *args) -> "Standard_Boolean":
        r"""
        Return true if timer has been started.

        Returns
        -------
        bool

        """
        return _Media.Media_Timer_IsStarted(self, *args)

    def Pause(self, *args) -> "void":
        r"""
        Pause the timer.

        Returns
        -------
        None

        """
        return _Media.Media_Timer_Pause(self, *args)

    def PlaybackSpeed(self, *args) -> "Standard_Real":
        r"""
        Return playback speed coefficient (1.0 means normal speed).

        Returns
        -------
        float

        """
        return _Media.Media_Timer_PlaybackSpeed(self, *args)

    def Seek(self, *args) -> "void":
        r"""
        Seek the timer to specified position.

        Parameters
        ----------
        theTime: float

        Returns
        -------
        None

        """
        return _Media.Media_Timer_Seek(self, *args)

    def SetPlaybackSpeed(self, *args) -> "void":
        r"""
        Setup playback speed coefficient.

        Parameters
        ----------
        theSpeed: float

        Returns
        -------
        None

        """
        return _Media.Media_Timer_SetPlaybackSpeed(self, *args)

    def Start(self, *args) -> "void":
        r"""
        Start the timer.

        Returns
        -------
        None

        """
        return _Media.Media_Timer_Start(self, *args)

    def Stop(self, *args) -> "void":
        r"""
        Stop the timer.

        Returns
        -------
        None

        """
        return _Media.Media_Timer_Stop(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Timer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Timer

# Register Media_Timer in _Media:
_Media.Media_Timer_swigregister(Media_Timer)





