# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Convert module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_convert.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Convert
else:
    import _Convert

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Convert.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _Convert.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Convert.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Convert.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _Convert.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _Convert.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _Convert.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _Convert.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _Convert.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _Convert.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Convert.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _Convert.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _Convert.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Convert.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Convert.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Convert.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _Convert.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Convert:
_Convert.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _Convert.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColgp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *

Convert_TgtThetaOver2 = _Convert.Convert_TgtThetaOver2
Convert_TgtThetaOver2_1 = _Convert.Convert_TgtThetaOver2_1
Convert_TgtThetaOver2_2 = _Convert.Convert_TgtThetaOver2_2
Convert_TgtThetaOver2_3 = _Convert.Convert_TgtThetaOver2_3
Convert_TgtThetaOver2_4 = _Convert.Convert_TgtThetaOver2_4
Convert_QuasiAngular = _Convert.Convert_QuasiAngular
Convert_RationalC1 = _Convert.Convert_RationalC1
Convert_Polynomial = _Convert.Convert_Polynomial


class Convert_ParameterisationType(IntEnum):
	Convert_TgtThetaOver2 = 0
	Convert_TgtThetaOver2_1 = 1
	Convert_TgtThetaOver2_2 = 2
	Convert_TgtThetaOver2_3 = 3
	Convert_TgtThetaOver2_4 = 4
	Convert_QuasiAngular = 5
	Convert_RationalC1 = 6
	Convert_Polynomial = 7
Convert_TgtThetaOver2 = Convert_ParameterisationType.Convert_TgtThetaOver2
Convert_TgtThetaOver2_1 = Convert_ParameterisationType.Convert_TgtThetaOver2_1
Convert_TgtThetaOver2_2 = Convert_ParameterisationType.Convert_TgtThetaOver2_2
Convert_TgtThetaOver2_3 = Convert_ParameterisationType.Convert_TgtThetaOver2_3
Convert_TgtThetaOver2_4 = Convert_ParameterisationType.Convert_TgtThetaOver2_4
Convert_QuasiAngular = Convert_ParameterisationType.Convert_QuasiAngular
Convert_RationalC1 = Convert_ParameterisationType.Convert_RationalC1
Convert_Polynomial = Convert_ParameterisationType.Convert_Polynomial

class Convert_SequenceOfArray1OfPoles(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HArray1OfPnt > >::iterator":
        return _Convert.Convert_SequenceOfArray1OfPoles_begin(self)

    def end(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HArray1OfPnt > >::iterator":
        return _Convert.Convert_SequenceOfArray1OfPoles_end(self)

    def cbegin(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HArray1OfPnt > >::const_iterator":
        return _Convert.Convert_SequenceOfArray1OfPoles_cbegin(self)

    def cend(self) -> "NCollection_Sequence< opencascade::handle< TColgp_HArray1OfPnt > >::const_iterator":
        return _Convert.Convert_SequenceOfArray1OfPoles_cend(self)

    def __init__(self, *args):
        _Convert.Convert_SequenceOfArray1OfPoles_swiginit(self, _Convert.new_Convert_SequenceOfArray1OfPoles(*args))

    def Size(self) -> "Standard_Integer":
        return _Convert.Convert_SequenceOfArray1OfPoles_Size(self)

    def Length(self) -> "Standard_Integer":
        return _Convert.Convert_SequenceOfArray1OfPoles_Length(self)

    def Lower(self) -> "Standard_Integer":
        return _Convert.Convert_SequenceOfArray1OfPoles_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _Convert.Convert_SequenceOfArray1OfPoles_Upper(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _Convert.Convert_SequenceOfArray1OfPoles_IsEmpty(self)

    def Reverse(self) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Reverse(self)

    def Exchange(self, I: "Standard_Integer const", J: "Standard_Integer const") -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_delNode(theNode, theAl)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Clear(self, theAllocator)

    def Assign(self, theOther: "Convert_SequenceOfArray1OfPoles") -> "NCollection_Sequence< opencascade::handle< TColgp_HArray1OfPnt > > &":
        return _Convert.Convert_SequenceOfArray1OfPoles_Assign(self, theOther)

    def Set(self, theOther: "Convert_SequenceOfArray1OfPoles") -> "NCollection_Sequence< opencascade::handle< TColgp_HArray1OfPnt > > &":
        return _Convert.Convert_SequenceOfArray1OfPoles_Set(self, theOther)

    def Remove(self, *args) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Remove(self, *args)

    def Append(self, *args) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Prepend(self, *args)

    def InsertBefore(self, *args) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_InsertAfter(self, *args)

    def Split(self, theIndex: "Standard_Integer const", theSeq: "Convert_SequenceOfArray1OfPoles") -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_Split(self, theIndex, theSeq)

    def First(self) -> "opencascade::handle< TColgp_HArray1OfPnt > const &":
        return _Convert.Convert_SequenceOfArray1OfPoles_First(self)

    def ChangeFirst(self) -> "opencascade::handle< TColgp_HArray1OfPnt > &":
        return _Convert.Convert_SequenceOfArray1OfPoles_ChangeFirst(self)

    def Last(self) -> "opencascade::handle< TColgp_HArray1OfPnt > const &":
        return _Convert.Convert_SequenceOfArray1OfPoles_Last(self)

    def ChangeLast(self) -> "opencascade::handle< TColgp_HArray1OfPnt > &":
        return _Convert.Convert_SequenceOfArray1OfPoles_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "opencascade::handle< TColgp_HArray1OfPnt > const &":
        return _Convert.Convert_SequenceOfArray1OfPoles_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "opencascade::handle< TColgp_HArray1OfPnt > &":
        return _Convert.Convert_SequenceOfArray1OfPoles_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "opencascade::handle< TColgp_HArray1OfPnt > &":
        return _Convert.Convert_SequenceOfArray1OfPoles___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "opencascade::handle< TColgp_HArray1OfPnt > const &") -> "void":
        return _Convert.Convert_SequenceOfArray1OfPoles_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _Convert.delete_Convert_SequenceOfArray1OfPoles

    def __len__(self):
        return self.Size()


# Register Convert_SequenceOfArray1OfPoles in _Convert:
_Convert.Convert_SequenceOfArray1OfPoles_swigregister(Convert_SequenceOfArray1OfPoles)

def Convert_SequenceOfArray1OfPoles_delNode(theNode: "NCollection_SeqNode *", theAl: "opencascade::handle< NCollection_BaseAllocator > &") -> "void":
    return _Convert.Convert_SequenceOfArray1OfPoles_delNode(theNode, theAl)

class Convert_CompBezierCurves2dToBSplineCurve2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a framework for converting a sequence of adjacent non-rational bezier curves into a bspline curve. knots will be created on the computed bspline curve at each junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. angulartolerance (given in radians, and defaulted to 1.0 e-4) will be used to check the parallelism of the two tangent vectors. use the following functions: - addcurve to define in sequence the adjacent bezier curves to be converted, - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve.

        Parameters
        ----------
        AngularTolerance: float,optional
        	default value is 1.0e-4

        Returns
        -------
        None

        """
        _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_swiginit(self, _Convert.new_Convert_CompBezierCurves2dToBSplineCurve2d(*args))

    def AddCurve(self, *args) -> "void":
        r"""
        Adds the bezier curve defined by the table of poles poles, to the sequence (still contained in this framework) of adjacent bezier curves to be converted into a bspline curve. only polynomial (i.e. non-rational) bezier curves are converted using this framework. if this is not the first call to the function (i.e. if this framework still contains data in its sequence of bezier curves), the degree of continuity of the bspline curve will be increased at the time of computation at the first point of the added bezier curve (i.e. the first point of the poles table). this will be the case if the tangent vector of the curve at this point is parallel to the tangent vector at the end point of the preceding bezier curve in the sequence of bezier curves still contained in this framework. an angular tolerance given at the time of construction of this framework, will be used to check the parallelism of the two tangent vectors. this checking procedure, and all the relative computations will be performed by the function perform. when the sequence of adjacent bezier curves is complete, use the following functions: - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve. warning the sequence of bezier curves treated by this framework is automatically initialized with the first bezier curve when the function is first called. during subsequent use of this function, ensure that the first point of the added bezier curve (i.e. the first point of the poles table) is coincident with the last point of the sequence (i.e. the last point of the preceding bezier curve in the sequence) of bezier curves still contained in this framework. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above, as this condition is not checked either when defining the sequence of bezier curves or at the time of computation.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_AddCurve(self, *args)

    def Degree(self, *args) -> "Standard_Integer":
        r"""
        Returns the degree of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_Degree(self, *args)

    def KnotsAndMults(self, *args) -> "void":
        r"""
        Loads the knots table with the knots and the mults table with the corresponding multiplicities of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the knots and mults arrays must be equal to the number of knots in the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above as these conditions are not checked, and an error may occur.

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_KnotsAndMults(self, *args)

    def NbKnots(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of knots of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_NbKnots(self, *args)

    def NbPoles(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of poles of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_NbPoles(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Computes all the data needed to build a bspline curve equivalent to the sequence of adjacent bezier curves still contained in this framework. a knot is inserted on the computed bspline curve at the junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. an angular tolerance given at the time of construction of this framework is used to check the parallelism of the two tangent vectors. use the available consultation functions to access the computed data. this data may then be used to construct the bspline curve. warning ensure that the curves in the sequence of bezier curves contained in this framework are adjacent. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above as this condition is not checked, either when defining the bezier curve sequence or at the time of computation.

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_Perform(self, *args)

    def Poles(self, *args) -> "void":
        r"""
        Loads the poles table with the poles of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the poles array must be equal to the number of poles of the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above, as these conditions are not checked, and an error may occur.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt2d

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurves2dToBSplineCurve2d_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CompBezierCurves2dToBSplineCurve2d

# Register Convert_CompBezierCurves2dToBSplineCurve2d in _Convert:
_Convert.Convert_CompBezierCurves2dToBSplineCurve2d_swigregister(Convert_CompBezierCurves2dToBSplineCurve2d)

class Convert_CompBezierCurvesToBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a framework for converting a sequence of adjacent non-rational bezier curves into a bspline curve. knots will be created on the computed bspline curve at each junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. angulartolerance (given in radians, and defaulted to 1.0 e-4) will be used to check the parallelism of the two tangent vectors. use the following functions: - addcurve to define in sequence the adjacent bezier curves to be converted, - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve.

        Parameters
        ----------
        AngularTolerance: float,optional
        	default value is 1.0e-4

        Returns
        -------
        None

        """
        _Convert.Convert_CompBezierCurvesToBSplineCurve_swiginit(self, _Convert.new_Convert_CompBezierCurvesToBSplineCurve(*args))

    def AddCurve(self, *args) -> "void":
        r"""
        Adds the bezier curve defined by the table of poles poles, to the sequence (still contained in this framework) of adjacent bezier curves to be converted into a bspline curve. only polynomial (i.e. non-rational) bezier curves are converted using this framework. if this is not the first call to the function (i.e. if this framework still contains data in its bezier curve sequence), the degree of continuity of the bspline curve will be increased at the time of computation at the first point of the added bezier curve (i.e. the first point of the poles table). this will be the case if the tangent vector of the curve at this point is parallel to the tangent vector at the end point of the preceding bezier curve in the bezier curve sequence still contained in this framework. an angular tolerance given at the time of construction of this framework will be used to check the parallelism of the two tangent vectors. this checking procedure and all related computations will be performed by the perform function. when the adjacent bezier curve sequence is complete, use the following functions: - perform to compute the data needed to build the bspline curve, - and the available consultation functions to access the computed data. this data may be used to construct the bspline curve. warning the bezier curve sequence treated by this framework is automatically initialized with the first bezier curve when the function is first called. during subsequent use of this function, ensure that the first point of the added bezier curve (i.e. the first point of the poles table) is coincident with the last point of the bezier curve sequence (i.e. the last point of the preceding bezier curve in the sequence) still contained in this framework. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above, as this condition is not checked either when defining the bezier curve sequence or at the time of computation.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_AddCurve(self, *args)

    def Degree(self, *args) -> "Standard_Integer":
        r"""
        Returns the degree of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_Degree(self, *args)

    def KnotsAndMults(self, *args) -> "void":
        r"""
        - loads the knots table with the knots, - and loads the mults table with the corresponding multiplicities of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the knots and mults arrays must be equal to the number of knots in the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above as these conditions are not checked, and an error may occur.

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_KnotsAndMults(self, *args)

    def NbKnots(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of knots of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_NbKnots(self, *args)

    def NbPoles(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of poles of the bspline curve whose data is computed in this framework. warning take particular care not to use this function before the computation is performed (perform function), as this condition is not checked and an error may therefore occur.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_NbPoles(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Computes all the data needed to build a bspline curve equivalent to the adjacent bezier curve sequence still contained in this framework. a knot is inserted on the computed bspline curve at the junction point of two consecutive bezier curves. the degree of continuity of the bspline curve will be increased at the junction point of two consecutive bezier curves if their tangent vectors at this point are parallel. an angular tolerance given at the time of construction of this framework is used to check the parallelism of the two tangent vectors. use the available consultation functions to access the computed data. this data may then be used to construct the bspline curve. warning make sure that the curves in the bezier curve sequence contained in this framework are adjacent. an error may occur at the time of computation if this condition is not satisfied. particular care must be taken with respect to the above as this condition is not checked, either when defining the bezier curve sequence or at the time of computation.

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_Perform(self, *args)

    def Poles(self, *args) -> "void":
        r"""
        Loads the poles table with the poles of the bspline curve whose data is computed in this framework. warning - do not use this function before the computation is performed (perform function). - the length of the poles array must be equal to the number of poles of the bspline curve whose data is computed in this framework. particular care must be taken with respect to the above, as these conditions are not checked, and an error may occur.

        Parameters
        ----------
        Poles: TColgp_Array1OfPnt

        Returns
        -------
        None

        """
        return _Convert.Convert_CompBezierCurvesToBSplineCurve_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CompBezierCurvesToBSplineCurve

# Register Convert_CompBezierCurvesToBSplineCurve in _Convert:
_Convert.Convert_CompBezierCurvesToBSplineCurve_swigregister(Convert_CompBezierCurvesToBSplineCurve)

class Convert_CompPolynomialToPoles(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Warning! continuity can be at most the maximum degree of the polynomial functions trueintervals : this is the true parameterisation for the composite curve that is : the curve has mycontinuity if the nth curve is parameterized between mytrueintervals(n) and mytrueintervals(n+1) //! coefficients have to be the implicit 'c form': coefficients[numcurves][maxdegree+1][dimension] //! warning! the numberofcoefficient of an polynome is his degree + 1 example: to convert the linear function f(x) = 2*x + 1 on the domaine [2,5] to bspline with the bound [-1,1]. arguments are : numcurves = 1; continuity = 1; dimension = 1; maxdegree = 1; numcoeffpercurve [1] = {2}; coefficients[2] = {1, 2}; polynomialintervals[1,2] = {{2,5}} trueintervals[2] = {-1, 1}.

        Parameters
        ----------
        NumCurves: int
        Continuity: int
        Dimension: int
        MaxDegree: int
        NumCoeffPerCurve: TColStd_HArray1OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialIntervals: TColStd_HArray2OfReal
        TrueIntervals: TColStd_HArray1OfReal

        Returns
        -------
        None
        To convert sevral span with different order of continuity. warning: the length of continuity have to be numcurves-1.

        Parameters
        ----------
        NumCurves: int
        Dimension: int
        MaxDegree: int
        Continuity: TColStd_Array1OfInteger
        NumCoeffPerCurve: TColStd_Array1OfInteger
        Coefficients: TColStd_Array1OfReal
        PolynomialIntervals: TColStd_Array2OfReal
        TrueIntervals: TColStd_Array1OfReal

        Returns
        -------
        None
        To convert only one span.

        Parameters
        ----------
        Dimension: int
        MaxDegree: int
        Degree: int
        Coefficients: TColStd_Array1OfReal
        PolynomialIntervals: TColStd_Array1OfReal
        TrueIntervals: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _Convert.Convert_CompPolynomialToPoles_swiginit(self, _Convert.new_Convert_CompPolynomialToPoles(*args))

    def Degree(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompPolynomialToPoles_Degree(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _Convert.Convert_CompPolynomialToPoles_IsDone(self, *args)

    def Knots(self, *args) -> "void":
        r"""
        Knots of the n-dimensional bspline.

        Parameters
        ----------
        K: TColStd_HArray1OfReal

        Returns
        -------
        None

        """
        return _Convert.Convert_CompPolynomialToPoles_Knots(self, *args)

    def Multiplicities(self, *args) -> "void":
        r"""
        Multiplicities of the knots in the bspline.

        Parameters
        ----------
        M: TColStd_HArray1OfInteger

        Returns
        -------
        None

        """
        return _Convert.Convert_CompPolynomialToPoles_Multiplicities(self, *args)

    def NbKnots(self, *args) -> "Standard_Integer":
        r"""
        Degree of the n-dimensional bspline.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompPolynomialToPoles_NbKnots(self, *args)

    def NbPoles(self, *args) -> "Standard_Integer":
        r"""
        Number of poles of the n-dimensional bspline.

        Returns
        -------
        int

        """
        return _Convert.Convert_CompPolynomialToPoles_NbPoles(self, *args)

    def Poles(self, *args) -> "void":
        r"""
        Returns the poles of the n-dimensional bspline in the following format : [1..numpoles][1..dimension].

        Parameters
        ----------
        Poles: TColStd_HArray2OfReal

        Returns
        -------
        None

        """
        return _Convert.Convert_CompPolynomialToPoles_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CompPolynomialToPoles

# Register Convert_CompPolynomialToPoles in _Convert:
_Convert.Convert_CompPolynomialToPoles_swigregister(Convert_CompPolynomialToPoles)

class Convert_ConicToBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def BuildCosAndSin(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Parametrisation: Convert_ParameterisationType
        CosNumerator: TColStd_HArray1OfReal
        SinNumerator: TColStd_HArray1OfReal
        Denominator: TColStd_HArray1OfReal
        Knots: TColStd_HArray1OfReal
        Mults: TColStd_HArray1OfInteger

        Returns
        -------
        Degree: int
        No available documentation.

        Parameters
        ----------
        Parametrisation: Convert_ParameterisationType
        UFirst: float
        ULast: float
        CosNumerator: TColStd_HArray1OfReal
        SinNumerator: TColStd_HArray1OfReal
        Denominator: TColStd_HArray1OfReal
        Knots: TColStd_HArray1OfReal
        Mults: TColStd_HArray1OfInteger

        Returns
        -------
        Degree: int

        """
        return _Convert.Convert_ConicToBSplineCurve_BuildCosAndSin(self, *args)

    def Degree(self, *args) -> "Standard_Integer":
        r"""
        Returns the degree of the bspline curve whose data is computed in this framework.

        Returns
        -------
        int

        """
        return _Convert.Convert_ConicToBSplineCurve_Degree(self, *args)

    def IsPeriodic(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the bspline curve whose data is computed in this framework is periodic.

        Returns
        -------
        bool

        """
        return _Convert.Convert_ConicToBSplineCurve_IsPeriodic(self, *args)

    def Knot(self, *args) -> "Standard_Real":
        r"""
        Returns the knot of index index to the knots table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the knots table of the bspline curve whose data is computed in this framework.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _Convert.Convert_ConicToBSplineCurve_Knot(self, *args)

    def Multiplicity(self, *args) -> "Standard_Integer":
        r"""
        Returns the multiplicity of the knot of index index to the knots table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the knots table of the bspline curve whose data is computed in this framework.

        Parameters
        ----------
        Index: int

        Returns
        -------
        int

        """
        return _Convert.Convert_ConicToBSplineCurve_Multiplicity(self, *args)

    def NbKnots(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of knots of the bspline curve whose data is computed in this framework.

        Returns
        -------
        int

        """
        return _Convert.Convert_ConicToBSplineCurve_NbKnots(self, *args)

    def NbPoles(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of poles of the bspline curve whose data is computed in this framework.

        Returns
        -------
        int

        """
        return _Convert.Convert_ConicToBSplineCurve_NbPoles(self, *args)

    def Pole(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the pole of index index to the poles table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the poles table of the bspline curve whose data is computed in this framework.

        Parameters
        ----------
        Index: int

        Returns
        -------
        gp_Pnt2d

        """
        return _Convert.Convert_ConicToBSplineCurve_Pole(self, *args)

    def Weight(self, *args) -> "Standard_Real":
        r"""
        Returns the weight of the pole of index index to the poles table of the bspline curve whose data is computed in this framework. exceptions standard_outofrange if index is outside the bounds of the poles table of the bspline curve whose data is computed in this framework.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _Convert.Convert_ConicToBSplineCurve_Weight(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ConicToBSplineCurve

# Register Convert_ConicToBSplineCurve in _Convert:
_Convert.Convert_ConicToBSplineCurve_swigregister(Convert_ConicToBSplineCurve)

class Convert_ElementarySurfaceToBSplineSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsUPeriodic(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_IsUPeriodic(self, *args)

    def IsVPeriodic(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the bspline surface whose data is computed in this framework is periodic in the u or v parametric direction.

        Returns
        -------
        bool

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_IsVPeriodic(self, *args)

    def NbUKnots(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbUKnots(self, *args)

    def NbUPoles(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbUPoles(self, *args)

    def NbVKnots(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of knots for the u or v parametric direction of the bspline surface whose data is computed in this framework .

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbVKnots(self, *args)

    def NbVPoles(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of poles for the u or v parametric direction of the bspline surface whose data is computed in this framework.

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_NbVPoles(self, *args)

    def Pole(self, *args) -> "gp_Pnt":
        r"""
        Returns the pole of index (uindex,vindex) to the poles table of the bspline surface whose data is computed in this framework. exceptions standard_outofrange if, for the bspline surface whose data is computed in this framework: - uindex is outside the bounds of the poles table in the u parametric direction, or - vindex is outside the bounds of the poles table in the v parametric direction.

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Returns
        -------
        gp_Pnt

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_Pole(self, *args)

    def UDegree(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_UDegree(self, *args)

    def UKnot(self, *args) -> "Standard_Real":
        r"""
        Returns the u-knot of range uindex. raised if uindex < 1 or uindex > nbuknots.

        Parameters
        ----------
        UIndex: int

        Returns
        -------
        float

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_UKnot(self, *args)

    def UMultiplicity(self, *args) -> "Standard_Integer":
        r"""
        Returns the multiplicity of the u-knot of range uindex. raised if uindex < 1 or uindex > nbuknots.

        Parameters
        ----------
        UIndex: int

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_UMultiplicity(self, *args)

    def VDegree(self, *args) -> "Standard_Integer":
        r"""
        Returns the degree for the u or v parametric direction of the bspline surface whose data is computed in this framework.

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_VDegree(self, *args)

    def VKnot(self, *args) -> "Standard_Real":
        r"""
        Returns the v-knot of range vindex. raised if vindex < 1 or vindex > nbvknots.

        Parameters
        ----------
        UIndex: int

        Returns
        -------
        float

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_VKnot(self, *args)

    def VMultiplicity(self, *args) -> "Standard_Integer":
        r"""
        Returns the multiplicity of the v-knot of range vindex. raised if vindex < 1 or vindex > nbvknots.

        Parameters
        ----------
        VIndex: int

        Returns
        -------
        int

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_VMultiplicity(self, *args)

    def Weight(self, *args) -> "Standard_Real":
        r"""
        Returns the weight of the pole of index (uindex,vindex) to the poles table of the bspline surface whose data is computed in this framework. exceptions standard_outofrange if, for the bspline surface whose data is computed in this framework: - uindex is outside the bounds of the poles table in the u parametric direction, or - vindex is outside the bounds of the poles table in the v parametric direction.

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Returns
        -------
        float

        """
        return _Convert.Convert_ElementarySurfaceToBSplineSurface_Weight(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ElementarySurfaceToBSplineSurface

# Register Convert_ElementarySurfaceToBSplineSurface in _Convert:
_Convert.Convert_ElementarySurfaceToBSplineSurface_swigregister(Convert_ElementarySurfaceToBSplineSurface)

class Convert_GridPolynomialToPoles(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        To only one polynomial surface. the length of <polynomialuintervals> and <polynomialvintervals> have to be 2. this values defined the parametric domain of the polynomial equation. //! coefficients : the <coefficients> have to be formated than an 'c array' [maxudegree+1] [maxvdegree+1] [3].

        Parameters
        ----------
        MaxUDegree: int
        MaxVDegree: int
        NumCoeff: TColStd_HArray1OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialUIntervals: TColStd_HArray1OfReal
        PolynomialVIntervals: TColStd_HArray1OfReal

        Returns
        -------
        None
        To one grid of polynomial surface. warning! continuity in each parametric direction can be at most the maximum degree of the polynomial functions. //! <trueuintervals>, <truevintervals> : this is the true parameterisation for the composite surface //! coefficients : the coefficients have to be formated than an 'c array' [nbvsurfaces] [nbusurfaces] [maxudegree+1] [maxvdegree+1] [3] raises domainerror if <numcoeffpersurface> is not a [1, nbvsurfaces*nbusurfaces, 1,2] array. if <coefficients> is not a.

        Parameters
        ----------
        NbUSurfaces: int
        NBVSurfaces: int
        UContinuity: int
        VContinuity: int
        MaxUDegree: int
        MaxVDegree: int
        NumCoeffPerSurface: TColStd_HArray2OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialUIntervals: TColStd_HArray1OfReal
        PolynomialVIntervals: TColStd_HArray1OfReal
        TrueUIntervals: TColStd_HArray1OfReal
        TrueVIntervals: TColStd_HArray1OfReal

        Returns
        -------
        None

        """
        _Convert.Convert_GridPolynomialToPoles_swiginit(self, _Convert.new_Convert_GridPolynomialToPoles(*args))

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _Convert.Convert_GridPolynomialToPoles_IsDone(self, *args)

    def NbUKnots(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_GridPolynomialToPoles_NbUKnots(self, *args)

    def NbUPoles(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_GridPolynomialToPoles_NbUPoles(self, *args)

    def NbVKnots(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_GridPolynomialToPoles_NbVKnots(self, *args)

    def NbVPoles(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_GridPolynomialToPoles_NbVPoles(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        UContinuity: int
        VContinuity: int
        MaxUDegree: int
        MaxVDegree: int
        NumCoeffPerSurface: TColStd_HArray2OfInteger
        Coefficients: TColStd_HArray1OfReal
        PolynomialUIntervals: TColStd_HArray1OfReal
        PolynomialVIntervals: TColStd_HArray1OfReal
        TrueUIntervals: TColStd_HArray1OfReal
        TrueVIntervals: TColStd_HArray1OfReal

        Returns
        -------
        None

        """
        return _Convert.Convert_GridPolynomialToPoles_Perform(self, *args)

    def Poles(self, *args) -> "opencascade::handle< TColgp_HArray2OfPnt > const &":
        r"""
        Returns the poles of the bspline surface.

        Returns
        -------
        opencascade::handle<TColgp_HArray2OfPnt>

        """
        return _Convert.Convert_GridPolynomialToPoles_Poles(self, *args)

    def UDegree(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_GridPolynomialToPoles_UDegree(self, *args)

    def UKnots(self, *args) -> "opencascade::handle< TColStd_HArray1OfReal > const &":
        r"""
        Knots in the u direction.

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        """
        return _Convert.Convert_GridPolynomialToPoles_UKnots(self, *args)

    def UMultiplicities(self, *args) -> "opencascade::handle< TColStd_HArray1OfInteger > const &":
        r"""
        Multiplicities of the knots in the u direction.

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfInteger>

        """
        return _Convert.Convert_GridPolynomialToPoles_UMultiplicities(self, *args)

    def VDegree(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _Convert.Convert_GridPolynomialToPoles_VDegree(self, *args)

    def VKnots(self, *args) -> "opencascade::handle< TColStd_HArray1OfReal > const &":
        r"""
        Knots in the v direction.

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        """
        return _Convert.Convert_GridPolynomialToPoles_VKnots(self, *args)

    def VMultiplicities(self, *args) -> "opencascade::handle< TColStd_HArray1OfInteger > const &":
        r"""
        Multiplicities of the knots in the v direction.

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfInteger>

        """
        return _Convert.Convert_GridPolynomialToPoles_VMultiplicities(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_GridPolynomialToPoles

# Register Convert_GridPolynomialToPoles in _Convert:
_Convert.Convert_GridPolynomialToPoles_swigregister(Convert_GridPolynomialToPoles)

class Convert_CircleToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The equivalent b-spline curve has the same orientation as the circle c.

        Parameters
        ----------
        C: gp_Circ2d
        Parameterisation: Convert_ParameterisationType,optional
        	default value is Convert_TgtThetaOver2

        Returns
        -------
        None
        The circle c is limited between the parametric values u1, u2 in radians. u1 and u2 [0.0, 2*pi] . the equivalent b-spline curve is oriented from u1 to u2 and has the same orientation as the circle c. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi.

        Parameters
        ----------
        C: gp_Circ2d
        U1: float
        U2: float
        Parameterisation: Convert_ParameterisationType,optional
        	default value is Convert_TgtThetaOver2

        Returns
        -------
        None

        """
        _Convert.Convert_CircleToBSplineCurve_swiginit(self, _Convert.new_Convert_CircleToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CircleToBSplineCurve

# Register Convert_CircleToBSplineCurve in _Convert:
_Convert.Convert_CircleToBSplineCurve_swigregister(Convert_CircleToBSplineCurve)

class Convert_ConeToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The equivalent b-spline surface as the same orientation as the cone in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2.

        Parameters
        ----------
        C: gp_Cone
        U1: float
        U2: float
        V1: float
        V2: float

        Returns
        -------
        None
        The equivalent b-spline surface as the same orientation as the cone in the u and v parametric directions. //! raised if v1 = v2.

        Parameters
        ----------
        C: gp_Cone
        V1: float
        V2: float

        Returns
        -------
        None

        """
        _Convert.Convert_ConeToBSplineSurface_swiginit(self, _Convert.new_Convert_ConeToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ConeToBSplineSurface

# Register Convert_ConeToBSplineSurface in _Convert:
_Convert.Convert_ConeToBSplineSurface_swigregister(Convert_ConeToBSplineSurface)

class Convert_CylinderToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The equivalent b-splinesurface as the same orientation as the cylinder in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2.

        Parameters
        ----------
        Cyl: gp_Cylinder
        U1: float
        U2: float
        V1: float
        V2: float

        Returns
        -------
        None
        The equivalent b-splinesurface as the same orientation as the cylinder in the u and v parametric directions. //! raised if v1 = v2.

        Parameters
        ----------
        Cyl: gp_Cylinder
        V1: float
        V2: float

        Returns
        -------
        None

        """
        _Convert.Convert_CylinderToBSplineSurface_swiginit(self, _Convert.new_Convert_CylinderToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_CylinderToBSplineSurface

# Register Convert_CylinderToBSplineSurface in _Convert:
_Convert.Convert_CylinderToBSplineSurface_swigregister(Convert_CylinderToBSplineSurface)

class Convert_EllipseToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The equivalent b-spline curve has the same orientation as the ellipse e.

        Parameters
        ----------
        E: gp_Elips2d
        Parameterisation: Convert_ParameterisationType,optional
        	default value is Convert_TgtThetaOver2

        Returns
        -------
        None
        The ellipse e is limited between the parametric values u1, u2. the equivalent b-spline curve is oriented from u1 to u2 and has the same orientation as e. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi.

        Parameters
        ----------
        E: gp_Elips2d
        U1: float
        U2: float
        Parameterisation: Convert_ParameterisationType,optional
        	default value is Convert_TgtThetaOver2

        Returns
        -------
        None

        """
        _Convert.Convert_EllipseToBSplineCurve_swiginit(self, _Convert.new_Convert_EllipseToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_EllipseToBSplineCurve

# Register Convert_EllipseToBSplineCurve in _Convert:
_Convert.Convert_EllipseToBSplineCurve_swigregister(Convert_EllipseToBSplineCurve)

class Convert_HyperbolaToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The hyperbola h is limited between the parametric values u1, u2 and the equivalent b-spline curve has the same orientation as the hyperbola.

        Parameters
        ----------
        H: gp_Hypr2d
        U1: float
        U2: float

        Returns
        -------
        None

        """
        _Convert.Convert_HyperbolaToBSplineCurve_swiginit(self, _Convert.new_Convert_HyperbolaToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_HyperbolaToBSplineCurve

# Register Convert_HyperbolaToBSplineCurve in _Convert:
_Convert.Convert_HyperbolaToBSplineCurve_swigregister(Convert_HyperbolaToBSplineCurve)

class Convert_ParabolaToBSplineCurve(Convert_ConicToBSplineCurve):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The parabola prb is limited between the parametric values u1, u2 and the equivalent b-spline curve as the same orientation as the parabola prb.

        Parameters
        ----------
        Prb: gp_Parab2d
        U1: float
        U2: float

        Returns
        -------
        None

        """
        _Convert.Convert_ParabolaToBSplineCurve_swiginit(self, _Convert.new_Convert_ParabolaToBSplineCurve(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_ParabolaToBSplineCurve

# Register Convert_ParabolaToBSplineCurve in _Convert:
_Convert.Convert_ParabolaToBSplineCurve_swigregister(Convert_ParabolaToBSplineCurve)

class Convert_SphereToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The equivalent b-spline surface as the same orientation as the sphere in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2.

        Parameters
        ----------
        Sph: gp_Sphere
        U1: float
        U2: float
        V1: float
        V2: float

        Returns
        -------
        None
        The equivalent b-spline surface as the same orientation as the sphere in the u and v parametric directions. //! raised if utrim = true and param1 = param2 or param1 = param2 + 2.0 * pi raised if utrim = false and param1 = param2.

        Parameters
        ----------
        Sph: gp_Sphere
        Param1: float
        Param2: float
        UTrim: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        The equivalent b-spline surface as the same orientation as the sphere in the u and v parametric directions.

        Parameters
        ----------
        Sph: gp_Sphere

        Returns
        -------
        None

        """
        _Convert.Convert_SphereToBSplineSurface_swiginit(self, _Convert.new_Convert_SphereToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_SphereToBSplineSurface

# Register Convert_SphereToBSplineSurface in _Convert:
_Convert.Convert_SphereToBSplineSurface_swigregister(Convert_SphereToBSplineSurface)

class Convert_TorusToBSplineSurface(Convert_ElementarySurfaceToBSplineSurface):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The equivalent b-spline surface as the same orientation as the torus in the u and v parametric directions. //! raised if u1 = u2 or u1 = u2 + 2.0 * pi raised if v1 = v2 or v1 = v2 + 2.0 * pi.

        Parameters
        ----------
        T: gp_Torus
        U1: float
        U2: float
        V1: float
        V2: float

        Returns
        -------
        None
        The equivalent b-spline surface as the same orientation as the torus in the u and v parametric directions. //! raised if param1 = param2 or param1 = param2 + 2.0 * pi.

        Parameters
        ----------
        T: gp_Torus
        Param1: float
        Param2: float
        UTrim: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        The equivalent b-spline surface as the same orientation as the torus in the u and v parametric directions.

        Parameters
        ----------
        T: gp_Torus

        Returns
        -------
        None

        """
        _Convert.Convert_TorusToBSplineSurface_swiginit(self, _Convert.new_Convert_TorusToBSplineSurface(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Convert.delete_Convert_TorusToBSplineSurface

# Register Convert_TorusToBSplineSurface in _Convert:
_Convert.Convert_TorusToBSplineSurface_swigregister(Convert_TorusToBSplineSurface)


Convert_SequenceOfArray1OfPoles2d=OCC.Core.TColgp.TColgp_SequenceOfArray1OfPnt2d



