/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.h2.command.Prepared;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.constraint.Constraint;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.result.SimpleRowValue;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.IndexHints;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    protected Column[] columns;
    protected CompareMode compareMode;
    protected boolean isHidden;
    private final HashMap<String, Column> columnMap;
    private final boolean persistIndexes;
    private final boolean persistData;
    private ArrayList<TriggerObject> triggers;
    private ArrayList<Constraint> constraints;
    private ArrayList<Sequence> sequences;
    private final CopyOnWriteArrayList<TableView> dependentViews = new CopyOnWriteArrayList();
    private ArrayList<TableSynonym> synonyms;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private volatile Row nullRow;
    private boolean tableExpression;

    protected Table(Schema schema, int n, String string, boolean bl, boolean bl2) {
        super(schema, n, string, 11);
        this.columnMap = schema.getDatabase().newStringMap();
        this.persistIndexes = bl;
        this.persistData = bl2;
        this.compareMode = schema.getDatabase().getCompareMode();
    }

    @Override
    public void rename(String string) {
        super.rename(string);
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                constraint.rebuild();
            }
        }
    }

    public boolean isView() {
        return false;
    }

    public abstract boolean lock(Session var1, boolean var2, boolean var3);

    public abstract void close(Session var1);

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, IndexColumn[] var4, IndexType var5, boolean var6, String var7);

    public Row getRow(Session session, long l) {
        return null;
    }

    public abstract void removeRow(Session var1, Row var2);

    public Row lockRow(Session session, Row row) {
        throw DbException.getUnsupportedException("lockRow()");
    }

    public abstract void truncate(Session var1);

    public abstract void addRow(Session var1, Row var2);

    public void updateRow(Session session, Row row, Row row2) {
        row2.setKey(row.getKey());
        this.removeRow(session, row);
        this.addRow(session, row2);
    }

    public abstract void checkSupportAlter();

    public abstract TableType getTableType();

    public abstract Index getScanIndex(Session var1);

    public Index getScanIndex(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return this.getScanIndex(session);
    }

    public abstract Index getUniqueIndex();

    public abstract ArrayList<Index> getIndexes();

    public Index getIndex(String string) {
        ArrayList<Index> arrayList = this.getIndexes();
        if (arrayList != null) {
            for (Index index : arrayList) {
                if (!index.getName().equals(string)) continue;
                return index;
            }
        }
        throw DbException.get(42112, string);
    }

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public abstract boolean isDeterministic();

    public abstract boolean canGetRowCount();

    public boolean canReference() {
        return true;
    }

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1);

    public abstract long getRowCountApproximation();

    public abstract long getDiskSpaceUsed();

    public Column getRowIdColumn() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    public boolean isQueryComparable() {
        return true;
    }

    public void addDependencies(HashSet<DbObject> hashSet) {
        if (hashSet.contains(this)) {
            return;
        }
        if (this.sequences != null) {
            hashSet.addAll(this.sequences);
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        for (Column column : this.columns) {
            column.isEverything(expressionVisitor);
        }
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                constraint.isEverything(expressionVisitor);
            }
        }
        hashSet.add(this);
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> arrayList = Utils.newSmallArrayList();
        ArrayList<Index> arrayList2 = this.getIndexes();
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        if (this.constraints != null) {
            arrayList.addAll(this.constraints);
        }
        if (this.triggers != null) {
            arrayList.addAll(this.triggers);
        }
        if (this.sequences != null) {
            arrayList.addAll(this.sequences);
        }
        arrayList.addAll(this.dependentViews);
        if (this.synonyms != null) {
            arrayList.addAll(this.synonyms);
        }
        ArrayList<Right> arrayList3 = this.database.getAllRights();
        for (Right right : arrayList3) {
            if (right.getGrantedObject() != this) continue;
            arrayList.add(right);
        }
        return arrayList;
    }

    protected void setColumns(Column[] columnArray) {
        this.columns = columnArray;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            int n = column.getType().getValueType();
            if (n == -1) {
                throw DbException.get(50004, column.getSQL(false));
            }
            column.setTable(this, i);
            String string = column.getName();
            if (this.columnMap.get(string) != null) {
                throw DbException.get(42121, string);
            }
            this.columnMap.put(string, column);
        }
    }

    public void renameColumn(Column column, String string) {
        for (Column column2 : this.columns) {
            if (column2 == column || !column2.getName().equals(string)) continue;
            throw DbException.get(42121, string);
        }
        this.columnMap.remove(column.getName());
        column.rename(string);
        this.columnMap.put(string, column);
    }

    public boolean isLockedExclusivelyBy(Session session) {
        return false;
    }

    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        Row row;
        Session.Savepoint savepoint = session.setSavepoint();
        int n = 0;
        rowList.reset();
        while (rowList.hasNext()) {
            if ((++n & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            row = rowList.next();
            rowList.next();
            try {
                this.removeRow(session, row);
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() == 90131 || dbException.getErrorCode() == 90112) {
                    session.rollbackTo(savepoint);
                }
                throw dbException;
            }
            session.log(this, (short)1, row);
        }
        rowList.reset();
        while (rowList.hasNext()) {
            if ((++n & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            rowList.next();
            row = rowList.next();
            try {
                this.addRow(session, row);
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() == 90131) {
                    session.rollbackTo(savepoint);
                }
                throw dbException;
            }
            session.log(this, (short)0, row);
        }
    }

    public CopyOnWriteArrayList<TableView> getDependentViews() {
        return this.dependentViews;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        Object object;
        while (!this.dependentViews.isEmpty()) {
            object = this.dependentViews.get(0);
            this.dependentViews.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.synonyms != null && !this.synonyms.isEmpty()) {
            object = this.synonyms.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.triggers != null && !this.triggers.isEmpty()) {
            object = this.triggers.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.constraints != null && !this.constraints.isEmpty()) {
            object = this.constraints.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedObject() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.sequences != null && !this.sequences.isEmpty()) {
            object = this.sequences.remove(0);
            if (this.database.getDependentTable((SchemaObject)object, this) != null) continue;
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
    }

    public void dropMultipleColumnsConstraintsAndIndexes(Session session, ArrayList<Column> arrayList) {
        HashSet<Constraint> hashSet = new HashSet<Constraint>();
        if (this.constraints != null) {
            for (Column arrayList22 : arrayList) {
                for (Constraint constraint : this.constraints) {
                    HashSet<Column> hashSet2 = constraint.getReferencedColumns(this);
                    if (!hashSet2.contains(arrayList22)) continue;
                    if (hashSet2.size() == 1) {
                        hashSet.add(constraint);
                        continue;
                    }
                    throw DbException.get(90083, constraint.getSQL(false));
                }
            }
        }
        HashSet hashSet3 = new HashSet();
        ArrayList<Index> arrayList2 = this.getIndexes();
        if (arrayList2 != null) {
            for (Column column : arrayList) {
                for (Index index : arrayList2) {
                    if (index.getCreateSQL() == null || index.getColumnIndex(column) < 0) continue;
                    if (index.getColumns().length == 1) {
                        hashSet3.add(index);
                        continue;
                    }
                    throw DbException.get(90083, index.getSQL(false));
                }
            }
        }
        for (Constraint constraint : hashSet) {
            session.getDatabase().removeSchemaObject(session, constraint);
        }
        Iterator<Object> iterator2 = hashSet3.iterator();
        while (iterator2.hasNext()) {
            Index index = (Index)iterator2.next();
            if (!this.getIndexes().contains(index)) continue;
            session.getDatabase().removeSchemaObject(session, index);
        }
    }

    public Row createRow(Value[] valueArray, int n) {
        return this.database.createRow(valueArray, n);
    }

    public Row getTemplateRow() {
        return this.createRow(new Value[this.columns.length], -1);
    }

    public SearchRow getTemplateSimpleRow(boolean bl) {
        if (bl) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    Row getNullRow() {
        Row row = this.nullRow;
        if (row == null) {
            Object[] objectArray = new Value[this.columns.length];
            Arrays.fill(objectArray, ValueNull.INSTANCE);
            this.nullRow = row = this.database.createRow((Value[])objectArray, 1);
        }
        return row;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getType() {
        return 0;
    }

    public Column getColumn(int n) {
        return this.columns[n];
    }

    public Column getColumn(String string) {
        Column column = this.columnMap.get(string);
        if (column == null) {
            throw DbException.get(42122, string);
        }
        return column;
    }

    public Column getColumn(String string, boolean bl) {
        Column column = this.columnMap.get(string);
        if (column == null && !bl) {
            throw DbException.get(42122, string);
        }
        return column;
    }

    public Column findColumn(String string) {
        return this.columnMap.get(string);
    }

    public boolean doesColumnExist(String string) {
        return this.columnMap.containsKey(string);
    }

    public PlanItem getBestPlanItem(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        PlanItem planItem = new PlanItem();
        planItem.setIndex(this.getScanIndex(session));
        planItem.cost = planItem.getIndex().getCost(session, null, tableFilterArray, n, null, allColumnsForPlan);
        Trace trace = session.getTrace();
        if (trace.isDebugEnabled()) {
            trace.debug("Table      :     potential plan item cost {0} index {1}", planItem.cost, planItem.getIndex().getPlanSQL());
        }
        ArrayList<Index> arrayList = this.getIndexes();
        IndexHints indexHints = Table.getIndexHints(tableFilterArray, n);
        if (arrayList != null && nArray != null) {
            int n2 = arrayList.size();
            for (int i = 1; i < n2; ++i) {
                Index index = arrayList.get(i);
                if (Table.isIndexExcludedByHints(indexHints, index)) continue;
                double d = index.getCost(session, nArray, tableFilterArray, n, sortOrder, allColumnsForPlan);
                if (trace.isDebugEnabled()) {
                    trace.debug("Table      :     potential plan item cost {0} index {1}", d, index.getPlanSQL());
                }
                if (!(d < planItem.cost)) continue;
                planItem.cost = d;
                planItem.setIndex(index);
            }
        }
        return planItem;
    }

    private static boolean isIndexExcludedByHints(IndexHints indexHints, Index index) {
        return indexHints != null && !indexHints.allowIndex(index);
    }

    private static IndexHints getIndexHints(TableFilter[] tableFilterArray, int n) {
        return tableFilterArray == null ? null : tableFilterArray[n].getIndexHints();
    }

    public Index findPrimaryKey() {
        ArrayList<Index> arrayList = this.getIndexes();
        if (arrayList != null) {
            for (Index index : arrayList) {
                if (!index.getIndexType().isPrimaryKey()) continue;
                return index;
            }
        }
        return null;
    }

    public Index getPrimaryKey() {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw DbException.get(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Value value;
            Value value2 = row.getValue(i);
            Column column = this.columns[i];
            if (column.getComputed()) {
                value2 = null;
                value = column.computeValue(session, row);
            }
            if ((value = column.validateConvertUpdateSequence(session, value2)) == value2) continue;
            row.setValue(i, value);
        }
    }

    private static void remove(ArrayList<? extends DbObject> arrayList, DbObject dbObject) {
        if (arrayList != null) {
            arrayList.remove(dbObject);
        }
    }

    public void removeIndex(Index index) {
        ArrayList<Index> arrayList = this.getIndexes();
        if (arrayList != null) {
            Table.remove(arrayList, index);
            if (index.getIndexType().isPrimaryKey()) {
                for (Column column : index.getColumns()) {
                    column.setPrimaryKey(false);
                }
            }
        }
    }

    public void removeDependentView(TableView tableView) {
        this.dependentViews.remove(tableView);
    }

    public void removeSynonym(TableSynonym tableSynonym) {
        Table.remove(this.synonyms, tableSynonym);
    }

    public void removeConstraint(Constraint constraint) {
        Table.remove(this.constraints, constraint);
    }

    public final void removeSequence(Sequence sequence) {
        Table.remove(this.sequences, sequence);
    }

    public void removeTrigger(TriggerObject triggerObject) {
        Table.remove(this.triggers, triggerObject);
    }

    public void addDependentView(TableView tableView) {
        this.dependentViews.add(tableView);
    }

    public void addSynonym(TableSynonym tableSynonym) {
        this.synonyms = Table.add(this.synonyms, tableSynonym);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || !this.constraints.contains(constraint)) {
            this.constraints = Table.add(this.constraints, constraint);
        }
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = Table.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject triggerObject) {
        this.triggers = Table.add(this.triggers, triggerObject);
    }

    private static <T> ArrayList<T> add(ArrayList<T> arrayList, T t) {
        if (arrayList == null) {
            arrayList = Utils.newSmallArrayList();
        }
        arrayList.add(t);
        return arrayList;
    }

    public void fire(Session session, int n, boolean bl) {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                triggerObject.fire(session, n, bl);
            }
        }
    }

    public boolean hasSelectTrigger() {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                if (!triggerObject.isSelectTrigger()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasInsteadOfTrigger() {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                if (!triggerObject.isInsteadOf()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fireRow() {
        return this.constraints != null && !this.constraints.isEmpty() || this.triggers != null && !this.triggers.isEmpty();
    }

    public boolean fireBeforeRow(Session session, Row row, Row row2) {
        boolean bl = this.fireRow(session, row, row2, true, false);
        this.fireConstraints(session, row, row2, true);
        return bl;
    }

    private void fireConstraints(Session session, Row row, Row row2, boolean bl) {
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (constraint.isBefore() != bl) continue;
                constraint.checkRow(session, this, row, row2);
            }
        }
    }

    public void fireAfterRow(Session session, Row row, Row row2, boolean bl) {
        this.fireRow(session, row, row2, false, bl);
        if (!bl) {
            this.fireConstraints(session, row, row2, false);
        }
    }

    private boolean fireRow(Session session, Row row, Row row2, boolean bl, boolean bl2) {
        if (this.triggers != null) {
            for (TriggerObject triggerObject : this.triggers) {
                boolean bl3 = triggerObject.fireRow(session, this, row, row2, bl, bl2);
                if (!bl3) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean bl, boolean bl2) {
        if (bl && bl2 && this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                constraint.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = bl;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean bl, boolean bl2) {
        ArrayList<Index> arrayList = this.getIndexes();
        Index index = null;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                Index index2 = arrayList.get(i);
                if (bl && !index2.canGetFirstOrLast() || bl2 && !index2.canFindNext() || !index2.isFirstColumn(column) || index != null && index.getColumns().length <= index2.getColumns().length) continue;
                index = index2;
            }
        }
        return index;
    }

    public boolean getOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean bl) {
        this.onCommitDrop = bl;
    }

    public boolean getOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean bl) {
        this.onCommitTruncate = bl;
    }

    public void removeIndexOrTransferOwnership(Session session, Index index) {
        boolean bl = false;
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (!constraint.usesIndex(index)) continue;
                constraint.setIndexOwner(index);
                this.database.updateMeta(session, constraint);
                bl = true;
            }
        }
        if (!bl) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public void removeColumnExpressionsDependencies(Session session) {
        for (Column column : this.columns) {
            column.setDefaultExpression(session, null);
            column.setOnUpdateExpression(session, null);
            column.removeCheckConstraint();
        }
    }

    public ArrayList<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        return null;
    }

    public boolean isPersistIndexes() {
        return this.persistIndexes;
    }

    public boolean isPersistData() {
        return this.persistData;
    }

    public int compareValues(Value value, Value value2) {
        return value.compareTo(value2, this.database, this.compareMode);
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void checkWritingAllowed() {
        this.database.checkWritingAllowed();
    }

    private static Value getGeneratedValue(Session session, Column column, Expression expression) {
        Value value = expression == null ? column.validateConvertUpdateSequence(session, null) : expression.getValue(session);
        return column.convert(value, false);
    }

    public Value getDefaultValue(Session session, Column column) {
        return Table.getGeneratedValue(session, column, column.getDefaultExpression());
    }

    public Value getOnUpdateValue(Session session, Column column) {
        return Table.getGeneratedValue(session, column, column.getOnUpdateExpression());
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public boolean isMVStore() {
        return false;
    }

    public void setTableExpression(boolean bl) {
        this.tableExpression = bl;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }
}

