/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.tool.Listener;

public class BlacklistButton
extends Button {
    private final Image offImage = new Image(this.getClass().getResourceAsStream("/mediathek/res/programm/button-blacklist-aus.png"), 0.0, 18.0, true, true);
    private final ImageView offImageView = new ImageView(this.offImage);
    private final Image onImage = new Image(this.getClass().getResourceAsStream("/mediathek/res/programm/button-blacklist-ein.png"), 0.0, 18.0, true, true);
    private final ImageView onImageView = new ImageView(this.onImage);
    private final BooleanProperty activeProperty = new SimpleBooleanProperty(false);
    private final Tooltip tooltipOn = new Tooltip("Blacklist ausschalten");
    private final Tooltip tooltipOff = new Tooltip("Blacklist einschalten");

    public BlacklistButton() {
        boolean isOn = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ON));
        if (isOn) {
            this.setupOn();
        } else {
            this.setupOff();
        }
        this.activeProperty.addListener((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.setupOn();
            } else {
                this.setupOff();
            }
        });
        this.activeProperty.setValue(isOn);
        this.activeProperty.addListener((observable2, oldValue, newValue) -> SwingUtilities.invokeLater(() -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ON, Boolean.toString(newValue));
            Daten.getInstance().getListeBlacklist().filterListe();
            Listener.notify(39, BlacklistButton.class.getSimpleName());
        }));
        this.setOnAction(value -> this.activeProperty.setValue(this.activeProperty.getValue() == false));
        Listener.addListener(new Listener(39, BlacklistButton.class.getSimpleName()){

            @Override
            public void ping() {
                boolean on = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ON));
                Platform.runLater(() -> BlacklistButton.this.activeProperty.setValue(on));
            }
        });
    }

    private void setupOn() {
        this.setGraphic(this.onImageView);
        this.setTooltip(this.tooltipOn);
    }

    private void setupOff() {
        this.setGraphic(this.offImageView);
        this.setTooltip(this.tooltipOff);
    }
}

