/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.config.Icons;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log;
import org.apache.commons.lang3.SystemUtils;

public class DialogZiel
extends JDialog {
    public boolean ok = false;
    public String ziel;
    private final Dialog parent;
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JTextField jTextFieldPfad;

    public DialogZiel(Dialog pparent, boolean modal, String ziel, String titel) {
        super(pparent, modal);
        this.parent = pparent;
        this.initComponents();
        this.jButtonZiel.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.setTitle(titel);
        this.jButtonOk.addActionListener(new OkBeobachter());
        this.jButtonAbbrechen.addActionListener(new AbbrechenBeobachter());
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        this.jTextFieldPfad.setText(ziel);
        this.ziel = ziel;
        if (pparent != null) {
            this.setLocationRelativeTo(pparent);
        }
        EscapeKeyHandler.installHandler(this, () -> {
            this.ok = false;
            this.dispose();
        });
    }

    void check() {
        boolean ret = false;
        String pfad = this.jTextFieldPfad.getText();
        if (!pfad.isEmpty()) {
            try {
                int ook = new File(pfad).exists() ? JOptionPane.showConfirmDialog(this, "Datei:  \"" + pfad + "\"  existiert bereits", "\u00dcberschreiben?", 0) : 0;
                if (ook == 0) {
                    this.ziel = pfad;
                    ret = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ok = ret;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.jButtonZiel = new JButton();
        this.jTextFieldPfad = new JTextField();
        JLabel jLabel1 = new JLabel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonOk = new JButton();
        this.setDefaultCloseOperation(2);
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonZiel.setToolTipText("Zielpfad ausw\u00e4hlen");
        jLabel1.setText("Zielpfad:");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPfad, -1, 300, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(this.jButtonZiel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldPfad);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonOk.setText("Ok");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private class OkBeobachter
    implements ActionListener {
        private OkBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogZiel.this.check();
            DialogZiel.this.beenden();
        }
    }

    private class AbbrechenBeobachter
    implements ActionListener {
        private AbbrechenBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogZiel.this.ok = false;
            DialogZiel.this.beenden();
        }
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog(DialogZiel.this.parent, "Logdatei speichern");
                chooser.setMode(1);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        DialogZiel.this.jTextFieldPfad.setText(destination.getAbsolutePath());
                        DialogZiel.this.ziel = DialogZiel.this.jTextFieldPfad.getText();
                    }
                    catch (Exception ex) {
                        Log.errorLog(642109058, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!DialogZiel.this.jTextFieldPfad.getText().isEmpty()) {
                    chooser.setCurrentDirectory(new File(DialogZiel.this.jTextFieldPfad.getText()));
                } else {
                    chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
                }
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        DialogZiel.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(642109058, ex);
                    }
                }
            }
        }
    }
}

