/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import com.google.common.base.Stopwatch;
import com.jidesoft.utils.ThreadCheckingRepaintManager;
import com.zaxxer.sansorm.SansOrm;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Security;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.control.Alert;
import javafx.stage.Modality;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mediathek.SplashScreen;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenFilm;
import mediathek.daten.PooledDatabaseConnection;
import mediathek.gui.dialog.DialogStarteinstellungen;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mac.MediathekGuiMac;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.Functions;
import mediathek.tool.Log;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MemoryUtils;
import mediathek.tool.ReplaceList;
import mediathek.tool.SingleInstance;
import mediathek.tool.UIProgressState;
import mediathek.windows.MediathekGuiWindows;
import mediathek.x11.MediathekGuiX11;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import picocli.CommandLine;

public class Main {
    private static final String MAC_SYSTEM_PROPERTY_APPLE_LAF_USE_SCREEN_MENU_BAR = "apple.laf.useScreenMenuBar";
    private static final Logger logger = LogManager.getLogger(Main.class);
    public static Optional<SplashScreen> splashScreen = Optional.empty();

    private static void cleanupOsxFiles() {
        if (!Config.isPortableMode()) {
            try {
                Path oldFilmList = Paths.get(Daten.getSettingsDirectory_String(), "filme.json");
                Files.deleteIfExists(oldFilmList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void printJvmParameters() {
        logger.info("=== JavaVM Parameter ===");
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        for (String arg : jvmArgs) {
            System.out.println(arg);
        }
        logger.info("========================");
    }

    private static void printArguments(String ... aArguments) {
        for (String argument : aArguments) {
            logger.info("Startparameter: {}", (Object)argument);
        }
    }

    private static void setupLogging() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext(false);
        Configuration config = loggerContext.getConfiguration();
        String path = !Config.isPortableMode() ? Daten.getSettingsDirectory_String() + "/mediathekview.log" : Config.baseFilePath + "/mediathekview.log";
        PatternLayout consolePattern = Config.isEnhancedLoggingEnabled() || Config.isDebugModeEnabled() ? PatternLayout.newBuilder().withPattern("[%-5level] [%t] %c - %msg%n").build() : PatternLayout.newBuilder().withPattern(". %msg%n").build();
        ConsoleAppender consoleAppender = ConsoleAppender.createDefaultAppenderForLayout(consolePattern);
        if (!Config.isEnhancedLoggingEnabled() && !Config.isDebugModeEnabled()) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter(Level.INFO, Filter.Result.ACCEPT, Filter.Result.DENY);
            consoleAppender.addFilter(thresholdFilter);
        }
        consoleAppender.start();
        FileAppender.Builder fileAppenderBuilder = (FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("LogFile")).withAppend(false)).withFileName(path)).setLayout(PatternLayout.newBuilder().withPattern("%-5p %d  [%t] %C{2} (%F:%L) - %m%n").build())).setConfiguration(config);
        if (!Config.isEnhancedLoggingEnabled() && !Config.isDebugModeEnabled()) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter(Level.DEBUG, Filter.Result.ACCEPT, Filter.Result.DENY);
            fileAppenderBuilder.setFilter(thresholdFilter);
        }
        AsyncAppender asyncAppender = null;
        if (!Config.isFileLoggingDisabled()) {
            FileAppender fileAppender = fileAppenderBuilder.build();
            fileAppender.start();
            config.addAppender(fileAppender);
            asyncAppender = AsyncAppender.newBuilder().setName("Async").setAppenderRefs(new AppenderRef[]{AppenderRef.createAppenderRef(fileAppender.getName(), null, null)}).setConfiguration(config).setIncludeLocation(true).setBlocking(false).build();
            asyncAppender.start();
            config.addAppender(asyncAppender);
        }
        org.apache.logging.log4j.core.Logger rootLogger = loggerContext.getRootLogger();
        rootLogger.setLevel(Level.TRACE);
        rootLogger.addAppender(consoleAppender);
        if (!Config.isFileLoggingDisabled()) {
            rootLogger.addAppender(asyncAppender);
        }
        loggerContext.updateLoggers();
    }

    private static void setupPortableMode() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean portableMode = Config.isPortableMode();
        logger.info("Portable Mode: {}", (Object)portableMode);
        if (portableMode) {
            logger.trace("Configuring baseFilePath {} for portable mode", (Object)Config.baseFilePath);
            Daten.getInstance(Config.baseFilePath);
        } else {
            logger.trace("Configuring for non-portable mode");
            Daten.getInstance();
        }
        stopwatch.stop();
        logger.trace("setupPortableMode: {}", (Object)stopwatch);
    }

    private static String queryNimbusLaFName() {
        String systemLaF = UIManager.getSystemLookAndFeelClassName();
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                systemLaF = info.getClassName();
                break;
            }
        }
        catch (Exception e) {
            systemLaF = UIManager.getSystemLookAndFeelClassName();
        }
        return systemLaF;
    }

    private static void setSystemLookAndFeel() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return;
        }
        String laf = System.getProperty("swing.defaultlaf");
        if (laf == null || laf.isEmpty()) {
            logger.trace("L&F property is empty, setting L&F");
            String systemLaF = UIManager.getSystemLookAndFeelClassName();
            if (SystemUtils.IS_OS_LINUX) {
                systemLaF = Main.queryNimbusLaFName();
            }
            try {
                UIManager.setLookAndFeel(systemLaF);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                logger.error("L&F error: ", (Throwable)e);
            }
        }
    }

    private static void setupEnvironmentProperties() {
        System.setProperty("file.encoding", "UTF-8");
        Security.setProperty("crypto.policy", "unlimited");
    }

    private static void printVersionInformation() {
        String[] java;
        FastDateFormat formatter = FastDateFormat.getInstance("dd.MM.yyyy HH:mm:ss");
        logger.debug("=== Java Information ===");
        logger.info("Programmstart: {}", (Object)formatter.format(Log.startZeit));
        logger.info("Version: {}", (Object)Konstanten.MVVERSION);
        long maxMem = Runtime.getRuntime().maxMemory();
        logger.debug("maxMemory: {} MB", (Object)(maxMem / 0x100000L));
        logger.debug("Java:");
        for (String ja : java = Functions.getJavaVersion()) {
            logger.debug(ja);
        }
        logger.debug("===");
    }

    public static void main(String ... args2) {
        Main.setupEnvironmentProperties();
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Diese Version von MediathekView unterst\u00fctzt keine Kommandozeilenausf\u00fchrung.");
            System.exit(1);
        }
        CommandLine cmd = new CommandLine(Config.class);
        try {
            CommandLine.ParseResult parseResult = cmd.parseArgs(args2);
            if (parseResult.isUsageHelpRequested()) {
                cmd.usage(System.out);
                System.exit(cmd.getCommandSpec().exitCodeOnUsageHelp());
            }
            Config.setPortableMode(parseResult.hasMatchedPositional(0));
            Main.setupLogging();
            Main.setupPortableMode();
            Main.printVersionInformation();
            Main.printJvmParameters();
            Main.printArguments(args2);
        }
        catch (CommandLine.ParameterException ex) {
            cmd.getErr().println(ex.getMessage());
            if (!CommandLine.UnmatchedArgumentException.printSuggestions(ex, cmd.getErr())) {
                ex.getCommandLine().usage(cmd.getErr());
            }
            System.exit(cmd.getCommandSpec().exitCodeOnInvalidInput());
        }
        catch (Exception ex) {
            logger.error("Command line parse error:", (Throwable)ex);
            System.exit(cmd.getCommandSpec().exitCodeOnExecutionException());
        }
        Main.printDirectoryPaths();
        Main.initializeJavaFX();
        Main.checkMemoryRequirements();
        Main.installSingleInstanceHandler();
        Main.setSystemLookAndFeel();
        splashScreen = Optional.of(new SplashScreen());
        splashScreen.ifPresent(SplashScreen::show);
        Main.loadConfigurationData();
        Daten.getInstance().launchHistoryDataLoading();
        Main.deleteDatabase();
        if (MemoryUtils.isLowMemoryEnvironment()) {
            Main.setupDatabase();
            DatenFilm.Database.initializeDatabase();
        }
        Main.startGuiMode();
    }

    private static void initializeJavaFX() {
        Platform.setImplicitExit(false);
        JFXPanel dummy = new JFXPanel();
    }

    private static void loadConfigurationData() {
        Daten daten = Daten.getInstance();
        if (!daten.allesLaden()) {
            ReplaceList.init();
            splashScreen.ifPresent(SplashScreen::close);
            DialogStarteinstellungen dialog = new DialogStarteinstellungen(null, daten);
            dialog.setVisible(true);
            MVConfig.loadSystemParameter();
        }
    }

    private static void printDirectoryPaths() {
        logger.trace("Programmpfad: " + MVFunctionSys.getPathJar());
        logger.info("Verzeichnis Einstellungen: " + Daten.getSettingsDirectory_String());
    }

    private static void deleteDatabase() {
        if (!MemoryUtils.isLowMemoryEnvironment()) {
            try {
                String dbLocation = PooledDatabaseConnection.getDatabaseLocation() + "mediathekview.mv.db";
                Files.deleteIfExists(Paths.get(dbLocation, new String[0]));
            }
            catch (IOException e) {
                logger.error("deleteDatabase()", (Throwable)e);
            }
        }
    }

    private static void setupDatabase() {
        logger.trace("setupDatabase()");
        SansOrm.initializeTxSimple(PooledDatabaseConnection.getInstance().getDataSource());
    }

    private static void installSingleInstanceHandler() {
        SingleInstance singleInstanceWatcher = new SingleInstance();
        if (singleInstanceWatcher.isAppAlreadyActive()) {
            JavaFxUtils.invokeInFxThreadAndWait(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("MediathekView");
                alert.setHeaderText("MediathekView wird bereits ausgef\u00fchrt");
                alert.setContentText("Es d\u00fcrfen nicht mehrere Programme gleichzeitig laufen.\nBitte beenden Sie die andere Instanz.");
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.showAndWait();
            });
            System.exit(1);
        }
    }

    private static void checkForOfficialOSXAppUse() {
        String osxOfficialApp = System.getProperty("OSX_OFFICIAL_APP");
        if (osxOfficialApp == null || osxOfficialApp.isEmpty() || osxOfficialApp.equalsIgnoreCase("false")) {
            logger.warn("WARN: macOS app NOT launched from official launcher!");
        }
    }

    private static void checkMemoryRequirements() {
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem < 471859200L) {
            if (SystemUtils.isJavaAwtHeadless()) {
                System.err.println("Die VM hat nicht gen\u00fcgend Arbeitsspeicher zugewiesen bekommen.");
                System.err.println("Nutzen Sie den Startparameter -Xmx512M f\u00fcr Minimumspeicher");
            } else {
                JavaFxUtils.invokeInFxThreadAndWait(() -> {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("MediathekView");
                    alert.setHeaderText("Speicherwarnung");
                    alert.setContentText("MediathekView hat nicht gen\u00fcgend Arbeitsspeicher zugewiesen bekommen.\nEs werden mindestens 512MB RAM ben\u00f6tigt.");
                    alert.showAndWait();
                });
            }
            System.exit(3);
        }
    }

    private static void startGuiMode() {
        SwingUtilities.invokeLater(() -> {
            splashScreen.ifPresent(s2 -> s2.update(UIProgressState.INIT_FX));
            splashScreen.ifPresent(s2 -> s2.update(UIProgressState.FILE_CLEANUP));
            if (SystemUtils.IS_OS_MAC_OSX) {
                Main.checkForOfficialOSXAppUse();
                System.setProperty(MAC_SYSTEM_PROPERTY_APPLE_LAF_USE_SCREEN_MENU_BAR, Boolean.TRUE.toString());
                Main.cleanupOsxFiles();
            }
            if (Config.isDebugModeEnabled()) {
                RepaintManager.setCurrentManager(new ThreadCheckingRepaintManager());
                logger.info("Swing Thread checking repaint manager installed.");
            }
            splashScreen.ifPresent(s2 -> s2.update(UIProgressState.START_UI));
            MediathekGui window = Main.getPlatformWindow();
            splashScreen.ifPresent(SplashScreen::close);
            window.setVisible(true);
            if (SystemUtils.IS_OS_WINDOWS) {
                window.toFront();
                window.requestFocus();
            }
        });
    }

    private static MediathekGui getPlatformWindow() {
        MediathekGui window;
        Stopwatch watch = Stopwatch.createStarted();
        if (SystemUtils.IS_OS_MAC_OSX) {
            window = new MediathekGuiMac();
        } else if (SystemUtils.IS_OS_WINDOWS) {
            window = new MediathekGuiWindows();
        } else if (SystemUtils.IS_OS_UNIX) {
            window = new MediathekGuiX11();
        } else {
            throw new IllegalStateException("Unknown operating system detected! Cannot create main window");
        }
        watch.stop();
        logger.trace("getPlatformWindow(): {}", (Object)watch);
        return window;
    }
}

