/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.SkinBase;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.controlsfx.control.HyperlinkLabel;

public class HyperlinkLabelSkin
extends SkinBase<HyperlinkLabel> {
    private static final String HYPERLINK_START = "[";
    private static final String HYPERLINK_END = "]";
    private final TextFlow textFlow;
    private final EventHandler<ActionEvent> eventHandler = new EventHandler<ActionEvent>(){

        @Override
        public void handle(ActionEvent event) {
            EventHandler<ActionEvent> onActionHandler = ((HyperlinkLabel)HyperlinkLabelSkin.this.getSkinnable()).getOnAction();
            if (onActionHandler != null) {
                onActionHandler.handle(event);
            }
        }
    };

    public HyperlinkLabelSkin(HyperlinkLabel control) {
        super(control);
        this.textFlow = new TextFlow();
        this.getChildren().add(this.textFlow);
        this.updateText();
        this.registerChangeListener(control.textProperty(), e -> this.updateText());
    }

    private void updateText() {
        String text = ((HyperlinkLabel)this.getSkinnable()).getText();
        if (text == null || text.isEmpty()) {
            this.textFlow.getChildren().clear();
            return;
        }
        ArrayList<Labeled> nodes = new ArrayList<Labeled>();
        int start = 0;
        int textLength = text.length();
        while (start != -1 && start < textLength) {
            Node label;
            int startPos = text.indexOf(HYPERLINK_START, start);
            int endPos = text.indexOf(HYPERLINK_END, startPos);
            if ((startPos == -1 || endPos == -1) && textLength > start) {
                label = new Label(text.substring(start));
                nodes.add((Labeled)label);
                break;
            }
            label = new Text(text.substring(start, startPos));
            nodes.add((Labeled)label);
            Hyperlink hyperlink = new Hyperlink(text.substring(startPos + 1, endPos));
            hyperlink.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            hyperlink.setOnAction(this.eventHandler);
            nodes.add(hyperlink);
            start = endPos + 1;
        }
        this.textFlow.getChildren().setAll((Collection<Node>)nodes);
    }
}

