/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.debuginfo;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LocalVarsDebugInfoAttr;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.Named;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.debuginfo.LocalVar;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Debug Info Apply", desc="Apply debug info to registers (type and names)", runAfter={SSATransform.class, TypeInferenceVisitor.class})
public class DebugInfoApplyVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DebugInfoApplyVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        try {
            if (mth.contains(AType.LOCAL_VARS_DEBUG_INFO)) {
                DebugInfoApplyVisitor.applyDebugInfo(mth);
                mth.remove(AType.LOCAL_VARS_DEBUG_INFO);
            }
            DebugInfoApplyVisitor.checkTypes(mth);
        }
        catch (Exception e) {
            LOG.error("Error to apply debug info: {}", (Object)ErrorsCounter.formatMsg(mth, e.getMessage()), (Object)e);
        }
    }

    private static void checkTypes(MethodNode mth) {
        if (mth.isNoCode() || mth.getSVars().isEmpty()) {
            return;
        }
        mth.getSVars().forEach(var -> {
            ArgType type = var.getTypeInfo().getType();
            if (!type.isTypeKnown()) {
                mth.addComment("JADX WARNING: type inference failed for: " + var.getDetailedVarInfo(mth));
            }
        });
    }

    private static void applyDebugInfo(MethodNode mth) {
        mth.getSVars().forEach(ssaVar -> DebugInfoApplyVisitor.collectVarDebugInfo(mth, ssaVar));
        DebugInfoApplyVisitor.fixLinesForReturn(mth);
        DebugInfoApplyVisitor.fixNamesForPhiInsns(mth);
    }

    private static void collectVarDebugInfo(MethodNode mth, SSAVar ssaVar) {
        HashSet<RegDebugInfoAttr> debugInfoSet = new HashSet<RegDebugInfoAttr>(ssaVar.getUseCount() + 1);
        DebugInfoApplyVisitor.addRegDbdInfo(debugInfoSet, ssaVar.getAssign());
        ssaVar.getUseList().forEach(registerArg -> DebugInfoApplyVisitor.addRegDbdInfo(debugInfoSet, registerArg));
        int dbgCount = debugInfoSet.size();
        if (dbgCount == 0) {
            DebugInfoApplyVisitor.searchDebugInfoByOffset(mth, ssaVar);
            return;
        }
        if (dbgCount == 1) {
            RegDebugInfoAttr debugInfo = (RegDebugInfoAttr)debugInfoSet.iterator().next();
            DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, debugInfo.getRegType(), debugInfo.getName());
        } else {
            LOG.warn("Multiple debug info for {}: {}", (Object)ssaVar, debugInfoSet);
            for (RegDebugInfoAttr debugInfo : debugInfoSet) {
                DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, debugInfo.getRegType(), debugInfo.getName());
            }
        }
    }

    private static void searchDebugInfoByOffset(MethodNode mth, SSAVar ssaVar) {
        LocalVarsDebugInfoAttr debugInfoAttr = mth.get(AType.LOCAL_VARS_DEBUG_INFO);
        if (debugInfoAttr == null) {
            return;
        }
        Optional<Integer> max = ssaVar.getUseList().stream().map(DebugInfoApplyVisitor::getInsnOffsetByArg).max(Integer::compareTo);
        if (!max.isPresent()) {
            return;
        }
        int startOffset = DebugInfoApplyVisitor.getInsnOffsetByArg(ssaVar.getAssign());
        int endOffset = max.get();
        int regNum = ssaVar.getRegNum();
        for (LocalVar localVar : debugInfoAttr.getLocalVars()) {
            int endAddr;
            int startAddr;
            if (localVar.getRegNum() != regNum || !DebugInfoApplyVisitor.isInside(startOffset, startAddr = localVar.getStartAddr(), endAddr = localVar.getEndAddr()) && !DebugInfoApplyVisitor.isInside(endOffset, startAddr, endAddr)) continue;
            DebugInfoApplyVisitor.applyDebugInfo(mth, ssaVar, localVar.getType(), localVar.getName());
            break;
        }
    }

    private static boolean isInside(int var, int start, int end) {
        return start <= var && var <= end;
    }

    private static int getInsnOffsetByArg(InsnArg arg) {
        InsnNode insn;
        if (arg != null && (insn = arg.getParentInsn()) != null) {
            return insn.getOffset();
        }
        return -1;
    }

    public static void applyDebugInfo(MethodNode mth, SSAVar ssaVar, ArgType type, String varName) {
        TypeUpdateResult result = mth.root().getTypeUpdate().applyWithWiderAllow(ssaVar, type);
        if (result != TypeUpdateResult.REJECT) {
            if (NameMapper.isValidAndPrintable(varName)) {
                ssaVar.setName(varName);
            }
            DebugInfoApplyVisitor.detachDebugInfo(ssaVar.getAssign());
            ssaVar.getUseList().forEach(DebugInfoApplyVisitor::detachDebugInfo);
        }
    }

    private static void detachDebugInfo(RegisterArg reg) {
        if (reg != null) {
            reg.remove(AType.REG_DEBUG_INFO);
        }
    }

    private static void addRegDbdInfo(Set<RegDebugInfoAttr> debugInfo, RegisterArg reg) {
        RegDebugInfoAttr debugInfoAttr = reg.get(AType.REG_DEBUG_INFO);
        if (debugInfoAttr != null) {
            debugInfo.add(debugInfoAttr);
        }
    }

    private static void fixLinesForReturn(MethodNode mth) {
        if (mth.getReturnType().equals(ArgType.VOID)) {
            return;
        }
        InsnNode origReturn = null;
        ArrayList<InsnNode> newReturns = new ArrayList<InsnNode>(mth.getExitBlocks().size());
        for (BlockNode exit : mth.getExitBlocks()) {
            InsnNode ret = BlockUtils.getLastInsn(exit);
            if (ret == null) continue;
            if (ret.contains(AFlag.ORIG_RETURN)) {
                origReturn = ret;
                continue;
            }
            newReturns.add(ret);
        }
        if (origReturn != null) {
            for (InsnNode ret : newReturns) {
                InsnArg oldArg = origReturn.getArg(0);
                InsnArg newArg = ret.getArg(0);
                if (oldArg.isRegister() && newArg.isRegister()) {
                    RegisterArg oldArgReg = (RegisterArg)oldArg;
                    RegisterArg newArgReg = (RegisterArg)newArg;
                    DebugInfoApplyVisitor.applyDebugInfo(mth, newArgReg.getSVar(), oldArgReg.getType(), oldArgReg.getName());
                }
                ret.setSourceLine(origReturn.getSourceLine());
            }
        }
    }

    private static void fixNamesForPhiInsns(MethodNode mth) {
        mth.getSVars().forEach(ssaVar -> {
            for (PhiInsn phiInsn : ssaVar.getUsedInPhi()) {
                HashSet<String> names = new HashSet<String>(1 + phiInsn.getArgsCount());
                DebugInfoApplyVisitor.addArgName(phiInsn.getResult(), names);
                phiInsn.getArguments().forEach(arg -> DebugInfoApplyVisitor.addArgName(arg, names));
                if (names.size() == 1) {
                    DebugInfoApplyVisitor.setNameForInsn(phiInsn, (String)names.iterator().next());
                    continue;
                }
                if (names.size() <= 1) continue;
                LOG.warn("Different names in phi insn: {}, use first", names);
                DebugInfoApplyVisitor.setNameForInsn(phiInsn, (String)names.iterator().next());
            }
        });
    }

    private static void addArgName(InsnArg arg, Set<String> names) {
        String name;
        if (arg instanceof Named && (name = ((Named)((Object)arg)).getName()) != null) {
            names.add(name);
        }
    }

    private static void setNameForInsn(PhiInsn phiInsn, String name) {
        phiInsn.getResult().setName(name);
        phiInsn.getArguments().forEach(arg -> {
            if (arg instanceof Named) {
                ((Named)((Object)arg)).setName(name);
            }
        });
    }
}

