#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ral
version:              0.2
visibility:           public
id:                   ral-0.2-E1GQhI189v080qrpf7DiNL
key:                  ral-0.2-E1GQhI189v080qrpf7DiNL
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    This packages don'\''t provide length-indexed variant, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  eef26ef67b806e83f1f87416866cf3ec
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-8.10.5/site-local/ral-0.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/ral-0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/ral-0.2
hs-libraries:         HSral-0.2-E1GQhI189v080qrpf7DiNL
depends:
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk
    adjunctions-4.4-8Wm1QSIjMoe9YCYyPgaxz4 base-4.14.2.0
    bin-0.1.1-6naxVQ2kQM6JROY9bqM671 deepseq-1.4.4.0
    distributive-0.6.2.1-FKGYrCjdfe8EPx7TggrhZc
    fin-0.2-9toFUgeTE8qCOIuyHgyRF9
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
    semigroupoids-5.3.5-1MUCoMhFnfRKlT8x21E1a0

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

