/* testsortedset.c generated by valac 0.56.17, the Vala compiler
 * generated from testsortedset.vala, do not modify */

/* testsortedset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_SET_TESTS (set_tests_get_type ())
#define SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_TESTS, SetTests))
#define SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_TESTS, SetTestsClass))
#define IS_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_TESTS))
#define IS_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_TESTS))
#define SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_TESTS, SetTestsClass))

typedef struct _SetTests SetTests;
typedef struct _SetTestsClass SetTestsClass;
typedef struct _SetTestsPrivate SetTestsPrivate;

#define TYPE_SORTED_SET_TESTS (sorted_set_tests_get_type ())
#define SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_SET_TESTS, SortedSetTests))
#define SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))
#define IS_SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_SET_TESTS))
#define IS_SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_SET_TESTS))
#define SORTED_SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))

typedef struct _SortedSetTests SortedSetTests;
typedef struct _SortedSetTestsClass SortedSetTestsClass;
typedef struct _SortedSetTestsPrivate SortedSetTestsPrivate;
enum  {
	SORTED_SET_TESTS_0_PROPERTY,
	SORTED_SET_TESTS_NUM_PROPERTIES
};
static GParamSpec* sorted_set_tests_properties[SORTED_SET_TESTS_NUM_PROPERTIES];
typedef void (*GeeTestCaseTestMethod) (gpointer user_data);
typedef enum  {
	SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD,
	SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL,
	SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB,
	SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY
} SortedSetTestsSubSetTestsType;

#define SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TYPE (sorted_set_tests_sub_set_tests_type_get_type ())

#define SORTED_SET_TESTS_TYPE_SUB_SET_TESTS (sorted_set_tests_sub_set_tests_get_type ())
#define SORTED_SET_TESTS_SUB_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SORTED_SET_TESTS_TYPE_SUB_SET_TESTS, SortedSetTestsSubSetTests))
#define SORTED_SET_TESTS_SUB_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SORTED_SET_TESTS_TYPE_SUB_SET_TESTS, SortedSetTestsSubSetTestsClass))
#define SORTED_SET_TESTS_IS_SUB_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SORTED_SET_TESTS_TYPE_SUB_SET_TESTS))
#define SORTED_SET_TESTS_IS_SUB_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SORTED_SET_TESTS_TYPE_SUB_SET_TESTS))
#define SORTED_SET_TESTS_SUB_SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SORTED_SET_TESTS_TYPE_SUB_SET_TESTS, SortedSetTestsSubSetTestsClass))

typedef struct _SortedSetTestsSubSetTests SortedSetTestsSubSetTests;
typedef struct _SortedSetTestsSubSetTestsClass SortedSetTestsSubSetTestsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SortedSetTestsSubSetTestsPrivate SortedSetTestsSubSetTestsPrivate;
enum  {
	SORTED_SET_TESTS_SUB_SET_TESTS_0_PROPERTY,
	SORTED_SET_TESTS_SUB_SET_TESTS_NUM_PROPERTIES
};
static GParamSpec* sorted_set_tests_sub_set_tests_properties[SORTED_SET_TESTS_SUB_SET_TESTS_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _SetTests {
	CollectionTests parent_instance;
	SetTestsPrivate * priv;
};

struct _SetTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_ignored) (SetTests* self);
};

struct _SortedSetTests {
	SetTests parent_instance;
	SortedSetTestsPrivate * priv;
};

struct _SortedSetTestsClass {
	SetTestsClass parent_class;
};

struct _SortedSetTestsPrivate {
	gboolean strict;
};

struct _SortedSetTestsSubSetTests {
	GeeTestCase parent_instance;
	SortedSetTestsSubSetTestsPrivate * priv;
};

struct _SortedSetTestsSubSetTestsClass {
	GeeTestCaseClass parent_class;
};

struct _SortedSetTestsSubSetTestsPrivate {
	GeeSortedSet* master;
	GeeSortedSet* subset;
	SortedSetTests* test;
	SortedSetTestsSubSetTestsType type;
	gboolean strict;
};

static gint SortedSetTests_private_offset;
static gpointer sorted_set_tests_parent_class = NULL;
static gint SortedSetTestsSubSetTests_private_offset;
static gpointer sorted_set_tests_sub_set_tests_parent_class = NULL;

VALA_EXTERN GType gee_test_case_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeTestCase, g_object_unref)
VALA_EXTERN GType collection_tests_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CollectionTests, g_object_unref)
VALA_EXTERN GType set_tests_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SetTests, g_object_unref)
VALA_EXTERN GType sorted_set_tests_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedSetTests, g_object_unref)
VALA_EXTERN SortedSetTests* sorted_set_tests_construct (GType object_type,
                                            const gchar* name,
                                            gboolean strict);
VALA_EXTERN SetTests* set_tests_construct (GType object_type,
                               const gchar* name);
VALA_EXTERN void gee_test_case_add_test (GeeTestCase* self,
                             const gchar* name,
                             GeeTestCaseTestMethod test,
                             gpointer test_target,
                             GDestroyNotify test_target_destroy_notify);
VALA_EXTERN void sorted_set_tests_test_first (SortedSetTests* self);
static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_last (SortedSetTests* self);
static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_ordering (SortedSetTests* self);
static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_iterator_at (SortedSetTests* self);
static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_lower (SortedSetTests* self);
static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_higher (SortedSetTests* self);
static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_floor (SortedSetTests* self);
static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_test_ceil (SortedSetTests* self);
static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self);
VALA_EXTERN GTestSuite* gee_test_case_get_suite (GeeTestCase* self);
VALA_EXTERN GType sorted_set_tests_sub_set_tests_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SortedSetTestsSubSetTests* sorted_set_tests_sub_set_tests_new (SortedSetTests* test,
                                                               SortedSetTestsSubSetTestsType type,
                                                               gboolean strict);
VALA_EXTERN SortedSetTestsSubSetTests* sorted_set_tests_sub_set_tests_construct (GType object_type,
                                                                     SortedSetTests* test,
                                                                     SortedSetTestsSubSetTestsType type,
                                                                     gboolean strict);
VALA_EXTERN GType sorted_set_tests_sub_set_tests_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedSetTestsSubSetTests, g_object_unref)
VALA_EXTERN void gee_test_case_set_up (GeeTestCase* self);
VALA_EXTERN void gee_test_case_tear_down (GeeTestCase* self);
VALA_EXTERN const gchar* sorted_set_tests_sub_set_tests_type_to_string (SortedSetTestsSubSetTestsType self);
VALA_EXTERN GeeTestCase* gee_test_case_construct (GType object_type,
                                      const gchar* name);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_size (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_size_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_contains (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_contains_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_add (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_add_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_remove (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_remove_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_iterator (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_iterator_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_clear (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_clear_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_iterator_at (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_lower (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_lower_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_higher (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_higher_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_ceil (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_ceil_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_floor (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_floor_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_subsets (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_subsets_gee_test_case_test_method (gpointer self);
VALA_EXTERN void sorted_set_tests_sub_set_tests_test_boundaries (SortedSetTestsSubSetTests* self);
static void _sorted_set_tests_sub_set_tests_test_boundaries_gee_test_case_test_method (gpointer self);
static void sorted_set_tests_sub_set_tests_real_set_up (GeeTestCase* base);
static void sorted_set_tests_sub_set_tests_real_tear_down (GeeTestCase* base);
static void sorted_set_tests_sub_set_tests_finalize (GObject * obj);
static GType sorted_set_tests_sub_set_tests_get_type_once (void);
static void sorted_set_tests_finalize (GObject * obj);
static GType sorted_set_tests_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sorted_set_tests_get_instance_private (SortedSetTests* self)
{
	return G_STRUCT_MEMBER_P (self, SortedSetTests_private_offset);
}

static void
_sorted_set_tests_test_first_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_first ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_last_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_last ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_ordering ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_iterator_at ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_lower ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_higher ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_floor ((SortedSetTests*) self);
}

static void
_sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_test_ceil ((SortedSetTests*) self);
}

SortedSetTests*
sorted_set_tests_construct (GType object_type,
                            const gchar* name,
                            gboolean strict)
{
	SortedSetTests * self = NULL;
	GTestSuite* _tmp0_;
	SortedSetTestsSubSetTests* _tmp1_;
	SortedSetTestsSubSetTests* _tmp2_;
	GTestSuite* _tmp3_;
	GTestSuite* _tmp4_;
	SortedSetTestsSubSetTests* _tmp5_;
	SortedSetTestsSubSetTests* _tmp6_;
	GTestSuite* _tmp7_;
	GTestSuite* _tmp8_;
	SortedSetTestsSubSetTests* _tmp9_;
	SortedSetTestsSubSetTests* _tmp10_;
	GTestSuite* _tmp11_;
	GTestSuite* _tmp12_;
	SortedSetTestsSubSetTests* _tmp13_;
	SortedSetTestsSubSetTests* _tmp14_;
	GTestSuite* _tmp15_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SortedSetTests*) set_tests_construct (object_type, name);
	self->priv->strict = strict;
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] first", _sorted_set_tests_test_first_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] last", _sorted_set_tests_test_last_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ordering", _sorted_set_tests_test_ordering_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_test_iterator_at_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_test_lower_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_test_higher_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_test_floor_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_test_ceil_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	_tmp0_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp1_ = sorted_set_tests_sub_set_tests_new (self, SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD, strict);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_test_case_get_suite ((GeeTestCase*) _tmp2_);
	g_test_suite_add_suite (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp5_ = sorted_set_tests_sub_set_tests_new (self, SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL, strict);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_test_case_get_suite ((GeeTestCase*) _tmp6_);
	g_test_suite_add_suite (_tmp4_, _tmp7_);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp9_ = sorted_set_tests_sub_set_tests_new (self, SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB, strict);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_test_case_get_suite ((GeeTestCase*) _tmp10_);
	g_test_suite_add_suite (_tmp8_, _tmp11_);
	_g_object_unref0 (_tmp10_);
	_tmp12_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp13_ = sorted_set_tests_sub_set_tests_new (self, SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY, strict);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_test_case_get_suite ((GeeTestCase*) _tmp14_);
	g_test_suite_add_suite (_tmp12_, _tmp15_);
	_g_object_unref0 (_tmp14_);
	return self;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sorted_set_tests_test_ordering (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeIterator* iterator = NULL;
	GeeIterator* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gpointer _tmp7_;
	gchar* _tmp8_;
	gpointer _tmp9_;
	gchar* _tmp10_;
	gpointer _tmp11_;
	gchar* _tmp12_;
	gpointer _tmp13_;
	gchar* _tmp14_;
	gpointer _tmp15_;
	gchar* _tmp16_;
	gpointer _tmp17_;
	gchar* _tmp18_;
	gpointer _tmp19_;
	gchar* _tmp20_;
	gpointer _tmp21_;
	gchar* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	gpointer _tmp25_;
	gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_vala_assert (test_set != NULL, "test_set != null");
	gee_collection_add ((GeeCollection*) test_set, "one");
	gee_collection_add ((GeeCollection*) test_set, "two");
	gee_collection_add ((GeeCollection*) test_set, "three");
	gee_collection_add ((GeeCollection*) test_set, "four");
	gee_collection_add ((GeeCollection*) test_set, "five");
	gee_collection_add ((GeeCollection*) test_set, "six");
	gee_collection_add ((GeeCollection*) test_set, "seven");
	gee_collection_add ((GeeCollection*) test_set, "eight");
	gee_collection_add ((GeeCollection*) test_set, "nine");
	gee_collection_add ((GeeCollection*) test_set, "ten");
	gee_collection_add ((GeeCollection*) test_set, "eleven");
	gee_collection_add ((GeeCollection*) test_set, "twelve");
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) test_set);
	iterator = _tmp2_;
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp3_ = gee_iterator_get (iterator);
	_tmp4_ = (gchar*) _tmp3_;
	_vala_assert (g_strcmp0 (_tmp4_, "eight") == 0, "iterator.get () == \"eight\"");
	_g_free0 (_tmp4_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp5_ = gee_iterator_get (iterator);
	_tmp6_ = (gchar*) _tmp5_;
	_vala_assert (g_strcmp0 (_tmp6_, "eleven") == 0, "iterator.get () == \"eleven\"");
	_g_free0 (_tmp6_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp7_ = gee_iterator_get (iterator);
	_tmp8_ = (gchar*) _tmp7_;
	_vala_assert (g_strcmp0 (_tmp8_, "five") == 0, "iterator.get () == \"five\"");
	_g_free0 (_tmp8_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp9_ = gee_iterator_get (iterator);
	_tmp10_ = (gchar*) _tmp9_;
	_vala_assert (g_strcmp0 (_tmp10_, "four") == 0, "iterator.get () == \"four\"");
	_g_free0 (_tmp10_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp11_ = gee_iterator_get (iterator);
	_tmp12_ = (gchar*) _tmp11_;
	_vala_assert (g_strcmp0 (_tmp12_, "nine") == 0, "iterator.get () == \"nine\"");
	_g_free0 (_tmp12_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp13_ = gee_iterator_get (iterator);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (g_strcmp0 (_tmp14_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp14_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp15_ = gee_iterator_get (iterator);
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "seven") == 0, "iterator.get () == \"seven\"");
	_g_free0 (_tmp16_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp17_ = gee_iterator_get (iterator);
	_tmp18_ = (gchar*) _tmp17_;
	_vala_assert (g_strcmp0 (_tmp18_, "six") == 0, "iterator.get () == \"six\"");
	_g_free0 (_tmp18_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp19_ = gee_iterator_get (iterator);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp20_, "ten") == 0, "iterator.get () == \"ten\"");
	_g_free0 (_tmp20_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp21_ = gee_iterator_get (iterator);
	_tmp22_ = (gchar*) _tmp21_;
	_vala_assert (g_strcmp0 (_tmp22_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp22_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp23_ = gee_iterator_get (iterator);
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (g_strcmp0 (_tmp24_, "twelve") == 0, "iterator.get () == \"twelve\"");
	_g_free0 (_tmp24_);
	_vala_assert (gee_iterator_next (iterator), "iterator.next ()");
	_tmp25_ = gee_iterator_get (iterator);
	_tmp26_ = (gchar*) _tmp25_;
	_vala_assert (g_strcmp0 (_tmp26_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp26_);
	_vala_assert (gee_iterator_next (iterator) == FALSE, "iterator.next () == false");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_first (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	GeeSortedSet* _tmp7_;
	GeeSortedSet* _tmp8_;
	GeeSortedSet* _tmp9_;
	GeeSortedSet* _tmp10_;
	GeeSortedSet* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	if (self->priv->strict) {
		if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
			GeeSortedSet* _tmp2_;
			gpointer _tmp3_;
			gchar* _tmp4_;
			_tmp2_ = test_set;
			_tmp3_ = gee_sorted_set_first (_tmp2_);
			_tmp4_ = (gchar*) _tmp3_;
			_g_free0 (_tmp4_);
			exit (0);
		}
		g_test_trap_assert_failed ();
	}
	_tmp5_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "one"), "test_set.add (\"one\")");
	_tmp6_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "two"), "test_set.add (\"two\")");
	_tmp7_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp7_, "three"), "test_set.add (\"three\")");
	_tmp8_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp8_, "four"), "test_set.add (\"four\")");
	_tmp9_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp9_, "five"), "test_set.add (\"five\")");
	_tmp10_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, "six"), "test_set.add (\"six\")");
	_tmp11_ = test_set;
	_tmp12_ = gee_sorted_set_first (_tmp11_);
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "five") == 0, "test_set.first () == \"five\"");
	_g_free0 (_tmp13_);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_last (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	GeeSortedSet* _tmp7_;
	GeeSortedSet* _tmp8_;
	GeeSortedSet* _tmp9_;
	GeeSortedSet* _tmp10_;
	GeeSortedSet* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	if (self->priv->strict) {
		if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
			GeeSortedSet* _tmp2_;
			gpointer _tmp3_;
			gchar* _tmp4_;
			_tmp2_ = test_set;
			_tmp3_ = gee_sorted_set_last (_tmp2_);
			_tmp4_ = (gchar*) _tmp3_;
			_g_free0 (_tmp4_);
			exit (0);
		}
		g_test_trap_assert_failed ();
	}
	_tmp5_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "one"), "test_set.add (\"one\")");
	_tmp6_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "two"), "test_set.add (\"two\")");
	_tmp7_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp7_, "three"), "test_set.add (\"three\")");
	_tmp8_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp8_, "four"), "test_set.add (\"four\")");
	_tmp9_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp9_, "five"), "test_set.add (\"five\")");
	_tmp10_ = test_set;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, "six"), "test_set.add (\"six\")");
	_tmp11_ = test_set;
	_tmp12_ = gee_sorted_set_last (_tmp11_);
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "two") == 0, "test_set.last () == \"two\"");
	_g_free0 (_tmp13_);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_iterator_at (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeIterator* iter = NULL;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	GeeIterator* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	gchar* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "one"), "test_set.add (\"one\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "two"), "test_set.add (\"two\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "three"), "test_set.add (\"three\")");
	_tmp2_ = gee_sorted_set_iterator_at (test_set, "one");
	iter = _tmp2_;
	_tmp3_ = iter;
	_vala_assert (_tmp3_ != NULL, "iter != null");
	_tmp4_ = iter;
	_tmp5_ = gee_iterator_get (_tmp4_);
	_tmp6_ = (gchar*) _tmp5_;
	_vala_assert (g_strcmp0 (_tmp6_, "one") == 0, "iter.get () == \"one\"");
	_g_free0 (_tmp6_);
	_tmp7_ = gee_sorted_set_iterator_at (test_set, "two");
	_g_object_unref0 (iter);
	iter = _tmp7_;
	_tmp8_ = iter;
	_vala_assert (_tmp8_ != NULL, "iter != null");
	_tmp9_ = iter;
	_tmp10_ = gee_iterator_get (_tmp9_);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "two") == 0, "iter.get () == \"two\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_iterator_at (test_set, "three");
	_g_object_unref0 (iter);
	iter = _tmp12_;
	_tmp13_ = iter;
	_vala_assert (_tmp13_ != NULL, "iter != null");
	_tmp14_ = iter;
	_tmp15_ = gee_iterator_get (_tmp14_);
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "three") == 0, "iter.get () == \"three\"");
	_g_free0 (_tmp16_);
	_tmp17_ = gee_sorted_set_iterator_at (test_set, "zero");
	_g_object_unref0 (iter);
	iter = _tmp17_;
	_tmp18_ = iter;
	_vala_assert (_tmp18_ == NULL, "iter == null");
	_g_object_unref0 (iter);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_lower (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	gpointer _tmp6_;
	gchar* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	gpointer _tmp18_;
	gchar* _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_lower (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.lower (\"one\") == null");
	_g_free0 (_tmp3_);
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "one"), "test_set.add (\"one\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "two"), "test_set.add (\"two\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "three"), "test_set.add (\"three\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "four"), "test_set.add (\"four\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "five"), "test_set.add (\"five\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "six"), "test_set.add (\"six\")");
	_tmp4_ = gee_sorted_set_lower (test_set, "one");
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "four") == 0, "test_set.lower (\"one\") == \"four\"");
	_g_free0 (_tmp5_);
	_tmp6_ = gee_sorted_set_lower (test_set, "o");
	_tmp7_ = (gchar*) _tmp6_;
	_vala_assert (g_strcmp0 (_tmp7_, "four") == 0, "test_set.lower (\"o\") == \"four\"");
	_g_free0 (_tmp7_);
	_tmp8_ = gee_sorted_set_lower (test_set, "two");
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "three") == 0, "test_set.lower (\"two\") == \"three\"");
	_g_free0 (_tmp9_);
	_tmp10_ = gee_sorted_set_lower (test_set, "t");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "six") == 0, "test_set.lower (\"t\") == \"six\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_lower (test_set, "three");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "six") == 0, "test_set.lower (\"three\") == \"six\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_lower (test_set, "four");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "five") == 0, "test_set.lower (\"four\") == \"five\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_lower (test_set, "f");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (_tmp17_ == NULL, "test_set.lower (\"f\") == null");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_lower (test_set, "five");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (_tmp19_ == NULL, "test_set.lower (\"five\") == null");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_lower (test_set, "six");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "one") == 0, "test_set.lower (\"six\") == \"one\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_lower (test_set, "s");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "one") == 0, "test_set.lower (\"s\") == \"one\"");
	_g_free0 (_tmp23_);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_higher (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	gpointer _tmp6_;
	gchar* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	gpointer _tmp18_;
	gchar* _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_higher (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.higher (\"one\") == null");
	_g_free0 (_tmp3_);
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "one"), "test_set.add (\"one\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "two"), "test_set.add (\"two\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "three"), "test_set.add (\"three\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "four"), "test_set.add (\"four\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "five"), "test_set.add (\"five\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "six"), "test_set.add (\"six\")");
	_tmp4_ = gee_sorted_set_higher (test_set, "one");
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "six") == 0, "test_set.higher (\"one\") == \"six\"");
	_g_free0 (_tmp5_);
	_tmp6_ = gee_sorted_set_higher (test_set, "o");
	_tmp7_ = (gchar*) _tmp6_;
	_vala_assert (g_strcmp0 (_tmp7_, "one") == 0, "test_set.higher (\"o\") == \"one\"");
	_g_free0 (_tmp7_);
	_tmp8_ = gee_sorted_set_higher (test_set, "two");
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (_tmp9_ == NULL, "test_set.higher (\"two\") == null");
	_g_free0 (_tmp9_);
	_tmp10_ = gee_sorted_set_higher (test_set, "t");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "three") == 0, "test_set.higher (\"t\") == \"three\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_higher (test_set, "three");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "two") == 0, "test_set.higher (\"three\") == \"two\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_higher (test_set, "four");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "one") == 0, "test_set.higher (\"four\") == \"one\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_higher (test_set, "f");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "five") == 0, "test_set.higher (\"f\") == \"five\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_higher (test_set, "five");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "four") == 0, "test_set.higher (\"five\") == \"four\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_higher (test_set, "six");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "three") == 0, "test_set.higher (\"six\") == \"three\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_higher (test_set, "s");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "six") == 0, "test_set.higher (\"s\") == \"six\"");
	_g_free0 (_tmp23_);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_floor (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	gpointer _tmp6_;
	gchar* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	gpointer _tmp18_;
	gchar* _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_floor (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.floor (\"one\") == null");
	_g_free0 (_tmp3_);
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "one"), "test_set.add (\"one\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "two"), "test_set.add (\"two\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "three"), "test_set.add (\"three\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "four"), "test_set.add (\"four\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "five"), "test_set.add (\"five\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "six"), "test_set.add (\"six\")");
	_tmp4_ = gee_sorted_set_floor (test_set, "one");
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "one") == 0, "test_set.floor (\"one\") == \"one\"");
	_g_free0 (_tmp5_);
	_tmp6_ = gee_sorted_set_floor (test_set, "o");
	_tmp7_ = (gchar*) _tmp6_;
	_vala_assert (g_strcmp0 (_tmp7_, "four") == 0, "test_set.floor (\"o\") == \"four\"");
	_g_free0 (_tmp7_);
	_tmp8_ = gee_sorted_set_floor (test_set, "two");
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "two") == 0, "test_set.floor (\"two\") == \"two\"");
	_g_free0 (_tmp9_);
	_tmp10_ = gee_sorted_set_floor (test_set, "t");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "six") == 0, "test_set.floor (\"t\") == \"six\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_floor (test_set, "three");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "three") == 0, "test_set.floor (\"three\") == \"three\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_floor (test_set, "four");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "four") == 0, "test_set.floor (\"four\") == \"four\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_floor (test_set, "f");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (_tmp17_ == NULL, "test_set.floor (\"f\") == null");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_floor (test_set, "five");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "five") == 0, "test_set.floor (\"five\") == \"five\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_floor (test_set, "six");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "six") == 0, "test_set.floor (\"six\") == \"six\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_floor (test_set, "s");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "one") == 0, "test_set.floor (\"s\") == \"one\"");
	_g_free0 (_tmp23_);
	_g_object_unref0 (test_set);
}

void
sorted_set_tests_test_ceil (SortedSetTests* self)
{
	GeeSortedSet* test_set = NULL;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gpointer _tmp4_;
	gchar* _tmp5_;
	gpointer _tmp6_;
	gchar* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	gpointer _tmp18_;
	gchar* _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_ceil (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.ceil (\"one\") == null");
	_g_free0 (_tmp3_);
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "one"), "test_set.add (\"one\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "two"), "test_set.add (\"two\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "three"), "test_set.add (\"three\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "four"), "test_set.add (\"four\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "five"), "test_set.add (\"five\")");
	_vala_assert (gee_collection_add ((GeeCollection*) test_set, "six"), "test_set.add (\"six\")");
	_tmp4_ = gee_sorted_set_ceil (test_set, "one");
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "one") == 0, "test_set.ceil (\"one\") == \"one\"");
	_g_free0 (_tmp5_);
	_tmp6_ = gee_sorted_set_ceil (test_set, "o");
	_tmp7_ = (gchar*) _tmp6_;
	_vala_assert (g_strcmp0 (_tmp7_, "one") == 0, "test_set.ceil (\"o\") == \"one\"");
	_g_free0 (_tmp7_);
	_tmp8_ = gee_sorted_set_ceil (test_set, "two");
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "two") == 0, "test_set.ceil (\"two\") == \"two\"");
	_g_free0 (_tmp9_);
	_tmp10_ = gee_sorted_set_ceil (test_set, "t");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "three") == 0, "test_set.ceil (\"t\") == \"three\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_ceil (test_set, "three");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "three") == 0, "test_set.ceil (\"three\") == \"three\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_ceil (test_set, "four");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "four") == 0, "test_set.ceil (\"four\") == \"four\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_ceil (test_set, "f");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "five") == 0, "test_set.ceil (\"f\") == \"five\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_ceil (test_set, "five");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "five") == 0, "test_set.ceil (\"five\") == \"five\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_ceil (test_set, "six");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "six") == 0, "test_set.ceil (\"six\") == \"six\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_ceil (test_set, "s");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "six") == 0, "test_set.ceil (\"s\") == \"six\"");
	_g_free0 (_tmp23_);
	_g_object_unref0 (test_set);
}

static inline gpointer
sorted_set_tests_sub_set_tests_get_instance_private (SortedSetTestsSubSetTests* self)
{
	return G_STRUCT_MEMBER_P (self, SortedSetTestsSubSetTests_private_offset);
}

const gchar*
sorted_set_tests_sub_set_tests_type_to_string (SortedSetTestsSubSetTestsType self)
{
	const gchar* result;
	switch (self) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			result = "Head";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			result = "Tail";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			result = "Range";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			result = "Empty";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
sorted_set_tests_sub_set_tests_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD, "SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD", "head"}, {SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL, "SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL", "tail"}, {SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB, "SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB", "sub"}, {SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY, "SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY", "empty"}, {0, NULL, NULL}};
	GType sorted_set_tests_sub_set_tests_type_type_id;
	sorted_set_tests_sub_set_tests_type_type_id = g_enum_register_static ("SortedSetTestsSubSetTestsType", values);
	return sorted_set_tests_sub_set_tests_type_type_id;
}

GType
sorted_set_tests_sub_set_tests_type_get_type (void)
{
	static volatile gsize sorted_set_tests_sub_set_tests_type_type_id__once = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_tests_type_type_id__once)) {
		GType sorted_set_tests_sub_set_tests_type_type_id;
		sorted_set_tests_sub_set_tests_type_type_id = sorted_set_tests_sub_set_tests_type_get_type_once ();
		g_once_init_leave (&sorted_set_tests_sub_set_tests_type_type_id__once, sorted_set_tests_sub_set_tests_type_type_id);
	}
	return sorted_set_tests_sub_set_tests_type_type_id__once;
}

static void
_sorted_set_tests_sub_set_tests_test_size_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_size ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_contains_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_contains ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_add_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_add ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_remove_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_remove ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_iterator_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_iterator ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_clear_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_clear ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_iterator_at ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_lower_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_lower ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_higher_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_higher ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_ceil_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_ceil ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_floor_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_floor ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_subsets_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_subsets ((SortedSetTestsSubSetTests*) self);
}

static void
_sorted_set_tests_sub_set_tests_test_boundaries_gee_test_case_test_method (gpointer self)
{
	sorted_set_tests_sub_set_tests_test_boundaries ((SortedSetTestsSubSetTests*) self);
}

SortedSetTestsSubSetTests*
sorted_set_tests_sub_set_tests_construct (GType object_type,
                                          SortedSetTests* test,
                                          SortedSetTestsSubSetTestsType type,
                                          gboolean strict)
{
	SortedSetTestsSubSetTests * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SortedSetTests* _tmp3_;
	g_return_val_if_fail (test != NULL, NULL);
	_tmp0_ = sorted_set_tests_sub_set_tests_type_to_string (type);
	_tmp1_ = g_strdup_printf ("%s Subset", _tmp0_);
	_tmp2_ = _tmp1_;
	self = (SortedSetTestsSubSetTests*) gee_test_case_construct (object_type, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = _g_object_ref0 (test);
	_g_object_unref0 (self->priv->test);
	self->priv->test = _tmp3_;
	self->priv->type = type;
	self->priv->strict = strict;
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] size", _sorted_set_tests_sub_set_tests_test_size_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains", _sorted_set_tests_sub_set_tests_test_contains_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add", _sorted_set_tests_sub_set_tests_test_add_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove", _sorted_set_tests_sub_set_tests_test_remove_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator", _sorted_set_tests_sub_set_tests_test_iterator_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _sorted_set_tests_sub_set_tests_test_clear_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_sub_set_tests_test_iterator_at_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_sub_set_tests_test_lower_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_sub_set_tests_test_higher_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_sub_set_tests_test_ceil_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_sub_set_tests_test_floor_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] subsets", _sorted_set_tests_sub_set_tests_test_subsets_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] boundaries", _sorted_set_tests_sub_set_tests_test_boundaries_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}

SortedSetTestsSubSetTests*
sorted_set_tests_sub_set_tests_new (SortedSetTests* test,
                                    SortedSetTestsSubSetTestsType type,
                                    gboolean strict)
{
	return sorted_set_tests_sub_set_tests_construct (SORTED_SET_TESTS_TYPE_SUB_SET_TESTS, test, type, strict);
}

static void
sorted_set_tests_sub_set_tests_real_set_up (GeeTestCase* base)
{
	SortedSetTestsSubSetTests * self;
	SortedSetTests* _tmp0_;
	SortedSetTests* _tmp1_;
	GeeCollection* _tmp2_;
	GeeSortedSet* _tmp3_;
	self = (SortedSetTestsSubSetTests*) base;
	_tmp0_ = self->priv->test;
	gee_test_case_set_up ((GeeTestCase*) _tmp0_);
	_tmp1_ = self->priv->test;
	_tmp2_ = ((CollectionTests*) _tmp1_)->test_collection;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->master);
	self->priv->master = _tmp3_;
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp4_;
			GeeSortedSet* _tmp5_;
			_tmp4_ = self->priv->master;
			_tmp5_ = gee_sorted_set_head_set (_tmp4_, "one");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp5_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp6_;
			GeeSortedSet* _tmp7_;
			_tmp6_ = self->priv->master;
			_tmp7_ = gee_sorted_set_tail_set (_tmp6_, "six");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp7_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp8_;
			GeeSortedSet* _tmp9_;
			_tmp8_ = self->priv->master;
			_tmp9_ = gee_sorted_set_sub_set (_tmp8_, "four", "three");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp9_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp10_;
			GeeSortedSet* _tmp11_;
			_tmp10_ = self->priv->master;
			_tmp11_ = gee_sorted_set_sub_set (_tmp10_, "three", "four");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp11_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
sorted_set_tests_sub_set_tests_real_tear_down (GeeTestCase* base)
{
	SortedSetTestsSubSetTests * self;
	SortedSetTests* _tmp0_;
	self = (SortedSetTestsSubSetTests*) base;
	_tmp0_ = self->priv->test;
	gee_test_case_tear_down ((GeeTestCase*) _tmp0_);
}

void
sorted_set_tests_sub_set_tests_test_size (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeSortedSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeSortedSet* _tmp6_;
	GeeSortedSet* _tmp7_;
	GeeSortedSet* _tmp8_;
	GeeSortedSet* _tmp9_;
	GeeSortedSet* _tmp10_;
	GeeSortedSet* _tmp11_;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subset;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_, "subset.is_empty");
	_tmp3_ = self->priv->subset;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "subset.size == 0");
	_tmp6_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp6_, "one"), "master.add (\"one\")");
	_tmp7_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp7_, "two"), "master.add (\"two\")");
	_tmp8_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp8_, "three"), "master.add (\"three\")");
	_tmp9_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp9_, "four"), "master.add (\"four\")");
	_tmp10_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp10_, "five"), "master.add (\"five\")");
	_tmp11_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp11_, "six"), "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			GeeSortedSet* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp15_ = self->priv->subset;
			_tmp16_ = gee_collection_get_is_empty ((GeeCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_vala_assert (!_tmp17_, "!subset.is_empty");
			_tmp18_ = self->priv->subset;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_vala_assert (_tmp20_ == 2, "subset.size == 2");
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			GeeSortedSet* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_collection_get_is_empty ((GeeCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_vala_assert (!_tmp23_, "!subset.is_empty");
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_vala_assert (_tmp26_ == 3, "subset.size == 3");
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp29_;
			GeeSortedSet* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp27_ = self->priv->subset;
			_tmp28_ = gee_collection_get_is_empty ((GeeCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_vala_assert (!_tmp29_, "!subset.is_empty");
			_tmp30_ = self->priv->subset;
			_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_vala_assert (_tmp32_ == 3, "subset.size == 3");
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp33_;
			gboolean _tmp34_;
			gboolean _tmp35_;
			GeeSortedSet* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp33_ = self->priv->subset;
			_tmp34_ = gee_collection_get_is_empty ((GeeCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_vala_assert (_tmp35_, "subset.is_empty");
			_tmp36_ = self->priv->subset;
			_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_vala_assert (_tmp38_ == 0, "subset.size == 0");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sorted_set_tests_sub_set_tests_test_contains (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp45_;
	gint _tmp45__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar** _tmp16_;
			_tmp9_ = g_strdup ("four");
			_tmp10_ = g_strdup ("five");
			_tmp11_ = g_new0 (gchar*, 2 + 1);
			_tmp11_[0] = _tmp9_;
			_tmp11_[1] = _tmp10_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp11_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp12_ = g_strdup ("one");
			_tmp13_ = g_strdup ("two");
			_tmp14_ = g_strdup ("three");
			_tmp15_ = g_strdup ("six");
			_tmp16_ = g_new0 (gchar*, 4 + 1);
			_tmp16_[0] = _tmp12_;
			_tmp16_[1] = _tmp13_;
			_tmp16_[2] = _tmp14_;
			_tmp16_[3] = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp16_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar** _tmp24_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp20_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp21_ = g_strdup ("one");
			_tmp22_ = g_strdup ("four");
			_tmp23_ = g_strdup ("five");
			_tmp24_ = g_new0 (gchar*, 3 + 1);
			_tmp24_[0] = _tmp21_;
			_tmp24_[1] = _tmp22_;
			_tmp24_[2] = _tmp23_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp24_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			_tmp25_ = g_strdup ("one");
			_tmp26_ = g_strdup ("four");
			_tmp27_ = g_strdup ("six");
			_tmp28_ = g_new0 (gchar*, 3 + 1);
			_tmp28_[0] = _tmp25_;
			_tmp28_[1] = _tmp26_;
			_tmp28_[2] = _tmp27_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp28_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp29_ = g_strdup ("two");
			_tmp30_ = g_strdup ("three");
			_tmp31_ = g_strdup ("five");
			_tmp32_ = g_new0 (gchar*, 3 + 1);
			_tmp32_[0] = _tmp29_;
			_tmp32_[1] = _tmp30_;
			_tmp32_[2] = _tmp31_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp32_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			gchar** _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar** _tmp40_;
			_tmp33_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp33_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp34_ = g_strdup ("one");
			_tmp35_ = g_strdup ("two");
			_tmp36_ = g_strdup ("three");
			_tmp37_ = g_strdup ("four");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_strdup ("six");
			_tmp40_ = g_new0 (gchar*, 6 + 1);
			_tmp40_[0] = _tmp34_;
			_tmp40_[1] = _tmp35_;
			_tmp40_[2] = _tmp36_;
			_tmp40_[3] = _tmp37_;
			_tmp40_[4] = _tmp38_;
			_tmp40_[5] = _tmp39_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp40_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp41_ = contains;
	_tmp41__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp41_;
		s_collection_length1 = _tmp41__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp42_;
			gchar* s = NULL;
			_tmp42_ = g_strdup (s_collection[s_it]);
			s = _tmp42_;
			{
				GeeSortedSet* _tmp43_;
				const gchar* _tmp44_;
				_tmp43_ = self->priv->subset;
				_tmp44_ = s;
				_vala_assert (gee_collection_contains ((GeeCollection*) _tmp43_, _tmp44_), "subset.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp45_ = not_contains;
	_tmp45__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp45_;
		s_collection_length1 = _tmp45__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp46_;
			gchar* s = NULL;
			_tmp46_ = g_strdup (s_collection[s_it]);
			s = _tmp46_;
			{
				GeeSortedSet* _tmp47_;
				const gchar* _tmp48_;
				_tmp47_ = self->priv->subset;
				_tmp48_ = s;
				_vala_assert (!gee_collection_contains ((GeeCollection*) _tmp47_, _tmp48_), "!subset.contains (s)");
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}

void
sorted_set_tests_sub_set_tests_test_add (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar** success = NULL;
	gint success_length1 = 0;
	gint _success_size_ = 0;
	gchar** fail = NULL;
	gint fail_length1 = 0;
	gint _fail_size_ = 0;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar** _tmp41_;
	gint _tmp41__length1;
	GeeSortedSet* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_;
			_tmp9_ = g_strdup ("a");
			_tmp10_ = g_strdup ("o");
			_tmp11_ = g_new0 (gchar*, 2 + 1);
			_tmp11_[0] = _tmp9_;
			_tmp11_[1] = _tmp10_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp11_;
			success_length1 = 2;
			_success_size_ = success_length1;
			_tmp12_ = g_strdup ("oz");
			_tmp13_ = g_strdup ("z");
			_tmp14_ = g_new0 (gchar*, 2 + 1);
			_tmp14_[0] = _tmp12_;
			_tmp14_[1] = _tmp13_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp14_;
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar** _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			_tmp15_ = g_strdup ("siz");
			_tmp16_ = g_strdup ("z");
			_tmp17_ = g_new0 (gchar*, 2 + 1);
			_tmp17_[0] = _tmp15_;
			_tmp17_[1] = _tmp16_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp17_;
			success_length1 = 2;
			_success_size_ = success_length1;
			_tmp18_ = g_strdup ("sia");
			_tmp19_ = g_strdup ("a");
			_tmp20_ = g_new0 (gchar*, 2 + 1);
			_tmp20_[0] = _tmp18_;
			_tmp20_[1] = _tmp19_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp20_;
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar** _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar** _tmp26_;
			_tmp21_ = g_strdup ("o");
			_tmp22_ = g_strdup ("th");
			_tmp23_ = g_new0 (gchar*, 2 + 1);
			_tmp23_[0] = _tmp21_;
			_tmp23_[1] = _tmp22_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp23_;
			success_length1 = 2;
			_success_size_ = success_length1;
			_tmp24_ = g_strdup ("f");
			_tmp25_ = g_strdup ("u");
			_tmp26_ = g_new0 (gchar*, 2 + 1);
			_tmp26_[0] = _tmp24_;
			_tmp26_[1] = _tmp25_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp26_;
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			gchar** _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			_tmp27_ = g_new0 (gchar*, 0 + 1);
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp27_;
			success_length1 = 0;
			_success_size_ = success_length1;
			_tmp28_ = g_strdup ("o");
			_tmp29_ = g_strdup ("th");
			_tmp30_ = g_strdup ("f");
			_tmp31_ = g_strdup ("u");
			_tmp32_ = g_new0 (gchar*, 4 + 1);
			_tmp32_[0] = _tmp28_;
			_tmp32_[1] = _tmp29_;
			_tmp32_[2] = _tmp30_;
			_tmp32_[3] = _tmp31_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp32_;
			fail_length1 = 4;
			_fail_size_ = fail_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp33_ = success;
	_tmp33__length1 = success_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp33_;
		s_collection_length1 = _tmp33__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp34_;
			gchar* s = NULL;
			_tmp34_ = g_strdup (s_collection[s_it]);
			s = _tmp34_;
			{
				GeeSortedSet* _tmp35_;
				const gchar* _tmp36_;
				GeeSortedSet* _tmp37_;
				const gchar* _tmp38_;
				GeeSortedSet* _tmp39_;
				const gchar* _tmp40_;
				_tmp35_ = self->priv->subset;
				_tmp36_ = s;
				_vala_assert (gee_collection_add ((GeeCollection*) _tmp35_, _tmp36_), "subset.add (s)");
				_tmp37_ = self->priv->subset;
				_tmp38_ = s;
				_vala_assert (gee_collection_contains ((GeeCollection*) _tmp37_, _tmp38_), "subset.contains (s)");
				_tmp39_ = self->priv->master;
				_tmp40_ = s;
				_vala_assert (gee_collection_contains ((GeeCollection*) _tmp39_, _tmp40_), "master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp41_ = fail;
	_tmp41__length1 = fail_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp41_;
		s_collection_length1 = _tmp41__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp42_;
			gchar* s = NULL;
			_tmp42_ = g_strdup (s_collection[s_it]);
			s = _tmp42_;
			{
				GeeSortedSet* _tmp43_;
				const gchar* _tmp44_;
				GeeSortedSet* _tmp45_;
				const gchar* _tmp46_;
				GeeSortedSet* _tmp47_;
				const gchar* _tmp48_;
				_tmp43_ = self->priv->subset;
				_tmp44_ = s;
				_vala_assert (!gee_collection_add ((GeeCollection*) _tmp43_, _tmp44_), "!subset.add (s)");
				_tmp45_ = self->priv->subset;
				_tmp46_ = s;
				_vala_assert (!gee_collection_contains ((GeeCollection*) _tmp45_, _tmp46_), "!subset.contains (s)");
				_tmp47_ = self->priv->master;
				_tmp48_ = s;
				_vala_assert (!gee_collection_contains ((GeeCollection*) _tmp47_, _tmp48_), "!master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp49_ = self->priv->master;
	_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = success;
	_tmp52__length1 = success_length1;
	_vala_assert (_tmp51_ == (6 + _tmp52__length1), "master.size == 6 + success.length");
	fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
	success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
}

void
sorted_set_tests_sub_set_tests_test_remove (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp47_;
	gint _tmp47__length1;
	GeeSortedSet* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar** _tmp16_;
			_tmp9_ = g_strdup ("four");
			_tmp10_ = g_strdup ("five");
			_tmp11_ = g_new0 (gchar*, 2 + 1);
			_tmp11_[0] = _tmp9_;
			_tmp11_[1] = _tmp10_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp11_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp12_ = g_strdup ("one");
			_tmp13_ = g_strdup ("two");
			_tmp14_ = g_strdup ("three");
			_tmp15_ = g_strdup ("six");
			_tmp16_ = g_new0 (gchar*, 4 + 1);
			_tmp16_[0] = _tmp12_;
			_tmp16_[1] = _tmp13_;
			_tmp16_[2] = _tmp14_;
			_tmp16_[3] = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp16_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar** _tmp24_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp20_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp21_ = g_strdup ("one");
			_tmp22_ = g_strdup ("four");
			_tmp23_ = g_strdup ("five");
			_tmp24_ = g_new0 (gchar*, 3 + 1);
			_tmp24_[0] = _tmp21_;
			_tmp24_[1] = _tmp22_;
			_tmp24_[2] = _tmp23_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp24_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			_tmp25_ = g_strdup ("one");
			_tmp26_ = g_strdup ("four");
			_tmp27_ = g_strdup ("six");
			_tmp28_ = g_new0 (gchar*, 3 + 1);
			_tmp28_[0] = _tmp25_;
			_tmp28_[1] = _tmp26_;
			_tmp28_[2] = _tmp27_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp28_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp29_ = g_strdup ("two");
			_tmp30_ = g_strdup ("three");
			_tmp31_ = g_strdup ("five");
			_tmp32_ = g_new0 (gchar*, 3 + 1);
			_tmp32_[0] = _tmp29_;
			_tmp32_[1] = _tmp30_;
			_tmp32_[2] = _tmp31_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp32_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			gchar** _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar** _tmp40_;
			_tmp33_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp33_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp34_ = g_strdup ("one");
			_tmp35_ = g_strdup ("two");
			_tmp36_ = g_strdup ("three");
			_tmp37_ = g_strdup ("four");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_strdup ("six");
			_tmp40_ = g_new0 (gchar*, 6 + 1);
			_tmp40_[0] = _tmp34_;
			_tmp40_[1] = _tmp35_;
			_tmp40_[2] = _tmp36_;
			_tmp40_[3] = _tmp37_;
			_tmp40_[4] = _tmp38_;
			_tmp40_[5] = _tmp39_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp40_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp41_ = contains;
	_tmp41__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp41_;
		s_collection_length1 = _tmp41__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp42_;
			gchar* s = NULL;
			_tmp42_ = g_strdup (s_collection[s_it]);
			s = _tmp42_;
			{
				GeeSortedSet* _tmp43_;
				const gchar* _tmp44_;
				GeeSortedSet* _tmp45_;
				const gchar* _tmp46_;
				_tmp43_ = self->priv->subset;
				_tmp44_ = s;
				_vala_assert (gee_collection_remove ((GeeCollection*) _tmp43_, _tmp44_), "subset.remove (s)");
				_tmp45_ = self->priv->master;
				_tmp46_ = s;
				_vala_assert (!gee_collection_contains ((GeeCollection*) _tmp45_, _tmp46_), "!master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp47_ = not_contains;
	_tmp47__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp47_;
		s_collection_length1 = _tmp47__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp48_;
			gchar* s = NULL;
			_tmp48_ = g_strdup (s_collection[s_it]);
			s = _tmp48_;
			{
				GeeSortedSet* _tmp49_;
				const gchar* _tmp50_;
				GeeSortedSet* _tmp51_;
				const gchar* _tmp52_;
				_tmp49_ = self->priv->subset;
				_tmp50_ = s;
				_vala_assert (!gee_collection_remove ((GeeCollection*) _tmp49_, _tmp50_), "!subset.remove (s)");
				_tmp51_ = self->priv->master;
				_tmp52_ = s;
				_vala_assert (gee_collection_contains ((GeeCollection*) _tmp51_, _tmp52_), "master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp53_ = self->priv->master;
	_tmp54_ = gee_collection_get_size ((GeeCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = contains;
	_tmp56__length1 = contains_length1;
	_vala_assert (_tmp55_ == (6 - _tmp56__length1), "master.size == 6 - contains.length");
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}

void
sorted_set_tests_sub_set_tests_test_iterator (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	guint i = 0U;
	gchar** _tmp30_;
	gint _tmp30__length1;
	GeeIterator* iter = NULL;
	GeeSortedSet* _tmp31_;
	GeeIterator* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			_tmp9_ = g_strdup ("five");
			_tmp10_ = g_strdup ("four");
			_tmp11_ = g_new0 (gchar*, 2 + 1);
			_tmp11_[0] = _tmp9_;
			_tmp11_[1] = _tmp10_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp11_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_;
			_tmp12_ = g_strdup ("six");
			_tmp13_ = g_strdup ("three");
			_tmp14_ = g_strdup ("two");
			_tmp15_ = g_new0 (gchar*, 3 + 1);
			_tmp15_[0] = _tmp12_;
			_tmp15_[1] = _tmp13_;
			_tmp15_[2] = _tmp14_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp15_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar** _tmp19_;
			_tmp16_ = g_strdup ("four");
			_tmp17_ = g_strdup ("one");
			_tmp18_ = g_strdup ("six");
			_tmp19_ = g_new0 (gchar*, 3 + 1);
			_tmp19_[0] = _tmp16_;
			_tmp19_[1] = _tmp17_;
			_tmp19_[2] = _tmp18_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp19_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			gchar** _tmp20_;
			_tmp20_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp20_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	i = (guint) 0;
	{
		GeeIterator* _e_it = NULL;
		GeeSortedSet* _tmp21_;
		GeeIterator* _tmp22_;
		_tmp21_ = self->priv->subset;
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_e_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			gchar* e = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			const gchar* _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			guint _tmp28_;
			const gchar* _tmp29_;
			_tmp23_ = _e_it;
			if (!gee_iterator_next (_tmp23_)) {
				break;
			}
			_tmp24_ = _e_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			e = (gchar*) _tmp25_;
			_tmp26_ = e;
			_tmp27_ = contains;
			_tmp27__length1 = contains_length1;
			_tmp28_ = i;
			i = _tmp28_ + 1;
			_tmp29_ = _tmp27_[_tmp28_];
			_vala_assert (g_strcmp0 (_tmp26_, _tmp29_) == 0, "e == contains[i++]");
			_g_free0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	_tmp30_ = contains;
	_tmp30__length1 = contains_length1;
	_vala_assert (i == ((guint) _tmp30__length1), "i == contains.length");
	_tmp31_ = self->priv->subset;
	_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
	iter = _tmp32_;
	if (self->priv->type != SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY) {
		GeeIterator* _tmp33_;
		GeeIterator* _tmp34_;
		GeeIterator* _tmp35_;
		gpointer _tmp36_;
		gchar* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		const gchar* _tmp39_;
		GeeIterator* _tmp40_;
		GeeIterator* _tmp41_;
		GeeIterator* _tmp42_;
		gpointer _tmp43_;
		gchar* _tmp44_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		const gchar* _tmp46_;
		_tmp33_ = iter;
		_vala_assert (gee_iterator_has_next (_tmp33_), "iter.has_next ()");
		_tmp34_ = iter;
		_vala_assert (gee_iterator_next (_tmp34_), "iter.next ()");
		_tmp35_ = iter;
		_tmp36_ = gee_iterator_get (_tmp35_);
		_tmp37_ = (gchar*) _tmp36_;
		_tmp38_ = contains;
		_tmp38__length1 = contains_length1;
		_tmp39_ = _tmp38_[0];
		_vala_assert (g_strcmp0 (_tmp37_, _tmp39_) == 0, "iter.get () == contains[0]");
		_g_free0 (_tmp37_);
		_tmp40_ = iter;
		_vala_assert (gee_iterator_has_next (_tmp40_), "iter.has_next ()");
		_tmp41_ = iter;
		_vala_assert (gee_iterator_next (_tmp41_), "iter.next ()");
		_tmp42_ = iter;
		_tmp43_ = gee_iterator_get (_tmp42_);
		_tmp44_ = (gchar*) _tmp43_;
		_tmp45_ = contains;
		_tmp45__length1 = contains_length1;
		_tmp46_ = _tmp45_[1];
		_vala_assert (g_strcmp0 (_tmp44_, _tmp46_) == 0, "iter.get () == contains[1]");
		_g_free0 (_tmp44_);
	} else {
		if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
			GeeIterator* _tmp47_;
			_tmp47_ = iter;
			gee_iterator_remove (_tmp47_);
			exit (0);
		}
		g_test_trap_assert_failed ();
	}
	_g_object_unref0 (iter);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}

void
sorted_set_tests_sub_set_tests_test_clear (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	GeeSortedSet* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gchar** _tmp46_;
	gint _tmp46__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar** _tmp16_;
			_tmp9_ = g_strdup ("four");
			_tmp10_ = g_strdup ("five");
			_tmp11_ = g_new0 (gchar*, 2 + 1);
			_tmp11_[0] = _tmp9_;
			_tmp11_[1] = _tmp10_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp11_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp12_ = g_strdup ("one");
			_tmp13_ = g_strdup ("two");
			_tmp14_ = g_strdup ("three");
			_tmp15_ = g_strdup ("six");
			_tmp16_ = g_new0 (gchar*, 4 + 1);
			_tmp16_[0] = _tmp12_;
			_tmp16_[1] = _tmp13_;
			_tmp16_[2] = _tmp14_;
			_tmp16_[3] = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp16_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar** _tmp24_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp20_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp21_ = g_strdup ("one");
			_tmp22_ = g_strdup ("four");
			_tmp23_ = g_strdup ("five");
			_tmp24_ = g_new0 (gchar*, 3 + 1);
			_tmp24_[0] = _tmp21_;
			_tmp24_[1] = _tmp22_;
			_tmp24_[2] = _tmp23_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp24_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			_tmp25_ = g_strdup ("one");
			_tmp26_ = g_strdup ("four");
			_tmp27_ = g_strdup ("six");
			_tmp28_ = g_new0 (gchar*, 3 + 1);
			_tmp28_[0] = _tmp25_;
			_tmp28_[1] = _tmp26_;
			_tmp28_[2] = _tmp27_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp28_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp29_ = g_strdup ("two");
			_tmp30_ = g_strdup ("three");
			_tmp31_ = g_strdup ("five");
			_tmp32_ = g_new0 (gchar*, 3 + 1);
			_tmp32_[0] = _tmp29_;
			_tmp32_[1] = _tmp30_;
			_tmp32_[2] = _tmp31_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp32_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			gchar** _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar** _tmp40_;
			_tmp33_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp33_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp34_ = g_strdup ("one");
			_tmp35_ = g_strdup ("two");
			_tmp36_ = g_strdup ("three");
			_tmp37_ = g_strdup ("four");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_strdup ("six");
			_tmp40_ = g_new0 (gchar*, 6 + 1);
			_tmp40_[0] = _tmp34_;
			_tmp40_[1] = _tmp35_;
			_tmp40_[2] = _tmp36_;
			_tmp40_[3] = _tmp37_;
			_tmp40_[4] = _tmp38_;
			_tmp40_[5] = _tmp39_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp40_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp41_ = self->priv->subset;
	gee_collection_clear ((GeeCollection*) _tmp41_);
	_tmp42_ = contains;
	_tmp42__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp42_;
		s_collection_length1 = _tmp42__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp43_;
			gchar* s = NULL;
			_tmp43_ = g_strdup (s_collection[s_it]);
			s = _tmp43_;
			{
				GeeSortedSet* _tmp44_;
				const gchar* _tmp45_;
				_tmp44_ = self->priv->master;
				_tmp45_ = s;
				_vala_assert (!gee_collection_contains ((GeeCollection*) _tmp44_, _tmp45_), "!master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp46_ = not_contains;
	_tmp46__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp46_;
		s_collection_length1 = _tmp46__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp47_;
			gchar* s = NULL;
			_tmp47_ = g_strdup (s_collection[s_it]);
			s = _tmp47_;
			{
				GeeSortedSet* _tmp48_;
				const gchar* _tmp49_;
				_tmp48_ = self->priv->master;
				_tmp49_ = s;
				_vala_assert (gee_collection_contains ((GeeCollection*) _tmp48_, _tmp49_), "master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}

void
sorted_set_tests_sub_set_tests_test_boundaries (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			GeeSortedSet* _tmp12_;
			gpointer _tmp13_;
			gchar* _tmp14_;
			_tmp9_ = self->priv->subset;
			_tmp10_ = gee_sorted_set_first (_tmp9_);
			_tmp11_ = (gchar*) _tmp10_;
			_vala_assert (g_strcmp0 (_tmp11_, "five") == 0, "subset.first () == \"five\"");
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->subset;
			_tmp13_ = gee_sorted_set_last (_tmp12_);
			_tmp14_ = (gchar*) _tmp13_;
			_vala_assert (g_strcmp0 (_tmp14_, "four") == 0, "subset.last () == \"four\"");
			_g_free0 (_tmp14_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			GeeSortedSet* _tmp18_;
			gpointer _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->priv->subset;
			_tmp16_ = gee_sorted_set_first (_tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			_vala_assert (g_strcmp0 (_tmp17_, "six") == 0, "subset.first () == \"six\"");
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->subset;
			_tmp19_ = gee_sorted_set_last (_tmp18_);
			_tmp20_ = (gchar*) _tmp19_;
			_vala_assert (g_strcmp0 (_tmp20_, "two") == 0, "subset.last () == \"two\"");
			_g_free0 (_tmp20_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp21_;
			gpointer _tmp22_;
			gchar* _tmp23_;
			GeeSortedSet* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_sorted_set_first (_tmp21_);
			_tmp23_ = (gchar*) _tmp22_;
			_vala_assert (g_strcmp0 (_tmp23_, "four") == 0, "subset.first () == \"four\"");
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_sorted_set_last (_tmp24_);
			_tmp26_ = (gchar*) _tmp25_;
			_vala_assert (g_strcmp0 (_tmp26_, "six") == 0, "subset.last () == \"six\"");
			_g_free0 (_tmp26_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			if (self->priv->strict) {
				if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
					GeeSortedSet* _tmp27_;
					gpointer _tmp28_;
					gchar* _tmp29_;
					_tmp27_ = self->priv->subset;
					_tmp28_ = gee_sorted_set_first (_tmp27_);
					_tmp29_ = (gchar*) _tmp28_;
					_g_free0 (_tmp29_);
					exit (0);
				}
				g_test_trap_assert_failed ();
				if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
					GeeSortedSet* _tmp30_;
					gpointer _tmp31_;
					gchar* _tmp32_;
					_tmp30_ = self->priv->subset;
					_tmp31_ = gee_sorted_set_last (_tmp30_);
					_tmp32_ = (gchar*) _tmp31_;
					_g_free0 (_tmp32_);
					exit (0);
				}
				g_test_trap_assert_failed ();
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sorted_set_tests_sub_set_tests_test_iterator_at (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp51_;
	gint _tmp51__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar** _tmp16_;
			_tmp9_ = g_strdup ("four");
			_tmp10_ = g_strdup ("five");
			_tmp11_ = g_new0 (gchar*, 2 + 1);
			_tmp11_[0] = _tmp9_;
			_tmp11_[1] = _tmp10_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp11_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp12_ = g_strdup ("one");
			_tmp13_ = g_strdup ("two");
			_tmp14_ = g_strdup ("three");
			_tmp15_ = g_strdup ("six");
			_tmp16_ = g_new0 (gchar*, 4 + 1);
			_tmp16_[0] = _tmp12_;
			_tmp16_[1] = _tmp13_;
			_tmp16_[2] = _tmp14_;
			_tmp16_[3] = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp16_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar** _tmp24_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp20_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp21_ = g_strdup ("one");
			_tmp22_ = g_strdup ("four");
			_tmp23_ = g_strdup ("five");
			_tmp24_ = g_new0 (gchar*, 3 + 1);
			_tmp24_[0] = _tmp21_;
			_tmp24_[1] = _tmp22_;
			_tmp24_[2] = _tmp23_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp24_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			_tmp25_ = g_strdup ("one");
			_tmp26_ = g_strdup ("four");
			_tmp27_ = g_strdup ("six");
			_tmp28_ = g_new0 (gchar*, 3 + 1);
			_tmp28_[0] = _tmp25_;
			_tmp28_[1] = _tmp26_;
			_tmp28_[2] = _tmp27_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp28_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp29_ = g_strdup ("two");
			_tmp30_ = g_strdup ("three");
			_tmp31_ = g_strdup ("five");
			_tmp32_ = g_new0 (gchar*, 3 + 1);
			_tmp32_[0] = _tmp29_;
			_tmp32_[1] = _tmp30_;
			_tmp32_[2] = _tmp31_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp32_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			gchar** _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar** _tmp40_;
			_tmp33_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp33_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp34_ = g_strdup ("one");
			_tmp35_ = g_strdup ("two");
			_tmp36_ = g_strdup ("three");
			_tmp37_ = g_strdup ("four");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_strdup ("six");
			_tmp40_ = g_new0 (gchar*, 6 + 1);
			_tmp40_[0] = _tmp34_;
			_tmp40_[1] = _tmp35_;
			_tmp40_[2] = _tmp36_;
			_tmp40_[3] = _tmp37_;
			_tmp40_[4] = _tmp38_;
			_tmp40_[5] = _tmp39_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp40_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp41_ = contains;
	_tmp41__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp41_;
		s_collection_length1 = _tmp41__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp42_;
			gchar* s = NULL;
			_tmp42_ = g_strdup (s_collection[s_it]);
			s = _tmp42_;
			{
				GeeIterator* iter = NULL;
				GeeSortedSet* _tmp43_;
				const gchar* _tmp44_;
				GeeIterator* _tmp45_;
				GeeIterator* _tmp46_;
				GeeIterator* _tmp47_;
				gpointer _tmp48_;
				gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp43_ = self->priv->subset;
				_tmp44_ = s;
				_tmp45_ = gee_sorted_set_iterator_at (_tmp43_, _tmp44_);
				iter = _tmp45_;
				_tmp46_ = iter;
				_vala_assert (_tmp46_ != NULL, "iter != null");
				_tmp47_ = iter;
				_tmp48_ = gee_iterator_get (_tmp47_);
				_tmp49_ = (gchar*) _tmp48_;
				_tmp50_ = s;
				_vala_assert (g_strcmp0 (_tmp49_, _tmp50_) == 0, "iter.get () == s");
				_g_free0 (_tmp49_);
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	_tmp51_ = not_contains;
	_tmp51__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp51_;
		s_collection_length1 = _tmp51__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp52_;
			gchar* s = NULL;
			_tmp52_ = g_strdup (s_collection[s_it]);
			s = _tmp52_;
			{
				GeeIterator* iter = NULL;
				GeeSortedSet* _tmp53_;
				const gchar* _tmp54_;
				GeeIterator* _tmp55_;
				GeeIterator* _tmp56_;
				_tmp53_ = self->priv->subset;
				_tmp54_ = s;
				_tmp55_ = gee_sorted_set_iterator_at (_tmp53_, _tmp54_);
				iter = _tmp55_;
				_tmp56_ = iter;
				_vala_assert (_tmp56_ == NULL, "iter == null");
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}

void
sorted_set_tests_sub_set_tests_test_lower (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			GeeSortedSet* _tmp12_;
			gpointer _tmp13_;
			gchar* _tmp14_;
			GeeSortedSet* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			GeeSortedSet* _tmp18_;
			gpointer _tmp19_;
			gchar* _tmp20_;
			_tmp9_ = self->priv->subset;
			_tmp10_ = gee_sorted_set_lower (_tmp9_, "a");
			_tmp11_ = (gchar*) _tmp10_;
			_vala_assert (_tmp11_ == NULL, "subset.lower (\"a\") == null");
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->subset;
			_tmp13_ = gee_sorted_set_lower (_tmp12_, "five");
			_tmp14_ = (gchar*) _tmp13_;
			_vala_assert (_tmp14_ == NULL, "subset.lower (\"five\") == null");
			_g_free0 (_tmp14_);
			_tmp15_ = self->priv->subset;
			_tmp16_ = gee_sorted_set_lower (_tmp15_, "four");
			_tmp17_ = (gchar*) _tmp16_;
			_vala_assert (g_strcmp0 (_tmp17_, "five") == 0, "subset.lower (\"four\") == \"five\"");
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->subset;
			_tmp19_ = gee_sorted_set_lower (_tmp18_, "six");
			_tmp20_ = (gchar*) _tmp19_;
			_vala_assert (g_strcmp0 (_tmp20_, "four") == 0, "subset.lower (\"six\") == \"four\"");
			_g_free0 (_tmp20_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp21_;
			gpointer _tmp22_;
			gchar* _tmp23_;
			GeeSortedSet* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			GeeSortedSet* _tmp27_;
			gpointer _tmp28_;
			gchar* _tmp29_;
			GeeSortedSet* _tmp30_;
			gpointer _tmp31_;
			gchar* _tmp32_;
			GeeSortedSet* _tmp33_;
			gpointer _tmp34_;
			gchar* _tmp35_;
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_sorted_set_lower (_tmp21_, "one");
			_tmp23_ = (gchar*) _tmp22_;
			_vala_assert (_tmp23_ == NULL, "subset.lower (\"one\") == null");
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_sorted_set_lower (_tmp24_, "six");
			_tmp26_ = (gchar*) _tmp25_;
			_vala_assert (_tmp26_ == NULL, "subset.lower (\"six\") == null");
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->subset;
			_tmp28_ = gee_sorted_set_lower (_tmp27_, "three");
			_tmp29_ = (gchar*) _tmp28_;
			_vala_assert (g_strcmp0 (_tmp29_, "six") == 0, "subset.lower (\"three\") == \"six\"");
			_g_free0 (_tmp29_);
			_tmp30_ = self->priv->subset;
			_tmp31_ = gee_sorted_set_lower (_tmp30_, "two");
			_tmp32_ = (gchar*) _tmp31_;
			_vala_assert (g_strcmp0 (_tmp32_, "three") == 0, "subset.lower (\"two\") == \"three\"");
			_g_free0 (_tmp32_);
			_tmp33_ = self->priv->subset;
			_tmp34_ = gee_sorted_set_lower (_tmp33_, "z");
			_tmp35_ = (gchar*) _tmp34_;
			_vala_assert (g_strcmp0 (_tmp35_, "two") == 0, "subset.lower (\"z\") == \"two\"");
			_g_free0 (_tmp35_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp36_;
			gpointer _tmp37_;
			gchar* _tmp38_;
			GeeSortedSet* _tmp39_;
			gpointer _tmp40_;
			gchar* _tmp41_;
			GeeSortedSet* _tmp42_;
			gpointer _tmp43_;
			gchar* _tmp44_;
			GeeSortedSet* _tmp45_;
			gpointer _tmp46_;
			gchar* _tmp47_;
			GeeSortedSet* _tmp48_;
			gpointer _tmp49_;
			gchar* _tmp50_;
			_tmp36_ = self->priv->subset;
			_tmp37_ = gee_sorted_set_lower (_tmp36_, "five");
			_tmp38_ = (gchar*) _tmp37_;
			_vala_assert (_tmp38_ == NULL, "subset.lower (\"five\") == null");
			_g_free0 (_tmp38_);
			_tmp39_ = self->priv->subset;
			_tmp40_ = gee_sorted_set_lower (_tmp39_, "four");
			_tmp41_ = (gchar*) _tmp40_;
			_vala_assert (_tmp41_ == NULL, "subset.lower (\"four\") == null");
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->subset;
			_tmp43_ = gee_sorted_set_lower (_tmp42_, "one");
			_tmp44_ = (gchar*) _tmp43_;
			_vala_assert (g_strcmp0 (_tmp44_, "four") == 0, "subset.lower (\"one\") == \"four\"");
			_g_free0 (_tmp44_);
			_tmp45_ = self->priv->subset;
			_tmp46_ = gee_sorted_set_lower (_tmp45_, "six");
			_tmp47_ = (gchar*) _tmp46_;
			_vala_assert (g_strcmp0 (_tmp47_, "one") == 0, "subset.lower (\"six\") == \"one\"");
			_g_free0 (_tmp47_);
			_tmp48_ = self->priv->subset;
			_tmp49_ = gee_sorted_set_lower (_tmp48_, "three");
			_tmp50_ = (gchar*) _tmp49_;
			_vala_assert (g_strcmp0 (_tmp50_, "six") == 0, "subset.lower (\"three\") == \"six\"");
			_g_free0 (_tmp50_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp51_;
			gpointer _tmp52_;
			gchar* _tmp53_;
			_tmp51_ = self->priv->subset;
			_tmp52_ = gee_sorted_set_lower (_tmp51_, "six");
			_tmp53_ = (gchar*) _tmp52_;
			_vala_assert (_tmp53_ == NULL, "subset.lower (\"six\") == null");
			_g_free0 (_tmp53_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sorted_set_tests_sub_set_tests_test_higher (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			GeeSortedSet* _tmp12_;
			gpointer _tmp13_;
			gchar* _tmp14_;
			GeeSortedSet* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			GeeSortedSet* _tmp18_;
			gpointer _tmp19_;
			gchar* _tmp20_;
			_tmp9_ = self->priv->subset;
			_tmp10_ = gee_sorted_set_higher (_tmp9_, "a");
			_tmp11_ = (gchar*) _tmp10_;
			_vala_assert (g_strcmp0 (_tmp11_, "five") == 0, "subset.higher (\"a\") == \"five\"");
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->subset;
			_tmp13_ = gee_sorted_set_higher (_tmp12_, "five");
			_tmp14_ = (gchar*) _tmp13_;
			_vala_assert (g_strcmp0 (_tmp14_, "four") == 0, "subset.higher (\"five\") == \"four\"");
			_g_free0 (_tmp14_);
			_tmp15_ = self->priv->subset;
			_tmp16_ = gee_sorted_set_higher (_tmp15_, "four");
			_tmp17_ = (gchar*) _tmp16_;
			_vala_assert (_tmp17_ == NULL, "subset.higher (\"four\") == null");
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->subset;
			_tmp19_ = gee_sorted_set_higher (_tmp18_, "six");
			_tmp20_ = (gchar*) _tmp19_;
			_vala_assert (_tmp20_ == NULL, "subset.higher (\"six\") == null");
			_g_free0 (_tmp20_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp21_;
			gpointer _tmp22_;
			gchar* _tmp23_;
			GeeSortedSet* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			GeeSortedSet* _tmp27_;
			gpointer _tmp28_;
			gchar* _tmp29_;
			GeeSortedSet* _tmp30_;
			gpointer _tmp31_;
			gchar* _tmp32_;
			GeeSortedSet* _tmp33_;
			gpointer _tmp34_;
			gchar* _tmp35_;
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_sorted_set_higher (_tmp21_, "one");
			_tmp23_ = (gchar*) _tmp22_;
			_vala_assert (g_strcmp0 (_tmp23_, "six") == 0, "subset.higher (\"one\") == \"six\"");
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_sorted_set_higher (_tmp24_, "six");
			_tmp26_ = (gchar*) _tmp25_;
			_vala_assert (g_strcmp0 (_tmp26_, "three") == 0, "subset.higher (\"six\") == \"three\"");
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->subset;
			_tmp28_ = gee_sorted_set_higher (_tmp27_, "three");
			_tmp29_ = (gchar*) _tmp28_;
			_vala_assert (g_strcmp0 (_tmp29_, "two") == 0, "subset.higher (\"three\") == \"two\"");
			_g_free0 (_tmp29_);
			_tmp30_ = self->priv->subset;
			_tmp31_ = gee_sorted_set_higher (_tmp30_, "two");
			_tmp32_ = (gchar*) _tmp31_;
			_vala_assert (_tmp32_ == NULL, "subset.higher (\"two\") == null");
			_g_free0 (_tmp32_);
			_tmp33_ = self->priv->subset;
			_tmp34_ = gee_sorted_set_higher (_tmp33_, "z");
			_tmp35_ = (gchar*) _tmp34_;
			_vala_assert (_tmp35_ == NULL, "subset.higher (\"z\") == null");
			_g_free0 (_tmp35_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp36_;
			gpointer _tmp37_;
			gchar* _tmp38_;
			GeeSortedSet* _tmp39_;
			gpointer _tmp40_;
			gchar* _tmp41_;
			GeeSortedSet* _tmp42_;
			gpointer _tmp43_;
			gchar* _tmp44_;
			GeeSortedSet* _tmp45_;
			gpointer _tmp46_;
			gchar* _tmp47_;
			GeeSortedSet* _tmp48_;
			gpointer _tmp49_;
			gchar* _tmp50_;
			_tmp36_ = self->priv->subset;
			_tmp37_ = gee_sorted_set_higher (_tmp36_, "five");
			_tmp38_ = (gchar*) _tmp37_;
			_vala_assert (g_strcmp0 (_tmp38_, "four") == 0, "subset.higher (\"five\") == \"four\"");
			_g_free0 (_tmp38_);
			_tmp39_ = self->priv->subset;
			_tmp40_ = gee_sorted_set_higher (_tmp39_, "four");
			_tmp41_ = (gchar*) _tmp40_;
			_vala_assert (g_strcmp0 (_tmp41_, "one") == 0, "subset.higher (\"four\") == \"one\"");
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->subset;
			_tmp43_ = gee_sorted_set_higher (_tmp42_, "one");
			_tmp44_ = (gchar*) _tmp43_;
			_vala_assert (g_strcmp0 (_tmp44_, "six") == 0, "subset.higher (\"one\") == \"six\"");
			_g_free0 (_tmp44_);
			_tmp45_ = self->priv->subset;
			_tmp46_ = gee_sorted_set_higher (_tmp45_, "six");
			_tmp47_ = (gchar*) _tmp46_;
			_vala_assert (_tmp47_ == NULL, "subset.higher (\"six\") == null");
			_g_free0 (_tmp47_);
			_tmp48_ = self->priv->subset;
			_tmp49_ = gee_sorted_set_higher (_tmp48_, "three");
			_tmp50_ = (gchar*) _tmp49_;
			_vala_assert (_tmp50_ == NULL, "subset.higher (\"three\") == null");
			_g_free0 (_tmp50_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp51_;
			gpointer _tmp52_;
			gchar* _tmp53_;
			_tmp51_ = self->priv->subset;
			_tmp52_ = gee_sorted_set_higher (_tmp51_, "six");
			_tmp53_ = (gchar*) _tmp52_;
			_vala_assert (_tmp53_ == NULL, "subset.higher (\"six\") == null");
			_g_free0 (_tmp53_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sorted_set_tests_sub_set_tests_test_floor (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			GeeSortedSet* _tmp12_;
			gpointer _tmp13_;
			gchar* _tmp14_;
			GeeSortedSet* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			GeeSortedSet* _tmp18_;
			gpointer _tmp19_;
			gchar* _tmp20_;
			_tmp9_ = self->priv->subset;
			_tmp10_ = gee_sorted_set_floor (_tmp9_, "a");
			_tmp11_ = (gchar*) _tmp10_;
			_vala_assert (_tmp11_ == NULL, "subset.floor (\"a\") == null");
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->subset;
			_tmp13_ = gee_sorted_set_floor (_tmp12_, "five");
			_tmp14_ = (gchar*) _tmp13_;
			_vala_assert (g_strcmp0 (_tmp14_, "five") == 0, "subset.floor (\"five\") == \"five\"");
			_g_free0 (_tmp14_);
			_tmp15_ = self->priv->subset;
			_tmp16_ = gee_sorted_set_floor (_tmp15_, "four");
			_tmp17_ = (gchar*) _tmp16_;
			_vala_assert (g_strcmp0 (_tmp17_, "four") == 0, "subset.floor (\"four\") == \"four\"");
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->subset;
			_tmp19_ = gee_sorted_set_floor (_tmp18_, "six");
			_tmp20_ = (gchar*) _tmp19_;
			_vala_assert (g_strcmp0 (_tmp20_, "four") == 0, "subset.floor (\"six\") == \"four\"");
			_g_free0 (_tmp20_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp21_;
			gpointer _tmp22_;
			gchar* _tmp23_;
			GeeSortedSet* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			GeeSortedSet* _tmp27_;
			gpointer _tmp28_;
			gchar* _tmp29_;
			GeeSortedSet* _tmp30_;
			gpointer _tmp31_;
			gchar* _tmp32_;
			GeeSortedSet* _tmp33_;
			gpointer _tmp34_;
			gchar* _tmp35_;
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_sorted_set_floor (_tmp21_, "one");
			_tmp23_ = (gchar*) _tmp22_;
			_vala_assert (_tmp23_ == NULL, "subset.floor (\"one\") == null");
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_sorted_set_floor (_tmp24_, "six");
			_tmp26_ = (gchar*) _tmp25_;
			_vala_assert (g_strcmp0 (_tmp26_, "six") == 0, "subset.floor (\"six\") == \"six\"");
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->subset;
			_tmp28_ = gee_sorted_set_floor (_tmp27_, "three");
			_tmp29_ = (gchar*) _tmp28_;
			_vala_assert (g_strcmp0 (_tmp29_, "three") == 0, "subset.floor (\"three\") == \"three\"");
			_g_free0 (_tmp29_);
			_tmp30_ = self->priv->subset;
			_tmp31_ = gee_sorted_set_floor (_tmp30_, "two");
			_tmp32_ = (gchar*) _tmp31_;
			_vala_assert (g_strcmp0 (_tmp32_, "two") == 0, "subset.floor (\"two\") == \"two\"");
			_g_free0 (_tmp32_);
			_tmp33_ = self->priv->subset;
			_tmp34_ = gee_sorted_set_floor (_tmp33_, "z");
			_tmp35_ = (gchar*) _tmp34_;
			_vala_assert (g_strcmp0 (_tmp35_, "two") == 0, "subset.floor (\"z\") == \"two\"");
			_g_free0 (_tmp35_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp36_;
			gpointer _tmp37_;
			gchar* _tmp38_;
			GeeSortedSet* _tmp39_;
			gpointer _tmp40_;
			gchar* _tmp41_;
			GeeSortedSet* _tmp42_;
			gpointer _tmp43_;
			gchar* _tmp44_;
			GeeSortedSet* _tmp45_;
			gpointer _tmp46_;
			gchar* _tmp47_;
			GeeSortedSet* _tmp48_;
			gpointer _tmp49_;
			gchar* _tmp50_;
			_tmp36_ = self->priv->subset;
			_tmp37_ = gee_sorted_set_floor (_tmp36_, "five");
			_tmp38_ = (gchar*) _tmp37_;
			_vala_assert (_tmp38_ == NULL, "subset.floor (\"five\") == null");
			_g_free0 (_tmp38_);
			_tmp39_ = self->priv->subset;
			_tmp40_ = gee_sorted_set_floor (_tmp39_, "four");
			_tmp41_ = (gchar*) _tmp40_;
			_vala_assert (g_strcmp0 (_tmp41_, "four") == 0, "subset.floor (\"four\") == \"four\"");
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->subset;
			_tmp43_ = gee_sorted_set_floor (_tmp42_, "one");
			_tmp44_ = (gchar*) _tmp43_;
			_vala_assert (g_strcmp0 (_tmp44_, "one") == 0, "subset.floor (\"one\") == \"one\"");
			_g_free0 (_tmp44_);
			_tmp45_ = self->priv->subset;
			_tmp46_ = gee_sorted_set_floor (_tmp45_, "six");
			_tmp47_ = (gchar*) _tmp46_;
			_vala_assert (g_strcmp0 (_tmp47_, "six") == 0, "subset.floor (\"six\") == \"six\"");
			_g_free0 (_tmp47_);
			_tmp48_ = self->priv->subset;
			_tmp49_ = gee_sorted_set_floor (_tmp48_, "three");
			_tmp50_ = (gchar*) _tmp49_;
			_vala_assert (g_strcmp0 (_tmp50_, "six") == 0, "subset.floor (\"three\") == \"six\"");
			_g_free0 (_tmp50_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp51_;
			gpointer _tmp52_;
			gchar* _tmp53_;
			_tmp51_ = self->priv->subset;
			_tmp52_ = gee_sorted_set_floor (_tmp51_, "six");
			_tmp53_ = (gchar*) _tmp52_;
			_vala_assert (_tmp53_ == NULL, "subset.floor (\"six\") == null");
			_g_free0 (_tmp53_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sorted_set_tests_sub_set_tests_test_ceil (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			GeeSortedSet* _tmp12_;
			gpointer _tmp13_;
			gchar* _tmp14_;
			GeeSortedSet* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			GeeSortedSet* _tmp18_;
			gpointer _tmp19_;
			gchar* _tmp20_;
			_tmp9_ = self->priv->subset;
			_tmp10_ = gee_sorted_set_ceil (_tmp9_, "a");
			_tmp11_ = (gchar*) _tmp10_;
			_vala_assert (g_strcmp0 (_tmp11_, "five") == 0, "subset.ceil (\"a\") == \"five\"");
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->subset;
			_tmp13_ = gee_sorted_set_ceil (_tmp12_, "five");
			_tmp14_ = (gchar*) _tmp13_;
			_vala_assert (g_strcmp0 (_tmp14_, "five") == 0, "subset.ceil (\"five\") == \"five\"");
			_g_free0 (_tmp14_);
			_tmp15_ = self->priv->subset;
			_tmp16_ = gee_sorted_set_ceil (_tmp15_, "four");
			_tmp17_ = (gchar*) _tmp16_;
			_vala_assert (g_strcmp0 (_tmp17_, "four") == 0, "subset.ceil (\"four\") == \"four\"");
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->subset;
			_tmp19_ = gee_sorted_set_ceil (_tmp18_, "six");
			_tmp20_ = (gchar*) _tmp19_;
			_vala_assert (_tmp20_ == NULL, "subset.ceil (\"six\") == null");
			_g_free0 (_tmp20_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* _tmp21_;
			gpointer _tmp22_;
			gchar* _tmp23_;
			GeeSortedSet* _tmp24_;
			gpointer _tmp25_;
			gchar* _tmp26_;
			GeeSortedSet* _tmp27_;
			gpointer _tmp28_;
			gchar* _tmp29_;
			GeeSortedSet* _tmp30_;
			gpointer _tmp31_;
			gchar* _tmp32_;
			GeeSortedSet* _tmp33_;
			gpointer _tmp34_;
			gchar* _tmp35_;
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_sorted_set_ceil (_tmp21_, "one");
			_tmp23_ = (gchar*) _tmp22_;
			_vala_assert (g_strcmp0 (_tmp23_, "six") == 0, "subset.ceil (\"one\") == \"six\"");
			_g_free0 (_tmp23_);
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_sorted_set_ceil (_tmp24_, "six");
			_tmp26_ = (gchar*) _tmp25_;
			_vala_assert (g_strcmp0 (_tmp26_, "six") == 0, "subset.ceil (\"six\") == \"six\"");
			_g_free0 (_tmp26_);
			_tmp27_ = self->priv->subset;
			_tmp28_ = gee_sorted_set_ceil (_tmp27_, "three");
			_tmp29_ = (gchar*) _tmp28_;
			_vala_assert (g_strcmp0 (_tmp29_, "three") == 0, "subset.ceil (\"three\") == \"three\"");
			_g_free0 (_tmp29_);
			_tmp30_ = self->priv->subset;
			_tmp31_ = gee_sorted_set_ceil (_tmp30_, "two");
			_tmp32_ = (gchar*) _tmp31_;
			_vala_assert (g_strcmp0 (_tmp32_, "two") == 0, "subset.ceil (\"two\") == \"two\"");
			_g_free0 (_tmp32_);
			_tmp33_ = self->priv->subset;
			_tmp34_ = gee_sorted_set_ceil (_tmp33_, "z");
			_tmp35_ = (gchar*) _tmp34_;
			_vala_assert (_tmp35_ == NULL, "subset.ceil (\"z\") == null");
			_g_free0 (_tmp35_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* _tmp36_;
			gpointer _tmp37_;
			gchar* _tmp38_;
			GeeSortedSet* _tmp39_;
			gpointer _tmp40_;
			gchar* _tmp41_;
			GeeSortedSet* _tmp42_;
			gpointer _tmp43_;
			gchar* _tmp44_;
			GeeSortedSet* _tmp45_;
			gpointer _tmp46_;
			gchar* _tmp47_;
			GeeSortedSet* _tmp48_;
			gpointer _tmp49_;
			gchar* _tmp50_;
			_tmp36_ = self->priv->subset;
			_tmp37_ = gee_sorted_set_ceil (_tmp36_, "five");
			_tmp38_ = (gchar*) _tmp37_;
			_vala_assert (g_strcmp0 (_tmp38_, "four") == 0, "subset.ceil (\"five\") == \"four\"");
			_g_free0 (_tmp38_);
			_tmp39_ = self->priv->subset;
			_tmp40_ = gee_sorted_set_ceil (_tmp39_, "four");
			_tmp41_ = (gchar*) _tmp40_;
			_vala_assert (g_strcmp0 (_tmp41_, "four") == 0, "subset.ceil (\"four\") == \"four\"");
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->subset;
			_tmp43_ = gee_sorted_set_ceil (_tmp42_, "one");
			_tmp44_ = (gchar*) _tmp43_;
			_vala_assert (g_strcmp0 (_tmp44_, "one") == 0, "subset.ceil (\"one\") == \"one\"");
			_g_free0 (_tmp44_);
			_tmp45_ = self->priv->subset;
			_tmp46_ = gee_sorted_set_ceil (_tmp45_, "six");
			_tmp47_ = (gchar*) _tmp46_;
			_vala_assert (g_strcmp0 (_tmp47_, "six") == 0, "subset.ceil (\"six\") == \"six\"");
			_g_free0 (_tmp47_);
			_tmp48_ = self->priv->subset;
			_tmp49_ = gee_sorted_set_ceil (_tmp48_, "three");
			_tmp50_ = (gchar*) _tmp49_;
			_vala_assert (_tmp50_ == NULL, "subset.ceil (\"three\") == null");
			_g_free0 (_tmp50_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp51_;
			gpointer _tmp52_;
			gchar* _tmp53_;
			_tmp51_ = self->priv->subset;
			_tmp52_ = gee_sorted_set_ceil (_tmp51_, "six");
			_tmp53_ = (gchar*) _tmp52_;
			_vala_assert (_tmp53_ == NULL, "subset.ceil (\"six\") == null");
			_g_free0 (_tmp53_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sorted_set_tests_sub_set_tests_test_subsets (SortedSetTestsSubSetTests* self)
{
	GeeSortedSet* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* _tmp5_;
	GeeSortedSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp0_, "one"), "master.add (\"one\")");
	_tmp1_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp1_, "two"), "master.add (\"two\")");
	_tmp2_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp2_, "three"), "master.add (\"three\")");
	_tmp3_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp3_, "four"), "master.add (\"four\")");
	_tmp4_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp4_, "five"), "master.add (\"five\")");
	_tmp5_ = self->priv->master;
	_vala_assert (gee_collection_add ((GeeCollection*) _tmp5_, "six"), "master.add (\"six\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_assert (_tmp8_ == 6, "master.size == 6");
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_HEAD:
		{
			GeeSortedSet* subsubset = NULL;
			GeeSortedSet* _tmp9_;
			GeeSortedSet* _tmp10_;
			GeeSortedSet* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeSortedSet* _tmp14_;
			GeeSortedSet* _tmp15_;
			GeeSortedSet* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeSortedSet* _tmp19_;
			GeeSortedSet* _tmp20_;
			GeeSortedSet* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			GeeSortedSet* _tmp24_;
			GeeSortedSet* _tmp25_;
			GeeSortedSet* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp9_ = self->priv->subset;
			_tmp10_ = gee_sorted_set_head_set (_tmp9_, "four");
			subsubset = _tmp10_;
			_tmp11_ = subsubset;
			_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_vala_assert (_tmp13_ == 1, "subsubset.size == 1");
			_tmp14_ = self->priv->subset;
			_tmp15_ = gee_sorted_set_tail_set (_tmp14_, "four");
			_g_object_unref0 (subsubset);
			subsubset = _tmp15_;
			_tmp16_ = subsubset;
			_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_vala_assert (_tmp18_ == 1, "subsubset.size == 1");
			_tmp19_ = self->priv->subset;
			_tmp20_ = gee_sorted_set_sub_set (_tmp19_, "four", "one");
			_g_object_unref0 (subsubset);
			subsubset = _tmp20_;
			_tmp21_ = subsubset;
			_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			_vala_assert (_tmp23_ == 1, "subsubset.size == 1");
			_tmp24_ = self->priv->subset;
			_tmp25_ = gee_sorted_set_sub_set (_tmp24_, "four", "four");
			_g_object_unref0 (subsubset);
			subsubset = _tmp25_;
			_tmp26_ = subsubset;
			_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_vala_assert (_tmp28_ == 0, "subsubset.size == 0");
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_TAIL:
		{
			GeeSortedSet* subsubset = NULL;
			GeeSortedSet* _tmp29_;
			GeeSortedSet* _tmp30_;
			GeeSortedSet* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			GeeSortedSet* _tmp34_;
			GeeSortedSet* _tmp35_;
			GeeSortedSet* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			GeeSortedSet* _tmp39_;
			GeeSortedSet* _tmp40_;
			GeeSortedSet* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			_tmp29_ = self->priv->subset;
			_tmp30_ = gee_sorted_set_head_set (_tmp29_, "two");
			subsubset = _tmp30_;
			_tmp31_ = subsubset;
			_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			_vala_assert (_tmp33_ == 2, "subsubset.size == 2");
			_tmp34_ = self->priv->subset;
			_tmp35_ = gee_sorted_set_tail_set (_tmp34_, "three");
			_g_object_unref0 (subsubset);
			subsubset = _tmp35_;
			_tmp36_ = subsubset;
			_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_vala_assert (_tmp38_ == 2, "subsubset.size == 2");
			_tmp39_ = self->priv->subset;
			_tmp40_ = gee_sorted_set_sub_set (_tmp39_, "three", "two");
			_g_object_unref0 (subsubset);
			subsubset = _tmp40_;
			_tmp41_ = subsubset;
			_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_vala_assert (_tmp43_ == 1, "subsubset.size == 1");
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_SUB:
		{
			GeeSortedSet* subsubset = NULL;
			GeeSortedSet* _tmp44_;
			GeeSortedSet* _tmp45_;
			GeeSortedSet* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			GeeSortedSet* _tmp49_;
			GeeSortedSet* _tmp50_;
			GeeSortedSet* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			GeeSortedSet* _tmp54_;
			GeeSortedSet* _tmp55_;
			GeeSortedSet* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			GeeSortedSet* _tmp59_;
			GeeSortedSet* _tmp60_;
			GeeSortedSet* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			_tmp44_ = self->priv->subset;
			_tmp45_ = gee_sorted_set_head_set (_tmp44_, "six");
			subsubset = _tmp45_;
			_tmp46_ = subsubset;
			_tmp47_ = gee_collection_get_size ((GeeCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_vala_assert (_tmp48_ == 2, "subsubset.size == 2");
			_tmp49_ = self->priv->subset;
			_tmp50_ = gee_sorted_set_tail_set (_tmp49_, "one");
			_g_object_unref0 (subsubset);
			subsubset = _tmp50_;
			_tmp51_ = subsubset;
			_tmp52_ = gee_collection_get_size ((GeeCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_vala_assert (_tmp53_ == 2, "subsubset.size == 2");
			_tmp54_ = self->priv->subset;
			_tmp55_ = gee_sorted_set_sub_set (_tmp54_, "one", "six");
			_g_object_unref0 (subsubset);
			subsubset = _tmp55_;
			_tmp56_ = subsubset;
			_tmp57_ = gee_collection_get_size ((GeeCollection*) _tmp56_);
			_tmp58_ = _tmp57_;
			_vala_assert (_tmp58_ == 1, "subsubset.size == 1");
			_tmp59_ = self->priv->subset;
			_tmp60_ = gee_sorted_set_sub_set (_tmp59_, "five", "two");
			_g_object_unref0 (subsubset);
			subsubset = _tmp60_;
			_tmp61_ = subsubset;
			_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
			_tmp63_ = _tmp62_;
			_vala_assert (_tmp63_ == 3, "subsubset.size == 3");
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TESTS_TYPE_EMPTY:
		{
			GeeSortedSet* subsubset = NULL;
			GeeSortedSet* _tmp64_;
			GeeSortedSet* _tmp65_;
			GeeSortedSet* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			GeeSortedSet* _tmp69_;
			GeeSortedSet* _tmp70_;
			GeeSortedSet* _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			GeeSortedSet* _tmp74_;
			GeeSortedSet* _tmp75_;
			GeeSortedSet* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			_tmp64_ = self->priv->subset;
			_tmp65_ = gee_sorted_set_head_set (_tmp64_, "six");
			subsubset = _tmp65_;
			_tmp66_ = subsubset;
			_tmp67_ = gee_collection_get_size ((GeeCollection*) _tmp66_);
			_tmp68_ = _tmp67_;
			_vala_assert (_tmp68_ == 0, "subsubset.size == 0");
			_tmp69_ = self->priv->subset;
			_tmp70_ = gee_sorted_set_tail_set (_tmp69_, "three");
			_g_object_unref0 (subsubset);
			subsubset = _tmp70_;
			_tmp71_ = subsubset;
			_tmp72_ = gee_collection_get_size ((GeeCollection*) _tmp71_);
			_tmp73_ = _tmp72_;
			_vala_assert (_tmp73_ == 0, "subsubset.size == 0");
			_tmp74_ = self->priv->subset;
			_tmp75_ = gee_sorted_set_sub_set (_tmp74_, "one", "six");
			_g_object_unref0 (subsubset);
			subsubset = _tmp75_;
			_tmp76_ = subsubset;
			_tmp77_ = gee_collection_get_size ((GeeCollection*) _tmp76_);
			_tmp78_ = _tmp77_;
			_vala_assert (_tmp78_ == 0, "subsubset.size == 0");
			_g_object_unref0 (subsubset);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
sorted_set_tests_sub_set_tests_class_init (SortedSetTestsSubSetTestsClass * klass,
                                           gpointer klass_data)
{
	sorted_set_tests_sub_set_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SortedSetTestsSubSetTests_private_offset);
	((GeeTestCaseClass *) klass)->set_up = (void (*) (GeeTestCase*)) sorted_set_tests_sub_set_tests_real_set_up;
	((GeeTestCaseClass *) klass)->tear_down = (void (*) (GeeTestCase*)) sorted_set_tests_sub_set_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = sorted_set_tests_sub_set_tests_finalize;
}

static void
sorted_set_tests_sub_set_tests_instance_init (SortedSetTestsSubSetTests * self,
                                              gpointer klass)
{
	self->priv = sorted_set_tests_sub_set_tests_get_instance_private (self);
}

static void
sorted_set_tests_sub_set_tests_finalize (GObject * obj)
{
	SortedSetTestsSubSetTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SORTED_SET_TESTS_TYPE_SUB_SET_TESTS, SortedSetTestsSubSetTests);
	_g_object_unref0 (self->priv->master);
	_g_object_unref0 (self->priv->subset);
	_g_object_unref0 (self->priv->test);
	G_OBJECT_CLASS (sorted_set_tests_sub_set_tests_parent_class)->finalize (obj);
}

static GType
sorted_set_tests_sub_set_tests_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsSubSetTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_sub_set_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTestsSubSetTests), 0, (GInstanceInitFunc) sorted_set_tests_sub_set_tests_instance_init, NULL };
	GType sorted_set_tests_sub_set_tests_type_id;
	sorted_set_tests_sub_set_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "SortedSetTestsSubSetTests", &g_define_type_info, 0);
	SortedSetTestsSubSetTests_private_offset = g_type_add_instance_private (sorted_set_tests_sub_set_tests_type_id, sizeof (SortedSetTestsSubSetTestsPrivate));
	return sorted_set_tests_sub_set_tests_type_id;
}

GType
sorted_set_tests_sub_set_tests_get_type (void)
{
	static volatile gsize sorted_set_tests_sub_set_tests_type_id__once = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_tests_type_id__once)) {
		GType sorted_set_tests_sub_set_tests_type_id;
		sorted_set_tests_sub_set_tests_type_id = sorted_set_tests_sub_set_tests_get_type_once ();
		g_once_init_leave (&sorted_set_tests_sub_set_tests_type_id__once, sorted_set_tests_sub_set_tests_type_id);
	}
	return sorted_set_tests_sub_set_tests_type_id__once;
}

static void
sorted_set_tests_class_init (SortedSetTestsClass * klass,
                             gpointer klass_data)
{
	sorted_set_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SortedSetTests_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sorted_set_tests_finalize;
}

static void
sorted_set_tests_instance_init (SortedSetTests * self,
                                gpointer klass)
{
	self->priv = sorted_set_tests_get_instance_private (self);
}

static void
sorted_set_tests_finalize (GObject * obj)
{
	SortedSetTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SORTED_SET_TESTS, SortedSetTests);
	G_OBJECT_CLASS (sorted_set_tests_parent_class)->finalize (obj);
}

static GType
sorted_set_tests_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTests), 0, (GInstanceInitFunc) sorted_set_tests_instance_init, NULL };
	GType sorted_set_tests_type_id;
	sorted_set_tests_type_id = g_type_register_static (TYPE_SET_TESTS, "SortedSetTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SortedSetTests_private_offset = g_type_add_instance_private (sorted_set_tests_type_id, sizeof (SortedSetTestsPrivate));
	return sorted_set_tests_type_id;
}

GType
sorted_set_tests_get_type (void)
{
	static volatile gsize sorted_set_tests_type_id__once = 0;
	if (g_once_init_enter (&sorted_set_tests_type_id__once)) {
		GType sorted_set_tests_type_id;
		sorted_set_tests_type_id = sorted_set_tests_get_type_once ();
		g_once_init_leave (&sorted_set_tests_type_id__once, sorted_set_tests_type_id);
	}
	return sorted_set_tests_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

