/*
 * Copyright 2019 by its authors. See AUTHORS.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <Eo.h>
#include <Ecore.h>

#define EOLIANCXXTEST_API
#define EOLIANCXXTEST_API_WEAK

#include <a.eo.hh>

#include "eolian_cxx_suite.h"

EFL_START_TEST(eolian_cxx_test_wrapper_size)
{
  efl::eo::eo_init init;

  ::efl::eo::concrete b(nullptr);
  ::nonamespace::A c;

  fail_if(sizeof(b) != sizeof(Eo*));
  fail_if(sizeof(b) != sizeof(c));
}
EFL_END_TEST

void
eolian_cxx_test_wrapper(TCase* tc)
{
  tcase_add_test(tc, eolian_cxx_test_wrapper_size);
}
