# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_rustup_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_rustup_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_rustup_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_rustup_using_subcommand
	set -l cmd (__fish_rustup_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c rustup -n "__fish_rustup_needs_command" -s v -l verbose -d 'Set log level to \'DEBUG\' if \'RUSTUP_LOG\' is unset'
complete -c rustup -n "__fish_rustup_needs_command" -s q -l quiet -d 'Disable progress output, set log level to \'WARN\' if \'RUSTUP_LOG\' is unset'
complete -c rustup -n "__fish_rustup_needs_command" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_needs_command" -s V -l version -d 'Print version'
complete -c rustup -n "__fish_rustup_needs_command" -a "install" -d 'Install or update the given toolchains, or by default the active toolchain'
complete -c rustup -n "__fish_rustup_needs_command" -a "uninstall" -d 'Uninstall the given toolchains'
complete -c rustup -n "__fish_rustup_needs_command" -a "dump-testament" -d 'Dump information about the build'
complete -c rustup -n "__fish_rustup_needs_command" -a "toolchain" -d 'Install, uninstall, or list toolchains'
complete -c rustup -n "__fish_rustup_needs_command" -a "default" -d 'Set the default toolchain'
complete -c rustup -n "__fish_rustup_needs_command" -a "show" -d 'Show the active and installed toolchains or profiles'
complete -c rustup -n "__fish_rustup_needs_command" -a "update" -d 'Update Rust toolchains and rustup'
complete -c rustup -n "__fish_rustup_needs_command" -a "check" -d 'Check for updates to Rust toolchains and rustup'
complete -c rustup -n "__fish_rustup_needs_command" -a "target" -d 'Modify a toolchain\'s supported targets'
complete -c rustup -n "__fish_rustup_needs_command" -a "component" -d 'Modify a toolchain\'s installed components'
complete -c rustup -n "__fish_rustup_needs_command" -a "override" -d 'Modify toolchain overrides for directories'
complete -c rustup -n "__fish_rustup_needs_command" -a "run" -d 'Run a command with an environment configured for a given toolchain'
complete -c rustup -n "__fish_rustup_needs_command" -a "which" -d 'Display which binary will be run for a given command'
complete -c rustup -n "__fish_rustup_needs_command" -a "doc" -d 'Open the documentation for the current toolchain'
complete -c rustup -n "__fish_rustup_needs_command" -a "self" -d 'Modify the rustup installation'
complete -c rustup -n "__fish_rustup_needs_command" -a "set" -d 'Alter rustup settings'
complete -c rustup -n "__fish_rustup_needs_command" -a "completions" -d 'Generate tab-completion scripts for your shell'
complete -c rustup -n "__fish_rustup_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand install" -l profile -r -f -a "minimal\t''
default\t''
complete\t''"
complete -c rustup -n "__fish_rustup_using_subcommand install" -s c -l component -d 'Comma-separated list of components to be added on installation' -r
complete -c rustup -n "__fish_rustup_using_subcommand install" -s t -l target -d 'Comma-separated list of targets to be added on installation' -r
complete -c rustup -n "__fish_rustup_using_subcommand install" -l no-self-update -d 'Don\'t perform self update when running the `rustup toolchain install` command'
complete -c rustup -n "__fish_rustup_using_subcommand install" -l force -d 'Force an update, even if some components are missing'
complete -c rustup -n "__fish_rustup_using_subcommand install" -l allow-downgrade -d 'Allow rustup to downgrade the toolchain to satisfy your component choice'
complete -c rustup -n "__fish_rustup_using_subcommand install" -l force-non-host -d 'Install toolchains that require an emulator. See https://github.com/rust-lang/rustup/wiki/Non-host-toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand install" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand uninstall" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand dump-testament" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and not __fish_seen_subcommand_from list install uninstall link help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and not __fish_seen_subcommand_from list install uninstall link help" -f -a "list" -d 'List installed toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and not __fish_seen_subcommand_from list install uninstall link help" -f -a "install" -d 'Install or update the given toolchains, or by default the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and not __fish_seen_subcommand_from list install uninstall link help" -f -a "uninstall" -d 'Uninstall the given toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and not __fish_seen_subcommand_from list install uninstall link help" -f -a "link" -d 'Create a custom toolchain by symlinking to a directory'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and not __fish_seen_subcommand_from list install uninstall link help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Enable verbose output with toolchain information'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Force the output to be a single column'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -l profile -r -f -a "minimal\t''
default\t''
complete\t''"
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -s c -l component -d 'Comma-separated list of components to be added on installation' -r
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -s t -l target -d 'Comma-separated list of targets to be added on installation' -r
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -l no-self-update -d 'Don\'t perform self update when running the `rustup toolchain install` command'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -l force -d 'Force an update, even if some components are missing'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -l allow-downgrade -d 'Allow rustup to downgrade the toolchain to satisfy your component choice'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -l force-non-host -d 'Install toolchains that require an emulator. See https://github.com/rust-lang/rustup/wiki/Non-host-toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from install" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from uninstall" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from link" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from help" -f -a "list" -d 'List installed toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from help" -f -a "install" -d 'Install or update the given toolchains, or by default the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from help" -f -a "uninstall" -d 'Uninstall the given toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from help" -f -a "link" -d 'Create a custom toolchain by symlinking to a directory'
complete -c rustup -n "__fish_rustup_using_subcommand toolchain; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand default" -l force-non-host -d 'Install toolchains that require an emulator. See https://github.com/rust-lang/rustup/wiki/Non-host-toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand default" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand show; and not __fish_seen_subcommand_from active-toolchain home profile help" -s v -l verbose -d 'Enable verbose output with rustc information for all installed toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand show; and not __fish_seen_subcommand_from active-toolchain home profile help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand show; and not __fish_seen_subcommand_from active-toolchain home profile help" -f -a "active-toolchain" -d 'Show the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand show; and not __fish_seen_subcommand_from active-toolchain home profile help" -f -a "home" -d 'Display the computed value of RUSTUP_HOME'
complete -c rustup -n "__fish_rustup_using_subcommand show; and not __fish_seen_subcommand_from active-toolchain home profile help" -f -a "profile" -d 'Show the default profile used for the `rustup install` command'
complete -c rustup -n "__fish_rustup_using_subcommand show; and not __fish_seen_subcommand_from active-toolchain home profile help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from active-toolchain" -s v -l verbose -d 'Enable verbose output with rustc information'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from active-toolchain" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from home" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from profile" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from help" -f -a "active-toolchain" -d 'Show the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from help" -f -a "home" -d 'Display the computed value of RUSTUP_HOME'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from help" -f -a "profile" -d 'Show the default profile used for the `rustup install` command'
complete -c rustup -n "__fish_rustup_using_subcommand show; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand update" -l no-self-update -d 'Don\'t perform self update when running the `rustup update` command'
complete -c rustup -n "__fish_rustup_using_subcommand update" -l force -d 'Force an update, even if some components are missing'
complete -c rustup -n "__fish_rustup_using_subcommand update" -l force-non-host -d 'Install toolchains that require an emulator. See https://github.com/rust-lang/rustup/wiki/Non-host-toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand update" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand check" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand target; and not __fish_seen_subcommand_from list add remove help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand target; and not __fish_seen_subcommand_from list add remove help" -f -a "list" -d 'List installed and available targets'
complete -c rustup -n "__fish_rustup_using_subcommand target; and not __fish_seen_subcommand_from list add remove help" -f -a "add" -d 'Add a target to a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand target; and not __fish_seen_subcommand_from list add remove help" -f -a "remove" -d 'Remove a target from a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand target; and not __fish_seen_subcommand_from list add remove help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from list" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from list" -l installed -d 'List only installed targets'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Force the output to be a single column'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from add" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from remove" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from help" -f -a "list" -d 'List installed and available targets'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a target to a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a target from a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand target; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand component; and not __fish_seen_subcommand_from list add remove help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand component; and not __fish_seen_subcommand_from list add remove help" -f -a "list" -d 'List installed and available components'
complete -c rustup -n "__fish_rustup_using_subcommand component; and not __fish_seen_subcommand_from list add remove help" -f -a "add" -d 'Add a component to a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand component; and not __fish_seen_subcommand_from list add remove help" -f -a "remove" -d 'Remove a component from a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand component; and not __fish_seen_subcommand_from list add remove help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from list" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from list" -l installed -d 'List only installed components'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Force the output to be a single column'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from add" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from add" -l target -r
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from remove" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from remove" -l target -r
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from help" -f -a "list" -d 'List installed and available components'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a component to a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a component from a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand component; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand override; and not __fish_seen_subcommand_from list set unset help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand override; and not __fish_seen_subcommand_from list set unset help" -f -a "list" -d 'List directory toolchain overrides'
complete -c rustup -n "__fish_rustup_using_subcommand override; and not __fish_seen_subcommand_from list set unset help" -f -a "set" -d 'Set the override toolchain for a directory'
complete -c rustup -n "__fish_rustup_using_subcommand override; and not __fish_seen_subcommand_from list set unset help" -f -a "unset" -d 'Remove the override toolchain for a directory'
complete -c rustup -n "__fish_rustup_using_subcommand override; and not __fish_seen_subcommand_from list set unset help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from set" -l path -d 'Path to the directory' -r -F
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from unset" -l path -d 'Path to the directory' -r -F
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from unset" -l nonexistent -d 'Remove override toolchain for all nonexistent directories'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from unset" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from help" -f -a "list" -d 'List directory toolchain overrides'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from help" -f -a "set" -d 'Set the override toolchain for a directory'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from help" -f -a "unset" -d 'Remove the override toolchain for a directory'
complete -c rustup -n "__fish_rustup_using_subcommand override; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand run" -l install -d 'Install the requested toolchain if needed'
complete -c rustup -n "__fish_rustup_using_subcommand run" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand which" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', \'1.8.0\', or a custom toolchain name. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand which" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l toolchain -d 'Toolchain name, such as \'stable\', \'nightly\', or \'1.8.0\'. For more information see `rustup help toolchain`' -r
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l path -d 'Only print the path to the documentation'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l alloc -d 'The Rust core allocation and collections library'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l book -d 'The Rust Programming Language book'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l cargo -d 'The Cargo Book'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l clippy -d 'The Clippy Documentation'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l core -d 'The Rust Core Library'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l edition-guide -d 'The Rust Edition Guide'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l embedded-book -d 'The Embedded Rust Book'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l error-codes -d 'The Rust Error Codes Index'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l nomicon -d 'The Dark Arts of Advanced and Unsafe Rust Programming'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l proc_macro -d 'A support library for macro authors when defining new macros'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l reference -d 'The Rust Reference'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l rust-by-example -d 'A collection of runnable examples that illustrate various Rust concepts and standard libraries'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l rustc -d 'The compiler for the Rust programming language'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l rustdoc -d 'Documentation generator for Rust projects'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l std -d 'Standard library API documentation'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l style-guide -d 'The Rust Style Guide'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l test -d 'Support code for rustc\'s built in unit-test and micro-benchmarking framework'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -l unstable-book -d 'The Unstable Book'
complete -c rustup -n "__fish_rustup_using_subcommand doc" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand self; and not __fish_seen_subcommand_from update uninstall upgrade-data help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand self; and not __fish_seen_subcommand_from update uninstall upgrade-data help" -f -a "update" -d 'Download and install updates to rustup'
complete -c rustup -n "__fish_rustup_using_subcommand self; and not __fish_seen_subcommand_from update uninstall upgrade-data help" -f -a "uninstall" -d 'Uninstall rustup'
complete -c rustup -n "__fish_rustup_using_subcommand self; and not __fish_seen_subcommand_from update uninstall upgrade-data help" -f -a "upgrade-data" -d 'Upgrade the internal data format'
complete -c rustup -n "__fish_rustup_using_subcommand self; and not __fish_seen_subcommand_from update uninstall upgrade-data help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from uninstall" -s y
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from uninstall" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from upgrade-data" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "update" -d 'Download and install updates to rustup'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "uninstall" -d 'Uninstall rustup'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "upgrade-data" -d 'Upgrade the internal data format'
complete -c rustup -n "__fish_rustup_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand set; and not __fish_seen_subcommand_from default-host profile auto-self-update auto-install help" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand set; and not __fish_seen_subcommand_from default-host profile auto-self-update auto-install help" -f -a "default-host" -d 'The triple used to identify toolchains when not specified'
complete -c rustup -n "__fish_rustup_using_subcommand set; and not __fish_seen_subcommand_from default-host profile auto-self-update auto-install help" -f -a "profile" -d 'The default components installed with a toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand set; and not __fish_seen_subcommand_from default-host profile auto-self-update auto-install help" -f -a "auto-self-update" -d 'The rustup auto self update mode'
complete -c rustup -n "__fish_rustup_using_subcommand set; and not __fish_seen_subcommand_from default-host profile auto-self-update auto-install help" -f -a "auto-install" -d 'The auto toolchain install mode'
complete -c rustup -n "__fish_rustup_using_subcommand set; and not __fish_seen_subcommand_from default-host profile auto-self-update auto-install help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from default-host" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from profile" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from auto-self-update" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from auto-install" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from help" -f -a "default-host" -d 'The triple used to identify toolchains when not specified'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from help" -f -a "profile" -d 'The default components installed with a toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from help" -f -a "auto-self-update" -d 'The rustup auto self update mode'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from help" -f -a "auto-install" -d 'The auto toolchain install mode'
complete -c rustup -n "__fish_rustup_using_subcommand set; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand completions" -s h -l help -d 'Print help'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "install" -d 'Install or update the given toolchains, or by default the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "uninstall" -d 'Uninstall the given toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "dump-testament" -d 'Dump information about the build'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "toolchain" -d 'Install, uninstall, or list toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "default" -d 'Set the default toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "show" -d 'Show the active and installed toolchains or profiles'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "update" -d 'Update Rust toolchains and rustup'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "check" -d 'Check for updates to Rust toolchains and rustup'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "target" -d 'Modify a toolchain\'s supported targets'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "component" -d 'Modify a toolchain\'s installed components'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "override" -d 'Modify toolchain overrides for directories'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "run" -d 'Run a command with an environment configured for a given toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "which" -d 'Display which binary will be run for a given command'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "doc" -d 'Open the documentation for the current toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "self" -d 'Modify the rustup installation'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "set" -d 'Alter rustup settings'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "completions" -d 'Generate tab-completion scripts for your shell'
complete -c rustup -n "__fish_rustup_using_subcommand help; and not __fish_seen_subcommand_from install uninstall dump-testament toolchain default show update check target component override run which doc self set completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from toolchain" -f -a "list" -d 'List installed toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from toolchain" -f -a "install" -d 'Install or update the given toolchains, or by default the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from toolchain" -f -a "uninstall" -d 'Uninstall the given toolchains'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from toolchain" -f -a "link" -d 'Create a custom toolchain by symlinking to a directory'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from show" -f -a "active-toolchain" -d 'Show the active toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from show" -f -a "home" -d 'Display the computed value of RUSTUP_HOME'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from show" -f -a "profile" -d 'Show the default profile used for the `rustup install` command'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from target" -f -a "list" -d 'List installed and available targets'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from target" -f -a "add" -d 'Add a target to a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from target" -f -a "remove" -d 'Remove a target from a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from component" -f -a "list" -d 'List installed and available components'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from component" -f -a "add" -d 'Add a component to a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from component" -f -a "remove" -d 'Remove a component from a Rust toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from override" -f -a "list" -d 'List directory toolchain overrides'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from override" -f -a "set" -d 'Set the override toolchain for a directory'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from override" -f -a "unset" -d 'Remove the override toolchain for a directory'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from self" -f -a "update" -d 'Download and install updates to rustup'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from self" -f -a "uninstall" -d 'Uninstall rustup'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from self" -f -a "upgrade-data" -d 'Upgrade the internal data format'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from set" -f -a "default-host" -d 'The triple used to identify toolchains when not specified'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from set" -f -a "profile" -d 'The default components installed with a toolchain'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from set" -f -a "auto-self-update" -d 'The rustup auto self update mode'
complete -c rustup -n "__fish_rustup_using_subcommand help; and __fish_seen_subcommand_from set" -f -a "auto-install" -d 'The auto toolchain install mode'
