/***************************************************************************
                          unknownapplication.h - description
                             -------------------
    begin                : Thu Jul 23 2009
    copyright            : (C) 2009 by Valerio Pilo
    email                : "project" --at-- "kmess" --dot-- "org"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UNKNOWNAPPLICATION_H
#define UNKNOWNAPPLICATION_H

#include "p2papplication.h"



/**
 * Unknown application notification class.
 *
 * This class can be used to give useful error messages to the user when
 * unsupported applications are requested by contacts.
 *
 * @author Valerio Pilo
 * @ingroup Applications
 */
class UnknownApplication : public P2PApplication
{
  Q_OBJECT

  public:
    // The constructor
                           UnknownApplication( ApplicationList *applicationList, const QString &eufGuid );
    // The destructor
    virtual               ~UnknownApplication();


  public: // Static public members

    // Return the GUID for web applications (games)
    static QString         getGamesAppId();
    // Return the GUID for meeting
    static QString         getMeetingAppId();
    // Return the GUID for remote desktop
    static QString         getRemoteDesktopAppId();
    // Return the GUID for webcam transfer sending
    static QString         getWebcamPushAppId();
    // Return the GUID for webcam transfer receiving
    static QString         getWebcamPullAppId();
    // Return the GUID for voice conversations
    static QString         getVoiceAppId();


  private:
    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser( const MimeMessage& message );

  private: // Private members
    // The GUID of the unsupported but known application
    const QString          applicationGuid_;
};

#endif
