#  iodcomp.awk Copyright (c) 1993-2021, David A. Clunie DBA PixelMed Publishing. All rights reserved.
# create C++ headers from composite iod template

# can set these values on the command line:
#
#	role	  - either "declare" or "build" or "verify" or "write" or "select"

NR==1	{
	print "// Automatically generated from template - EDITS WILL BE LOST"
	print ""
	print "// Generated by iodcomp.awk with options " role " " outname
	print ""

	if (role == "declare" || role == "build" || role == "verify" || role == "write" || role == "select") {
		print "#ifndef __Header_" outname "__"
		print "#define __Header_" outname "__"
		print ""
	}
	else {
		print "Error - role " role " invalid" >"/dev/tty"
		exit 1
	}

	if (role == "select") {
		print "CompositeIOD *"
		print "selectCompositeIOD(AttributeList *list,const char *profile)"
		print "{"
		print "\t(void)list;"
		print "\tAssert(list);"
		print ""
		print "CompositeIOD *iod=0;"
		print ""
	}

	iodcomp=""
	ie=""
	}

/^[ 	]*CompositeIOD=/ {

	iodcomp=""
	if (match($0,"CompositeIOD=\"[^\"]*\""))
		iodcomp=substr($0,RSTART+length("CompositeIOD=\""),
			RLENGTH-length("CompositeIOD=\"")-1);

	condition=""
	if (match($0,"Condition=\"[^\"]*\""))
		condition=substr($0,RSTART+length("Condition=\""),
			RLENGTH-length("Condition=\"")-1);

	profile=""
	if (match($0,"Profile=\"[^\"]*\""))
		profile=substr($0,RSTART+length("Profile=\""),
			RLENGTH-length("Profile=\"")-1);

	retired="false"
	if (match($0,"[Rr]etired=\"[^\"]*\""))
		retired=substr($0,RSTART+length("retired=\""),
			RLENGTH-length("retired=\"")-1);
	
	if (role == "declare") {
		print "class CompositeIOD_" iodcomp " : public CompositeIOD {"
	}
	else if (role == "build") {
		print "CompositeIOD_" iodcomp "::CompositeIOD_" iodcomp "(AttributeList *list)"
		print "{"
		print "\t(void)list; // Quiets compiler in case iodcomp empty"
		print "\tAssert(list);"
		print ""
	}
	else if (role == "verify") {
		print "bool"
		print "CompositeIOD_" iodcomp "::verify(AttributeList *list,bool verbose,bool newformat,TextOutputStream& log,ElementDictionary *dict) const"
		print "{"
		print "\tconst char *iodcomp = \"" iodcomp "\";"
		print "\t(void)iodcomp;  // Quiets compiler in case iodcomp empty"
		print "\t(void)list;"
		print "\t(void)verbose;"
		print "\t(void)log;"
		print "\t(void)dict;"
		print "\tAssert(list);"
		print "\tAssert(dict);"
		print ""
		print "\tbool success=true;"
		print ""
		print ""
		print "\tif (verbose)"
		print "\t\tlog << MMsgDC(Verifying) << \" \" << MMsgDC(CompositeInformationObject) << \" \" << iodcomp << endl;"
		print ""
	}
	else if (role == "write") {
		print "void"
		print "CompositeIOD_" iodcomp "::write(TextOutputStream& stream,AttributeList *list,ElementDictionary *dict) const"
		print "{"
		print "\tstream << \"\\tCompositeIOD <" iodcomp ">\\n\";"
		print ""
	}
	else if (role == "select" && length(condition) > 0) {
		if (length(profile) == 0) {
			print "\t" selectelse "if (Condition_" condition "(list,0,list) && profile == NULL) {"
		}
		else{
			print "\t" selectelse "if (Condition_" condition "(list,0,list) && profile && strcmp(profile,\"" profile "\") == 0) {"
		}
		print "\t\tiod = new CompositeIOD_" iodcomp "(list);"
		print "\t}"
		selectelse="else "
	}

	}

/^[ 	]*CompositeIODEnd/ {

	if (role == "declare") {
		print "public:"
		print "\t            CompositeIOD_" iodcomp "(AttributeList *list);"
		print "\tconst char *identify(void) const { return \"" iodcomp "\"; }"
		print "\tbool        retired(void) const { return " retired "; }"
		print "\tvoid        write(TextOutputStream& stream,AttributeList *list,ElementDictionary *dict) const ;"
		print "\tbool        verify(AttributeList *list,bool verbose,bool newformat,TextOutputStream& log,ElementDictionary *dict) const;"
		print "};"
		print ""
	}
	else if (role == "build") {
		print "}"
		print ""
	}
	else if (role == "verify") {
		print "\treturn success;"
		print "}"
		print ""
	}
	else if (role == "write") {
		print "}"
		print ""
	}
	iodcomp=""

	}

/^[ 	]*Module/ {

	module=""
	if (match($0,"Module=\"[^\"]*\""))
		module=substr($0,RSTART+length("Module=\""),
			RLENGTH-length("Module=\"")-1);

	usage=""
	if (match($0,"Usage=\"[^\"]*\""))
		usage=substr($0,RSTART+length("Usage=\""),
			RLENGTH-length("Usage=\"")-1);

	condition=""
	if (match($0,"Condition=\"[^\"]*\""))
		condition=substr($0,RSTART+length("Condition=\""),
			RLENGTH-length("Condition=\"")-1);

	if (role == "declare") {
		print "\tModule_" module " *" module ";"
	}
	else if (role == "build") {
		if (length(condition) > 0) {
			print "\tif (Condition_" condition "(list,0,list)) {"
			print "\t\t" module " = new Module_" module "(list," ie "IE);"
			print "\t\tAssert(" module ");"
			print "\t}"
			print "\telse"
			print "\t\t" module "=0;"
			print ""
		}
		else {
			print "\t" module " = new Module_" module "(list," ie "IE);"
			print "\tAssert(" module ");"
			print ""
		}
	}
	else if (role == "verify") {
		# should put in required module checking here ?
		print "\tif (" module " && !" module "->verify(list,NULL/*parentlist*/,list/*rootlist*/,verbose,newformat,log,dict)) success=false;"
		print "\tif (verbose)"
		print "\t\tlog << \"" iodcomp " success after verifying " module " \" << (success ? \"success\" : \"failure\") << endl;";
		print ""
	}
	else if (role == "write") {
		print "\tif (" module ")"
		print "\t\t" module "->write(stream,list,dict);"
		print "\telse"
		print "\t\tstream << \"\\tModule <" module "> not present\\n\";"
		print ""
	}

	}

/^[ 	]*InformationEntity=/ {
	ie=""
	if (match($0,"InformationEntity=\"[^\"]*\""))
		ie=substr($0,RSTART+length("InformationEntity=\""),
			RLENGTH-length("InformationEntity=\"")-1);
}

END {
	if (role == "select") {
		print ""
		print "\treturn iod;"
		print "}"
		print ""
	}

	if (role == "declare" || role == "build" || role == "verify" || role == "write" || role == "select") {
		print ""
		print "#endif /* __Header_" outname "__ */"
	}
}

