/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.ValidationErrorValue;

public final class CastableExpression
extends UnaryExpression {
    AtomicType targetType;
    boolean allowEmpty;

    public CastableExpression(Expression expression, AtomicType atomicType, boolean bl) {
        super(expression);
        this.targetType = atomicType;
        this.allowEmpty = bl;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        if (this.operand instanceof AtomicValue) {
            return BooleanValue.get(this.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext()));
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        SequenceType sequenceType = SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, this.allowEmpty ? 24576 : 16384);
        RoleLocator roleLocator = new RoleLocator(2, "castable as", 0, null);
        roleLocator.setSourceLocator(this);
        try {
            this.operand = TypeChecker.staticTypeCheck(this.operand, sequenceType, false, roleLocator, staticContext);
        }
        catch (XPathException xPathException) {
            return BooleanValue.FALSE;
        }
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (!CastExpression.isPossibleCast(this.operand.getItemType(typeHierarchy).getPrimitiveType(), this.targetType.getPrimitiveType())) {
            return BooleanValue.FALSE;
        }
        if (this.operand instanceof AtomicValue) {
            return BooleanValue.get(this.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext()));
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        if (this.operand instanceof AtomicValue) {
            return BooleanValue.get(this.effectiveBooleanValue(staticContext.makeEarlyEvaluationContext()));
        }
        return this;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.targetType == ((CastableExpression)object).targetType && this.allowEmpty == ((CastableExpression)object).allowEmpty;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        try {
            AtomicValue atomicValue = (AtomicValue)this.operand.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return this.allowEmpty;
            }
            if (this.targetType instanceof BuiltInAtomicType) {
                return !(atomicValue.convert(this.targetType, xPathContext, true) instanceof ValidationErrorValue);
            }
            AtomicValue atomicValue2 = atomicValue.convert((AtomicType)this.targetType.getBuiltInBaseType(), xPathContext, true);
            if (atomicValue2 instanceof ValidationErrorValue) {
                return false;
            }
            AtomicValue atomicValue3 = this.targetType.makeDerivedValue(atomicValue2, atomicValue2.getStringValueCS(), true);
            return !(atomicValue3 instanceof ValidationErrorValue);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    protected String displayOperator(Configuration configuration) {
        return "castable as " + this.targetType.toString(configuration.getNamePool());
    }
}

