; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s

declare  i4  @llvm.ssub.sat.i4   (i4,  i4)
declare  i32 @llvm.ssub.sat.i32  (i32, i32)
declare  i64 @llvm.ssub.sat.i64  (i64, i64)
declare  <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32>, <4 x i32>)

define i32 @func(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: func:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs w8, w0, w1
; CHECK-NEXT:    mov w9, #2147483647
; CHECK-NEXT:    cmp w8, #0 // =0
; CHECK-NEXT:    cinv w8, w9, ge
; CHECK-NEXT:    subs w9, w0, w1
; CHECK-NEXT:    csel w0, w8, w9, vs
; CHECK-NEXT:    ret
  %tmp = call i32 @llvm.ssub.sat.i32(i32 %x, i32 %y);
  ret i32 %tmp;
}

define i64 @func2(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: func2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    subs x8, x0, x1
; CHECK-NEXT:    mov x9, #9223372036854775807
; CHECK-NEXT:    cmp x8, #0 // =0
; CHECK-NEXT:    cinv x8, x9, ge
; CHECK-NEXT:    subs x9, x0, x1
; CHECK-NEXT:    csel x0, x8, x9, vs
; CHECK-NEXT:    ret
  %tmp = call i64 @llvm.ssub.sat.i64(i64 %x, i64 %y);
  ret i64 %tmp;
}

define i4 @func3(i4 %x, i4 %y) nounwind {
; CHECK-LABEL: func3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #28
; CHECK-NEXT:    subs w10, w8, w1, lsl #28
; CHECK-NEXT:    mov w9, #2147483647
; CHECK-NEXT:    cmp w10, #0 // =0
; CHECK-NEXT:    cinv w9, w9, ge
; CHECK-NEXT:    subs w8, w8, w1, lsl #28
; CHECK-NEXT:    csel w8, w9, w8, vs
; CHECK-NEXT:    asr w0, w8, #28
; CHECK-NEXT:    ret
  %tmp = call i4 @llvm.ssub.sat.i4(i4 %x, i4 %y);
  ret i4 %tmp;
}

define <4 x i32> @vec(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: vec:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    cmge v1.4s, v1.4s, #0
; CHECK-NEXT:    cmge v0.4s, v0.4s, #0
; CHECK-NEXT:    cmge v5.4s, v2.4s, #0
; CHECK-NEXT:    cmlt v4.4s, v2.4s, #0
; CHECK-NEXT:    cmeq v1.4s, v0.4s, v1.4s
; CHECK-NEXT:    cmeq v0.4s, v0.4s, v5.4s
; CHECK-NEXT:    mvni v3.4s, #128, lsl #24
; CHECK-NEXT:    mvn v5.16b, v4.16b
; CHECK-NEXT:    mvn v1.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    bsl v3.16b, v4.16b, v5.16b
; CHECK-NEXT:    and v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    bsl v0.16b, v3.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %x, <4 x i32> %y);
  ret <4 x i32> %tmp;
}
