/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class SameTermFilterOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new SameTermFilterVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VarBinder
    extends QueryModelVisitorBase<RuntimeException> {
        private String varName;
        private Value value;

        public VarBinder(String varName, Value value) {
            this.varName = varName;
            this.value = value;
        }

        @Override
        public void meet(Var var) {
            if (var.getName().equals(this.varName)) {
                var.setValue(this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VarRenamer
    extends QueryModelVisitorBase<RuntimeException> {
        private String oldName;
        private String newName;

        public VarRenamer(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public void meet(Var var) {
            if (var.getName().equals(this.oldName)) {
                var.setName(this.newName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SameTermFilterVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected SameTermFilterVisitor() {
        }

        @Override
        public void meet(SameTerm sameTerm) {
            super.meet(sameTerm);
            if (sameTerm.getParentNode() instanceof Filter) {
                Filter filter = (Filter)sameTerm.getParentNode();
                ValueExpr leftArg = sameTerm.getLeftArg();
                ValueExpr rightArg = sameTerm.getRightArg();
                Set<String> bindingNames = filter.getArg().getBindingNames();
                if (leftArg instanceof Var && !bindingNames.contains(((Var)leftArg).getName()) || rightArg instanceof Var && !bindingNames.contains(((Var)rightArg).getName())) {
                    filter.replaceWith(new EmptySet());
                    return;
                }
                if (leftArg instanceof Var && rightArg instanceof Var) {
                    this.renameVar((Var)rightArg, (Var)leftArg, filter);
                } else if (leftArg instanceof Var && rightArg instanceof ValueConstant) {
                    this.bindVar((Var)leftArg, (ValueConstant)rightArg, filter);
                } else if (rightArg instanceof Var && leftArg instanceof ValueConstant) {
                    this.bindVar((Var)rightArg, (ValueConstant)leftArg, filter);
                }
            }
        }

        private void renameVar(Var oldVar, Var newVar, Filter filter) {
            filter.getArg().visit(new VarRenamer(oldVar.getName(), newVar.getName()));
            Extension extension = new Extension(filter.getArg());
            extension.addElement(new ExtensionElem(new Var(newVar.getName()), oldVar.getName()));
            filter.replaceWith(extension);
        }

        private void bindVar(Var var, ValueConstant valueConstant, Filter filter) {
            filter.getArg().visit(new VarBinder(var.getName(), valueConstant.getValue()));
            filter.setCondition(new Bound(var));
        }
    }
}

