/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.IntersectIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LimitIteration;
import info.aduna.iteration.MinusIteration;
import info.aduna.iteration.OffsetIteration;
import info.aduna.iteration.SingletonIteration;
import info.aduna.iteration.UnionIteration;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.DecimalLiteralImpl;
import org.openrdf.model.impl.IntegerLiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.CompareAll;
import org.openrdf.query.algebra.CompareAny;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.In;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Label;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Like;
import org.openrdf.query.algebra.LocalName;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Namespace;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.function.FunctionRegistry;
import org.openrdf.query.algebra.evaluation.iterator.CompatibleBindingSetFilter;
import org.openrdf.query.algebra.evaluation.iterator.ExtensionIterator;
import org.openrdf.query.algebra.evaluation.iterator.FilterIterator;
import org.openrdf.query.algebra.evaluation.iterator.GroupIterator;
import org.openrdf.query.algebra.evaluation.iterator.JoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.LeftJoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.MultiProjectionIterator;
import org.openrdf.query.algebra.evaluation.iterator.OrderIterator;
import org.openrdf.query.algebra.evaluation.iterator.ProjectionIterator;
import org.openrdf.query.algebra.evaluation.util.OrderComparator;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationStrategyImpl
implements EvaluationStrategy {
    private final TripleSource tripleSource;
    private final Dataset dataset;

    public EvaluationStrategyImpl(TripleSource tripleSource) {
        this(tripleSource, null);
    }

    public EvaluationStrategyImpl(TripleSource tripleSource, Dataset dataset) {
        this.tripleSource = tripleSource;
        this.dataset = dataset;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof StatementPattern) {
            return this.evaluate((StatementPattern)expr, bindings);
        }
        if (expr instanceof UnaryTupleOperator) {
            return this.evaluate((UnaryTupleOperator)expr, bindings);
        }
        if (expr instanceof BinaryTupleOperator) {
            return this.evaluate((BinaryTupleOperator)expr, bindings);
        }
        if (expr instanceof SingletonSet) {
            return this.evaluate((SingletonSet)expr, bindings);
        }
        if (expr instanceof EmptySet) {
            return this.evaluate((EmptySet)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(StatementPattern sp, final BindingSet bindings) throws QueryEvaluationException {
        void var11_14;
        final Var subjVar = sp.getSubjectVar();
        final Var predVar = sp.getPredicateVar();
        final Var objVar = sp.getObjectVar();
        final Var conVar = sp.getContextVar();
        Value subjValue = this.getVarValue(subjVar, bindings);
        Value predValue = this.getVarValue(predVar, bindings);
        Value objValue = this.getVarValue(objVar, bindings);
        Value contextValue = this.getVarValue(conVar, bindings);
        Object var11_11 = null;
        try {
            Resource[] contexts;
            if (this.dataset != null) {
                Set<URI> graphs = sp.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS ? this.dataset.getDefaultGraphs() : this.dataset.getNamedGraphs();
                if (graphs.isEmpty()) {
                    return new EmptyIteration<BindingSet, QueryEvaluationException>();
                }
                if (contextValue != null) {
                    if (!graphs.contains(contextValue)) return new EmptyIteration<BindingSet, QueryEvaluationException>();
                    contexts = new Resource[]{(Resource)contextValue};
                } else {
                    contexts = graphs.toArray(new Resource[graphs.size()]);
                }
            } else {
                contexts = contextValue != null ? new Resource[]{(Resource)contextValue} : new Resource[]{};
            }
            CloseableIteration<? extends Statement, QueryEvaluationException> closeableIteration = this.tripleSource.getStatements((Resource)subjValue, (URI)predValue, objValue, contexts);
            if (contexts.length == 0 && sp.getScope() == StatementPattern.Scope.NAMED_CONTEXTS) {
                FilterIteration<Statement, QueryEvaluationException> filterIteration = new FilterIteration<Statement, QueryEvaluationException>(closeableIteration){

                    @Override
                    protected boolean accept(Statement st) {
                        return st.getContext() != null;
                    }
                };
            }
        }
        catch (ClassCastException e) {
            return new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        FilterIteration<Statement, QueryEvaluationException> filterIteration = new FilterIteration<Statement, QueryEvaluationException>((Iteration)var11_14){

            @Override
            protected boolean accept(Statement st) {
                Resource subj = st.getSubject();
                URI pred = st.getPredicate();
                Value obj = st.getObject();
                Resource context = st.getContext();
                if (subjVar != null) {
                    if (subjVar.equals(predVar) && !subj.equals(pred)) {
                        return false;
                    }
                    if (subjVar.equals(objVar) && !subj.equals(obj)) {
                        return false;
                    }
                    if (subjVar.equals(conVar) && !subj.equals(context)) {
                        return false;
                    }
                }
                if (predVar != null) {
                    if (predVar.equals(objVar) && !((Object)pred).equals(obj)) {
                        return false;
                    }
                    if (predVar.equals(conVar) && !((Object)pred).equals(context)) {
                        return false;
                    }
                }
                return objVar == null || !objVar.equals(conVar) || obj.equals(context);
            }
        };
        return new ConvertingIteration<Statement, BindingSet, QueryEvaluationException>((Iteration)filterIteration){

            @Override
            protected BindingSet convert(Statement st) {
                QueryBindingSet result = new QueryBindingSet(bindings);
                if (subjVar != null && !result.hasBinding(subjVar.getName())) {
                    result.addBinding(subjVar.getName(), st.getSubject());
                }
                if (predVar != null && !result.hasBinding(predVar.getName())) {
                    result.addBinding(predVar.getName(), st.getPredicate());
                }
                if (objVar != null && !result.hasBinding(objVar.getName())) {
                    result.addBinding(objVar.getName(), st.getObject());
                }
                if (conVar != null && !result.hasBinding(conVar.getName()) && st.getContext() != null) {
                    result.addBinding(conVar.getName(), st.getContext());
                }
                return result;
            }
        };
    }

    private Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(UnaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.evaluate((Projection)expr, bindings);
        }
        if (expr instanceof MultiProjection) {
            return this.evaluate((MultiProjection)expr, bindings);
        }
        if (expr instanceof Filter) {
            return this.evaluate((Filter)expr, bindings);
        }
        if (expr instanceof Slice) {
            return this.evaluate((Slice)expr, bindings);
        }
        if (expr instanceof Extension) {
            return this.evaluate((Extension)expr, bindings);
        }
        if (expr instanceof Distinct) {
            return this.evaluate((Distinct)expr, bindings);
        }
        if (expr instanceof Group) {
            return this.evaluate((Group)expr, bindings);
        }
        if (expr instanceof Order) {
            return this.evaluate((Order)expr, bindings);
        }
        if (expr instanceof QueryRoot) {
            return this.evaluate(((QueryRoot)expr).getArg(), bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Projection projection, BindingSet bindings) throws QueryEvaluationException {
        ProjectionIterator result = this.evaluate(projection.getArg(), bindings);
        result = new ProjectionIterator(projection, result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(MultiProjection multiProjection, BindingSet bindings) throws QueryEvaluationException {
        MultiProjectionIterator result = this.evaluate(multiProjection.getArg(), bindings);
        result = new MultiProjectionIterator(multiProjection, result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Filter filter, BindingSet bindings) throws QueryEvaluationException {
        FilterIterator result = this.evaluate(filter.getArg(), bindings);
        result = new FilterIterator(filter, result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Slice slice, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> result = this.evaluate(slice.getArg(), bindings);
        if (slice.hasOffset()) {
            result = new OffsetIteration<BindingSet, QueryEvaluationException>(result, slice.getOffset());
        }
        if (slice.hasLimit()) {
            result = new LimitIteration<BindingSet, QueryEvaluationException>(result, slice.getLimit());
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Extension extension, BindingSet bindings) throws QueryEvaluationException {
        ExtensionIterator result = this.evaluate(extension.getArg(), bindings);
        result = new ExtensionIterator(extension, result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return new DistinctIteration<BindingSet, QueryEvaluationException>(this.evaluate(distinct.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Group node, BindingSet bindings) throws QueryEvaluationException {
        return new GroupIterator(this, node, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp);
        return new OrderIterator(this.evaluate(node.getArg(), bindings), cmp);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BinaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.evaluate((Join)expr, bindings);
        }
        if (expr instanceof LeftJoin) {
            return this.evaluate((LeftJoin)expr, bindings);
        }
        if (expr instanceof Union) {
            return this.evaluate((Union)expr, bindings);
        }
        if (expr instanceof Intersection) {
            return this.evaluate((Intersection)expr, bindings);
        }
        if (expr instanceof Difference) {
            return this.evaluate((Difference)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        return new JoinIterator(this, join, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        Set<String> boundVars = bindings.getBindingNames();
        Set<String> leftVars = leftJoin.getLeftArg().getBindingNames();
        Set<String> optionalVars = leftJoin.getRightArg().getBindingNames();
        HashSet<String> problemVars = new HashSet<String>(boundVars);
        problemVars.retainAll(optionalVars);
        problemVars.removeAll(leftVars);
        if (problemVars.isEmpty()) {
            return new LeftJoinIterator(this, leftJoin, bindings);
        }
        QueryBindingSet filteredBindings = new QueryBindingSet(bindings);
        filteredBindings.removeAll(problemVars);
        CloseableIterationBase iter = new LeftJoinIterator(this, leftJoin, filteredBindings);
        iter = new CompatibleBindingSetFilter(iter, bindings);
        return iter;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Union union, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(union.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(union.getRightArg(), bindings);
            }
        };
        return new UnionIteration<BindingSet, QueryEvaluationException>(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Intersection intersection, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(intersection.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(intersection.getRightArg(), bindings);
            }
        };
        return new IntersectIteration<BindingSet, QueryEvaluationException>(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Difference difference, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(difference.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(difference.getRightArg(), bindings);
            }
        };
        return new MinusIteration<BindingSet, QueryEvaluationException>(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SingletonSet singletonSet, BindingSet bindings) throws QueryEvaluationException {
        return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(EmptySet emptySet, BindingSet bindings) throws QueryEvaluationException {
        return new EmptyIteration<BindingSet, QueryEvaluationException>();
    }

    @Override
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof Var) {
            return this.evaluate((Var)expr, bindings);
        }
        if (expr instanceof ValueConstant) {
            return this.evaluate((ValueConstant)expr, bindings);
        }
        if (expr instanceof BNodeGenerator) {
            return this.evaluate((BNodeGenerator)expr, bindings);
        }
        if (expr instanceof Bound) {
            return this.evaluate((Bound)expr, bindings);
        }
        if (expr instanceof Str) {
            return this.evaluate((Str)expr, bindings);
        }
        if (expr instanceof Label) {
            return this.evaluate((Label)expr, bindings);
        }
        if (expr instanceof Lang) {
            return this.evaluate((Lang)expr, bindings);
        }
        if (expr instanceof LangMatches) {
            return this.evaluate((LangMatches)expr, bindings);
        }
        if (expr instanceof Datatype) {
            return this.evaluate((Datatype)expr, bindings);
        }
        if (expr instanceof Namespace) {
            return this.evaluate((Namespace)expr, bindings);
        }
        if (expr instanceof LocalName) {
            return this.evaluate((LocalName)expr, bindings);
        }
        if (expr instanceof IsResource) {
            return this.evaluate((IsResource)expr, bindings);
        }
        if (expr instanceof IsURI) {
            return this.evaluate((IsURI)expr, bindings);
        }
        if (expr instanceof IsBNode) {
            return this.evaluate((IsBNode)expr, bindings);
        }
        if (expr instanceof IsLiteral) {
            return this.evaluate((IsLiteral)expr, bindings);
        }
        if (expr instanceof Regex) {
            return this.evaluate((Regex)expr, bindings);
        }
        if (expr instanceof Like) {
            return this.evaluate((Like)expr, bindings);
        }
        if (expr instanceof FunctionCall) {
            return this.evaluate((FunctionCall)expr, bindings);
        }
        if (expr instanceof And) {
            return this.evaluate((And)expr, bindings);
        }
        if (expr instanceof Or) {
            return this.evaluate((Or)expr, bindings);
        }
        if (expr instanceof Not) {
            return this.evaluate((Not)expr, bindings);
        }
        if (expr instanceof SameTerm) {
            return this.evaluate((SameTerm)expr, bindings);
        }
        if (expr instanceof Compare) {
            return this.evaluate((Compare)expr, bindings);
        }
        if (expr instanceof MathExpr) {
            return this.evaluate((MathExpr)expr, bindings);
        }
        if (expr instanceof In) {
            return this.evaluate((In)expr, bindings);
        }
        if (expr instanceof CompareAny) {
            return this.evaluate((CompareAny)expr, bindings);
        }
        if (expr instanceof CompareAll) {
            return this.evaluate((CompareAll)expr, bindings);
        }
        if (expr instanceof Exists) {
            return this.evaluate((Exists)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    public Value evaluate(Var var, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value value = var.getValue();
        if (value == null) {
            value = bindings.getValue(var.getName());
        }
        if (value == null) {
            throw new ValueExprEvaluationException();
        }
        return value;
    }

    public Value evaluate(ValueConstant valueConstant, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        return valueConstant.getValue();
    }

    public Value evaluate(BNodeGenerator node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        return this.tripleSource.getValueFactory().createBNode();
    }

    public Value evaluate(Bound node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value argValue = this.evaluate(node.getArg(), bindings);
            return BooleanLiteralImpl.valueOf(argValue != null);
        }
        catch (ValueExprEvaluationException e) {
            return BooleanLiteralImpl.FALSE;
        }
    }

    public Value evaluate(Str node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Label node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Lang node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            String langTag = literal.getLanguage();
            if (langTag == null) {
                langTag = "";
            }
            return this.tripleSource.getValueFactory().createLiteral(langTag);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Datatype node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value v = this.evaluate(node.getArg(), bindings);
        if (v instanceof Literal) {
            Literal literal = (Literal)v;
            if (literal.getDatatype() != null) {
                return literal.getDatatype();
            }
            if (literal.getLanguage() == null) {
                return XMLSchema.STRING;
            }
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Namespace node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            URI uri = (URI)argValue;
            return this.tripleSource.getValueFactory().createURI(uri.getNamespace());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LocalName node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            URI uri = (URI)argValue;
            return this.tripleSource.getValueFactory().createLiteral(uri.getLocalName());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(IsResource node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof Resource);
    }

    public Value evaluate(IsURI node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof URI);
    }

    public Value evaluate(IsBNode node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof BNode);
    }

    public Value evaluate(IsLiteral node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof Literal);
    }

    public Value evaluate(Regex node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value arg = this.evaluate(node.getArg(), bindings);
        Value parg = this.evaluate(node.getPatternArg(), bindings);
        Value farg = null;
        ValueExpr flagsArg = node.getFlagsArg();
        if (flagsArg != null) {
            farg = this.evaluate(flagsArg, bindings);
        }
        if (QueryEvaluationUtil.isSimpleLiteral(arg) && QueryEvaluationUtil.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtil.isSimpleLiteral(farg))) {
            String text = ((Literal)arg).getLabel();
            String ptn = ((Literal)parg).getLabel();
            String flags = "";
            if (farg != null) {
                flags = ((Literal)farg).getLabel();
            }
            int f = 0;
            block8: for (char c : flags.toCharArray()) {
                switch (c) {
                    case 's': {
                        f |= 0x20;
                        continue block8;
                    }
                    case 'm': {
                        f |= 8;
                        continue block8;
                    }
                    case 'i': {
                        f |= 2;
                        continue block8;
                    }
                    case 'x': {
                        f |= 4;
                        continue block8;
                    }
                    case 'd': {
                        f |= 1;
                        continue block8;
                    }
                    case 'u': {
                        f |= 0x40;
                        continue block8;
                    }
                    default: {
                        throw new ValueExprEvaluationException(flags);
                    }
                }
            }
            Pattern pattern = Pattern.compile(ptn, f);
            boolean result = pattern.matcher(text).find();
            return BooleanLiteralImpl.valueOf(result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LangMatches node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value langTagValue = this.evaluate(node.getLeftArg(), bindings);
        Value langRangeValue = this.evaluate(node.getRightArg(), bindings);
        if (QueryEvaluationUtil.isSimpleLiteral(langTagValue) && QueryEvaluationUtil.isSimpleLiteral(langRangeValue)) {
            String langTag = ((Literal)langTagValue).getLabel();
            String langRange = ((Literal)langRangeValue).getLabel();
            boolean result = false;
            if (langRange.equals("*")) {
                result = langTag.length() > 0;
            } else if (langTag.length() == langRange.length()) {
                result = langTag.equalsIgnoreCase(langRange);
            } else if (langTag.length() > langRange.length()) {
                String prefix = langTag.substring(0, langRange.length());
                result = prefix.equalsIgnoreCase(langRange) && langTag.charAt(langRange.length()) == '-';
            }
            return BooleanLiteralImpl.valueOf(result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Like node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        String snippet;
        Value val = this.evaluate(node.getArg(), bindings);
        String strVal = null;
        if (val instanceof URI) {
            strVal = ((Object)((URI)val)).toString();
        } else if (val instanceof Literal) {
            strVal = ((Literal)val).getLabel();
        }
        if (strVal == null) {
            throw new ValueExprEvaluationException();
        }
        if (!node.isCaseSensitive()) {
            strVal = strVal.toLowerCase();
        }
        int valIndex = 0;
        int prevPatternIndex = -1;
        int patternIndex = node.getOpPattern().indexOf(42);
        if (patternIndex == -1) {
            return BooleanLiteralImpl.valueOf(node.getOpPattern().equals(strVal));
        }
        if (patternIndex > 0) {
            snippet = node.getOpPattern().substring(0, patternIndex);
            if (!strVal.startsWith(snippet)) {
                return BooleanLiteralImpl.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        while (patternIndex != -1) {
            snippet = node.getOpPattern().substring(prevPatternIndex + 1, patternIndex);
            valIndex = strVal.indexOf(snippet, valIndex);
            if (valIndex == -1) {
                return BooleanLiteralImpl.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        snippet = node.getOpPattern().substring(prevPatternIndex + 1);
        if (snippet.length() > 0) {
            int i;
            valIndex = strVal.indexOf(snippet, valIndex);
            while ((i = strVal.indexOf(snippet, valIndex + 1)) != -1) {
                valIndex = i;
            }
            if (valIndex == -1) {
                return BooleanLiteralImpl.FALSE;
            }
            if ((valIndex += snippet.length()) < strVal.length()) {
                return BooleanLiteralImpl.FALSE;
            }
        }
        return BooleanLiteralImpl.TRUE;
    }

    public Value evaluate(FunctionCall node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Function function = (Function)FunctionRegistry.getInstance().get(node.getURI());
        if (function == null) {
            throw new QueryEvaluationException("Unknown function '" + node.getURI() + "'");
        }
        List<ValueExpr> args = node.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate(args.get(i), bindings);
        }
        return function.evaluate(this.tripleSource.getValueFactory(), argValues);
    }

    public Value evaluate(And node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteralImpl.FALSE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteralImpl.FALSE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Or node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteralImpl.TRUE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteralImpl.TRUE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Not node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        boolean argBoolean = QueryEvaluationUtil.getEffectiveBooleanValue(argValue);
        return BooleanLiteralImpl.valueOf(!argBoolean);
    }

    public Value evaluate(SameTerm node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(leftVal != null && leftVal.equals(rightVal));
    }

    public Value evaluate(Compare node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator()));
    }

    public Value evaluate(MathExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return EvaluationStrategyImpl.getValue((Literal)leftVal, (Literal)rightVal, node.getOperator());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(In node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftValue = this.evaluate(node.getArg(), bindings);
        boolean result = false;
        String bindingName = node.getSubQuery().getBindingNames().iterator().next();
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
        try {
            while (!result && iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Value rightValue = bindingSet.getValue(bindingName);
                result = leftValue == null && rightValue == null || leftValue != null && leftValue.equals(rightValue);
            }
        }
        finally {
            iter.close();
        }
        return BooleanLiteralImpl.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(CompareAny node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean result;
        block7: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = false;
            String bindingName = node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block5: while (true) {
                while (!result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block5;
                    }
                    catch (ValueExprEvaluationException e) {
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iter.close();
            }
        }
        return BooleanLiteralImpl.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(CompareAll node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean result;
        block7: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = true;
            String bindingName = node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block5: while (true) {
                while (result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block5;
                    }
                    catch (ValueExprEvaluationException e) {
                        result = false;
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iter.close();
            }
        }
        return BooleanLiteralImpl.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(Exists node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
        try {
            BooleanLiteralImpl booleanLiteralImpl = BooleanLiteralImpl.valueOf(iter.hasNext());
            return booleanLiteralImpl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value value = this.evaluate(expr, bindings);
            return QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }

    private static Literal getValue(Literal leftLit, Literal rightLit, MathExpr.MathOp op) {
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null && rightDatatype != null && XMLDatatypeUtil.isNumericDatatype(leftDatatype) && XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            URI commonDatatype = ((Object)leftDatatype).equals(XMLSchema.DOUBLE) || ((Object)rightDatatype).equals(XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (((Object)leftDatatype).equals(XMLSchema.FLOAT) || ((Object)rightDatatype).equals(XMLSchema.FLOAT) ? XMLSchema.FLOAT : (((Object)leftDatatype).equals(XMLSchema.DECIMAL) || ((Object)rightDatatype).equals(XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : (op == MathExpr.MathOp.DIVIDE ? XMLSchema.DECIMAL : XMLSchema.INTEGER)));
            try {
                if (((Object)commonDatatype).equals(XMLSchema.DOUBLE)) {
                    double left = leftLit.doubleValue();
                    double right = rightLit.doubleValue();
                    switch (op) {
                        case PLUS: {
                            return new NumericLiteralImpl(left + right);
                        }
                        case MINUS: {
                            return new NumericLiteralImpl(left - right);
                        }
                        case MULTIPLY: {
                            return new NumericLiteralImpl(left * right);
                        }
                        case DIVIDE: {
                            return new NumericLiteralImpl(left / right);
                        }
                    }
                    throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
                }
                if (((Object)commonDatatype).equals(XMLSchema.FLOAT)) {
                    float left = leftLit.floatValue();
                    float right = rightLit.floatValue();
                    switch (op) {
                        case PLUS: {
                            return new NumericLiteralImpl(left + right);
                        }
                        case MINUS: {
                            return new NumericLiteralImpl(left - right);
                        }
                        case MULTIPLY: {
                            return new NumericLiteralImpl(left * right);
                        }
                        case DIVIDE: {
                            return new NumericLiteralImpl(left / right);
                        }
                    }
                    throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
                }
                if (((Object)commonDatatype).equals(XMLSchema.DECIMAL)) {
                    BigDecimal left = leftLit.decimalValue();
                    BigDecimal right = rightLit.decimalValue();
                    switch (op) {
                        case PLUS: {
                            return new DecimalLiteralImpl(left.add(right));
                        }
                        case MINUS: {
                            return new DecimalLiteralImpl(left.subtract(right));
                        }
                        case MULTIPLY: {
                            return new DecimalLiteralImpl(left.multiply(right));
                        }
                        case DIVIDE: {
                            return new DecimalLiteralImpl(left.divide(right, RoundingMode.HALF_UP));
                        }
                    }
                    throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
                }
                BigInteger left = leftLit.integerValue();
                BigInteger right = rightLit.integerValue();
                switch (op) {
                    case PLUS: {
                        return new IntegerLiteralImpl(left.add(right));
                    }
                    case MINUS: {
                        return new IntegerLiteralImpl(left.subtract(right));
                    }
                    case MULTIPLY: {
                        return new IntegerLiteralImpl(left.multiply(right));
                    }
                    case DIVIDE: {
                        throw new RuntimeException("Integer divisions should be processed as decimal divisions");
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)op));
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        return null;
    }
}

