This matches if the packet arrival time/date is within a given range. All
options are optional, but are ANDed when specified.
.TP
\fB--datestart\fR \fIYYYY\fR[\fB-\fR\fIMM\fR[\fB-\fR\fIDD\fR[\fBT\fR\fIhh\fR[\fB:\fR\fImm\fR[\fB:\fR\fIss\fR]]]]]
.TP
\fB--datestop\fR \fIYYYY\fR[\fB-\fR\fIMM\fR[\fB-\fR\fIDD\fR[\fBT\fR\fIhh\fR[\fB:\fR\fImm\fR[\fB:\fR\fIss\fR]]]]]
.IP
Only match during the given time, which must be in ISO 8601 "T" notation.
The possible time range is 1970-01-01T00:00:00 to 2038-01-19T04:17:07.
.IP
If --datestart or --datestop are not specified, it will default to 1970-01-01
and 2038-01-19, respectively.
.TP
\fB--timestart\fR \fIhh\fR\fB:\fR\fImm\fR[\fB:\fR\fIss\fR]
.TP
\fB--timestop\fR \fIhh\fR\fB:\fR\fImm\fR[\fB:\fR\fIss\fR]
.IP
Only match during the given daytime. The possible time range is 00:00:00 to
23:59:59. Leading zeroes are allowed (e.g. "06:03") and correctly interpreted
as base-10.
.TP
[\fB!\fR] \fB--monthday\fR \fIday\fR[\fB,\fR\fIday\fR...]
.IP
Only match on the given days of the month. Possible values are \fB1\fR
to \fB31\fR. Note that specifying \fB31\fR will of course not match
on months which do not have a 31st day; the same goes for 28- or 29-day
February.
.TP
[\fB!\fR] \fB--weekdays\fR \fIday\fR[\fB,\fR\fIday\fR...]
.IP
Only match on the given weekdays. Possible values are \fBMon\fR, \fBTue\fR,
\fBWed\fR, \fBThu\fR, \fBFri\fR, \fBSat\fR, \fBSun\fR, or values from \fB1\fR
to \fB7\fR, respectively. You may also use two-character variants (\fBMo\fR,
\fBTu\fR, etc.).
.TP
\fB--utc\fR
.IP
Interpret the times given for \fB--datestart\fR, \fB--datestop\fR,
\fB--timestart\fR and \fB--timestop\fR to be UTC.
.TP
\fB--localtz\fR
.IP
Interpret the times given for \fB--datestart\fR, \fB--datestop\fR,
\fB--timestart\fR and \fB--timestop\fR to be local kernel time. (Default)
.PP
EXAMPLES. To match on weekends, use:
.IP
-m time --weekdays Sa,Su
.PP
Or, to match (once) on a national holiday block:
.IP
-m time --datestart 2007-12-24 --datestop 2007-12-27
.PP
Since the stop time is actually inclusive, you would need the following stop
time to not match the first second of the new day:
.IP
-m time --datestart 2007-01-01T17:00 --datestop 2007-01-01T23:59:59
.PP
During lunch hour:
.IP
-m time --timestart 12:30 --timestop 13:30
.PP
The fourth Friday in the month:
.IP
-m time --weekdays Fr --monthdays 22,23,24,25,26,27,28
.PP
(Note that this exploits a certain mathematical property. It is not possible to
say "fourth Thursday OR fourth Friday" in one rule. It is possible with
multiple rules, though.)
