/* @(#)getargs.h	1.16 06/12/02 Copyright 1985 J. Schilling */
/*
 *	Definitions for getargs()/getallargs()/getfiles()
 *
 *	Copyright (c) 1985 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#ifndef	_SCHILY_GETARGS_H
#define	_SCHILY_GETARGS_H

#ifndef _SCHILY_MCONFIG_H
#include <schily/mconfig.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#define	NOARGS		  0	/* No more args			*/
#define	NOTAFLAG	  1	/* Not a flag type argument	*/
#define	BADFLAG		(-1)	/* Not a valid flag argument	*/
#define	BADFMT		(-2)	/* Error in format string	*/
#define	NOTAFILE	(-3)	/* Seems to be a flag type	*/

typedef	int	(*getargfun)	__PR((const char *__arg, void *__valp));
typedef	int	(*getpargfun)	__PR((const char *__arg, void *__valp, int *__pac, char *const **__pav, const char *__opt));

#define	NO_ARGFUN	(getargpfun)0

struct ga_flags {
	const char	*ga_format;
	void		*ga_arg;
	getpargfun	ga_funcp;
};

/*
 * Keep in sync with schily.h
 */
extern	int	getallargs __PR((int *, char * const**, const char *, ...));
extern	int	getargs __PR((int *, char * const**, const char *, ...));
extern	int	getfiles __PR((int *, char * const**, const char *));
extern	char	*getargerror __PR((int));

/*
 * The vector versions of the functions need struct ga_flags and thus need
 * getargs.h
 */
extern	int	getvallargs __PR((int *, char * const**, struct ga_flags *, void *));
extern	int	getvargs __PR((int *, char * const**, struct ga_flags *, void *));
extern	int	getvfiles __PR((int *, char * const**, struct ga_flags *, void *));

#ifdef	__cplusplus
}
#endif

#endif	/* _SCHILY_GETARGS_H */
