/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2022 Google LLC
 * Copyright 2022 Collabora Ltd.
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_UTIL_H
#define VN_PROTOCOL_RENDERER_UTIL_H

#include "vn_protocol_renderer_info.h"

struct vn_physical_device_proc_table {
   PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT GetPhysicalDeviceCalibrateableTimeDomainsEXT;
   PFN_vkGetPhysicalDeviceToolProperties GetPhysicalDeviceToolProperties;
};

struct vn_device_proc_table {
   PFN_vkAllocateCommandBuffers AllocateCommandBuffers;
   PFN_vkAllocateDescriptorSets AllocateDescriptorSets;
   PFN_vkAllocateMemory AllocateMemory;
   PFN_vkBeginCommandBuffer BeginCommandBuffer;
   PFN_vkBindBufferMemory BindBufferMemory;
   PFN_vkBindBufferMemory2 BindBufferMemory2;
   PFN_vkBindImageMemory BindImageMemory;
   PFN_vkBindImageMemory2 BindImageMemory2;
   PFN_vkCmdBeginConditionalRenderingEXT CmdBeginConditionalRenderingEXT;
   PFN_vkCmdBeginQuery CmdBeginQuery;
   PFN_vkCmdBeginQueryIndexedEXT CmdBeginQueryIndexedEXT;
   PFN_vkCmdBeginRenderPass CmdBeginRenderPass;
   PFN_vkCmdBeginRenderPass2 CmdBeginRenderPass2;
   PFN_vkCmdBeginRendering CmdBeginRendering;
   PFN_vkCmdBeginTransformFeedbackEXT CmdBeginTransformFeedbackEXT;
   PFN_vkCmdBindDescriptorSets CmdBindDescriptorSets;
   PFN_vkCmdBindIndexBuffer CmdBindIndexBuffer;
   PFN_vkCmdBindPipeline CmdBindPipeline;
   PFN_vkCmdBindTransformFeedbackBuffersEXT CmdBindTransformFeedbackBuffersEXT;
   PFN_vkCmdBindVertexBuffers CmdBindVertexBuffers;
   PFN_vkCmdBindVertexBuffers2 CmdBindVertexBuffers2;
   PFN_vkCmdBlitImage CmdBlitImage;
   PFN_vkCmdBlitImage2 CmdBlitImage2;
   PFN_vkCmdClearAttachments CmdClearAttachments;
   PFN_vkCmdClearColorImage CmdClearColorImage;
   PFN_vkCmdClearDepthStencilImage CmdClearDepthStencilImage;
   PFN_vkCmdCopyBuffer CmdCopyBuffer;
   PFN_vkCmdCopyBuffer2 CmdCopyBuffer2;
   PFN_vkCmdCopyBufferToImage CmdCopyBufferToImage;
   PFN_vkCmdCopyBufferToImage2 CmdCopyBufferToImage2;
   PFN_vkCmdCopyImage CmdCopyImage;
   PFN_vkCmdCopyImage2 CmdCopyImage2;
   PFN_vkCmdCopyImageToBuffer CmdCopyImageToBuffer;
   PFN_vkCmdCopyImageToBuffer2 CmdCopyImageToBuffer2;
   PFN_vkCmdCopyQueryPoolResults CmdCopyQueryPoolResults;
   PFN_vkCmdDispatch CmdDispatch;
   PFN_vkCmdDispatchBase CmdDispatchBase;
   PFN_vkCmdDispatchIndirect CmdDispatchIndirect;
   PFN_vkCmdDraw CmdDraw;
   PFN_vkCmdDrawIndexed CmdDrawIndexed;
   PFN_vkCmdDrawIndexedIndirect CmdDrawIndexedIndirect;
   PFN_vkCmdDrawIndexedIndirectCount CmdDrawIndexedIndirectCount;
   PFN_vkCmdDrawIndirect CmdDrawIndirect;
   PFN_vkCmdDrawIndirectByteCountEXT CmdDrawIndirectByteCountEXT;
   PFN_vkCmdDrawIndirectCount CmdDrawIndirectCount;
   PFN_vkCmdDrawMultiEXT CmdDrawMultiEXT;
   PFN_vkCmdDrawMultiIndexedEXT CmdDrawMultiIndexedEXT;
   PFN_vkCmdEndConditionalRenderingEXT CmdEndConditionalRenderingEXT;
   PFN_vkCmdEndQuery CmdEndQuery;
   PFN_vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT;
   PFN_vkCmdEndRenderPass CmdEndRenderPass;
   PFN_vkCmdEndRenderPass2 CmdEndRenderPass2;
   PFN_vkCmdEndRendering CmdEndRendering;
   PFN_vkCmdEndTransformFeedbackEXT CmdEndTransformFeedbackEXT;
   PFN_vkCmdExecuteCommands CmdExecuteCommands;
   PFN_vkCmdFillBuffer CmdFillBuffer;
   PFN_vkCmdNextSubpass CmdNextSubpass;
   PFN_vkCmdNextSubpass2 CmdNextSubpass2;
   PFN_vkCmdPipelineBarrier CmdPipelineBarrier;
   PFN_vkCmdPipelineBarrier2 CmdPipelineBarrier2;
   PFN_vkCmdPushConstants CmdPushConstants;
   PFN_vkCmdPushDescriptorSetKHR CmdPushDescriptorSetKHR;
   PFN_vkCmdPushDescriptorSetWithTemplateKHR CmdPushDescriptorSetWithTemplateKHR;
   PFN_vkCmdResetEvent CmdResetEvent;
   PFN_vkCmdResetEvent2 CmdResetEvent2;
   PFN_vkCmdResetQueryPool CmdResetQueryPool;
   PFN_vkCmdResolveImage CmdResolveImage;
   PFN_vkCmdResolveImage2 CmdResolveImage2;
   PFN_vkCmdSetBlendConstants CmdSetBlendConstants;
   PFN_vkCmdSetCullMode CmdSetCullMode;
   PFN_vkCmdSetDepthBias CmdSetDepthBias;
   PFN_vkCmdSetDepthBiasEnable CmdSetDepthBiasEnable;
   PFN_vkCmdSetDepthBounds CmdSetDepthBounds;
   PFN_vkCmdSetDepthBoundsTestEnable CmdSetDepthBoundsTestEnable;
   PFN_vkCmdSetDepthCompareOp CmdSetDepthCompareOp;
   PFN_vkCmdSetDepthTestEnable CmdSetDepthTestEnable;
   PFN_vkCmdSetDepthWriteEnable CmdSetDepthWriteEnable;
   PFN_vkCmdSetDeviceMask CmdSetDeviceMask;
   PFN_vkCmdSetEvent CmdSetEvent;
   PFN_vkCmdSetEvent2 CmdSetEvent2;
   PFN_vkCmdSetFrontFace CmdSetFrontFace;
   PFN_vkCmdSetLineStippleEXT CmdSetLineStippleEXT;
   PFN_vkCmdSetLineWidth CmdSetLineWidth;
   PFN_vkCmdSetLogicOpEXT CmdSetLogicOpEXT;
   PFN_vkCmdSetPatchControlPointsEXT CmdSetPatchControlPointsEXT;
   PFN_vkCmdSetPrimitiveRestartEnable CmdSetPrimitiveRestartEnable;
   PFN_vkCmdSetPrimitiveTopology CmdSetPrimitiveTopology;
   PFN_vkCmdSetRasterizerDiscardEnable CmdSetRasterizerDiscardEnable;
   PFN_vkCmdSetScissor CmdSetScissor;
   PFN_vkCmdSetScissorWithCount CmdSetScissorWithCount;
   PFN_vkCmdSetStencilCompareMask CmdSetStencilCompareMask;
   PFN_vkCmdSetStencilOp CmdSetStencilOp;
   PFN_vkCmdSetStencilReference CmdSetStencilReference;
   PFN_vkCmdSetStencilTestEnable CmdSetStencilTestEnable;
   PFN_vkCmdSetStencilWriteMask CmdSetStencilWriteMask;
   PFN_vkCmdSetViewport CmdSetViewport;
   PFN_vkCmdSetViewportWithCount CmdSetViewportWithCount;
   PFN_vkCmdUpdateBuffer CmdUpdateBuffer;
   PFN_vkCmdWaitEvents CmdWaitEvents;
   PFN_vkCmdWaitEvents2 CmdWaitEvents2;
   PFN_vkCmdWriteTimestamp CmdWriteTimestamp;
   PFN_vkCmdWriteTimestamp2 CmdWriteTimestamp2;
   PFN_vkCreateBuffer CreateBuffer;
   PFN_vkCreateBufferView CreateBufferView;
   PFN_vkCreateCommandPool CreateCommandPool;
   PFN_vkCreateComputePipelines CreateComputePipelines;
   PFN_vkCreateDescriptorPool CreateDescriptorPool;
   PFN_vkCreateDescriptorSetLayout CreateDescriptorSetLayout;
   PFN_vkCreateDescriptorUpdateTemplate CreateDescriptorUpdateTemplate;
   PFN_vkCreateEvent CreateEvent;
   PFN_vkCreateFence CreateFence;
   PFN_vkCreateFramebuffer CreateFramebuffer;
   PFN_vkCreateGraphicsPipelines CreateGraphicsPipelines;
   PFN_vkCreateImage CreateImage;
   PFN_vkCreateImageView CreateImageView;
   PFN_vkCreatePipelineCache CreatePipelineCache;
   PFN_vkCreatePipelineLayout CreatePipelineLayout;
   PFN_vkCreatePrivateDataSlot CreatePrivateDataSlot;
   PFN_vkCreateQueryPool CreateQueryPool;
   PFN_vkCreateRenderPass CreateRenderPass;
   PFN_vkCreateRenderPass2 CreateRenderPass2;
   PFN_vkCreateSampler CreateSampler;
   PFN_vkCreateSamplerYcbcrConversion CreateSamplerYcbcrConversion;
   PFN_vkCreateSemaphore CreateSemaphore;
   PFN_vkCreateShaderModule CreateShaderModule;
   PFN_vkDestroyBuffer DestroyBuffer;
   PFN_vkDestroyBufferView DestroyBufferView;
   PFN_vkDestroyCommandPool DestroyCommandPool;
   PFN_vkDestroyDescriptorPool DestroyDescriptorPool;
   PFN_vkDestroyDescriptorSetLayout DestroyDescriptorSetLayout;
   PFN_vkDestroyDescriptorUpdateTemplate DestroyDescriptorUpdateTemplate;
   PFN_vkDestroyDevice DestroyDevice;
   PFN_vkDestroyEvent DestroyEvent;
   PFN_vkDestroyFence DestroyFence;
   PFN_vkDestroyFramebuffer DestroyFramebuffer;
   PFN_vkDestroyImage DestroyImage;
   PFN_vkDestroyImageView DestroyImageView;
   PFN_vkDestroyPipeline DestroyPipeline;
   PFN_vkDestroyPipelineCache DestroyPipelineCache;
   PFN_vkDestroyPipelineLayout DestroyPipelineLayout;
   PFN_vkDestroyPrivateDataSlot DestroyPrivateDataSlot;
   PFN_vkDestroyQueryPool DestroyQueryPool;
   PFN_vkDestroyRenderPass DestroyRenderPass;
   PFN_vkDestroySampler DestroySampler;
   PFN_vkDestroySamplerYcbcrConversion DestroySamplerYcbcrConversion;
   PFN_vkDestroySemaphore DestroySemaphore;
   PFN_vkDestroyShaderModule DestroyShaderModule;
   PFN_vkDeviceWaitIdle DeviceWaitIdle;
   PFN_vkEndCommandBuffer EndCommandBuffer;
   PFN_vkFlushMappedMemoryRanges FlushMappedMemoryRanges;
   PFN_vkFreeCommandBuffers FreeCommandBuffers;
   PFN_vkFreeDescriptorSets FreeDescriptorSets;
   PFN_vkFreeMemory FreeMemory;
   PFN_vkGetBufferDeviceAddress GetBufferDeviceAddress;
   PFN_vkGetBufferMemoryRequirements GetBufferMemoryRequirements;
   PFN_vkGetBufferMemoryRequirements2 GetBufferMemoryRequirements2;
   PFN_vkGetBufferOpaqueCaptureAddress GetBufferOpaqueCaptureAddress;
   PFN_vkGetCalibratedTimestampsEXT GetCalibratedTimestampsEXT;
   PFN_vkGetDescriptorSetLayoutSupport GetDescriptorSetLayoutSupport;
   PFN_vkGetDeviceBufferMemoryRequirements GetDeviceBufferMemoryRequirements;
   PFN_vkGetDeviceGroupPeerMemoryFeatures GetDeviceGroupPeerMemoryFeatures;
   PFN_vkGetDeviceImageMemoryRequirements GetDeviceImageMemoryRequirements;
   PFN_vkGetDeviceImageSparseMemoryRequirements GetDeviceImageSparseMemoryRequirements;
   PFN_vkGetDeviceMemoryCommitment GetDeviceMemoryCommitment;
   PFN_vkGetDeviceMemoryOpaqueCaptureAddress GetDeviceMemoryOpaqueCaptureAddress;
   PFN_vkGetDeviceProcAddr GetDeviceProcAddr;
   PFN_vkGetDeviceQueue GetDeviceQueue;
   PFN_vkGetDeviceQueue2 GetDeviceQueue2;
   PFN_vkGetEventStatus GetEventStatus;
   PFN_vkGetFenceFdKHR GetFenceFdKHR;
   PFN_vkGetFenceStatus GetFenceStatus;
   PFN_vkGetImageDrmFormatModifierPropertiesEXT GetImageDrmFormatModifierPropertiesEXT;
   PFN_vkGetImageMemoryRequirements GetImageMemoryRequirements;
   PFN_vkGetImageMemoryRequirements2 GetImageMemoryRequirements2;
   PFN_vkGetImageSparseMemoryRequirements GetImageSparseMemoryRequirements;
   PFN_vkGetImageSparseMemoryRequirements2 GetImageSparseMemoryRequirements2;
   PFN_vkGetImageSubresourceLayout GetImageSubresourceLayout;
   PFN_vkGetMemoryFdKHR GetMemoryFdKHR;
   PFN_vkGetMemoryFdPropertiesKHR GetMemoryFdPropertiesKHR;
   PFN_vkGetPipelineCacheData GetPipelineCacheData;
   PFN_vkGetPrivateData GetPrivateData;
   PFN_vkGetQueryPoolResults GetQueryPoolResults;
   PFN_vkGetRenderAreaGranularity GetRenderAreaGranularity;
   PFN_vkGetSemaphoreCounterValue GetSemaphoreCounterValue;
   PFN_vkGetSemaphoreFdKHR GetSemaphoreFdKHR;
   PFN_vkImportFenceFdKHR ImportFenceFdKHR;
   PFN_vkImportSemaphoreFdKHR ImportSemaphoreFdKHR;
   PFN_vkInvalidateMappedMemoryRanges InvalidateMappedMemoryRanges;
   PFN_vkMapMemory MapMemory;
   PFN_vkMergePipelineCaches MergePipelineCaches;
   PFN_vkQueueBindSparse QueueBindSparse;
   PFN_vkQueueSubmit QueueSubmit;
   PFN_vkQueueSubmit2 QueueSubmit2;
   PFN_vkQueueWaitIdle QueueWaitIdle;
   PFN_vkResetCommandBuffer ResetCommandBuffer;
   PFN_vkResetCommandPool ResetCommandPool;
   PFN_vkResetDescriptorPool ResetDescriptorPool;
   PFN_vkResetEvent ResetEvent;
   PFN_vkResetFences ResetFences;
   PFN_vkResetQueryPool ResetQueryPool;
   PFN_vkSetEvent SetEvent;
   PFN_vkSetPrivateData SetPrivateData;
   PFN_vkSignalSemaphore SignalSemaphore;
   PFN_vkTrimCommandPool TrimCommandPool;
   PFN_vkUnmapMemory UnmapMemory;
   PFN_vkUpdateDescriptorSetWithTemplate UpdateDescriptorSetWithTemplate;
   PFN_vkUpdateDescriptorSets UpdateDescriptorSets;
   PFN_vkWaitForFences WaitForFences;
   PFN_vkWaitSemaphores WaitSemaphores;
};

static inline void
vn_util_init_physical_device_proc_table(VkInstance instance,
                                        struct vn_physical_device_proc_table *proc_table)
{
#define VN_GIPA(instance, cmd) (PFN_ ## cmd)vkGetInstanceProcAddr(instance, #cmd)
   proc_table->GetPhysicalDeviceCalibrateableTimeDomainsEXT = VN_GIPA(instance, vkGetPhysicalDeviceCalibrateableTimeDomainsEXT);
   proc_table->GetPhysicalDeviceToolProperties = VN_GIPA(instance, vkGetPhysicalDeviceToolProperties);
   if (!proc_table->GetPhysicalDeviceToolProperties)
      proc_table->GetPhysicalDeviceToolProperties = VN_GIPA(instance, vkGetPhysicalDeviceToolPropertiesEXT);
#undef VN_GIPA
}


static inline void
vn_util_init_device_proc_table(VkDevice dev,
                               uint32_t api_version,
                               const struct vn_info_extension_table *ext_table,
                               struct vn_device_proc_table *proc_table)
{
#define VN_GDPA(dev, cmd) (PFN_ ## cmd)vkGetDeviceProcAddr(dev, #cmd)
   proc_table->AllocateCommandBuffers = VN_GDPA(dev, vkAllocateCommandBuffers);
   proc_table->AllocateDescriptorSets = VN_GDPA(dev, vkAllocateDescriptorSets);
   proc_table->AllocateMemory = VN_GDPA(dev, vkAllocateMemory);
   proc_table->BeginCommandBuffer = VN_GDPA(dev, vkBeginCommandBuffer);
   proc_table->BindBufferMemory = VN_GDPA(dev, vkBindBufferMemory);
   proc_table->BindBufferMemory2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkBindBufferMemory2) :
      ext_table->KHR_bind_memory2 ? VN_GDPA(dev, vkBindBufferMemory2KHR) :
      NULL;
   proc_table->BindImageMemory = VN_GDPA(dev, vkBindImageMemory);
   proc_table->BindImageMemory2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkBindImageMemory2) :
      ext_table->KHR_bind_memory2 ? VN_GDPA(dev, vkBindImageMemory2KHR) :
      NULL;
   proc_table->CmdBeginConditionalRenderingEXT =
      ext_table->EXT_conditional_rendering ? VN_GDPA(dev, vkCmdBeginConditionalRenderingEXT) :
      NULL;
   proc_table->CmdBeginQuery = VN_GDPA(dev, vkCmdBeginQuery);
   proc_table->CmdBeginQueryIndexedEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdBeginQueryIndexedEXT) :
      NULL;
   proc_table->CmdBeginRenderPass = VN_GDPA(dev, vkCmdBeginRenderPass);
   proc_table->CmdBeginRenderPass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdBeginRenderPass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCmdBeginRenderPass2KHR) :
      NULL;
   proc_table->CmdBeginRendering =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdBeginRendering) :
      ext_table->KHR_dynamic_rendering ? VN_GDPA(dev, vkCmdBeginRenderingKHR) :
      NULL;
   proc_table->CmdBeginTransformFeedbackEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdBeginTransformFeedbackEXT) :
      NULL;
   proc_table->CmdBindDescriptorSets = VN_GDPA(dev, vkCmdBindDescriptorSets);
   proc_table->CmdBindIndexBuffer = VN_GDPA(dev, vkCmdBindIndexBuffer);
   proc_table->CmdBindPipeline = VN_GDPA(dev, vkCmdBindPipeline);
   proc_table->CmdBindTransformFeedbackBuffersEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdBindTransformFeedbackBuffersEXT) :
      NULL;
   proc_table->CmdBindVertexBuffers = VN_GDPA(dev, vkCmdBindVertexBuffers);
   proc_table->CmdBindVertexBuffers2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdBindVertexBuffers2) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdBindVertexBuffers2EXT) :
      NULL;
   proc_table->CmdBlitImage = VN_GDPA(dev, vkCmdBlitImage);
   proc_table->CmdBlitImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdBlitImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdBlitImage2KHR) :
      NULL;
   proc_table->CmdClearAttachments = VN_GDPA(dev, vkCmdClearAttachments);
   proc_table->CmdClearColorImage = VN_GDPA(dev, vkCmdClearColorImage);
   proc_table->CmdClearDepthStencilImage = VN_GDPA(dev, vkCmdClearDepthStencilImage);
   proc_table->CmdCopyBuffer = VN_GDPA(dev, vkCmdCopyBuffer);
   proc_table->CmdCopyBuffer2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyBuffer2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyBuffer2KHR) :
      NULL;
   proc_table->CmdCopyBufferToImage = VN_GDPA(dev, vkCmdCopyBufferToImage);
   proc_table->CmdCopyBufferToImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyBufferToImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyBufferToImage2KHR) :
      NULL;
   proc_table->CmdCopyImage = VN_GDPA(dev, vkCmdCopyImage);
   proc_table->CmdCopyImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyImage2KHR) :
      NULL;
   proc_table->CmdCopyImageToBuffer = VN_GDPA(dev, vkCmdCopyImageToBuffer);
   proc_table->CmdCopyImageToBuffer2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdCopyImageToBuffer2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdCopyImageToBuffer2KHR) :
      NULL;
   proc_table->CmdCopyQueryPoolResults = VN_GDPA(dev, vkCmdCopyQueryPoolResults);
   proc_table->CmdDispatch = VN_GDPA(dev, vkCmdDispatch);
   proc_table->CmdDispatchBase =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCmdDispatchBase) :
      ext_table->KHR_device_group ? VN_GDPA(dev, vkCmdDispatchBaseKHR) :
      NULL;
   proc_table->CmdDispatchIndirect = VN_GDPA(dev, vkCmdDispatchIndirect);
   proc_table->CmdDraw = VN_GDPA(dev, vkCmdDraw);
   proc_table->CmdDrawIndexed = VN_GDPA(dev, vkCmdDrawIndexed);
   proc_table->CmdDrawIndexedIndirect = VN_GDPA(dev, vkCmdDrawIndexedIndirect);
   proc_table->CmdDrawIndexedIndirectCount =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdDrawIndexedIndirectCount) :
      ext_table->KHR_draw_indirect_count ? VN_GDPA(dev, vkCmdDrawIndexedIndirectCountKHR) :
      NULL;
   proc_table->CmdDrawIndirect = VN_GDPA(dev, vkCmdDrawIndirect);
   proc_table->CmdDrawIndirectByteCountEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdDrawIndirectByteCountEXT) :
      NULL;
   proc_table->CmdDrawIndirectCount =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdDrawIndirectCount) :
      ext_table->KHR_draw_indirect_count ? VN_GDPA(dev, vkCmdDrawIndirectCountKHR) :
      NULL;
   proc_table->CmdDrawMultiEXT =
      ext_table->EXT_multi_draw ? VN_GDPA(dev, vkCmdDrawMultiEXT) :
      NULL;
   proc_table->CmdDrawMultiIndexedEXT =
      ext_table->EXT_multi_draw ? VN_GDPA(dev, vkCmdDrawMultiIndexedEXT) :
      NULL;
   proc_table->CmdEndConditionalRenderingEXT =
      ext_table->EXT_conditional_rendering ? VN_GDPA(dev, vkCmdEndConditionalRenderingEXT) :
      NULL;
   proc_table->CmdEndQuery = VN_GDPA(dev, vkCmdEndQuery);
   proc_table->CmdEndQueryIndexedEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdEndQueryIndexedEXT) :
      NULL;
   proc_table->CmdEndRenderPass = VN_GDPA(dev, vkCmdEndRenderPass);
   proc_table->CmdEndRenderPass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdEndRenderPass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCmdEndRenderPass2KHR) :
      NULL;
   proc_table->CmdEndRendering =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdEndRendering) :
      ext_table->KHR_dynamic_rendering ? VN_GDPA(dev, vkCmdEndRenderingKHR) :
      NULL;
   proc_table->CmdEndTransformFeedbackEXT =
      ext_table->EXT_transform_feedback ? VN_GDPA(dev, vkCmdEndTransformFeedbackEXT) :
      NULL;
   proc_table->CmdExecuteCommands = VN_GDPA(dev, vkCmdExecuteCommands);
   proc_table->CmdFillBuffer = VN_GDPA(dev, vkCmdFillBuffer);
   proc_table->CmdNextSubpass = VN_GDPA(dev, vkCmdNextSubpass);
   proc_table->CmdNextSubpass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCmdNextSubpass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCmdNextSubpass2KHR) :
      NULL;
   proc_table->CmdPipelineBarrier = VN_GDPA(dev, vkCmdPipelineBarrier);
   proc_table->CmdPipelineBarrier2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdPipelineBarrier2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdPipelineBarrier2KHR) :
      NULL;
   proc_table->CmdPushConstants = VN_GDPA(dev, vkCmdPushConstants);
   proc_table->CmdPushDescriptorSetKHR =
      ext_table->KHR_push_descriptor ? VN_GDPA(dev, vkCmdPushDescriptorSetKHR) :
      NULL;
   proc_table->CmdPushDescriptorSetWithTemplateKHR =
      ext_table->KHR_push_descriptor ? VN_GDPA(dev, vkCmdPushDescriptorSetWithTemplateKHR) :
      NULL;
   proc_table->CmdResetEvent = VN_GDPA(dev, vkCmdResetEvent);
   proc_table->CmdResetEvent2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdResetEvent2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdResetEvent2KHR) :
      NULL;
   proc_table->CmdResetQueryPool = VN_GDPA(dev, vkCmdResetQueryPool);
   proc_table->CmdResolveImage = VN_GDPA(dev, vkCmdResolveImage);
   proc_table->CmdResolveImage2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdResolveImage2) :
      ext_table->KHR_copy_commands2 ? VN_GDPA(dev, vkCmdResolveImage2KHR) :
      NULL;
   proc_table->CmdSetBlendConstants = VN_GDPA(dev, vkCmdSetBlendConstants);
   proc_table->CmdSetCullMode =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetCullMode) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetCullModeEXT) :
      NULL;
   proc_table->CmdSetDepthBias = VN_GDPA(dev, vkCmdSetDepthBias);
   proc_table->CmdSetDepthBiasEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthBiasEnable) :
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetDepthBiasEnableEXT) :
      NULL;
   proc_table->CmdSetDepthBounds = VN_GDPA(dev, vkCmdSetDepthBounds);
   proc_table->CmdSetDepthBoundsTestEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthBoundsTestEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthBoundsTestEnableEXT) :
      NULL;
   proc_table->CmdSetDepthCompareOp =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthCompareOp) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthCompareOpEXT) :
      NULL;
   proc_table->CmdSetDepthTestEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthTestEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthTestEnableEXT) :
      NULL;
   proc_table->CmdSetDepthWriteEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetDepthWriteEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetDepthWriteEnableEXT) :
      NULL;
   proc_table->CmdSetDeviceMask =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCmdSetDeviceMask) :
      ext_table->KHR_device_group ? VN_GDPA(dev, vkCmdSetDeviceMaskKHR) :
      NULL;
   proc_table->CmdSetEvent = VN_GDPA(dev, vkCmdSetEvent);
   proc_table->CmdSetEvent2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetEvent2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdSetEvent2KHR) :
      NULL;
   proc_table->CmdSetFrontFace =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetFrontFace) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetFrontFaceEXT) :
      NULL;
   proc_table->CmdSetLineStippleEXT =
      ext_table->EXT_line_rasterization ? VN_GDPA(dev, vkCmdSetLineStippleEXT) :
      NULL;
   proc_table->CmdSetLineWidth = VN_GDPA(dev, vkCmdSetLineWidth);
   proc_table->CmdSetLogicOpEXT =
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetLogicOpEXT) :
      NULL;
   proc_table->CmdSetPatchControlPointsEXT =
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetPatchControlPointsEXT) :
      NULL;
   proc_table->CmdSetPrimitiveRestartEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetPrimitiveRestartEnable) :
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetPrimitiveRestartEnableEXT) :
      NULL;
   proc_table->CmdSetPrimitiveTopology =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetPrimitiveTopology) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetPrimitiveTopologyEXT) :
      NULL;
   proc_table->CmdSetRasterizerDiscardEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetRasterizerDiscardEnable) :
      ext_table->EXT_extended_dynamic_state2 ? VN_GDPA(dev, vkCmdSetRasterizerDiscardEnableEXT) :
      NULL;
   proc_table->CmdSetScissor = VN_GDPA(dev, vkCmdSetScissor);
   proc_table->CmdSetScissorWithCount =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetScissorWithCount) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetScissorWithCountEXT) :
      NULL;
   proc_table->CmdSetStencilCompareMask = VN_GDPA(dev, vkCmdSetStencilCompareMask);
   proc_table->CmdSetStencilOp =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetStencilOp) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetStencilOpEXT) :
      NULL;
   proc_table->CmdSetStencilReference = VN_GDPA(dev, vkCmdSetStencilReference);
   proc_table->CmdSetStencilTestEnable =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetStencilTestEnable) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetStencilTestEnableEXT) :
      NULL;
   proc_table->CmdSetStencilWriteMask = VN_GDPA(dev, vkCmdSetStencilWriteMask);
   proc_table->CmdSetViewport = VN_GDPA(dev, vkCmdSetViewport);
   proc_table->CmdSetViewportWithCount =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdSetViewportWithCount) :
      ext_table->EXT_extended_dynamic_state ? VN_GDPA(dev, vkCmdSetViewportWithCountEXT) :
      NULL;
   proc_table->CmdUpdateBuffer = VN_GDPA(dev, vkCmdUpdateBuffer);
   proc_table->CmdWaitEvents = VN_GDPA(dev, vkCmdWaitEvents);
   proc_table->CmdWaitEvents2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdWaitEvents2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdWaitEvents2KHR) :
      NULL;
   proc_table->CmdWriteTimestamp = VN_GDPA(dev, vkCmdWriteTimestamp);
   proc_table->CmdWriteTimestamp2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCmdWriteTimestamp2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkCmdWriteTimestamp2KHR) :
      NULL;
   proc_table->CreateBuffer = VN_GDPA(dev, vkCreateBuffer);
   proc_table->CreateBufferView = VN_GDPA(dev, vkCreateBufferView);
   proc_table->CreateCommandPool = VN_GDPA(dev, vkCreateCommandPool);
   proc_table->CreateComputePipelines = VN_GDPA(dev, vkCreateComputePipelines);
   proc_table->CreateDescriptorPool = VN_GDPA(dev, vkCreateDescriptorPool);
   proc_table->CreateDescriptorSetLayout = VN_GDPA(dev, vkCreateDescriptorSetLayout);
   proc_table->CreateDescriptorUpdateTemplate =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCreateDescriptorUpdateTemplate) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkCreateDescriptorUpdateTemplateKHR) :
      NULL;
   proc_table->CreateEvent = VN_GDPA(dev, vkCreateEvent);
   proc_table->CreateFence = VN_GDPA(dev, vkCreateFence);
   proc_table->CreateFramebuffer = VN_GDPA(dev, vkCreateFramebuffer);
   proc_table->CreateGraphicsPipelines = VN_GDPA(dev, vkCreateGraphicsPipelines);
   proc_table->CreateImage = VN_GDPA(dev, vkCreateImage);
   proc_table->CreateImageView = VN_GDPA(dev, vkCreateImageView);
   proc_table->CreatePipelineCache = VN_GDPA(dev, vkCreatePipelineCache);
   proc_table->CreatePipelineLayout = VN_GDPA(dev, vkCreatePipelineLayout);
   proc_table->CreatePrivateDataSlot =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkCreatePrivateDataSlot) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkCreatePrivateDataSlotEXT) :
      NULL;
   proc_table->CreateQueryPool = VN_GDPA(dev, vkCreateQueryPool);
   proc_table->CreateRenderPass = VN_GDPA(dev, vkCreateRenderPass);
   proc_table->CreateRenderPass2 =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkCreateRenderPass2) :
      ext_table->KHR_create_renderpass2 ? VN_GDPA(dev, vkCreateRenderPass2KHR) :
      NULL;
   proc_table->CreateSampler = VN_GDPA(dev, vkCreateSampler);
   proc_table->CreateSamplerYcbcrConversion =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkCreateSamplerYcbcrConversion) :
      ext_table->KHR_sampler_ycbcr_conversion ? VN_GDPA(dev, vkCreateSamplerYcbcrConversionKHR) :
      NULL;
   proc_table->CreateSemaphore = VN_GDPA(dev, vkCreateSemaphore);
   proc_table->CreateShaderModule = VN_GDPA(dev, vkCreateShaderModule);
   proc_table->DestroyBuffer = VN_GDPA(dev, vkDestroyBuffer);
   proc_table->DestroyBufferView = VN_GDPA(dev, vkDestroyBufferView);
   proc_table->DestroyCommandPool = VN_GDPA(dev, vkDestroyCommandPool);
   proc_table->DestroyDescriptorPool = VN_GDPA(dev, vkDestroyDescriptorPool);
   proc_table->DestroyDescriptorSetLayout = VN_GDPA(dev, vkDestroyDescriptorSetLayout);
   proc_table->DestroyDescriptorUpdateTemplate =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkDestroyDescriptorUpdateTemplate) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkDestroyDescriptorUpdateTemplateKHR) :
      NULL;
   proc_table->DestroyDevice = VN_GDPA(dev, vkDestroyDevice);
   proc_table->DestroyEvent = VN_GDPA(dev, vkDestroyEvent);
   proc_table->DestroyFence = VN_GDPA(dev, vkDestroyFence);
   proc_table->DestroyFramebuffer = VN_GDPA(dev, vkDestroyFramebuffer);
   proc_table->DestroyImage = VN_GDPA(dev, vkDestroyImage);
   proc_table->DestroyImageView = VN_GDPA(dev, vkDestroyImageView);
   proc_table->DestroyPipeline = VN_GDPA(dev, vkDestroyPipeline);
   proc_table->DestroyPipelineCache = VN_GDPA(dev, vkDestroyPipelineCache);
   proc_table->DestroyPipelineLayout = VN_GDPA(dev, vkDestroyPipelineLayout);
   proc_table->DestroyPrivateDataSlot =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkDestroyPrivateDataSlot) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkDestroyPrivateDataSlotEXT) :
      NULL;
   proc_table->DestroyQueryPool = VN_GDPA(dev, vkDestroyQueryPool);
   proc_table->DestroyRenderPass = VN_GDPA(dev, vkDestroyRenderPass);
   proc_table->DestroySampler = VN_GDPA(dev, vkDestroySampler);
   proc_table->DestroySamplerYcbcrConversion =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkDestroySamplerYcbcrConversion) :
      ext_table->KHR_sampler_ycbcr_conversion ? VN_GDPA(dev, vkDestroySamplerYcbcrConversionKHR) :
      NULL;
   proc_table->DestroySemaphore = VN_GDPA(dev, vkDestroySemaphore);
   proc_table->DestroyShaderModule = VN_GDPA(dev, vkDestroyShaderModule);
   proc_table->DeviceWaitIdle = VN_GDPA(dev, vkDeviceWaitIdle);
   proc_table->EndCommandBuffer = VN_GDPA(dev, vkEndCommandBuffer);
   proc_table->FlushMappedMemoryRanges = VN_GDPA(dev, vkFlushMappedMemoryRanges);
   proc_table->FreeCommandBuffers = VN_GDPA(dev, vkFreeCommandBuffers);
   proc_table->FreeDescriptorSets = VN_GDPA(dev, vkFreeDescriptorSets);
   proc_table->FreeMemory = VN_GDPA(dev, vkFreeMemory);
   proc_table->GetBufferDeviceAddress =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetBufferDeviceAddress) :
      ext_table->KHR_buffer_device_address ? VN_GDPA(dev, vkGetBufferDeviceAddressKHR) :
      NULL;
   proc_table->GetBufferMemoryRequirements = VN_GDPA(dev, vkGetBufferMemoryRequirements);
   proc_table->GetBufferMemoryRequirements2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetBufferMemoryRequirements2) :
      ext_table->KHR_get_memory_requirements2 ? VN_GDPA(dev, vkGetBufferMemoryRequirements2KHR) :
      NULL;
   proc_table->GetBufferOpaqueCaptureAddress =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetBufferOpaqueCaptureAddress) :
      ext_table->KHR_buffer_device_address ? VN_GDPA(dev, vkGetBufferOpaqueCaptureAddressKHR) :
      NULL;
   proc_table->GetCalibratedTimestampsEXT =
      ext_table->EXT_calibrated_timestamps ? VN_GDPA(dev, vkGetCalibratedTimestampsEXT) :
      NULL;
   proc_table->GetDescriptorSetLayoutSupport =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetDescriptorSetLayoutSupport) :
      ext_table->KHR_maintenance3 ? VN_GDPA(dev, vkGetDescriptorSetLayoutSupportKHR) :
      NULL;
   proc_table->GetDeviceBufferMemoryRequirements =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetDeviceBufferMemoryRequirements) :
      ext_table->KHR_maintenance4 ? VN_GDPA(dev, vkGetDeviceBufferMemoryRequirementsKHR) :
      NULL;
   proc_table->GetDeviceGroupPeerMemoryFeatures =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetDeviceGroupPeerMemoryFeatures) :
      ext_table->KHR_device_group ? VN_GDPA(dev, vkGetDeviceGroupPeerMemoryFeaturesKHR) :
      NULL;
   proc_table->GetDeviceImageMemoryRequirements =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetDeviceImageMemoryRequirements) :
      ext_table->KHR_maintenance4 ? VN_GDPA(dev, vkGetDeviceImageMemoryRequirementsKHR) :
      NULL;
   proc_table->GetDeviceImageSparseMemoryRequirements =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetDeviceImageSparseMemoryRequirements) :
      ext_table->KHR_maintenance4 ? VN_GDPA(dev, vkGetDeviceImageSparseMemoryRequirementsKHR) :
      NULL;
   proc_table->GetDeviceMemoryCommitment = VN_GDPA(dev, vkGetDeviceMemoryCommitment);
   proc_table->GetDeviceMemoryOpaqueCaptureAddress =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetDeviceMemoryOpaqueCaptureAddress) :
      ext_table->KHR_buffer_device_address ? VN_GDPA(dev, vkGetDeviceMemoryOpaqueCaptureAddressKHR) :
      NULL;
   proc_table->GetDeviceProcAddr = VN_GDPA(dev, vkGetDeviceProcAddr);
   proc_table->GetDeviceQueue = VN_GDPA(dev, vkGetDeviceQueue);
   proc_table->GetDeviceQueue2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetDeviceQueue2) :
      NULL;
   proc_table->GetEventStatus = VN_GDPA(dev, vkGetEventStatus);
   proc_table->GetFenceFdKHR =
      ext_table->KHR_external_fence_fd ? VN_GDPA(dev, vkGetFenceFdKHR) :
      NULL;
   proc_table->GetFenceStatus = VN_GDPA(dev, vkGetFenceStatus);
   proc_table->GetImageDrmFormatModifierPropertiesEXT =
      ext_table->EXT_image_drm_format_modifier ? VN_GDPA(dev, vkGetImageDrmFormatModifierPropertiesEXT) :
      NULL;
   proc_table->GetImageMemoryRequirements = VN_GDPA(dev, vkGetImageMemoryRequirements);
   proc_table->GetImageMemoryRequirements2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetImageMemoryRequirements2) :
      ext_table->KHR_get_memory_requirements2 ? VN_GDPA(dev, vkGetImageMemoryRequirements2KHR) :
      NULL;
   proc_table->GetImageSparseMemoryRequirements = VN_GDPA(dev, vkGetImageSparseMemoryRequirements);
   proc_table->GetImageSparseMemoryRequirements2 =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkGetImageSparseMemoryRequirements2) :
      ext_table->KHR_get_memory_requirements2 ? VN_GDPA(dev, vkGetImageSparseMemoryRequirements2KHR) :
      NULL;
   proc_table->GetImageSubresourceLayout = VN_GDPA(dev, vkGetImageSubresourceLayout);
   proc_table->GetMemoryFdKHR =
      ext_table->KHR_external_memory_fd ? VN_GDPA(dev, vkGetMemoryFdKHR) :
      NULL;
   proc_table->GetMemoryFdPropertiesKHR =
      ext_table->KHR_external_memory_fd ? VN_GDPA(dev, vkGetMemoryFdPropertiesKHR) :
      NULL;
   proc_table->GetPipelineCacheData = VN_GDPA(dev, vkGetPipelineCacheData);
   proc_table->GetPrivateData =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkGetPrivateData) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkGetPrivateDataEXT) :
      NULL;
   proc_table->GetQueryPoolResults = VN_GDPA(dev, vkGetQueryPoolResults);
   proc_table->GetRenderAreaGranularity = VN_GDPA(dev, vkGetRenderAreaGranularity);
   proc_table->GetSemaphoreCounterValue =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkGetSemaphoreCounterValue) :
      ext_table->KHR_timeline_semaphore ? VN_GDPA(dev, vkGetSemaphoreCounterValueKHR) :
      NULL;
   proc_table->GetSemaphoreFdKHR =
      ext_table->KHR_external_semaphore_fd ? VN_GDPA(dev, vkGetSemaphoreFdKHR) :
      NULL;
   proc_table->ImportFenceFdKHR =
      ext_table->KHR_external_fence_fd ? VN_GDPA(dev, vkImportFenceFdKHR) :
      NULL;
   proc_table->ImportSemaphoreFdKHR =
      ext_table->KHR_external_semaphore_fd ? VN_GDPA(dev, vkImportSemaphoreFdKHR) :
      NULL;
   proc_table->InvalidateMappedMemoryRanges = VN_GDPA(dev, vkInvalidateMappedMemoryRanges);
   proc_table->MapMemory = VN_GDPA(dev, vkMapMemory);
   proc_table->MergePipelineCaches = VN_GDPA(dev, vkMergePipelineCaches);
   proc_table->QueueBindSparse = VN_GDPA(dev, vkQueueBindSparse);
   proc_table->QueueSubmit = VN_GDPA(dev, vkQueueSubmit);
   proc_table->QueueSubmit2 =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkQueueSubmit2) :
      ext_table->KHR_synchronization2 ? VN_GDPA(dev, vkQueueSubmit2KHR) :
      NULL;
   proc_table->QueueWaitIdle = VN_GDPA(dev, vkQueueWaitIdle);
   proc_table->ResetCommandBuffer = VN_GDPA(dev, vkResetCommandBuffer);
   proc_table->ResetCommandPool = VN_GDPA(dev, vkResetCommandPool);
   proc_table->ResetDescriptorPool = VN_GDPA(dev, vkResetDescriptorPool);
   proc_table->ResetEvent = VN_GDPA(dev, vkResetEvent);
   proc_table->ResetFences = VN_GDPA(dev, vkResetFences);
   proc_table->ResetQueryPool =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkResetQueryPool) :
      ext_table->EXT_host_query_reset ? VN_GDPA(dev, vkResetQueryPoolEXT) :
      NULL;
   proc_table->SetEvent = VN_GDPA(dev, vkSetEvent);
   proc_table->SetPrivateData =
      api_version >= VK_API_VERSION_1_3 ? VN_GDPA(dev, vkSetPrivateData) :
      ext_table->EXT_private_data ? VN_GDPA(dev, vkSetPrivateDataEXT) :
      NULL;
   proc_table->SignalSemaphore =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkSignalSemaphore) :
      ext_table->KHR_timeline_semaphore ? VN_GDPA(dev, vkSignalSemaphoreKHR) :
      NULL;
   proc_table->TrimCommandPool =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkTrimCommandPool) :
      ext_table->KHR_maintenance1 ? VN_GDPA(dev, vkTrimCommandPoolKHR) :
      NULL;
   proc_table->UnmapMemory = VN_GDPA(dev, vkUnmapMemory);
   proc_table->UpdateDescriptorSetWithTemplate =
      api_version >= VK_API_VERSION_1_1 ? VN_GDPA(dev, vkUpdateDescriptorSetWithTemplate) :
      ext_table->KHR_descriptor_update_template ? VN_GDPA(dev, vkUpdateDescriptorSetWithTemplateKHR) :
      NULL;
   proc_table->UpdateDescriptorSets = VN_GDPA(dev, vkUpdateDescriptorSets);
   proc_table->WaitForFences = VN_GDPA(dev, vkWaitForFences);
   proc_table->WaitSemaphores =
      api_version >= VK_API_VERSION_1_2 ? VN_GDPA(dev, vkWaitSemaphores) :
      ext_table->KHR_timeline_semaphore ? VN_GDPA(dev, vkWaitSemaphoresKHR) :
      NULL;
#undef VN_GDPA
}

#endif /* VN_PROTOCOL_RENDERER_UTIL_H */
