/*
 * Copyright 2016 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 2.15
import Lomiri.Components 1.3

StateGroup {
    id: root
    property var container
    property var surfaceItem
    property var hadSurface

    states: [
        State {
            name: "blank"
            when: !root.surfaceItem.surface && !root.hadSurface
        },
        State {
            name: "ready"
            when: root.surfaceItem.surface && root.surfaceItem.live
        },
        State {
            name: "zombie"
            when: root.hadSurface && !root.surfaceItem.live
        }
    ]
    transitions: [
        Transition {
            from: "*"; to: "zombie"
            // Slide downwards until it's out of view, through the bottom of the window
            SequentialAnimation {
                // clip so we don't go out of parent's bounds during spread
                PropertyAction { target: root.container.parent; property: "clip"; value: true }
                LomiriNumberAnimation { target: root.surfaceItem; property: "anchors.topMargin"; to: root.container.height
                                        duration: LomiriAnimation.BriskDuration }
                PropertyAction { target: root.surfaceItem; property: "visible"; value: false }
                PropertyAction { target: container.parent; property: "clip"; value: false }
                ScriptAction { script: {
                    // QtMir.Application can't destroy a zombie MirSurface if it's still being
                    // referenced by a MirSurfaceItem.
                    root.surfaceItem.surface = null;
                } }
            }
        },
        Transition {
            from: "*"; to: "ready"
            // Slide upwards into view, from the bottom of the window
            SequentialAnimation {
                // clip so we don't go out of parent's bounds during spread
                PropertyAction { target: root.container.parent; property: "clip"; value: true }
                ScriptAction { script: {
                    root.surfaceItem.visible = true;
                } }
                LomiriNumberAnimation {
                    target: root.surfaceItem; property: "anchors.topMargin"; from: root.container.height; to: 0
                    duration: LomiriAnimation.BriskDuration
                }
                PropertyAction { target: container.parent; property: "clip"; value: false }
            }
        },
        Transition {
            from: "*"; to: "blank"
            ScriptAction { script: {
                root.surfaceItem.visible = false;
            } }
        }
    ]
}
