/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import sun.security.util.Debug;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final Debug pdebug = Debug.getInstance("provider", "Provider");
    private static final boolean skipDebug = Debug.isOn("engine=") && !Debug.isOn("messagedigest");
    private String algorithm;
    private static final int INITIAL = 0;
    private static final int IN_PROGRESS = 1;
    private int state = 0;
    private Provider provider;

    protected MessageDigest(String algorithm) {
        this.algorithm = algorithm;
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            Object[] objs = Security.getImpl(algorithm, "MessageDigest", (String)null);
            MessageDigest md = objs[0] instanceof MessageDigest ? (MessageDigest)objs[0] : new Delegate((MessageDigestSpi)objs[0], algorithm);
            md.provider = (Provider)objs[1];
            if (!skipDebug && pdebug != null) {
                pdebug.println("MessageDigest." + algorithm + " algorithm from: " + md.provider.getName());
            }
            return md;
        }
        catch (NoSuchProviderException e) {
            throw new NoSuchAlgorithmException(algorithm + " not found");
        }
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objs = Security.getImpl(algorithm, "MessageDigest", provider);
        if (objs[0] instanceof MessageDigest) {
            MessageDigest md = (MessageDigest)objs[0];
            md.provider = (Provider)objs[1];
            return md;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objs[0], algorithm);
        delegate.provider = (Provider)objs[1];
        return delegate;
    }

    public static MessageDigest getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objs = Security.getImpl(algorithm, "MessageDigest", provider);
        if (objs[0] instanceof MessageDigest) {
            MessageDigest md = (MessageDigest)objs[0];
            md.provider = (Provider)objs[1];
            return md;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objs[0], algorithm);
        delegate.provider = (Provider)objs[1];
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte input) {
        this.engineUpdate(input);
        this.state = 1;
    }

    public void update(byte[] input, int offset, int len) {
        if (input == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (input.length - offset < len) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        this.engineUpdate(input, offset, len);
        this.state = 1;
    }

    public void update(byte[] input) {
        this.engineUpdate(input, 0, input.length);
        this.state = 1;
    }

    public final void update(ByteBuffer input) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.engineUpdate(input);
        this.state = 1;
    }

    public byte[] digest() {
        byte[] result = this.engineDigest();
        this.state = 0;
        return result;
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        if (buf == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (buf.length - offset < len) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        int numBytes = this.engineDigest(buf, offset, len);
        this.state = 0;
        return numBytes;
    }

    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        p.print(this.algorithm + " Message Digest from " + this.provider.getName() + ", ");
        switch (this.state) {
            case 0: {
                p.print("<initialized>");
                break;
            }
            case 1: {
                p.print("<in progress>");
            }
        }
        p.println();
        return baos.toString();
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        if (digesta == digestb) {
            return true;
        }
        if (digesta == null || digestb == null) {
            return false;
        }
        if (digesta.length != digestb.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < digesta.length; ++i) {
            result |= digesta[i] ^ digestb[i];
        }
        return result == 0;
    }

    public void reset() {
        this.engineReset();
        this.state = 0;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        int digestLen = this.engineGetDigestLength();
        if (digestLen == 0) {
            try {
                MessageDigest md = (MessageDigest)this.clone();
                byte[] digest = md.digest();
                return digest.length;
            }
            catch (CloneNotSupportedException e) {
                return digestLen;
            }
        }
        return digestLen;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    static class Delegate
    extends MessageDigest {
        private MessageDigestSpi digestSpi;

        public Delegate(MessageDigestSpi digestSpi, String algorithm) {
            super(algorithm);
            this.digestSpi = digestSpi;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            if (this.digestSpi instanceof Cloneable) {
                MessageDigestSpi digestSpiClone = (MessageDigestSpi)this.digestSpi.clone();
                Delegate that = new Delegate(digestSpiClone, ((MessageDigest)this).algorithm);
                ((MessageDigest)that).provider = ((MessageDigest)this).provider;
                ((MessageDigest)that).state = ((MessageDigest)this).state;
                return that;
            }
            throw new CloneNotSupportedException();
        }

        @Override
        protected int engineGetDigestLength() {
            return this.digestSpi.engineGetDigestLength();
        }

        @Override
        protected void engineUpdate(byte input) {
            this.digestSpi.engineUpdate(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.digestSpi.engineUpdate(input, offset, len);
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            this.digestSpi.engineUpdate(input);
        }

        @Override
        protected byte[] engineDigest() {
            return this.digestSpi.engineDigest();
        }

        @Override
        protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
            return this.digestSpi.engineDigest(buf, offset, len);
        }

        @Override
        protected void engineReset() {
            this.digestSpi.engineReset();
        }
    }
}

