/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOscillatorType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(OscillatorType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("sine"),
        MAKE_STATIC_STRING_IMPL("square"),
        MAKE_STATIC_STRING_IMPL("sawtooth"),
        MAKE_STATIC_STRING_IMPL("triangle"),
        MAKE_STATIC_STRING_IMPL("custom"),
    };
    static_assert(static_cast<size_t>(OscillatorType::Sine) == 0, "OscillatorType::Sine is not 0 as expected");
    static_assert(static_cast<size_t>(OscillatorType::Square) == 1, "OscillatorType::Square is not 1 as expected");
    static_assert(static_cast<size_t>(OscillatorType::Sawtooth) == 2, "OscillatorType::Sawtooth is not 2 as expected");
    static_assert(static_cast<size_t>(OscillatorType::Triangle) == 3, "OscillatorType::Triangle is not 3 as expected");
    static_assert(static_cast<size_t>(OscillatorType::Custom) == 4, "OscillatorType::Custom is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, OscillatorType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<OscillatorType> parseEnumerationFromString<OscillatorType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, OscillatorType> mappings[] = {
        { "custom", OscillatorType::Custom },
        { "sawtooth", OscillatorType::Sawtooth },
        { "sine", OscillatorType::Sine },
        { "square", OscillatorType::Square },
        { "triangle", OscillatorType::Triangle },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<OscillatorType> parseEnumeration<OscillatorType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<OscillatorType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<OscillatorType>()
{
    return "\"sine\", \"square\", \"sawtooth\", \"triangle\", \"custom\""_s;
}

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
